# Examples by Complexity

Examples organized by difficulty level to support progressive learning.

## Beginner Level
- Single resources with simple validation rules
- Basic rule syntax and concepts
- Estimated time: 10-15 minutes per example

## Intermediate Level
- Multi-resource configurations
- Complex rule combinations
- Real-world infrastructure patterns
- Estimated time: 20-30 minutes per example

## Advanced Level
- Enterprise-scale patterns
- Custom rule pack development
- Performance optimization
- Multi-cloud strategies
- Estimated time: 45-60 minutes per example

## Learning Path

1. Start with `beginner/` examples to understand core concepts
2. Progress to `intermediate/` for realistic scenarios
3. Advance to `advanced/` for production-ready patterns

Each example includes:
- Complete Terraform configuration
- Corresponding validation rules
- Step-by-step walkthrough
- Expected outputs
- Common variations to try
