# Typing stubs for NVIDIA DeepStream Python Bindings

![PyPI - Status](https://img.shields.io/pypi/status/pyds-stubs?style=for-the-badge)
![PyPI - Types](https://img.shields.io/pypi/types/pyds-stubs?style=for-the-badge)
![Static Badge](https://img.shields.io/badge/pyds%20Version-1.1.10-blue?style=for-the-badge)
![Python Version from PEP 621 TOML](https://img.shields.io/python/required-version-toml?tomlFilePath=https%3A%2F%2Fraw.githubusercontent.com%2Fnkaaf%2Fpyds-stubs%2Frefs%2Ftags%2F1.1.10%2Fpyproject.toml&style=for-the-badge)

This project provides type stubs for [pyds](https://github.com/NVIDIA-AI-IOT/deepstream_python_apps)
to improve the support of these important bindings in IDEs.

These are generated by [pybind11-stubgen](https://github.com/nkaaf/sizmailov-pybind11-stubgen) and
further post-processed. For the post-processing steps, check out the
[Post-Processing Chapter](#post-processing).

With the usage of this project, you agree to the license terms, found in the [License](#license)
chapter. This project is not affiliated with NVIDIA or the authors and maintainer of
the [pyds](https://github.com/NVIDIA-AI-IOT/deepstream_python_apps) repository. It is the result of
the need for type hints for a simpler and more stable implementation of DeepStream pipelines in
Python.

> [!NOTE]
> The stubs are distributed as a third-party stub-only library according to
> [PEP 561](https://peps.python.org/pep-0561/#stub-only-packages) because this project is not
> related to NVIDIA and if they ship stubs, this project can easily be deprecated and publicly
> archived.

## Index

* [Installation](#installation)
    * [Versioning](#versioning)
* [Usage](#usage)
* [Development](#development)
    * [Installation of Prerequisites](#installation-of-prerequisites)
    * [Build wheel](#build-wheel)
    * [Generation](#generation)
    * [Post-Processing](#post-processing)
* [License](#license)
* [Appendix](#appendix)
    * [Links](#links)
    * [Notice for NVIDIA](#notice-for-nvidia)

## Installation

This library can be easily installed with pip.

### Versioning

The stub versions matches the versions of pyds. For example, stub version `1.1.10` fits to pyds
version
`1.1.10`. If any fix has to be applied, the fourth position would be incremented. So the first fix of
`1.1.10` results in `1.1.10.1`.

Please pin your version directly or limit it upper-wise like:

`pyds-stubs>=1.1.10,<1.1.11`

## Usage

There is no magic, just only import pyds as you would normally do. This package is intended to be
used during the development and can be omitted in runtime environments.

## Development

### Installation of Prerequisites

* Python 3.8
* `uv` and `pre-commit` (both preferred via pipx)
* Python venv (optional, recommended)

```bash
pipx install pre-commit uv
pre-commit install
```

### Build wheel

```bash
uv build
```

### Generation

The stubs are generated by pybind11-stubgen (2.5.5). Install pyds from nvidia official sources. To
generate the stubs execute the following script in the environment, where pyds is installed.

```bash
pybind11-stubgen pyds
```

### Post-Processing

For correct usage, the generated stubs are post-processed. Following steps are applied:

* add generic class for `capsule` with information about the class of the object.
* remove class `GList` and add generic `GList` class with information about the class of the data.
* `cast` functions with `capsule` datatype: `capsule` is replaced by `capsule[class]` where `class`
  is the target class.
* `array` datatype: Replace with `numpy.ndarray`
* `numpy.ndarray[float32]`: Replace with `NDArray[numpy.float32]` with
  `from numpy.typing import NDArray`
* Returntype of `eglImage` property of `NvBufSurfaceMappedAddr`: `typing.Any` instead of `capsule`
* Returntype of `dataPtr` property of `NvBufSurfaceParams`: `typing.Any` instead of `capsule`
* Datatype of `batch_meta` of `NvDsBaseMeta`: `NvDsBatchMeta` instead of `_NvDsBatchMeta`
* Datatype of `uContext` of `NvDsBaseMeta`: `typing.Any` instead of `capsule`
* Datatype of `batch_user_meta_list` of `NvDsBatchMeta`: `GList[NvDsUserMeta] | None`
  instead of `GList`
* Datatype of `frame_meta_list` of `NvDsBatchMeta`: `GList[NvDsFrameMeta] | None` instead
  of `GList`
* Datatype of `meta_mutex`of `NvDsBatchMeta`: `GLib.RecMutex` instead of `_GRecMutex` with
  `from gi.repository import GLib`
* Datatype of `label_info_list` of `NvDsClassifierMeta`: `GList[NvDsLabelInfo] | None`
  instead of `GList`
* Datatype of `extMsg` of `NvDsEventMsgMeta`: `typing.Any` instead of `capsule`
* Datatype of `mask` of `NvDsFaceObjectWithExt`: `GList[typing.Any] | None`
  instead of `GList`
* Datatype of `display_meta_list` of `NvDsFrameMeta`: `GList[NvDsDisplayMeta] | None`
  instead of `GList`
* Datatype of `frame_user_meta_list` of `NvDsFrameMeta`: `GList[NvDsUserMeta] | None`
  instead of `GList`
* Datatype of `obj_meta_list` of `NvDsFrameMeta`: `GList[NvDsObjectMeta] | None` instead
  of `GList`
* Returntype of `buffer` property of `NvDsInferLayerInfo`: `typing.Any` instead of `capsule`
* Returntype of `priv_data` property of `NvDsInferSegmentationMeta`: `typing.Any` instead of
  `capsule`
* Returntype of `out_buf_ptrs_dev` property of `NvDsInferTensorMeta`: `typing.Any` instead of
  `capsule`
* Returntype of `out_buf_ptrs_host` property of `NvDsInferTensorMeta`: `typing.Any` instead of
  `capsule`
* Returntype of `priv_data` property of `NvDsInferTensorMeta`: `typing.Any` instead of `capsule`
* Datatype of `meta` of `NvDsMeta`: `Gst.Meta` instead of `_GstMeta` with
  `from gi.repository import Gst`
* Datatype of `meta_data` of `NvDsMeta`: `typing.Any` instead of `capsule`
* Datatype of `user_data` of `NvDsMeta`: `typing.Any` instead of `capsule`
* Add `NvDsMetaList` as an alias of `GList[NvDsMeta] | None`
* Datatype of `empty_list` of `NvDsMetaPool`: `NvDsMetaList` instead of `GList`
* Datatype of `full_list` of `NvDsMetaPool`: `NvDsMetaList` instead of `GList`
* Datatype of `classifier_meta_list` of `NvDsObjectMeta`:
  `GList[NvDsClassifierMeta] | None` instead of `GList`
* Datatype of `obj_user_meta_list` of `NvDsObjectMeta`:
  `GList[NvDsUserMeta] | None` instead of `GList`
* Datatype of `data` of `NvDsOpticalFlowMeta`: `typing.Any` instead of `capsule`
* Datatype of `priv` of `NvDsOpticalFlowMeta`: `typing.Any` instead of `capsule`
* Datatype of `reserved` of `NvDsOpticalFlowMeta`: `typing.Any` instead of `capsule`
* Datatype of `mask` of `NvDsPersonObjectExt`: `GList[typing.Any] | None`
  instead of `GList`
* Datatype of `payload` of `NvDsPayload`: `typing.Any` instead of `capsule`
* Datatype of `user_meta_data` of `NvDsUserMeta`: `typing.Any` instead of `capsule`
* Datatype of `mask` of `NvDsVehicleObjectExt`: `GList[typing.Any] | None`
  instead of `GList`
* Datatype of `text` of `RectDim`: `typing.Any` instead of `capsule`
* Rename `dmabuf` to `dmabuf_fd` of `NvBufSurfaceFromFd`
* Datatype of `buffer` of `NvBufSurfaceFromFd`: `capsule[NvBufSurface]` instead of `capsule`
* Rename `arg0` to `user_meta` of `alloc_nvds_event_msg_meta`
* Datatype of `buffer` of `free_gbuffer`: `typing.Any` instead of `capsule`
* Datatype of `arg0` of `get_detections`: `typing.Any` instead of `capsule`
* Datatype of `arg0` of `get_nvds_LayerInfo`: `typing.Any` instead of `capsule`
* Datatype of `data` of `get_optical_flow_vectors`: `capsule[NvDsOpticalFlowMeta]` instead of
  `capsule`
* Rename `data` to `of_meta` of `get_optical_flow_vectors`
* Datatype of `ptr` of `get_ptr`: `typing.Any` instead of `capsule`
* Datatype of `data` of `get_segmentation_masks`: `capsule[NvDsInferSegmentationMeta]` instead of
  `capsule`
* Datatype of `arg0` of `glist_get_nvds_Surface_Params`: `typing.Any` instead of `capsule`
* Datatype of `arg0` of `glist_get_nvds_batch_meta`: `typing.Any` instead of `capsule`
* Datatype of `arg0` of `glist_get_nvds_classifier_meta`: `typing.Any` instead of `capsule`
* Datatype of `arg0` of `glist_get_nvds_display_meta`: `typing.Any` instead of `capsule`
* Datatype of `arg0` of `glist_get_nvds_event_msg_meta`: `typing.Any` instead of `capsule`
* Datatype of `arg0` of `glist_get_nvds_frame_meta`: `typing.Any` instead of `capsule`
* Datatype of `arg0` of `glist_get_nvds_label_info`: `typing.Any` instead of `capsule`
* Datatype of `arg0` of `glist_get_nvds_object_meta`: `typing.Any` instead of `capsule`
* Datatype of `arg0` of `glist_get_nvds_person_object`: `typing.Any` instead of `capsule`
* Datatype of `arg0` of `glist_get_nvds_tensor_meta`: `typing.Any` instead of `capsule`
* Datatype of `arg0` of `glist_get_nvds_user_meta`: `typing.Any` instead of `capsule`
* Datatype of `arg0` of `glist_get_nvds_vehicle_object`: `typing.Any` instead of `capsule`
* Datatype of `buffer` of `gst_buffer_add_nvds_meta`: `Gst.Buffer` instead of `_GstBuffer`
* Datatype of `meta_data` of `gst_buffer_add_nvds_meta`: `typing.Any` instead of `capsule`
* Datatype of `user_data` of `gst_buffer_add_nvds_meta`: `typing.Any` instead of `capsule`
* Returntype of `gst_buffer_add_nvds_meta`: `NvDsMeta` instead of `_NvDsMeta`
* Rename `arg0` to `gst_element` of `gst_element_send_nvevent_new_stream_reset`
* Rename `arg1` to `source_id` of `gst_element_send_nvevent_new_stream_reset`
* Datatype of `data` of `nvds_batch_meta_copy_func`: `capsule[NvDsBatchMeta]` instead of `capsule`
* Datatype of `user_meta` of `nvds_batch_meta_copy_func`: `typing.Any` instead of `capsule`
* Rename `user_meta` to `user_data` of `nvds_batch_meta_copy_func`
* Returntype of `nvds_batch_meta_copy_func`: `capsule[NvDsBatchMeta]` instead of `capsule`
* Datatype of `data` of `nvds_batch_meta_release_func`: `capsule[NvDsBatchMeta]` instead of
  `capsule`
* Datatype of `user_data` of `nvds_batch_meta_release_func`: `typing.Any` instead of `capsule`
* Add `NvDsUserMetaList` as an alias of `GList[NvDsUserMeta] | None`
* Datatype of `meta_list` of `nvds_clear_batch_user_meta_list`: `NvDsUserMetaList` instead of `GList`
* Add `NvDisplayMetaList` as an alias of `GList[NvDsDisplayMeta] | None`
* Datatype of `meta_list` of `nvds_clear_display_meta_list`: `NvDisplayMetaList` instead of `GList`
* Add `NvDsFrameMetaList` as an alias of `GList[NvDsFrameMeta] | None`
* Datatype of `meta_list` of `nvds_clear_frame_meta_list`: `NvDsFrameMetaList` instead of `GList`
* Datatype of `meta_list` of `nvds_clear_frame_user_meta_list`: `NvDsUserMetaList` instead of `GList`
* Datatype of `meta_list` of `nvds_clear_meta_list`: `NvDsMetaList` instead of `GList`
* Returntype of `nvds_clear_meta_list`: `NvDsMetaList` instead of `GList`
* Add `NvDsObjectMetaList` as an alias of `GList[NvDsObjectMeta] | None`
* Datatype of `meta_list` of `nvds_clear_obj_meta_list`: `NvDsObjectMetaList` instead of `GList`
* Datatype of `meta_list` of `nvds_clear_obj_user_meta_list`: `NvDsObjectMetaList` instead of `GList`
* Datatype of `src_user_meta_list` of `nvds_copy_batch_user_meta_list`: `NvDsObjectMetaList` instead of `GList`
* Datatype of `src_display_meta` of `nvds_copy_display_meta_list`: `NvDisplayMetaList` instead of `GList`
* Rename `src_display_meta` to `src_display_meta_list` of `nvds_copy_display_meta_list`
* Datatype of `src_frame_meta_list` of `nvds_copy_frame_meta_list`: `NvDsFrameMetaList` instead of `GList`
* Datatype of `src_user_meta_list` of `nvds_copy_frame_user_meta_list`: `NvDsUserMetaList` instead of `GList`
* Datatype of `src_obj_meta_list` of `nvds_copy_obj_meta_list`: `NvDsObjectMetaList` instead of `GList`
* Rename `dst_object_meta` to `dst_frame_meta` of `nvds_copy_obj_meta_list`
* Datatype of `frame_meta_list` of `nvds_get_nth_frame_meta`: `GList[NvDsFrameMeta]` instead of `GList`
* Datatype of `arg0` of `register_user_copyfunc`:
  `typing.Callable[[typing.Any, typing.Any], typing.Any]` instead of
  `typing.Callable[[capsule, capsule], capsule]`
* Datatype of `arg0` of `register_user_releasefunc`:
  `typing.Callable[[typing.Any, typing.Any], None]` instead of
  `typing.Callable[[capsule, capsule], None]`
* Datatype of `arg1` of `set_user_copyfunc`: `typing.Callable[[typing.Any, typing.Any], typing.Any]`
  instead of `typing.Callable[[capsule, capsule], capsule]`
* Datatype of `arg1` of `set_user_releasefunc`: `typing.Callable[[typing.Any, typing.Any], None]`
  instead of `typing.Callable[[capsule, capsule], None]`
* Datatype of `func` of `user_copyfunc`: `typing.Callable[[typing.Any, typing.Any], typing.Any]`
  instead of `typing.Callable[[capsule, capsule], capsule]`
* Datatype of `func` of `user_releasefunc`: `typing.Callable[[typing.Any, typing.Any], None]`
  instead of `typing.Callable[[capsule, capsule], None]`

## License

This project is published
under [Apache License, Version 2.0](https://www.apache.org/licenses/LICENSE-2.0) - please comply
with it, if you use/modify/distribute it. The license can be found in "LICENSE".

## Appendix

### Links

* [Project Home](https://github.com/nkaaf/pyds-stubs)
* [pyds - NVIDIA DeepStream Python Bindings](https://github.com/NVIDIA-AI-IOT/deepstream_python_apps)
* [pybind11-stubgen](https://github.com/sizmailov/pybind11-stubgen)

### Notice for NVIDIA

I recently (Jun, 2025) saw
a [discussion](https://forums.developer.nvidia.com/t/feature-request-add-python-stubs-to-pyds-library/333191/4)
on your forum. If there is any official stub support by NVIDIA, this project will be deprecated and
publicly archived. I hope to hear from you ;)
