---
title: "Models"
sidebar_position: 3
---
# Python SDK Models

:::note
Please note that only `AnyscaleSDK` and imports under `anyscale.sdk` are considered public.
:::

## AccessConfig


Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**use_bearer_token** | **bool** | Flag to enable auth token. Default value is True | [optional] [default to true]

## AppConfig


Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**id** | **str** | Server assigned unique identifier. | [default to null]
**name** | **str** | Name of the App Config. | [default to null]
**project_id** | **str** | ID of the Project this App Config is for. | [optional] [default to null]
**organization_id** | **str** | ID of the Organization this App Config was created in. | [default to null]
**creator_id** | **str** | ID of the User that created this record. | [default to null]
**created_at** | **datetime** | Timestamp of when this record was created. | [default to null]
**last_modified_at** | **datetime** | Timestamp of when this record was last updated. | [default to null]
**deleted_at** | **datetime** | Timestamp of when this record was deleted. | [optional] [default to null]
**archiver_id** | **str** | ID of the User that archived this record. | [optional] [default to null]
**archived_at** | **datetime** | Timestamp of when this record was archived. | [optional] [default to null]
**is_default** | **bool** | True if this App Config is created and managed by anyscale | [optional] [default to false]
**anonymous** | **bool** | True if this is an anonymous app config. | [optional] [default to false]

## AppConfigConfigSchema


Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**base_image** | [**BASEIMAGESENUM**](#baseimagesenum) | The base image used in the app config. It needs to be one of the base images that we ever supported (BASE_IMAGES_HISTORY). | [default to null]
**env_vars** | [**object**](#) | Environment varibles in the docker image that&#39;ll be used at runtime. | [optional] [default to null]
**debian_packages** | **List[str]** | List of debian packages that&#39;ll be included in the image. | [optional] [default to null]
**python** | [**PythonModules**](#pythonmodules) | Python related dependencies. | [optional] [default to null]
**post_build_cmds** | **List[str]** | List of post build commands that&#39;ll be included in the image. For multi-line commands, please make sure those are provided as a single string and not split across multiple strings in the list. | [optional] [default to null]

## ApplyProductionServiceV2Model

DEPRECATED. Please do not use this model directly. Use ApplyServiceModel.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**name** | **str** | Name of the Service | [default to null]
**description** | **str** | Description of the Service | [optional] [default to null]
**project_id** | **str** | Id of the project this Service will start clusters in | [optional] [default to null]
**version** | **str** | A version string that represents the version for this service. Will be populated with the hash of the config if not specified. | [optional] [default to null]
**canary_percent** | **int** | A manual target percent for this service. If this field is not set, the service will automatically roll out. If set, this should be a number between 0 and 100. The newly created version will have weight &#x60;canary_percent&#x60; and the existing version will have &#x60;100 - canary_percent&#x60;. | [optional] [default to null]
**ray_serve_config** | **object** | The Ray Serve config to use for this service. This config defines your Ray Serve application, and will be passed directly to Ray Serve. You can learn more about Ray Serve config files here: https://docs.ray.io/en/latest/serve/production-guide/config.html | [default to null]
**build_id** | **str** | The id of the cluster env build. This id will determine the docker image your Service is run using. | [default to null]
**compute_config_id** | **str** | The id of the compute configuration that you want to use. This id will specify the resources required for your ServiceThe compute template includes a &#x60;cloud_id&#x60; that must be fixed for each service. | [default to null]
**config** | [**ServiceConfig**](#serviceconfig) | Target Service&#39;s configuration | [optional] [default to null]
**rollout_strategy** | [**RolloutStrategy**](#rolloutstrategy) | Strategy for rollout. The ROLLOUT strategy will deploy your Ray Serve configuration onto a newly started cluster, and then shift traffic over to the new cluster. You can manually control the speed of the rollout using the canary_percent configuration. The IN_PLACE strategy will use Ray Serve in place upgrade to update your existing cluster in place. When using this rollout strategy, you may only change the ray_serve_config field. You cannot partially shift traffic or rollback an in place upgrade. In place upgrades are faster and riskier than rollouts, and we recommend only using them for relatively safe changes (for example, increasing the number of replicas on a Ray Serve deployment). Default strategy is ROLLOUT. | [optional] [default to null]
**ray_gcs_external_storage_config** | [**RayGCSExternalStorageConfig**](#raygcsexternalstorageconfig) | Config for the Ray GCS to connect to external storage. If populated, head node fault tolerance will be enabled for this service. | [optional] [default to null]
**tracing_config** | [**TracingConfig**](#tracingconfig) | Config for initializing tracing within Anyscale runtime. | [optional] [default to null]
**auto_complete_rollout** | **bool** | Flag to indicate whether or not to complete the rollout after the canary version reaches 100%. | [optional] [default to true]
**max_surge_percent** | **int** | Max amount of excess capacity allocated during the rollout (0-100). | [optional] [default to null]

## ApplyServiceModel

This is the model used to apply a Service.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**name** | **str** | Name of the Service | [default to null]
**description** | **str** | Description of the Service | [optional] [default to null]
**project_id** | **str** | Id of the project this Service will start clusters in | [optional] [default to null]
**version** | **str** | A version string that represents the version for this service. Will be populated with the hash of the config if not specified. | [optional] [default to null]
**canary_percent** | **int** | A manual target percent for this service. If this field is not set, the service will automatically roll out. If set, this should be a number between 0 and 100. The newly created version will have weight &#x60;canary_percent&#x60; and the existing version will have &#x60;100 - canary_percent&#x60;. | [optional] [default to null]
**ray_serve_config** | **object** | The Ray Serve config to use for this service. This config defines your Ray Serve application, and will be passed directly to Ray Serve. You can learn more about Ray Serve config files here: https://docs.ray.io/en/latest/serve/production-guide/config.html | [default to null]
**build_id** | **str** | The id of the cluster env build. This id will determine the docker image your Service is run using. | [default to null]
**compute_config_id** | **str** | The id of the compute configuration that you want to use. This id will specify the resources required for your ServiceThe compute template includes a &#x60;cloud_id&#x60; that must be fixed for each service. | [default to null]
**config** | [**ServiceConfig**](#serviceconfig) | Target Service&#39;s configuration | [optional] [default to null]
**rollout_strategy** | [**RolloutStrategy**](#rolloutstrategy) | Strategy for rollout. The ROLLOUT strategy will deploy your Ray Serve configuration onto a newly started cluster, and then shift traffic over to the new cluster. You can manually control the speed of the rollout using the canary_percent configuration. The IN_PLACE strategy will use Ray Serve in place upgrade to update your existing cluster in place. When using this rollout strategy, you may only change the ray_serve_config field. You cannot partially shift traffic or rollback an in place upgrade. In place upgrades are faster and riskier than rollouts, and we recommend only using them for relatively safe changes (for example, increasing the number of replicas on a Ray Serve deployment). Default strategy is ROLLOUT. | [optional] [default to null]
**ray_gcs_external_storage_config** | [**RayGCSExternalStorageConfig**](#raygcsexternalstorageconfig) | Config for the Ray GCS to connect to external storage. If populated, head node fault tolerance will be enabled for this service. | [optional] [default to null]
**tracing_config** | [**TracingConfig**](#tracingconfig) | Config for initializing tracing within Anyscale runtime. | [optional] [default to null]
**auto_complete_rollout** | **bool** | Flag to indicate whether or not to complete the rollout after the canary version reaches 100%. | [optional] [default to true]
**max_surge_percent** | **int** | Max amount of excess capacity allocated during the rollout (0-100). | [optional] [default to null]

## ArchiveStatus

An enumeration.

Possible Values:
['ARCHIVED', 'NOT_ARCHIVED', 'ALL']

## BASEIMAGESENUM

An enumeration.

Possible Values:
['anyscale/ray-llm:2.44.0-py311-cu124', 'anyscale/ray-llm:2.44.1-py311-cu124', 'anyscale/ray-llm:2.45.0-py311-cu124', 'anyscale/ray-llm:2.46.0-py311-cu124', 'anyscale/ray-llm:2.47.0-py311-cu124', 'anyscale/ray-llm:2.47.1-py311-cu124', 'anyscale/ray-llm:2.48.0-py311-cu128', 'anyscale/ray-llm:2.49.0-py311-cu128', 'anyscale/ray-llm:2.49.1-py311-cu128', 'anyscale/ray-llm:nightly-py311-cu128', 'anyscale/ray-ml:1.10.0-py36-gpu', 'anyscale/ray-ml:1.10.0-py37-gpu', 'anyscale/ray-ml:1.10.0-py38-gpu', 'anyscale/ray-ml:1.10.0rc0-py36-gpu', 'anyscale/ray-ml:1.10.0rc0-py37-gpu', 'anyscale/ray-ml:1.10.0rc0-py38-gpu', 'anyscale/ray-ml:1.11.0-py36-gpu', 'anyscale/ray-ml:1.11.0-py37-gpu', 'anyscale/ray-ml:1.11.0-py38-gpu', 'anyscale/ray-ml:1.11.1-py36-gpu', 'anyscale/ray-ml:1.11.1-py37-gpu', 'anyscale/ray-ml:1.11.1-py38-gpu', 'anyscale/ray-ml:1.12.0-py36-gpu', 'anyscale/ray-ml:1.12.0-py37-gpu', 'anyscale/ray-ml:1.12.0-py38-gpu', 'anyscale/ray-ml:1.12.1-py36-gpu', 'anyscale/ray-ml:1.12.1-py37-gpu', 'anyscale/ray-ml:1.12.1-py38-gpu', 'anyscale/ray-ml:1.13.0-py36-cpu', 'anyscale/ray-ml:1.13.0-py36-gpu', 'anyscale/ray-ml:1.13.0-py37-cpu', 'anyscale/ray-ml:1.13.0-py37-gpu', 'anyscale/ray-ml:1.13.0-py38-cpu', 'anyscale/ray-ml:1.13.0-py38-gpu', 'anyscale/ray-ml:1.13.0rc0-py36-gpu', 'anyscale/ray-ml:1.13.0rc0-py37-gpu', 'anyscale/ray-ml:1.13.0rc0-py38-gpu', 'anyscale/ray-ml:1.7.0', 'anyscale/ray-ml:1.7.0-gpu', 'anyscale/ray-ml:1.7.0-py36', 'anyscale/ray-ml:1.7.0-py36-gpu', 'anyscale/ray-ml:1.7.0-py37', 'anyscale/ray-ml:1.7.0-py37-gpu', 'anyscale/ray-ml:1.7.0-py38', 'anyscale/ray-ml:1.7.0-py38-gpu', 'anyscale/ray-ml:1.7.0rc0', 'anyscale/ray-ml:1.7.0rc0-gpu', 'anyscale/ray-ml:1.7.0rc0-py36', 'anyscale/ray-ml:1.7.0rc0-py36-gpu', 'anyscale/ray-ml:1.7.0rc0-py37', 'anyscale/ray-ml:1.7.0rc0-py37-gpu', 'anyscale/ray-ml:1.7.0rc0-py38', 'anyscale/ray-ml:1.7.0rc0-py38-gpu', 'anyscale/ray-ml:1.7.1', 'anyscale/ray-ml:1.7.1-gpu', 'anyscale/ray-ml:1.7.1-py36', 'anyscale/ray-ml:1.7.1-py36-gpu', 'anyscale/ray-ml:1.7.1-py37', 'anyscale/ray-ml:1.7.1-py37-gpu', 'anyscale/ray-ml:1.7.1-py38', 'anyscale/ray-ml:1.7.1-py38-gpu', 'anyscale/ray-ml:1.8.0', 'anyscale/ray-ml:1.8.0-gpu', 'anyscale/ray-ml:1.8.0-py36', 'anyscale/ray-ml:1.8.0-py36-gpu', 'anyscale/ray-ml:1.8.0-py37', 'anyscale/ray-ml:1.8.0-py37-gpu', 'anyscale/ray-ml:1.8.0-py38', 'anyscale/ray-ml:1.8.0-py38-gpu', 'anyscale/ray-ml:1.9.0-py36-gpu', 'anyscale/ray-ml:1.9.0-py37-gpu', 'anyscale/ray-ml:1.9.0-py38-gpu', 'anyscale/ray-ml:1.9.0rc1-py36-gpu', 'anyscale/ray-ml:1.9.0rc1-py37-gpu', 'anyscale/ray-ml:1.9.0rc1-py38-gpu', 'anyscale/ray-ml:1.9.0rc2-py36-gpu', 'anyscale/ray-ml:1.9.0rc2-py37-gpu', 'anyscale/ray-ml:1.9.0rc2-py38-gpu', 'anyscale/ray-ml:1.9.1-py36-gpu', 'anyscale/ray-ml:1.9.1-py37-gpu', 'anyscale/ray-ml:1.9.1-py38-gpu', 'anyscale/ray-ml:1.9.1rc0-py36-gpu', 'anyscale/ray-ml:1.9.1rc0-py37-gpu', 'anyscale/ray-ml:1.9.1rc0-py38-gpu', 'anyscale/ray-ml:1.9.2-py36-gpu', 'anyscale/ray-ml:1.9.2-py37-gpu', 'anyscale/ray-ml:1.9.2-py38-gpu', 'anyscale/ray-ml:2.0.0-py36-cpu', 'anyscale/ray-ml:2.0.0-py36-gpu', 'anyscale/ray-ml:2.0.0-py37-cpu', 'anyscale/ray-ml:2.0.0-py37-gpu', 'anyscale/ray-ml:2.0.0-py38-cpu', 'anyscale/ray-ml:2.0.0-py38-gpu', 'anyscale/ray-ml:2.0.0rc0-py36-cpu', 'anyscale/ray-ml:2.0.0rc0-py36-gpu', 'anyscale/ray-ml:2.0.0rc0-py37-cpu', 'anyscale/ray-ml:2.0.0rc0-py37-gpu', 'anyscale/ray-ml:2.0.0rc0-py38-cpu', 'anyscale/ray-ml:2.0.0rc0-py38-gpu', 'anyscale/ray-ml:2.0.0rc1-py36-cpu', 'anyscale/ray-ml:2.0.0rc1-py36-gpu', 'anyscale/ray-ml:2.0.0rc1-py37-cpu', 'anyscale/ray-ml:2.0.0rc1-py37-gpu', 'anyscale/ray-ml:2.0.0rc1-py38-cpu', 'anyscale/ray-ml:2.0.0rc1-py38-gpu', 'anyscale/ray-ml:2.0.1-py36-cpu', 'anyscale/ray-ml:2.0.1-py36-gpu', 'anyscale/ray-ml:2.0.1-py37-cpu', 'anyscale/ray-ml:2.0.1-py37-gpu', 'anyscale/ray-ml:2.0.1-py38-cpu', 'anyscale/ray-ml:2.0.1-py38-gpu', 'anyscale/ray-ml:2.1.0-py36-cpu', 'anyscale/ray-ml:2.1.0-py36-gpu', 'anyscale/ray-ml:2.1.0-py37-cpu', 'anyscale/ray-ml:2.1.0-py37-gpu', 'anyscale/ray-ml:2.1.0-py38-cpu', 'anyscale/ray-ml:2.1.0-py38-gpu', 'anyscale/ray-ml:2.10.0-py310-cpu', 'anyscale/ray-ml:2.10.0-py310-gpu', 'anyscale/ray-ml:2.10.0-py38-cpu', 'anyscale/ray-ml:2.10.0-py38-gpu', 'anyscale/ray-ml:2.10.0-py39-cpu', 'anyscale/ray-ml:2.10.0-py39-gpu', 'anyscale/ray-ml:2.11.0-py310-cpu', 'anyscale/ray-ml:2.11.0-py310-gpu', 'anyscale/ray-ml:2.11.0-py311-cpu', 'anyscale/ray-ml:2.11.0-py311-gpu', 'anyscale/ray-ml:2.11.0-py39-cpu', 'anyscale/ray-ml:2.11.0-py39-gpu', 'anyscale/ray-ml:2.12.0-py310-cpu', 'anyscale/ray-ml:2.12.0-py310-gpu', 'anyscale/ray-ml:2.12.0-py311-cpu', 'anyscale/ray-ml:2.12.0-py311-gpu', 'anyscale/ray-ml:2.12.0-py39-cpu', 'anyscale/ray-ml:2.12.0-py39-gpu', 'anyscale/ray-ml:2.2.0-py310-cpu', 'anyscale/ray-ml:2.2.0-py310-gpu', 'anyscale/ray-ml:2.2.0-py37-cpu', 'anyscale/ray-ml:2.2.0-py37-gpu', 'anyscale/ray-ml:2.2.0-py38-cpu', 'anyscale/ray-ml:2.2.0-py38-gpu', 'anyscale/ray-ml:2.2.0-py39-cpu', 'anyscale/ray-ml:2.2.0-py39-gpu', 'anyscale/ray-ml:2.20.0-py310-cpu', 'anyscale/ray-ml:2.20.0-py310-gpu', 'anyscale/ray-ml:2.20.0-py311-cpu', 'anyscale/ray-ml:2.20.0-py311-gpu', 'anyscale/ray-ml:2.20.0-py39-cpu', 'anyscale/ray-ml:2.20.0-py39-gpu', 'anyscale/ray-ml:2.21.0-py310-cpu', 'anyscale/ray-ml:2.21.0-py310-gpu', 'anyscale/ray-ml:2.21.0-py311-cpu', 'anyscale/ray-ml:2.21.0-py311-gpu', 'anyscale/ray-ml:2.21.0-py39-cpu', 'anyscale/ray-ml:2.21.0-py39-gpu', 'anyscale/ray-ml:2.22.0-py310-cpu', 'anyscale/ray-ml:2.22.0-py310-gpu', 'anyscale/ray-ml:2.22.0-py311-cpu', 'anyscale/ray-ml:2.22.0-py311-gpu', 'anyscale/ray-ml:2.22.0-py39-cpu', 'anyscale/ray-ml:2.22.0-py39-gpu', 'anyscale/ray-ml:2.23.0-py310-cpu', 'anyscale/ray-ml:2.23.0-py310-gpu', 'anyscale/ray-ml:2.23.0-py311-cpu', 'anyscale/ray-ml:2.23.0-py311-gpu', 'anyscale/ray-ml:2.23.0-py39-cpu', 'anyscale/ray-ml:2.23.0-py39-gpu', 'anyscale/ray-ml:2.24.0-py310-cpu', 'anyscale/ray-ml:2.24.0-py310-gpu', 'anyscale/ray-ml:2.24.0-py311-cpu', 'anyscale/ray-ml:2.24.0-py311-gpu', 'anyscale/ray-ml:2.24.0-py39-cpu', 'anyscale/ray-ml:2.24.0-py39-gpu', 'anyscale/ray-ml:2.3.0-py310-cpu', 'anyscale/ray-ml:2.3.0-py310-gpu', 'anyscale/ray-ml:2.3.0-py37-cpu', 'anyscale/ray-ml:2.3.0-py37-gpu', 'anyscale/ray-ml:2.3.0-py38-cpu', 'anyscale/ray-ml:2.3.0-py38-gpu', 'anyscale/ray-ml:2.3.0-py39-cpu', 'anyscale/ray-ml:2.3.0-py39-gpu', 'anyscale/ray-ml:2.3.1-py310-cpu', 'anyscale/ray-ml:2.3.1-py310-gpu', 'anyscale/ray-ml:2.3.1-py37-cpu', 'anyscale/ray-ml:2.3.1-py37-gpu', 'anyscale/ray-ml:2.3.1-py38-cpu', 'anyscale/ray-ml:2.3.1-py38-gpu', 'anyscale/ray-ml:2.3.1-py39-cpu', 'anyscale/ray-ml:2.3.1-py39-gpu', 'anyscale/ray-ml:2.30.0-py310-cpu', 'anyscale/ray-ml:2.30.0-py310-gpu', 'anyscale/ray-ml:2.30.0-py311-cpu', 'anyscale/ray-ml:2.30.0-py311-gpu', 'anyscale/ray-ml:2.30.0-py39-cpu', 'anyscale/ray-ml:2.30.0-py39-gpu', 'anyscale/ray-ml:2.31.0-py310-cpu', 'anyscale/ray-ml:2.31.0-py310-gpu', 'anyscale/ray-ml:2.31.0-py311-cpu', 'anyscale/ray-ml:2.31.0-py311-gpu', 'anyscale/ray-ml:2.31.0-py39-cpu', 'anyscale/ray-ml:2.31.0-py39-gpu', 'anyscale/ray-ml:2.32.0-py310-cpu', 'anyscale/ray-ml:2.32.0-py310-gpu', 'anyscale/ray-ml:2.32.0-py311-cpu', 'anyscale/ray-ml:2.32.0-py311-gpu', 'anyscale/ray-ml:2.32.0-py39-cpu', 'anyscale/ray-ml:2.32.0-py39-gpu', 'anyscale/ray-ml:2.33.0-py310-cpu', 'anyscale/ray-ml:2.33.0-py310-gpu', 'anyscale/ray-ml:2.33.0-py311-cpu', 'anyscale/ray-ml:2.33.0-py311-gpu', 'anyscale/ray-ml:2.33.0-py39-cpu', 'anyscale/ray-ml:2.33.0-py39-gpu', 'anyscale/ray-ml:2.34.0-py310-cpu', 'anyscale/ray-ml:2.34.0-py310-gpu', 'anyscale/ray-ml:2.34.0-py311-cpu', 'anyscale/ray-ml:2.34.0-py311-gpu', 'anyscale/ray-ml:2.34.0-py39-cpu', 'anyscale/ray-ml:2.34.0-py39-gpu', 'anyscale/ray-ml:2.35.0-py310-cpu', 'anyscale/ray-ml:2.35.0-py310-gpu', 'anyscale/ray-ml:2.35.0-py311-cpu', 'anyscale/ray-ml:2.35.0-py311-gpu', 'anyscale/ray-ml:2.35.0-py39-cpu', 'anyscale/ray-ml:2.35.0-py39-gpu', 'anyscale/ray-ml:2.36.0-py310-cpu', 'anyscale/ray-ml:2.36.0-py310-gpu', 'anyscale/ray-ml:2.36.0-py311-cpu', 'anyscale/ray-ml:2.36.0-py311-gpu', 'anyscale/ray-ml:2.36.0-py39-cpu', 'anyscale/ray-ml:2.36.0-py39-gpu', 'anyscale/ray-ml:2.36.1-py310-cpu', 'anyscale/ray-ml:2.36.1-py310-gpu', 'anyscale/ray-ml:2.36.1-py311-cpu', 'anyscale/ray-ml:2.36.1-py311-gpu', 'anyscale/ray-ml:2.36.1-py39-cpu', 'anyscale/ray-ml:2.36.1-py39-gpu', 'anyscale/ray-ml:2.37.0-py310-cpu', 'anyscale/ray-ml:2.37.0-py310-gpu', 'anyscale/ray-ml:2.37.0-py311-cpu', 'anyscale/ray-ml:2.37.0-py311-gpu', 'anyscale/ray-ml:2.37.0-py39-cpu', 'anyscale/ray-ml:2.37.0-py39-gpu', 'anyscale/ray-ml:2.38.0-py310-cpu', 'anyscale/ray-ml:2.38.0-py310-gpu', 'anyscale/ray-ml:2.38.0-py311-cpu', 'anyscale/ray-ml:2.38.0-py311-gpu', 'anyscale/ray-ml:2.38.0-py39-cpu', 'anyscale/ray-ml:2.38.0-py39-gpu', 'anyscale/ray-ml:2.39.0-py310-cpu', 'anyscale/ray-ml:2.39.0-py310-gpu', 'anyscale/ray-ml:2.39.0-py311-cpu', 'anyscale/ray-ml:2.39.0-py311-gpu', 'anyscale/ray-ml:2.39.0-py39-cpu', 'anyscale/ray-ml:2.39.0-py39-gpu', 'anyscale/ray-ml:2.4.0-py310-cpu', 'anyscale/ray-ml:2.4.0-py310-gpu', 'anyscale/ray-ml:2.4.0-py37-cpu', 'anyscale/ray-ml:2.4.0-py37-gpu', 'anyscale/ray-ml:2.4.0-py38-cpu', 'anyscale/ray-ml:2.4.0-py38-gpu', 'anyscale/ray-ml:2.4.0-py39-cpu', 'anyscale/ray-ml:2.4.0-py39-gpu', 'anyscale/ray-ml:2.40.0-py310-cpu', 'anyscale/ray-ml:2.40.0-py310-gpu', 'anyscale/ray-ml:2.40.0-py311-cpu', 'anyscale/ray-ml:2.40.0-py311-gpu', 'anyscale/ray-ml:2.40.0-py39-cpu', 'anyscale/ray-ml:2.40.0-py39-gpu', 'anyscale/ray-ml:2.41.0-py310-cpu', 'anyscale/ray-ml:2.41.0-py310-gpu', 'anyscale/ray-ml:2.41.0-py311-cpu', 'anyscale/ray-ml:2.41.0-py311-gpu', 'anyscale/ray-ml:2.41.0-py39-cpu', 'anyscale/ray-ml:2.41.0-py39-gpu', 'anyscale/ray-ml:2.42.0-py310-cpu', 'anyscale/ray-ml:2.42.0-py310-gpu', 'anyscale/ray-ml:2.42.0-py311-cpu', 'anyscale/ray-ml:2.42.0-py311-gpu', 'anyscale/ray-ml:2.42.0-py39-cpu', 'anyscale/ray-ml:2.42.0-py39-gpu', 'anyscale/ray-ml:2.42.1-py310-cpu', 'anyscale/ray-ml:2.42.1-py310-gpu', 'anyscale/ray-ml:2.42.1-py311-cpu', 'anyscale/ray-ml:2.42.1-py311-gpu', 'anyscale/ray-ml:2.42.1-py39-cpu', 'anyscale/ray-ml:2.42.1-py39-gpu', 'anyscale/ray-ml:2.43.0-py310-cpu', 'anyscale/ray-ml:2.43.0-py310-gpu', 'anyscale/ray-ml:2.43.0-py311-cpu', 'anyscale/ray-ml:2.43.0-py311-gpu', 'anyscale/ray-ml:2.43.0-py39-cpu', 'anyscale/ray-ml:2.43.0-py39-gpu', 'anyscale/ray-ml:2.44.0-py310-cpu', 'anyscale/ray-ml:2.44.0-py310-gpu', 'anyscale/ray-ml:2.44.0-py311-cpu', 'anyscale/ray-ml:2.44.0-py311-gpu', 'anyscale/ray-ml:2.44.0-py39-cpu', 'anyscale/ray-ml:2.44.0-py39-gpu', 'anyscale/ray-ml:2.44.1-py310-cpu', 'anyscale/ray-ml:2.44.1-py310-gpu', 'anyscale/ray-ml:2.44.1-py311-cpu', 'anyscale/ray-ml:2.44.1-py311-gpu', 'anyscale/ray-ml:2.44.1-py39-cpu', 'anyscale/ray-ml:2.44.1-py39-gpu', 'anyscale/ray-ml:2.45.0-py310-cpu', 'anyscale/ray-ml:2.45.0-py310-gpu', 'anyscale/ray-ml:2.45.0-py311-cpu', 'anyscale/ray-ml:2.45.0-py311-gpu', 'anyscale/ray-ml:2.45.0-py39-cpu', 'anyscale/ray-ml:2.45.0-py39-gpu', 'anyscale/ray-ml:2.46.0-py310-cpu', 'anyscale/ray-ml:2.46.0-py310-gpu', 'anyscale/ray-ml:2.46.0-py311-cpu', 'anyscale/ray-ml:2.46.0-py311-gpu', 'anyscale/ray-ml:2.46.0-py39-cpu', 'anyscale/ray-ml:2.46.0-py39-gpu', 'anyscale/ray-ml:2.47.0-py310-cpu', 'anyscale/ray-ml:2.47.0-py310-gpu', 'anyscale/ray-ml:2.47.0-py311-cpu', 'anyscale/ray-ml:2.47.0-py311-gpu', 'anyscale/ray-ml:2.47.0-py39-cpu', 'anyscale/ray-ml:2.47.0-py39-gpu', 'anyscale/ray-ml:2.47.1-py310-cpu', 'anyscale/ray-ml:2.47.1-py310-gpu', 'anyscale/ray-ml:2.47.1-py311-cpu', 'anyscale/ray-ml:2.47.1-py311-gpu', 'anyscale/ray-ml:2.47.1-py39-cpu', 'anyscale/ray-ml:2.47.1-py39-gpu', 'anyscale/ray-ml:2.48.0-py310-cpu', 'anyscale/ray-ml:2.48.0-py310-gpu', 'anyscale/ray-ml:2.48.0-py311-cpu', 'anyscale/ray-ml:2.48.0-py311-gpu', 'anyscale/ray-ml:2.48.0-py39-cpu', 'anyscale/ray-ml:2.48.0-py39-gpu', 'anyscale/ray-ml:2.49.0-py310-cpu', 'anyscale/ray-ml:2.49.0-py310-gpu', 'anyscale/ray-ml:2.49.0-py311-cpu', 'anyscale/ray-ml:2.49.0-py311-gpu', 'anyscale/ray-ml:2.49.0-py39-cpu', 'anyscale/ray-ml:2.49.0-py39-gpu', 'anyscale/ray-ml:2.49.1-py310-cpu', 'anyscale/ray-ml:2.49.1-py310-gpu', 'anyscale/ray-ml:2.49.1-py311-cpu', 'anyscale/ray-ml:2.49.1-py311-gpu', 'anyscale/ray-ml:2.49.1-py39-cpu', 'anyscale/ray-ml:2.49.1-py39-gpu', 'anyscale/ray-ml:2.5.0-py310-cpu', 'anyscale/ray-ml:2.5.0-py310-gpu', 'anyscale/ray-ml:2.5.0-py37-cpu', 'anyscale/ray-ml:2.5.0-py37-gpu', 'anyscale/ray-ml:2.5.0-py38-cpu', 'anyscale/ray-ml:2.5.0-py38-gpu', 'anyscale/ray-ml:2.5.0-py39-cpu', 'anyscale/ray-ml:2.5.0-py39-gpu', 'anyscale/ray-ml:2.5.1-py310-cpu', 'anyscale/ray-ml:2.5.1-py310-gpu', 'anyscale/ray-ml:2.5.1-py37-cpu', 'anyscale/ray-ml:2.5.1-py37-gpu', 'anyscale/ray-ml:2.5.1-py38-cpu', 'anyscale/ray-ml:2.5.1-py38-gpu', 'anyscale/ray-ml:2.5.1-py39-cpu', 'anyscale/ray-ml:2.5.1-py39-gpu', 'anyscale/ray-ml:2.6.0-py310-cpu', 'anyscale/ray-ml:2.6.0-py310-gpu', 'anyscale/ray-ml:2.6.0-py38-cpu', 'anyscale/ray-ml:2.6.0-py38-gpu', 'anyscale/ray-ml:2.6.0-py39-cpu', 'anyscale/ray-ml:2.6.0-py39-gpu', 'anyscale/ray-ml:2.6.1-py310-cpu', 'anyscale/ray-ml:2.6.1-py310-gpu', 'anyscale/ray-ml:2.6.1-py38-cpu', 'anyscale/ray-ml:2.6.1-py38-gpu', 'anyscale/ray-ml:2.6.1-py39-cpu', 'anyscale/ray-ml:2.6.1-py39-gpu', 'anyscale/ray-ml:2.6.2-py310-cpu', 'anyscale/ray-ml:2.6.2-py310-gpu', 'anyscale/ray-ml:2.6.2-py38-cpu', 'anyscale/ray-ml:2.6.2-py38-gpu', 'anyscale/ray-ml:2.6.2-py39-cpu', 'anyscale/ray-ml:2.6.2-py39-gpu', 'anyscale/ray-ml:2.6.3-py310-cpu', 'anyscale/ray-ml:2.6.3-py310-gpu', 'anyscale/ray-ml:2.6.3-py38-cpu', 'anyscale/ray-ml:2.6.3-py38-gpu', 'anyscale/ray-ml:2.6.3-py39-cpu', 'anyscale/ray-ml:2.6.3-py39-gpu', 'anyscale/ray-ml:2.7.0optimized-py310-cpu', 'anyscale/ray-ml:2.7.0optimized-py310-gpu', 'anyscale/ray-ml:2.7.0optimized-py38-cpu', 'anyscale/ray-ml:2.7.0optimized-py38-gpu', 'anyscale/ray-ml:2.7.0optimized-py39-cpu', 'anyscale/ray-ml:2.7.0optimized-py39-gpu', 'anyscale/ray-ml:2.7.1optimized-py310-cpu', 'anyscale/ray-ml:2.7.1optimized-py310-gpu', 'anyscale/ray-ml:2.7.1optimized-py38-cpu', 'anyscale/ray-ml:2.7.1optimized-py38-gpu', 'anyscale/ray-ml:2.7.1optimized-py39-cpu', 'anyscale/ray-ml:2.7.1optimized-py39-gpu', 'anyscale/ray-ml:2.7.2optimized-py310-cpu', 'anyscale/ray-ml:2.7.2optimized-py310-gpu', 'anyscale/ray-ml:2.7.2optimized-py38-cpu', 'anyscale/ray-ml:2.7.2optimized-py38-gpu', 'anyscale/ray-ml:2.7.2optimized-py39-cpu', 'anyscale/ray-ml:2.7.2optimized-py39-gpu', 'anyscale/ray-ml:2.8.0-py310-cpu', 'anyscale/ray-ml:2.8.0-py310-gpu', 'anyscale/ray-ml:2.8.0-py38-cpu', 'anyscale/ray-ml:2.8.0-py38-gpu', 'anyscale/ray-ml:2.8.0-py39-cpu', 'anyscale/ray-ml:2.8.0-py39-gpu', 'anyscale/ray-ml:2.8.1-py310-cpu', 'anyscale/ray-ml:2.8.1-py310-gpu', 'anyscale/ray-ml:2.8.1-py38-cpu', 'anyscale/ray-ml:2.8.1-py38-gpu', 'anyscale/ray-ml:2.8.1-py39-cpu', 'anyscale/ray-ml:2.8.1-py39-gpu', 'anyscale/ray-ml:2.9.0-py310-cpu', 'anyscale/ray-ml:2.9.0-py310-gpu', 'anyscale/ray-ml:2.9.0-py38-cpu', 'anyscale/ray-ml:2.9.0-py38-gpu', 'anyscale/ray-ml:2.9.0-py39-cpu', 'anyscale/ray-ml:2.9.0-py39-gpu', 'anyscale/ray-ml:2.9.1-py310-cpu', 'anyscale/ray-ml:2.9.1-py310-gpu', 'anyscale/ray-ml:2.9.1-py38-cpu', 'anyscale/ray-ml:2.9.1-py38-gpu', 'anyscale/ray-ml:2.9.1-py39-cpu', 'anyscale/ray-ml:2.9.1-py39-gpu', 'anyscale/ray-ml:2.9.2-py310-cpu', 'anyscale/ray-ml:2.9.2-py310-gpu', 'anyscale/ray-ml:2.9.2-py38-cpu', 'anyscale/ray-ml:2.9.2-py38-gpu', 'anyscale/ray-ml:2.9.2-py39-cpu', 'anyscale/ray-ml:2.9.2-py39-gpu', 'anyscale/ray-ml:2.9.3-py310-cpu', 'anyscale/ray-ml:2.9.3-py310-gpu', 'anyscale/ray-ml:2.9.3-py38-cpu', 'anyscale/ray-ml:2.9.3-py38-gpu', 'anyscale/ray-ml:2.9.3-py39-cpu', 'anyscale/ray-ml:2.9.3-py39-gpu', 'anyscale/ray-ml:latest', 'anyscale/ray-ml:nightly', 'anyscale/ray-ml:nightly-gpu', 'anyscale/ray-ml:nightly-py310-gpu', 'anyscale/ray-ml:nightly-py311-gpu', 'anyscale/ray-ml:nightly-py36-gpu', 'anyscale/ray-ml:nightly-py37-gpu', 'anyscale/ray-ml:nightly-py38-gpu', 'anyscale/ray-ml:nightly-py39-gpu', 'anyscale/ray-ml:pinned-nightly', 'anyscale/ray-ml:pinned-nightly-gpu', 'anyscale/ray-ml:pinned-nightly-py310', 'anyscale/ray-ml:pinned-nightly-py310-gpu', 'anyscale/ray-ml:pinned-nightly-py311', 'anyscale/ray-ml:pinned-nightly-py311-gpu', 'anyscale/ray-ml:pinned-nightly-py36', 'anyscale/ray-ml:pinned-nightly-py36-gpu', 'anyscale/ray-ml:pinned-nightly-py37', 'anyscale/ray-ml:pinned-nightly-py37-gpu', 'anyscale/ray-ml:pinned-nightly-py38', 'anyscale/ray-ml:pinned-nightly-py38-gpu', 'anyscale/ray-ml:pinned-nightly-py39', 'anyscale/ray-ml:pinned-nightly-py39-gpu', 'anyscale/ray:1.10.0-py36', 'anyscale/ray:1.10.0-py36-cu101', 'anyscale/ray:1.10.0-py36-cu102', 'anyscale/ray:1.10.0-py36-cu110', 'anyscale/ray:1.10.0-py36-cu111', 'anyscale/ray:1.10.0-py36-cu112', 'anyscale/ray:1.10.0-py37', 'anyscale/ray:1.10.0-py37-cu101', 'anyscale/ray:1.10.0-py37-cu102', 'anyscale/ray:1.10.0-py37-cu110', 'anyscale/ray:1.10.0-py37-cu111', 'anyscale/ray:1.10.0-py37-cu112', 'anyscale/ray:1.10.0-py38', 'anyscale/ray:1.10.0-py38-cu101', 'anyscale/ray:1.10.0-py38-cu102', 'anyscale/ray:1.10.0-py38-cu110', 'anyscale/ray:1.10.0-py38-cu111', 'anyscale/ray:1.10.0-py38-cu112', 'anyscale/ray:1.10.0-py39', 'anyscale/ray:1.10.0-py39-cu101', 'anyscale/ray:1.10.0-py39-cu102', 'anyscale/ray:1.10.0-py39-cu110', 'anyscale/ray:1.10.0-py39-cu111', 'anyscale/ray:1.10.0-py39-cu112', 'anyscale/ray:1.10.0rc0-py36', 'anyscale/ray:1.10.0rc0-py36-cu101', 'anyscale/ray:1.10.0rc0-py36-cu102', 'anyscale/ray:1.10.0rc0-py36-cu110', 'anyscale/ray:1.10.0rc0-py36-cu111', 'anyscale/ray:1.10.0rc0-py36-cu112', 'anyscale/ray:1.10.0rc0-py37', 'anyscale/ray:1.10.0rc0-py37-cu101', 'anyscale/ray:1.10.0rc0-py37-cu102', 'anyscale/ray:1.10.0rc0-py37-cu110', 'anyscale/ray:1.10.0rc0-py37-cu111', 'anyscale/ray:1.10.0rc0-py37-cu112', 'anyscale/ray:1.10.0rc0-py38', 'anyscale/ray:1.10.0rc0-py38-cu101', 'anyscale/ray:1.10.0rc0-py38-cu102', 'anyscale/ray:1.10.0rc0-py38-cu110', 'anyscale/ray:1.10.0rc0-py38-cu111', 'anyscale/ray:1.10.0rc0-py38-cu112', 'anyscale/ray:1.11.0-py36', 'anyscale/ray:1.11.0-py36-cu101', 'anyscale/ray:1.11.0-py36-cu102', 'anyscale/ray:1.11.0-py36-cu110', 'anyscale/ray:1.11.0-py36-cu111', 'anyscale/ray:1.11.0-py36-cu112', 'anyscale/ray:1.11.0-py37', 'anyscale/ray:1.11.0-py37-cu101', 'anyscale/ray:1.11.0-py37-cu102', 'anyscale/ray:1.11.0-py37-cu110', 'anyscale/ray:1.11.0-py37-cu111', 'anyscale/ray:1.11.0-py37-cu112', 'anyscale/ray:1.11.0-py38', 'anyscale/ray:1.11.0-py38-cu101', 'anyscale/ray:1.11.0-py38-cu102', 'anyscale/ray:1.11.0-py38-cu110', 'anyscale/ray:1.11.0-py38-cu111', 'anyscale/ray:1.11.0-py38-cu112', 'anyscale/ray:1.11.0-py39', 'anyscale/ray:1.11.0-py39-cu101', 'anyscale/ray:1.11.0-py39-cu102', 'anyscale/ray:1.11.0-py39-cu110', 'anyscale/ray:1.11.0-py39-cu111', 'anyscale/ray:1.11.0-py39-cu112', 'anyscale/ray:1.11.1-py36', 'anyscale/ray:1.11.1-py36-cu101', 'anyscale/ray:1.11.1-py36-cu102', 'anyscale/ray:1.11.1-py36-cu110', 'anyscale/ray:1.11.1-py36-cu111', 'anyscale/ray:1.11.1-py36-cu112', 'anyscale/ray:1.11.1-py37', 'anyscale/ray:1.11.1-py37-cu101', 'anyscale/ray:1.11.1-py37-cu102', 'anyscale/ray:1.11.1-py37-cu110', 'anyscale/ray:1.11.1-py37-cu111', 'anyscale/ray:1.11.1-py37-cu112', 'anyscale/ray:1.11.1-py38', 'anyscale/ray:1.11.1-py38-cu101', 'anyscale/ray:1.11.1-py38-cu102', 'anyscale/ray:1.11.1-py38-cu110', 'anyscale/ray:1.11.1-py38-cu111', 'anyscale/ray:1.11.1-py38-cu112', 'anyscale/ray:1.11.1-py39', 'anyscale/ray:1.11.1-py39-cu101', 'anyscale/ray:1.11.1-py39-cu102', 'anyscale/ray:1.11.1-py39-cu110', 'anyscale/ray:1.11.1-py39-cu111', 'anyscale/ray:1.11.1-py39-cu112', 'anyscale/ray:1.12.0-py36', 'anyscale/ray:1.12.0-py36-cu101', 'anyscale/ray:1.12.0-py36-cu102', 'anyscale/ray:1.12.0-py36-cu110', 'anyscale/ray:1.12.0-py36-cu111', 'anyscale/ray:1.12.0-py36-cu112', 'anyscale/ray:1.12.0-py37', 'anyscale/ray:1.12.0-py37-cu101', 'anyscale/ray:1.12.0-py37-cu102', 'anyscale/ray:1.12.0-py37-cu110', 'anyscale/ray:1.12.0-py37-cu111', 'anyscale/ray:1.12.0-py37-cu112', 'anyscale/ray:1.12.0-py38', 'anyscale/ray:1.12.0-py38-cu101', 'anyscale/ray:1.12.0-py38-cu102', 'anyscale/ray:1.12.0-py38-cu110', 'anyscale/ray:1.12.0-py38-cu111', 'anyscale/ray:1.12.0-py38-cu112', 'anyscale/ray:1.12.0-py39', 'anyscale/ray:1.12.0-py39-cu101', 'anyscale/ray:1.12.0-py39-cu102', 'anyscale/ray:1.12.0-py39-cu110', 'anyscale/ray:1.12.0-py39-cu111', 'anyscale/ray:1.12.0-py39-cu112', 'anyscale/ray:1.12.1-py36', 'anyscale/ray:1.12.1-py36-cu101', 'anyscale/ray:1.12.1-py36-cu102', 'anyscale/ray:1.12.1-py36-cu110', 'anyscale/ray:1.12.1-py36-cu111', 'anyscale/ray:1.12.1-py36-cu112', 'anyscale/ray:1.12.1-py37', 'anyscale/ray:1.12.1-py37-cu101', 'anyscale/ray:1.12.1-py37-cu102', 'anyscale/ray:1.12.1-py37-cu110', 'anyscale/ray:1.12.1-py37-cu111', 'anyscale/ray:1.12.1-py37-cu112', 'anyscale/ray:1.12.1-py38', 'anyscale/ray:1.12.1-py38-cu101', 'anyscale/ray:1.12.1-py38-cu102', 'anyscale/ray:1.12.1-py38-cu110', 'anyscale/ray:1.12.1-py38-cu111', 'anyscale/ray:1.12.1-py38-cu112', 'anyscale/ray:1.12.1-py39', 'anyscale/ray:1.12.1-py39-cu101', 'anyscale/ray:1.12.1-py39-cu102', 'anyscale/ray:1.12.1-py39-cu110', 'anyscale/ray:1.12.1-py39-cu111', 'anyscale/ray:1.12.1-py39-cu112', 'anyscale/ray:1.13.0-py310', 'anyscale/ray:1.13.0-py36', 'anyscale/ray:1.13.0-py36-cu101', 'anyscale/ray:1.13.0-py36-cu102', 'anyscale/ray:1.13.0-py36-cu110', 'anyscale/ray:1.13.0-py36-cu111', 'anyscale/ray:1.13.0-py36-cu112', 'anyscale/ray:1.13.0-py37', 'anyscale/ray:1.13.0-py37-cu101', 'anyscale/ray:1.13.0-py37-cu102', 'anyscale/ray:1.13.0-py37-cu110', 'anyscale/ray:1.13.0-py37-cu111', 'anyscale/ray:1.13.0-py37-cu112', 'anyscale/ray:1.13.0-py38', 'anyscale/ray:1.13.0-py38-cu101', 'anyscale/ray:1.13.0-py38-cu102', 'anyscale/ray:1.13.0-py38-cu110', 'anyscale/ray:1.13.0-py38-cu111', 'anyscale/ray:1.13.0-py38-cu112', 'anyscale/ray:1.13.0-py39', 'anyscale/ray:1.13.0-py39-cu101', 'anyscale/ray:1.13.0-py39-cu102', 'anyscale/ray:1.13.0-py39-cu110', 'anyscale/ray:1.13.0-py39-cu111', 'anyscale/ray:1.13.0-py39-cu112', 'anyscale/ray:1.13.0rc0-py36', 'anyscale/ray:1.13.0rc0-py36-cu101', 'anyscale/ray:1.13.0rc0-py36-cu102', 'anyscale/ray:1.13.0rc0-py36-cu110', 'anyscale/ray:1.13.0rc0-py36-cu111', 'anyscale/ray:1.13.0rc0-py36-cu112', 'anyscale/ray:1.13.0rc0-py37', 'anyscale/ray:1.13.0rc0-py37-cu101', 'anyscale/ray:1.13.0rc0-py37-cu102', 'anyscale/ray:1.13.0rc0-py37-cu110', 'anyscale/ray:1.13.0rc0-py37-cu111', 'anyscale/ray:1.13.0rc0-py37-cu112', 'anyscale/ray:1.13.0rc0-py38', 'anyscale/ray:1.13.0rc0-py38-cu101', 'anyscale/ray:1.13.0rc0-py38-cu102', 'anyscale/ray:1.13.0rc0-py38-cu110', 'anyscale/ray:1.13.0rc0-py38-cu111', 'anyscale/ray:1.13.0rc0-py38-cu112', 'anyscale/ray:1.13.0rc0-py39', 'anyscale/ray:1.13.0rc0-py39-cu101', 'anyscale/ray:1.13.0rc0-py39-cu102', 'anyscale/ray:1.13.0rc0-py39-cu110', 'anyscale/ray:1.13.0rc0-py39-cu111', 'anyscale/ray:1.13.0rc0-py39-cu112', 'anyscale/ray:1.7.0', 'anyscale/ray:1.7.0-gpu', 'anyscale/ray:1.7.0-py36', 'anyscale/ray:1.7.0-py36-gpu', 'anyscale/ray:1.7.0-py37', 'anyscale/ray:1.7.0-py37-gpu', 'anyscale/ray:1.7.0-py38', 'anyscale/ray:1.7.0-py38-gpu', 'anyscale/ray:1.7.0rc0', 'anyscale/ray:1.7.0rc0-gpu', 'anyscale/ray:1.7.0rc0-py36', 'anyscale/ray:1.7.0rc0-py36-gpu', 'anyscale/ray:1.7.0rc0-py37', 'anyscale/ray:1.7.0rc0-py37-gpu', 'anyscale/ray:1.7.0rc0-py38', 'anyscale/ray:1.7.0rc0-py38-gpu', 'anyscale/ray:1.7.1', 'anyscale/ray:1.7.1-gpu', 'anyscale/ray:1.7.1-py36', 'anyscale/ray:1.7.1-py36-gpu', 'anyscale/ray:1.7.1-py37', 'anyscale/ray:1.7.1-py37-gpu', 'anyscale/ray:1.7.1-py38', 'anyscale/ray:1.7.1-py38-gpu', 'anyscale/ray:1.8.0', 'anyscale/ray:1.8.0-gpu', 'anyscale/ray:1.8.0-py36', 'anyscale/ray:1.8.0-py36-gpu', 'anyscale/ray:1.8.0-py37', 'anyscale/ray:1.8.0-py37-gpu', 'anyscale/ray:1.8.0-py38', 'anyscale/ray:1.8.0-py38-gpu', 'anyscale/ray:1.9.0-py36', 'anyscale/ray:1.9.0-py36-cu101', 'anyscale/ray:1.9.0-py36-cu102', 'anyscale/ray:1.9.0-py36-cu110', 'anyscale/ray:1.9.0-py36-cu111', 'anyscale/ray:1.9.0-py36-cu112', 'anyscale/ray:1.9.0-py37', 'anyscale/ray:1.9.0-py37-cu101', 'anyscale/ray:1.9.0-py37-cu102', 'anyscale/ray:1.9.0-py37-cu110', 'anyscale/ray:1.9.0-py37-cu111', 'anyscale/ray:1.9.0-py37-cu112', 'anyscale/ray:1.9.0-py38', 'anyscale/ray:1.9.0-py38-cu101', 'anyscale/ray:1.9.0-py38-cu102', 'anyscale/ray:1.9.0-py38-cu110', 'anyscale/ray:1.9.0-py38-cu111', 'anyscale/ray:1.9.0-py38-cu112', 'anyscale/ray:1.9.0-py39', 'anyscale/ray:1.9.0-py39-cu101', 'anyscale/ray:1.9.0-py39-cu102', 'anyscale/ray:1.9.0-py39-cu110', 'anyscale/ray:1.9.0-py39-cu111', 'anyscale/ray:1.9.0-py39-cu112', 'anyscale/ray:1.9.0rc1-py36', 'anyscale/ray:1.9.0rc1-py36-cu101', 'anyscale/ray:1.9.0rc1-py36-cu102', 'anyscale/ray:1.9.0rc1-py36-cu110', 'anyscale/ray:1.9.0rc1-py36-cu111', 'anyscale/ray:1.9.0rc1-py36-cu112', 'anyscale/ray:1.9.0rc1-py37', 'anyscale/ray:1.9.0rc1-py37-cu101', 'anyscale/ray:1.9.0rc1-py37-cu102', 'anyscale/ray:1.9.0rc1-py37-cu110', 'anyscale/ray:1.9.0rc1-py37-cu111', 'anyscale/ray:1.9.0rc1-py37-cu112', 'anyscale/ray:1.9.0rc1-py38', 'anyscale/ray:1.9.0rc1-py38-cu101', 'anyscale/ray:1.9.0rc1-py38-cu102', 'anyscale/ray:1.9.0rc1-py38-cu110', 'anyscale/ray:1.9.0rc1-py38-cu111', 'anyscale/ray:1.9.0rc1-py38-cu112', 'anyscale/ray:1.9.0rc2-py36', 'anyscale/ray:1.9.0rc2-py36-cu101', 'anyscale/ray:1.9.0rc2-py36-cu102', 'anyscale/ray:1.9.0rc2-py36-cu110', 'anyscale/ray:1.9.0rc2-py36-cu111', 'anyscale/ray:1.9.0rc2-py36-cu112', 'anyscale/ray:1.9.0rc2-py37', 'anyscale/ray:1.9.0rc2-py37-cu101', 'anyscale/ray:1.9.0rc2-py37-cu102', 'anyscale/ray:1.9.0rc2-py37-cu110', 'anyscale/ray:1.9.0rc2-py37-cu111', 'anyscale/ray:1.9.0rc2-py37-cu112', 'anyscale/ray:1.9.0rc2-py38', 'anyscale/ray:1.9.0rc2-py38-cu101', 'anyscale/ray:1.9.0rc2-py38-cu102', 'anyscale/ray:1.9.0rc2-py38-cu110', 'anyscale/ray:1.9.0rc2-py38-cu111', 'anyscale/ray:1.9.0rc2-py38-cu112', 'anyscale/ray:1.9.1-py36', 'anyscale/ray:1.9.1-py36-cu101', 'anyscale/ray:1.9.1-py36-cu102', 'anyscale/ray:1.9.1-py36-cu110', 'anyscale/ray:1.9.1-py36-cu111', 'anyscale/ray:1.9.1-py36-cu112', 'anyscale/ray:1.9.1-py37', 'anyscale/ray:1.9.1-py37-cu101', 'anyscale/ray:1.9.1-py37-cu102', 'anyscale/ray:1.9.1-py37-cu110', 'anyscale/ray:1.9.1-py37-cu111', 'anyscale/ray:1.9.1-py37-cu112', 'anyscale/ray:1.9.1-py38', 'anyscale/ray:1.9.1-py38-cu101', 'anyscale/ray:1.9.1-py38-cu102', 'anyscale/ray:1.9.1-py38-cu110', 'anyscale/ray:1.9.1-py38-cu111', 'anyscale/ray:1.9.1-py38-cu112', 'anyscale/ray:1.9.1-py39', 'anyscale/ray:1.9.1-py39-cu101', 'anyscale/ray:1.9.1-py39-cu102', 'anyscale/ray:1.9.1-py39-cu110', 'anyscale/ray:1.9.1-py39-cu111', 'anyscale/ray:1.9.1-py39-cu112', 'anyscale/ray:1.9.1rc0-py36', 'anyscale/ray:1.9.1rc0-py36-cu101', 'anyscale/ray:1.9.1rc0-py36-cu102', 'anyscale/ray:1.9.1rc0-py36-cu110', 'anyscale/ray:1.9.1rc0-py36-cu111', 'anyscale/ray:1.9.1rc0-py36-cu112', 'anyscale/ray:1.9.1rc0-py37', 'anyscale/ray:1.9.1rc0-py37-cu101', 'anyscale/ray:1.9.1rc0-py37-cu102', 'anyscale/ray:1.9.1rc0-py37-cu110', 'anyscale/ray:1.9.1rc0-py37-cu111', 'anyscale/ray:1.9.1rc0-py37-cu112', 'anyscale/ray:1.9.1rc0-py38', 'anyscale/ray:1.9.1rc0-py38-cu101', 'anyscale/ray:1.9.1rc0-py38-cu102', 'anyscale/ray:1.9.1rc0-py38-cu110', 'anyscale/ray:1.9.1rc0-py38-cu111', 'anyscale/ray:1.9.1rc0-py38-cu112', 'anyscale/ray:1.9.2-py36', 'anyscale/ray:1.9.2-py36-cu101', 'anyscale/ray:1.9.2-py36-cu102', 'anyscale/ray:1.9.2-py36-cu110', 'anyscale/ray:1.9.2-py36-cu111', 'anyscale/ray:1.9.2-py36-cu112', 'anyscale/ray:1.9.2-py37', 'anyscale/ray:1.9.2-py37-cu101', 'anyscale/ray:1.9.2-py37-cu102', 'anyscale/ray:1.9.2-py37-cu110', 'anyscale/ray:1.9.2-py37-cu111', 'anyscale/ray:1.9.2-py37-cu112', 'anyscale/ray:1.9.2-py38', 'anyscale/ray:1.9.2-py38-cu101', 'anyscale/ray:1.9.2-py38-cu102', 'anyscale/ray:1.9.2-py38-cu110', 'anyscale/ray:1.9.2-py38-cu111', 'anyscale/ray:1.9.2-py38-cu112', 'anyscale/ray:1.9.2-py39', 'anyscale/ray:1.9.2-py39-cu101', 'anyscale/ray:1.9.2-py39-cu102', 'anyscale/ray:1.9.2-py39-cu110', 'anyscale/ray:1.9.2-py39-cu111', 'anyscale/ray:1.9.2-py39-cu112', 'anyscale/ray:2.0.0-py310', 'anyscale/ray:2.0.0-py36', 'anyscale/ray:2.0.0-py36-cu101', 'anyscale/ray:2.0.0-py36-cu102', 'anyscale/ray:2.0.0-py36-cu110', 'anyscale/ray:2.0.0-py36-cu111', 'anyscale/ray:2.0.0-py36-cu112', 'anyscale/ray:2.0.0-py36-cu113', 'anyscale/ray:2.0.0-py37', 'anyscale/ray:2.0.0-py37-cu101', 'anyscale/ray:2.0.0-py37-cu102', 'anyscale/ray:2.0.0-py37-cu110', 'anyscale/ray:2.0.0-py37-cu111', 'anyscale/ray:2.0.0-py37-cu112', 'anyscale/ray:2.0.0-py37-cu113', 'anyscale/ray:2.0.0-py38', 'anyscale/ray:2.0.0-py38-cu101', 'anyscale/ray:2.0.0-py38-cu102', 'anyscale/ray:2.0.0-py38-cu110', 'anyscale/ray:2.0.0-py38-cu111', 'anyscale/ray:2.0.0-py38-cu112', 'anyscale/ray:2.0.0-py38-cu113', 'anyscale/ray:2.0.0-py39', 'anyscale/ray:2.0.0-py39-cu101', 'anyscale/ray:2.0.0-py39-cu102', 'anyscale/ray:2.0.0-py39-cu110', 'anyscale/ray:2.0.0-py39-cu111', 'anyscale/ray:2.0.0-py39-cu112', 'anyscale/ray:2.0.0-py39-cu113', 'anyscale/ray:2.0.0rc0-py310', 'anyscale/ray:2.0.0rc0-py36', 'anyscale/ray:2.0.0rc0-py36-cu101', 'anyscale/ray:2.0.0rc0-py36-cu102', 'anyscale/ray:2.0.0rc0-py36-cu110', 'anyscale/ray:2.0.0rc0-py36-cu111', 'anyscale/ray:2.0.0rc0-py36-cu112', 'anyscale/ray:2.0.0rc0-py37', 'anyscale/ray:2.0.0rc0-py37-cu101', 'anyscale/ray:2.0.0rc0-py37-cu102', 'anyscale/ray:2.0.0rc0-py37-cu110', 'anyscale/ray:2.0.0rc0-py37-cu111', 'anyscale/ray:2.0.0rc0-py37-cu112', 'anyscale/ray:2.0.0rc0-py38', 'anyscale/ray:2.0.0rc0-py38-cu101', 'anyscale/ray:2.0.0rc0-py38-cu102', 'anyscale/ray:2.0.0rc0-py38-cu110', 'anyscale/ray:2.0.0rc0-py38-cu111', 'anyscale/ray:2.0.0rc0-py38-cu112', 'anyscale/ray:2.0.0rc0-py39', 'anyscale/ray:2.0.0rc0-py39-cu101', 'anyscale/ray:2.0.0rc0-py39-cu102', 'anyscale/ray:2.0.0rc0-py39-cu110', 'anyscale/ray:2.0.0rc0-py39-cu111', 'anyscale/ray:2.0.0rc0-py39-cu112', 'anyscale/ray:2.0.0rc1-py310', 'anyscale/ray:2.0.0rc1-py36', 'anyscale/ray:2.0.0rc1-py36-cu101', 'anyscale/ray:2.0.0rc1-py36-cu102', 'anyscale/ray:2.0.0rc1-py36-cu110', 'anyscale/ray:2.0.0rc1-py36-cu111', 'anyscale/ray:2.0.0rc1-py36-cu112', 'anyscale/ray:2.0.0rc1-py37', 'anyscale/ray:2.0.0rc1-py37-cu101', 'anyscale/ray:2.0.0rc1-py37-cu102', 'anyscale/ray:2.0.0rc1-py37-cu110', 'anyscale/ray:2.0.0rc1-py37-cu111', 'anyscale/ray:2.0.0rc1-py37-cu112', 'anyscale/ray:2.0.0rc1-py38', 'anyscale/ray:2.0.0rc1-py38-cu101', 'anyscale/ray:2.0.0rc1-py38-cu102', 'anyscale/ray:2.0.0rc1-py38-cu110', 'anyscale/ray:2.0.0rc1-py38-cu111', 'anyscale/ray:2.0.0rc1-py38-cu112', 'anyscale/ray:2.0.0rc1-py39', 'anyscale/ray:2.0.0rc1-py39-cu101', 'anyscale/ray:2.0.0rc1-py39-cu102', 'anyscale/ray:2.0.0rc1-py39-cu110', 'anyscale/ray:2.0.0rc1-py39-cu111', 'anyscale/ray:2.0.0rc1-py39-cu112', 'anyscale/ray:2.0.1-py310', 'anyscale/ray:2.0.1-py36', 'anyscale/ray:2.0.1-py36-cu101', 'anyscale/ray:2.0.1-py36-cu102', 'anyscale/ray:2.0.1-py36-cu110', 'anyscale/ray:2.0.1-py36-cu111', 'anyscale/ray:2.0.1-py36-cu112', 'anyscale/ray:2.0.1-py36-cu113', 'anyscale/ray:2.0.1-py36-cu116', 'anyscale/ray:2.0.1-py37', 'anyscale/ray:2.0.1-py37-cu101', 'anyscale/ray:2.0.1-py37-cu102', 'anyscale/ray:2.0.1-py37-cu110', 'anyscale/ray:2.0.1-py37-cu111', 'anyscale/ray:2.0.1-py37-cu112', 'anyscale/ray:2.0.1-py37-cu113', 'anyscale/ray:2.0.1-py37-cu116', 'anyscale/ray:2.0.1-py38', 'anyscale/ray:2.0.1-py38-cu101', 'anyscale/ray:2.0.1-py38-cu102', 'anyscale/ray:2.0.1-py38-cu110', 'anyscale/ray:2.0.1-py38-cu111', 'anyscale/ray:2.0.1-py38-cu112', 'anyscale/ray:2.0.1-py38-cu113', 'anyscale/ray:2.0.1-py38-cu116', 'anyscale/ray:2.0.1-py39', 'anyscale/ray:2.0.1-py39-cu101', 'anyscale/ray:2.0.1-py39-cu102', 'anyscale/ray:2.0.1-py39-cu110', 'anyscale/ray:2.0.1-py39-cu111', 'anyscale/ray:2.0.1-py39-cu112', 'anyscale/ray:2.0.1-py39-cu113', 'anyscale/ray:2.0.1-py39-cu116', 'anyscale/ray:2.1.0-py310', 'anyscale/ray:2.1.0-py310-cu101', 'anyscale/ray:2.1.0-py310-cu102', 'anyscale/ray:2.1.0-py310-cu110', 'anyscale/ray:2.1.0-py310-cu111', 'anyscale/ray:2.1.0-py310-cu112', 'anyscale/ray:2.1.0-py310-cu113', 'anyscale/ray:2.1.0-py310-cu116', 'anyscale/ray:2.1.0-py36', 'anyscale/ray:2.1.0-py36-cu101', 'anyscale/ray:2.1.0-py36-cu102', 'anyscale/ray:2.1.0-py36-cu110', 'anyscale/ray:2.1.0-py36-cu111', 'anyscale/ray:2.1.0-py36-cu112', 'anyscale/ray:2.1.0-py36-cu113', 'anyscale/ray:2.1.0-py36-cu116', 'anyscale/ray:2.1.0-py37', 'anyscale/ray:2.1.0-py37-cu101', 'anyscale/ray:2.1.0-py37-cu102', 'anyscale/ray:2.1.0-py37-cu110', 'anyscale/ray:2.1.0-py37-cu111', 'anyscale/ray:2.1.0-py37-cu112', 'anyscale/ray:2.1.0-py37-cu113', 'anyscale/ray:2.1.0-py37-cu116', 'anyscale/ray:2.1.0-py38', 'anyscale/ray:2.1.0-py38-cu101', 'anyscale/ray:2.1.0-py38-cu102', 'anyscale/ray:2.1.0-py38-cu110', 'anyscale/ray:2.1.0-py38-cu111', 'anyscale/ray:2.1.0-py38-cu112', 'anyscale/ray:2.1.0-py38-cu113', 'anyscale/ray:2.1.0-py38-cu116', 'anyscale/ray:2.1.0-py39', 'anyscale/ray:2.1.0-py39-cu101', 'anyscale/ray:2.1.0-py39-cu102', 'anyscale/ray:2.1.0-py39-cu110', 'anyscale/ray:2.1.0-py39-cu111', 'anyscale/ray:2.1.0-py39-cu112', 'anyscale/ray:2.1.0-py39-cu113', 'anyscale/ray:2.1.0-py39-cu116', 'anyscale/ray:2.10.0-py310', 'anyscale/ray:2.10.0-py310-cu115', 'anyscale/ray:2.10.0-py310-cu116', 'anyscale/ray:2.10.0-py310-cu117', 'anyscale/ray:2.10.0-py310-cu118', 'anyscale/ray:2.10.0-py310-cu121', 'anyscale/ray:2.10.0-py311', 'anyscale/ray:2.10.0-py311-cu115', 'anyscale/ray:2.10.0-py311-cu116', 'anyscale/ray:2.10.0-py311-cu117', 'anyscale/ray:2.10.0-py311-cu118', 'anyscale/ray:2.10.0-py311-cu121', 'anyscale/ray:2.10.0-py38', 'anyscale/ray:2.10.0-py38-cu115', 'anyscale/ray:2.10.0-py38-cu116', 'anyscale/ray:2.10.0-py38-cu117', 'anyscale/ray:2.10.0-py38-cu118', 'anyscale/ray:2.10.0-py38-cu121', 'anyscale/ray:2.10.0-py39', 'anyscale/ray:2.10.0-py39-cu115', 'anyscale/ray:2.10.0-py39-cu116', 'anyscale/ray:2.10.0-py39-cu117', 'anyscale/ray:2.10.0-py39-cu118', 'anyscale/ray:2.10.0-py39-cu121', 'anyscale/ray:2.11.0-py310', 'anyscale/ray:2.11.0-py310-cu115', 'anyscale/ray:2.11.0-py310-cu116', 'anyscale/ray:2.11.0-py310-cu117', 'anyscale/ray:2.11.0-py310-cu118', 'anyscale/ray:2.11.0-py310-cu121', 'anyscale/ray:2.11.0-py311', 'anyscale/ray:2.11.0-py311-cu115', 'anyscale/ray:2.11.0-py311-cu116', 'anyscale/ray:2.11.0-py311-cu117', 'anyscale/ray:2.11.0-py311-cu118', 'anyscale/ray:2.11.0-py311-cu121', 'anyscale/ray:2.11.0-py39', 'anyscale/ray:2.11.0-py39-cu115', 'anyscale/ray:2.11.0-py39-cu116', 'anyscale/ray:2.11.0-py39-cu117', 'anyscale/ray:2.11.0-py39-cu118', 'anyscale/ray:2.11.0-py39-cu121', 'anyscale/ray:2.12.0-py310', 'anyscale/ray:2.12.0-py310-cu115', 'anyscale/ray:2.12.0-py310-cu116', 'anyscale/ray:2.12.0-py310-cu117', 'anyscale/ray:2.12.0-py310-cu118', 'anyscale/ray:2.12.0-py310-cu121', 'anyscale/ray:2.12.0-py311', 'anyscale/ray:2.12.0-py311-cu115', 'anyscale/ray:2.12.0-py311-cu116', 'anyscale/ray:2.12.0-py311-cu117', 'anyscale/ray:2.12.0-py311-cu118', 'anyscale/ray:2.12.0-py311-cu121', 'anyscale/ray:2.12.0-py39', 'anyscale/ray:2.12.0-py39-cu115', 'anyscale/ray:2.12.0-py39-cu116', 'anyscale/ray:2.12.0-py39-cu117', 'anyscale/ray:2.12.0-py39-cu118', 'anyscale/ray:2.12.0-py39-cu121', 'anyscale/ray:2.12.0-slim-py310', 'anyscale/ray:2.12.0-slim-py310-cu118', 'anyscale/ray:2.12.0-slim-py310-cu121', 'anyscale/ray:2.12.0-slim-py311', 'anyscale/ray:2.12.0-slim-py311-cu118', 'anyscale/ray:2.12.0-slim-py311-cu121', 'anyscale/ray:2.12.0-slim-py39', 'anyscale/ray:2.12.0-slim-py39-cu118', 'anyscale/ray:2.12.0-slim-py39-cu121', 'anyscale/ray:2.2.0-py310', 'anyscale/ray:2.2.0-py310-cu101', 'anyscale/ray:2.2.0-py310-cu102', 'anyscale/ray:2.2.0-py310-cu110', 'anyscale/ray:2.2.0-py310-cu111', 'anyscale/ray:2.2.0-py310-cu112', 'anyscale/ray:2.2.0-py310-cu113', 'anyscale/ray:2.2.0-py310-cu116', 'anyscale/ray:2.2.0-py37', 'anyscale/ray:2.2.0-py37-cu101', 'anyscale/ray:2.2.0-py37-cu102', 'anyscale/ray:2.2.0-py37-cu110', 'anyscale/ray:2.2.0-py37-cu111', 'anyscale/ray:2.2.0-py37-cu112', 'anyscale/ray:2.2.0-py37-cu113', 'anyscale/ray:2.2.0-py37-cu116', 'anyscale/ray:2.2.0-py38', 'anyscale/ray:2.2.0-py38-cu101', 'anyscale/ray:2.2.0-py38-cu102', 'anyscale/ray:2.2.0-py38-cu110', 'anyscale/ray:2.2.0-py38-cu111', 'anyscale/ray:2.2.0-py38-cu112', 'anyscale/ray:2.2.0-py38-cu113', 'anyscale/ray:2.2.0-py38-cu116', 'anyscale/ray:2.2.0-py39', 'anyscale/ray:2.2.0-py39-cu101', 'anyscale/ray:2.2.0-py39-cu102', 'anyscale/ray:2.2.0-py39-cu110', 'anyscale/ray:2.2.0-py39-cu111', 'anyscale/ray:2.2.0-py39-cu112', 'anyscale/ray:2.2.0-py39-cu113', 'anyscale/ray:2.2.0-py39-cu116', 'anyscale/ray:2.20.0-py310', 'anyscale/ray:2.20.0-py310-cu115', 'anyscale/ray:2.20.0-py310-cu116', 'anyscale/ray:2.20.0-py310-cu117', 'anyscale/ray:2.20.0-py310-cu118', 'anyscale/ray:2.20.0-py310-cu121', 'anyscale/ray:2.20.0-py311', 'anyscale/ray:2.20.0-py311-cu115', 'anyscale/ray:2.20.0-py311-cu116', 'anyscale/ray:2.20.0-py311-cu117', 'anyscale/ray:2.20.0-py311-cu118', 'anyscale/ray:2.20.0-py311-cu121', 'anyscale/ray:2.20.0-py39', 'anyscale/ray:2.20.0-py39-cu115', 'anyscale/ray:2.20.0-py39-cu116', 'anyscale/ray:2.20.0-py39-cu117', 'anyscale/ray:2.20.0-py39-cu118', 'anyscale/ray:2.20.0-py39-cu121', 'anyscale/ray:2.20.0-slim-py310', 'anyscale/ray:2.20.0-slim-py310-cu118', 'anyscale/ray:2.20.0-slim-py310-cu121', 'anyscale/ray:2.20.0-slim-py311', 'anyscale/ray:2.20.0-slim-py311-cu118', 'anyscale/ray:2.20.0-slim-py311-cu121', 'anyscale/ray:2.20.0-slim-py39', 'anyscale/ray:2.20.0-slim-py39-cu118', 'anyscale/ray:2.20.0-slim-py39-cu121', 'anyscale/ray:2.21.0-py310', 'anyscale/ray:2.21.0-py310-cu115', 'anyscale/ray:2.21.0-py310-cu116', 'anyscale/ray:2.21.0-py310-cu117', 'anyscale/ray:2.21.0-py310-cu118', 'anyscale/ray:2.21.0-py310-cu121', 'anyscale/ray:2.21.0-py311', 'anyscale/ray:2.21.0-py311-cu115', 'anyscale/ray:2.21.0-py311-cu116', 'anyscale/ray:2.21.0-py311-cu117', 'anyscale/ray:2.21.0-py311-cu118', 'anyscale/ray:2.21.0-py311-cu121', 'anyscale/ray:2.21.0-py39', 'anyscale/ray:2.21.0-py39-cu115', 'anyscale/ray:2.21.0-py39-cu116', 'anyscale/ray:2.21.0-py39-cu117', 'anyscale/ray:2.21.0-py39-cu118', 'anyscale/ray:2.21.0-py39-cu121', 'anyscale/ray:2.21.0-slim-py310', 'anyscale/ray:2.21.0-slim-py310-cu118', 'anyscale/ray:2.21.0-slim-py310-cu121', 'anyscale/ray:2.21.0-slim-py311', 'anyscale/ray:2.21.0-slim-py311-cu118', 'anyscale/ray:2.21.0-slim-py311-cu121', 'anyscale/ray:2.21.0-slim-py39', 'anyscale/ray:2.21.0-slim-py39-cu118', 'anyscale/ray:2.21.0-slim-py39-cu121', 'anyscale/ray:2.22.0-py310', 'anyscale/ray:2.22.0-py310-cu115', 'anyscale/ray:2.22.0-py310-cu116', 'anyscale/ray:2.22.0-py310-cu117', 'anyscale/ray:2.22.0-py310-cu118', 'anyscale/ray:2.22.0-py310-cu121', 'anyscale/ray:2.22.0-py311', 'anyscale/ray:2.22.0-py311-cu115', 'anyscale/ray:2.22.0-py311-cu116', 'anyscale/ray:2.22.0-py311-cu117', 'anyscale/ray:2.22.0-py311-cu118', 'anyscale/ray:2.22.0-py311-cu121', 'anyscale/ray:2.22.0-py39', 'anyscale/ray:2.22.0-py39-cu115', 'anyscale/ray:2.22.0-py39-cu116', 'anyscale/ray:2.22.0-py39-cu117', 'anyscale/ray:2.22.0-py39-cu118', 'anyscale/ray:2.22.0-py39-cu121', 'anyscale/ray:2.22.0-slim-py310', 'anyscale/ray:2.22.0-slim-py310-cu118', 'anyscale/ray:2.22.0-slim-py310-cu121', 'anyscale/ray:2.22.0-slim-py311', 'anyscale/ray:2.22.0-slim-py311-cu118', 'anyscale/ray:2.22.0-slim-py311-cu121', 'anyscale/ray:2.22.0-slim-py39', 'anyscale/ray:2.22.0-slim-py39-cu118', 'anyscale/ray:2.22.0-slim-py39-cu121', 'anyscale/ray:2.23.0-py310', 'anyscale/ray:2.23.0-py310-cu115', 'anyscale/ray:2.23.0-py310-cu116', 'anyscale/ray:2.23.0-py310-cu117', 'anyscale/ray:2.23.0-py310-cu118', 'anyscale/ray:2.23.0-py310-cu121', 'anyscale/ray:2.23.0-py311', 'anyscale/ray:2.23.0-py311-cu115', 'anyscale/ray:2.23.0-py311-cu116', 'anyscale/ray:2.23.0-py311-cu117', 'anyscale/ray:2.23.0-py311-cu118', 'anyscale/ray:2.23.0-py311-cu121', 'anyscale/ray:2.23.0-py39', 'anyscale/ray:2.23.0-py39-cu115', 'anyscale/ray:2.23.0-py39-cu116', 'anyscale/ray:2.23.0-py39-cu117', 'anyscale/ray:2.23.0-py39-cu118', 'anyscale/ray:2.23.0-py39-cu121', 'anyscale/ray:2.23.0-slim-py310', 'anyscale/ray:2.23.0-slim-py310-cu118', 'anyscale/ray:2.23.0-slim-py310-cu121', 'anyscale/ray:2.23.0-slim-py311', 'anyscale/ray:2.23.0-slim-py311-cu118', 'anyscale/ray:2.23.0-slim-py311-cu121', 'anyscale/ray:2.23.0-slim-py39', 'anyscale/ray:2.23.0-slim-py39-cu118', 'anyscale/ray:2.23.0-slim-py39-cu121', 'anyscale/ray:2.24.0-py310', 'anyscale/ray:2.24.0-py310-cu115', 'anyscale/ray:2.24.0-py310-cu116', 'anyscale/ray:2.24.0-py310-cu117', 'anyscale/ray:2.24.0-py310-cu118', 'anyscale/ray:2.24.0-py310-cu121', 'anyscale/ray:2.24.0-py311', 'anyscale/ray:2.24.0-py311-cu115', 'anyscale/ray:2.24.0-py311-cu116', 'anyscale/ray:2.24.0-py311-cu117', 'anyscale/ray:2.24.0-py311-cu118', 'anyscale/ray:2.24.0-py311-cu121', 'anyscale/ray:2.24.0-py39', 'anyscale/ray:2.24.0-py39-cu115', 'anyscale/ray:2.24.0-py39-cu116', 'anyscale/ray:2.24.0-py39-cu117', 'anyscale/ray:2.24.0-py39-cu118', 'anyscale/ray:2.24.0-py39-cu121', 'anyscale/ray:2.24.0-slim-py310', 'anyscale/ray:2.24.0-slim-py310-cu118', 'anyscale/ray:2.24.0-slim-py310-cu121', 'anyscale/ray:2.24.0-slim-py311', 'anyscale/ray:2.24.0-slim-py311-cu118', 'anyscale/ray:2.24.0-slim-py311-cu121', 'anyscale/ray:2.24.0-slim-py39', 'anyscale/ray:2.24.0-slim-py39-cu118', 'anyscale/ray:2.24.0-slim-py39-cu121', 'anyscale/ray:2.3.0-py310', 'anyscale/ray:2.3.0-py310-cu101', 'anyscale/ray:2.3.0-py310-cu102', 'anyscale/ray:2.3.0-py310-cu110', 'anyscale/ray:2.3.0-py310-cu111', 'anyscale/ray:2.3.0-py310-cu112', 'anyscale/ray:2.3.0-py310-cu113', 'anyscale/ray:2.3.0-py310-cu116', 'anyscale/ray:2.3.0-py310-cu118', 'anyscale/ray:2.3.0-py37', 'anyscale/ray:2.3.0-py37-cu101', 'anyscale/ray:2.3.0-py37-cu102', 'anyscale/ray:2.3.0-py37-cu110', 'anyscale/ray:2.3.0-py37-cu111', 'anyscale/ray:2.3.0-py37-cu112', 'anyscale/ray:2.3.0-py37-cu113', 'anyscale/ray:2.3.0-py37-cu116', 'anyscale/ray:2.3.0-py37-cu118', 'anyscale/ray:2.3.0-py38', 'anyscale/ray:2.3.0-py38-cu101', 'anyscale/ray:2.3.0-py38-cu102', 'anyscale/ray:2.3.0-py38-cu110', 'anyscale/ray:2.3.0-py38-cu111', 'anyscale/ray:2.3.0-py38-cu112', 'anyscale/ray:2.3.0-py38-cu113', 'anyscale/ray:2.3.0-py38-cu116', 'anyscale/ray:2.3.0-py38-cu118', 'anyscale/ray:2.3.0-py39', 'anyscale/ray:2.3.0-py39-cu101', 'anyscale/ray:2.3.0-py39-cu102', 'anyscale/ray:2.3.0-py39-cu110', 'anyscale/ray:2.3.0-py39-cu111', 'anyscale/ray:2.3.0-py39-cu112', 'anyscale/ray:2.3.0-py39-cu113', 'anyscale/ray:2.3.0-py39-cu116', 'anyscale/ray:2.3.0-py39-cu118', 'anyscale/ray:2.3.1-py310', 'anyscale/ray:2.3.1-py310-cu101', 'anyscale/ray:2.3.1-py310-cu102', 'anyscale/ray:2.3.1-py310-cu110', 'anyscale/ray:2.3.1-py310-cu111', 'anyscale/ray:2.3.1-py310-cu112', 'anyscale/ray:2.3.1-py310-cu113', 'anyscale/ray:2.3.1-py310-cu116', 'anyscale/ray:2.3.1-py310-cu118', 'anyscale/ray:2.3.1-py37', 'anyscale/ray:2.3.1-py37-cu101', 'anyscale/ray:2.3.1-py37-cu102', 'anyscale/ray:2.3.1-py37-cu110', 'anyscale/ray:2.3.1-py37-cu111', 'anyscale/ray:2.3.1-py37-cu112', 'anyscale/ray:2.3.1-py37-cu113', 'anyscale/ray:2.3.1-py37-cu116', 'anyscale/ray:2.3.1-py37-cu118', 'anyscale/ray:2.3.1-py38', 'anyscale/ray:2.3.1-py38-cu101', 'anyscale/ray:2.3.1-py38-cu102', 'anyscale/ray:2.3.1-py38-cu110', 'anyscale/ray:2.3.1-py38-cu111', 'anyscale/ray:2.3.1-py38-cu112', 'anyscale/ray:2.3.1-py38-cu113', 'anyscale/ray:2.3.1-py38-cu116', 'anyscale/ray:2.3.1-py38-cu118', 'anyscale/ray:2.3.1-py39', 'anyscale/ray:2.3.1-py39-cu101', 'anyscale/ray:2.3.1-py39-cu102', 'anyscale/ray:2.3.1-py39-cu110', 'anyscale/ray:2.3.1-py39-cu111', 'anyscale/ray:2.3.1-py39-cu112', 'anyscale/ray:2.3.1-py39-cu113', 'anyscale/ray:2.3.1-py39-cu116', 'anyscale/ray:2.3.1-py39-cu118', 'anyscale/ray:2.30.0-py310', 'anyscale/ray:2.30.0-py310-cu117', 'anyscale/ray:2.30.0-py310-cu118', 'anyscale/ray:2.30.0-py310-cu121', 'anyscale/ray:2.30.0-py310-cu123', 'anyscale/ray:2.30.0-py311', 'anyscale/ray:2.30.0-py311-cu117', 'anyscale/ray:2.30.0-py311-cu118', 'anyscale/ray:2.30.0-py311-cu121', 'anyscale/ray:2.30.0-py311-cu123', 'anyscale/ray:2.30.0-py39', 'anyscale/ray:2.30.0-py39-cu117', 'anyscale/ray:2.30.0-py39-cu118', 'anyscale/ray:2.30.0-py39-cu121', 'anyscale/ray:2.30.0-py39-cu123', 'anyscale/ray:2.30.0-slim-py310', 'anyscale/ray:2.30.0-slim-py310-cu118', 'anyscale/ray:2.30.0-slim-py310-cu121', 'anyscale/ray:2.30.0-slim-py310-cu123', 'anyscale/ray:2.30.0-slim-py311', 'anyscale/ray:2.30.0-slim-py311-cu118', 'anyscale/ray:2.30.0-slim-py311-cu121', 'anyscale/ray:2.30.0-slim-py311-cu123', 'anyscale/ray:2.30.0-slim-py39', 'anyscale/ray:2.30.0-slim-py39-cu118', 'anyscale/ray:2.30.0-slim-py39-cu121', 'anyscale/ray:2.30.0-slim-py39-cu123', 'anyscale/ray:2.31.0-py310', 'anyscale/ray:2.31.0-py310-cu117', 'anyscale/ray:2.31.0-py310-cu118', 'anyscale/ray:2.31.0-py310-cu121', 'anyscale/ray:2.31.0-py310-cu123', 'anyscale/ray:2.31.0-py311', 'anyscale/ray:2.31.0-py311-cu117', 'anyscale/ray:2.31.0-py311-cu118', 'anyscale/ray:2.31.0-py311-cu121', 'anyscale/ray:2.31.0-py311-cu123', 'anyscale/ray:2.31.0-py39', 'anyscale/ray:2.31.0-py39-cu117', 'anyscale/ray:2.31.0-py39-cu118', 'anyscale/ray:2.31.0-py39-cu121', 'anyscale/ray:2.31.0-py39-cu123', 'anyscale/ray:2.31.0-slim-py310', 'anyscale/ray:2.31.0-slim-py310-cu118', 'anyscale/ray:2.31.0-slim-py310-cu121', 'anyscale/ray:2.31.0-slim-py310-cu123', 'anyscale/ray:2.31.0-slim-py311', 'anyscale/ray:2.31.0-slim-py311-cu118', 'anyscale/ray:2.31.0-slim-py311-cu121', 'anyscale/ray:2.31.0-slim-py311-cu123', 'anyscale/ray:2.31.0-slim-py39', 'anyscale/ray:2.31.0-slim-py39-cu118', 'anyscale/ray:2.31.0-slim-py39-cu121', 'anyscale/ray:2.31.0-slim-py39-cu123', 'anyscale/ray:2.32.0-py310', 'anyscale/ray:2.32.0-py310-cu117', 'anyscale/ray:2.32.0-py310-cu118', 'anyscale/ray:2.32.0-py310-cu121', 'anyscale/ray:2.32.0-py310-cu123', 'anyscale/ray:2.32.0-py311', 'anyscale/ray:2.32.0-py311-cu117', 'anyscale/ray:2.32.0-py311-cu118', 'anyscale/ray:2.32.0-py311-cu121', 'anyscale/ray:2.32.0-py311-cu123', 'anyscale/ray:2.32.0-py39', 'anyscale/ray:2.32.0-py39-cu117', 'anyscale/ray:2.32.0-py39-cu118', 'anyscale/ray:2.32.0-py39-cu121', 'anyscale/ray:2.32.0-py39-cu123', 'anyscale/ray:2.32.0-slim-py310', 'anyscale/ray:2.32.0-slim-py310-cu118', 'anyscale/ray:2.32.0-slim-py310-cu121', 'anyscale/ray:2.32.0-slim-py310-cu123', 'anyscale/ray:2.32.0-slim-py311', 'anyscale/ray:2.32.0-slim-py311-cu118', 'anyscale/ray:2.32.0-slim-py311-cu121', 'anyscale/ray:2.32.0-slim-py311-cu123', 'anyscale/ray:2.32.0-slim-py39', 'anyscale/ray:2.32.0-slim-py39-cu118', 'anyscale/ray:2.32.0-slim-py39-cu121', 'anyscale/ray:2.32.0-slim-py39-cu123', 'anyscale/ray:2.33.0-py310', 'anyscale/ray:2.33.0-py310-cu117', 'anyscale/ray:2.33.0-py310-cu118', 'anyscale/ray:2.33.0-py310-cu121', 'anyscale/ray:2.33.0-py310-cu123', 'anyscale/ray:2.33.0-py311', 'anyscale/ray:2.33.0-py311-cu117', 'anyscale/ray:2.33.0-py311-cu118', 'anyscale/ray:2.33.0-py311-cu121', 'anyscale/ray:2.33.0-py311-cu123', 'anyscale/ray:2.33.0-py39', 'anyscale/ray:2.33.0-py39-cu117', 'anyscale/ray:2.33.0-py39-cu118', 'anyscale/ray:2.33.0-py39-cu121', 'anyscale/ray:2.33.0-py39-cu123', 'anyscale/ray:2.33.0-slim-py310', 'anyscale/ray:2.33.0-slim-py310-cu118', 'anyscale/ray:2.33.0-slim-py310-cu121', 'anyscale/ray:2.33.0-slim-py310-cu123', 'anyscale/ray:2.33.0-slim-py311', 'anyscale/ray:2.33.0-slim-py311-cu118', 'anyscale/ray:2.33.0-slim-py311-cu121', 'anyscale/ray:2.33.0-slim-py311-cu123', 'anyscale/ray:2.33.0-slim-py39', 'anyscale/ray:2.33.0-slim-py39-cu118', 'anyscale/ray:2.33.0-slim-py39-cu121', 'anyscale/ray:2.33.0-slim-py39-cu123', 'anyscale/ray:2.34.0-py310', 'anyscale/ray:2.34.0-py310-cu117', 'anyscale/ray:2.34.0-py310-cu118', 'anyscale/ray:2.34.0-py310-cu121', 'anyscale/ray:2.34.0-py310-cu123', 'anyscale/ray:2.34.0-py311', 'anyscale/ray:2.34.0-py311-cu117', 'anyscale/ray:2.34.0-py311-cu118', 'anyscale/ray:2.34.0-py311-cu121', 'anyscale/ray:2.34.0-py311-cu123', 'anyscale/ray:2.34.0-py39', 'anyscale/ray:2.34.0-py39-cu117', 'anyscale/ray:2.34.0-py39-cu118', 'anyscale/ray:2.34.0-py39-cu121', 'anyscale/ray:2.34.0-py39-cu123', 'anyscale/ray:2.34.0-slim-py310', 'anyscale/ray:2.34.0-slim-py310-cu118', 'anyscale/ray:2.34.0-slim-py310-cu121', 'anyscale/ray:2.34.0-slim-py310-cu123', 'anyscale/ray:2.34.0-slim-py311', 'anyscale/ray:2.34.0-slim-py311-cu118', 'anyscale/ray:2.34.0-slim-py311-cu121', 'anyscale/ray:2.34.0-slim-py311-cu123', 'anyscale/ray:2.34.0-slim-py39', 'anyscale/ray:2.34.0-slim-py39-cu118', 'anyscale/ray:2.34.0-slim-py39-cu121', 'anyscale/ray:2.34.0-slim-py39-cu123', 'anyscale/ray:2.35.0-py310', 'anyscale/ray:2.35.0-py310-cu117', 'anyscale/ray:2.35.0-py310-cu118', 'anyscale/ray:2.35.0-py310-cu121', 'anyscale/ray:2.35.0-py310-cu123', 'anyscale/ray:2.35.0-py311', 'anyscale/ray:2.35.0-py311-cu117', 'anyscale/ray:2.35.0-py311-cu118', 'anyscale/ray:2.35.0-py311-cu121', 'anyscale/ray:2.35.0-py311-cu123', 'anyscale/ray:2.35.0-py312', 'anyscale/ray:2.35.0-py312-cu117', 'anyscale/ray:2.35.0-py312-cu118', 'anyscale/ray:2.35.0-py312-cu121', 'anyscale/ray:2.35.0-py312-cu123', 'anyscale/ray:2.35.0-py39', 'anyscale/ray:2.35.0-py39-cu117', 'anyscale/ray:2.35.0-py39-cu118', 'anyscale/ray:2.35.0-py39-cu121', 'anyscale/ray:2.35.0-py39-cu123', 'anyscale/ray:2.35.0-slim-py310', 'anyscale/ray:2.35.0-slim-py310-cu118', 'anyscale/ray:2.35.0-slim-py310-cu121', 'anyscale/ray:2.35.0-slim-py310-cu123', 'anyscale/ray:2.35.0-slim-py311', 'anyscale/ray:2.35.0-slim-py311-cu118', 'anyscale/ray:2.35.0-slim-py311-cu121', 'anyscale/ray:2.35.0-slim-py311-cu123', 'anyscale/ray:2.35.0-slim-py312', 'anyscale/ray:2.35.0-slim-py312-cu118', 'anyscale/ray:2.35.0-slim-py312-cu121', 'anyscale/ray:2.35.0-slim-py312-cu123', 'anyscale/ray:2.35.0-slim-py39', 'anyscale/ray:2.35.0-slim-py39-cu118', 'anyscale/ray:2.35.0-slim-py39-cu121', 'anyscale/ray:2.35.0-slim-py39-cu123', 'anyscale/ray:2.36.0-py310', 'anyscale/ray:2.36.0-py310-cu117', 'anyscale/ray:2.36.0-py310-cu118', 'anyscale/ray:2.36.0-py310-cu121', 'anyscale/ray:2.36.0-py310-cu123', 'anyscale/ray:2.36.0-py311', 'anyscale/ray:2.36.0-py311-cu117', 'anyscale/ray:2.36.0-py311-cu118', 'anyscale/ray:2.36.0-py311-cu121', 'anyscale/ray:2.36.0-py311-cu123', 'anyscale/ray:2.36.0-py312', 'anyscale/ray:2.36.0-py312-cu117', 'anyscale/ray:2.36.0-py312-cu118', 'anyscale/ray:2.36.0-py312-cu121', 'anyscale/ray:2.36.0-py312-cu123', 'anyscale/ray:2.36.0-py39', 'anyscale/ray:2.36.0-py39-cu117', 'anyscale/ray:2.36.0-py39-cu118', 'anyscale/ray:2.36.0-py39-cu121', 'anyscale/ray:2.36.0-py39-cu123', 'anyscale/ray:2.36.0-slim-py310', 'anyscale/ray:2.36.0-slim-py310-cu118', 'anyscale/ray:2.36.0-slim-py310-cu121', 'anyscale/ray:2.36.0-slim-py310-cu123', 'anyscale/ray:2.36.0-slim-py311', 'anyscale/ray:2.36.0-slim-py311-cu118', 'anyscale/ray:2.36.0-slim-py311-cu121', 'anyscale/ray:2.36.0-slim-py311-cu123', 'anyscale/ray:2.36.0-slim-py312', 'anyscale/ray:2.36.0-slim-py312-cu118', 'anyscale/ray:2.36.0-slim-py312-cu121', 'anyscale/ray:2.36.0-slim-py312-cu123', 'anyscale/ray:2.36.0-slim-py39', 'anyscale/ray:2.36.0-slim-py39-cu118', 'anyscale/ray:2.36.0-slim-py39-cu121', 'anyscale/ray:2.36.0-slim-py39-cu123', 'anyscale/ray:2.36.1-py310', 'anyscale/ray:2.36.1-py310-cu117', 'anyscale/ray:2.36.1-py310-cu118', 'anyscale/ray:2.36.1-py310-cu121', 'anyscale/ray:2.36.1-py310-cu123', 'anyscale/ray:2.36.1-py311', 'anyscale/ray:2.36.1-py311-cu117', 'anyscale/ray:2.36.1-py311-cu118', 'anyscale/ray:2.36.1-py311-cu121', 'anyscale/ray:2.36.1-py311-cu123', 'anyscale/ray:2.36.1-py312', 'anyscale/ray:2.36.1-py312-cu117', 'anyscale/ray:2.36.1-py312-cu118', 'anyscale/ray:2.36.1-py312-cu121', 'anyscale/ray:2.36.1-py312-cu123', 'anyscale/ray:2.36.1-py39', 'anyscale/ray:2.36.1-py39-cu117', 'anyscale/ray:2.36.1-py39-cu118', 'anyscale/ray:2.36.1-py39-cu121', 'anyscale/ray:2.36.1-py39-cu123', 'anyscale/ray:2.36.1-slim-py310', 'anyscale/ray:2.36.1-slim-py310-cu118', 'anyscale/ray:2.36.1-slim-py310-cu121', 'anyscale/ray:2.36.1-slim-py310-cu123', 'anyscale/ray:2.36.1-slim-py311', 'anyscale/ray:2.36.1-slim-py311-cu118', 'anyscale/ray:2.36.1-slim-py311-cu121', 'anyscale/ray:2.36.1-slim-py311-cu123', 'anyscale/ray:2.36.1-slim-py312', 'anyscale/ray:2.36.1-slim-py312-cu118', 'anyscale/ray:2.36.1-slim-py312-cu121', 'anyscale/ray:2.36.1-slim-py312-cu123', 'anyscale/ray:2.36.1-slim-py39', 'anyscale/ray:2.36.1-slim-py39-cu118', 'anyscale/ray:2.36.1-slim-py39-cu121', 'anyscale/ray:2.36.1-slim-py39-cu123', 'anyscale/ray:2.37.0-py310', 'anyscale/ray:2.37.0-py310-cu117', 'anyscale/ray:2.37.0-py310-cu118', 'anyscale/ray:2.37.0-py310-cu121', 'anyscale/ray:2.37.0-py310-cu123', 'anyscale/ray:2.37.0-py311', 'anyscale/ray:2.37.0-py311-cu117', 'anyscale/ray:2.37.0-py311-cu118', 'anyscale/ray:2.37.0-py311-cu121', 'anyscale/ray:2.37.0-py311-cu123', 'anyscale/ray:2.37.0-py312', 'anyscale/ray:2.37.0-py312-cu117', 'anyscale/ray:2.37.0-py312-cu118', 'anyscale/ray:2.37.0-py312-cu121', 'anyscale/ray:2.37.0-py312-cu123', 'anyscale/ray:2.37.0-py39', 'anyscale/ray:2.37.0-py39-cu117', 'anyscale/ray:2.37.0-py39-cu118', 'anyscale/ray:2.37.0-py39-cu121', 'anyscale/ray:2.37.0-py39-cu123', 'anyscale/ray:2.37.0-slim-py310', 'anyscale/ray:2.37.0-slim-py310-cu118', 'anyscale/ray:2.37.0-slim-py310-cu121', 'anyscale/ray:2.37.0-slim-py310-cu123', 'anyscale/ray:2.37.0-slim-py311', 'anyscale/ray:2.37.0-slim-py311-cu118', 'anyscale/ray:2.37.0-slim-py311-cu121', 'anyscale/ray:2.37.0-slim-py311-cu123', 'anyscale/ray:2.37.0-slim-py312', 'anyscale/ray:2.37.0-slim-py312-cu118', 'anyscale/ray:2.37.0-slim-py312-cu121', 'anyscale/ray:2.37.0-slim-py312-cu123', 'anyscale/ray:2.37.0-slim-py39', 'anyscale/ray:2.37.0-slim-py39-cu118', 'anyscale/ray:2.37.0-slim-py39-cu121', 'anyscale/ray:2.37.0-slim-py39-cu123', 'anyscale/ray:2.38.0-py310', 'anyscale/ray:2.38.0-py310-cu117', 'anyscale/ray:2.38.0-py310-cu118', 'anyscale/ray:2.38.0-py310-cu121', 'anyscale/ray:2.38.0-py310-cu123', 'anyscale/ray:2.38.0-py311', 'anyscale/ray:2.38.0-py311-cu117', 'anyscale/ray:2.38.0-py311-cu118', 'anyscale/ray:2.38.0-py311-cu121', 'anyscale/ray:2.38.0-py311-cu123', 'anyscale/ray:2.38.0-py312', 'anyscale/ray:2.38.0-py312-cu117', 'anyscale/ray:2.38.0-py312-cu118', 'anyscale/ray:2.38.0-py312-cu121', 'anyscale/ray:2.38.0-py312-cu123', 'anyscale/ray:2.38.0-py39', 'anyscale/ray:2.38.0-py39-cu117', 'anyscale/ray:2.38.0-py39-cu118', 'anyscale/ray:2.38.0-py39-cu121', 'anyscale/ray:2.38.0-py39-cu123', 'anyscale/ray:2.38.0-slim-py310', 'anyscale/ray:2.38.0-slim-py310-cu118', 'anyscale/ray:2.38.0-slim-py310-cu121', 'anyscale/ray:2.38.0-slim-py310-cu123', 'anyscale/ray:2.38.0-slim-py311', 'anyscale/ray:2.38.0-slim-py311-cu118', 'anyscale/ray:2.38.0-slim-py311-cu121', 'anyscale/ray:2.38.0-slim-py311-cu123', 'anyscale/ray:2.38.0-slim-py312', 'anyscale/ray:2.38.0-slim-py312-cu118', 'anyscale/ray:2.38.0-slim-py312-cu121', 'anyscale/ray:2.38.0-slim-py312-cu123', 'anyscale/ray:2.38.0-slim-py39', 'anyscale/ray:2.38.0-slim-py39-cu118', 'anyscale/ray:2.38.0-slim-py39-cu121', 'anyscale/ray:2.38.0-slim-py39-cu123', 'anyscale/ray:2.39.0-py310', 'anyscale/ray:2.39.0-py310-cu117', 'anyscale/ray:2.39.0-py310-cu118', 'anyscale/ray:2.39.0-py310-cu121', 'anyscale/ray:2.39.0-py310-cu123', 'anyscale/ray:2.39.0-py311', 'anyscale/ray:2.39.0-py311-cu117', 'anyscale/ray:2.39.0-py311-cu118', 'anyscale/ray:2.39.0-py311-cu121', 'anyscale/ray:2.39.0-py311-cu123', 'anyscale/ray:2.39.0-py312', 'anyscale/ray:2.39.0-py312-cu117', 'anyscale/ray:2.39.0-py312-cu118', 'anyscale/ray:2.39.0-py312-cu121', 'anyscale/ray:2.39.0-py312-cu123', 'anyscale/ray:2.39.0-py39', 'anyscale/ray:2.39.0-py39-cu117', 'anyscale/ray:2.39.0-py39-cu118', 'anyscale/ray:2.39.0-py39-cu121', 'anyscale/ray:2.39.0-py39-cu123', 'anyscale/ray:2.39.0-slim-py310', 'anyscale/ray:2.39.0-slim-py310-cu118', 'anyscale/ray:2.39.0-slim-py310-cu121', 'anyscale/ray:2.39.0-slim-py310-cu123', 'anyscale/ray:2.39.0-slim-py311', 'anyscale/ray:2.39.0-slim-py311-cu118', 'anyscale/ray:2.39.0-slim-py311-cu121', 'anyscale/ray:2.39.0-slim-py311-cu123', 'anyscale/ray:2.39.0-slim-py312', 'anyscale/ray:2.39.0-slim-py312-cu118', 'anyscale/ray:2.39.0-slim-py312-cu121', 'anyscale/ray:2.39.0-slim-py312-cu123', 'anyscale/ray:2.39.0-slim-py39', 'anyscale/ray:2.39.0-slim-py39-cu118', 'anyscale/ray:2.39.0-slim-py39-cu121', 'anyscale/ray:2.39.0-slim-py39-cu123', 'anyscale/ray:2.4.0-py310', 'anyscale/ray:2.4.0-py310-cu101', 'anyscale/ray:2.4.0-py310-cu102', 'anyscale/ray:2.4.0-py310-cu110', 'anyscale/ray:2.4.0-py310-cu111', 'anyscale/ray:2.4.0-py310-cu112', 'anyscale/ray:2.4.0-py310-cu113', 'anyscale/ray:2.4.0-py310-cu116', 'anyscale/ray:2.4.0-py310-cu118', 'anyscale/ray:2.4.0-py37', 'anyscale/ray:2.4.0-py37-cu101', 'anyscale/ray:2.4.0-py37-cu102', 'anyscale/ray:2.4.0-py37-cu110', 'anyscale/ray:2.4.0-py37-cu111', 'anyscale/ray:2.4.0-py37-cu112', 'anyscale/ray:2.4.0-py37-cu113', 'anyscale/ray:2.4.0-py37-cu116', 'anyscale/ray:2.4.0-py37-cu118', 'anyscale/ray:2.4.0-py38', 'anyscale/ray:2.4.0-py38-cu101', 'anyscale/ray:2.4.0-py38-cu102', 'anyscale/ray:2.4.0-py38-cu110', 'anyscale/ray:2.4.0-py38-cu111', 'anyscale/ray:2.4.0-py38-cu112', 'anyscale/ray:2.4.0-py38-cu113', 'anyscale/ray:2.4.0-py38-cu116', 'anyscale/ray:2.4.0-py38-cu118', 'anyscale/ray:2.4.0-py39', 'anyscale/ray:2.4.0-py39-cu101', 'anyscale/ray:2.4.0-py39-cu102', 'anyscale/ray:2.4.0-py39-cu110', 'anyscale/ray:2.4.0-py39-cu111', 'anyscale/ray:2.4.0-py39-cu112', 'anyscale/ray:2.4.0-py39-cu113', 'anyscale/ray:2.4.0-py39-cu116', 'anyscale/ray:2.4.0-py39-cu118', 'anyscale/ray:2.40.0-py310', 'anyscale/ray:2.40.0-py310-cu117', 'anyscale/ray:2.40.0-py310-cu118', 'anyscale/ray:2.40.0-py310-cu121', 'anyscale/ray:2.40.0-py310-cu123', 'anyscale/ray:2.40.0-py311', 'anyscale/ray:2.40.0-py311-cu117', 'anyscale/ray:2.40.0-py311-cu118', 'anyscale/ray:2.40.0-py311-cu121', 'anyscale/ray:2.40.0-py311-cu123', 'anyscale/ray:2.40.0-py312', 'anyscale/ray:2.40.0-py312-cu117', 'anyscale/ray:2.40.0-py312-cu118', 'anyscale/ray:2.40.0-py312-cu121', 'anyscale/ray:2.40.0-py312-cu123', 'anyscale/ray:2.40.0-py39', 'anyscale/ray:2.40.0-py39-cu117', 'anyscale/ray:2.40.0-py39-cu118', 'anyscale/ray:2.40.0-py39-cu121', 'anyscale/ray:2.40.0-py39-cu123', 'anyscale/ray:2.40.0-slim-py310', 'anyscale/ray:2.40.0-slim-py310-cu118', 'anyscale/ray:2.40.0-slim-py310-cu121', 'anyscale/ray:2.40.0-slim-py310-cu123', 'anyscale/ray:2.40.0-slim-py311', 'anyscale/ray:2.40.0-slim-py311-cu118', 'anyscale/ray:2.40.0-slim-py311-cu121', 'anyscale/ray:2.40.0-slim-py311-cu123', 'anyscale/ray:2.40.0-slim-py312', 'anyscale/ray:2.40.0-slim-py312-cu118', 'anyscale/ray:2.40.0-slim-py312-cu121', 'anyscale/ray:2.40.0-slim-py312-cu123', 'anyscale/ray:2.40.0-slim-py39', 'anyscale/ray:2.40.0-slim-py39-cu118', 'anyscale/ray:2.40.0-slim-py39-cu121', 'anyscale/ray:2.40.0-slim-py39-cu123', 'anyscale/ray:2.41.0-py310', 'anyscale/ray:2.41.0-py310-cu117', 'anyscale/ray:2.41.0-py310-cu118', 'anyscale/ray:2.41.0-py310-cu121', 'anyscale/ray:2.41.0-py310-cu123', 'anyscale/ray:2.41.0-py311', 'anyscale/ray:2.41.0-py311-cu117', 'anyscale/ray:2.41.0-py311-cu118', 'anyscale/ray:2.41.0-py311-cu121', 'anyscale/ray:2.41.0-py311-cu123', 'anyscale/ray:2.41.0-py312', 'anyscale/ray:2.41.0-py312-cu117', 'anyscale/ray:2.41.0-py312-cu118', 'anyscale/ray:2.41.0-py312-cu121', 'anyscale/ray:2.41.0-py312-cu123', 'anyscale/ray:2.41.0-py39', 'anyscale/ray:2.41.0-py39-cu117', 'anyscale/ray:2.41.0-py39-cu118', 'anyscale/ray:2.41.0-py39-cu121', 'anyscale/ray:2.41.0-py39-cu123', 'anyscale/ray:2.41.0-slim-py310', 'anyscale/ray:2.41.0-slim-py310-cu118', 'anyscale/ray:2.41.0-slim-py310-cu121', 'anyscale/ray:2.41.0-slim-py310-cu123', 'anyscale/ray:2.41.0-slim-py311', 'anyscale/ray:2.41.0-slim-py311-cu118', 'anyscale/ray:2.41.0-slim-py311-cu121', 'anyscale/ray:2.41.0-slim-py311-cu123', 'anyscale/ray:2.41.0-slim-py312', 'anyscale/ray:2.41.0-slim-py312-cu118', 'anyscale/ray:2.41.0-slim-py312-cu121', 'anyscale/ray:2.41.0-slim-py312-cu123', 'anyscale/ray:2.41.0-slim-py39', 'anyscale/ray:2.41.0-slim-py39-cu118', 'anyscale/ray:2.41.0-slim-py39-cu121', 'anyscale/ray:2.41.0-slim-py39-cu123', 'anyscale/ray:2.42.0-py310', 'anyscale/ray:2.42.0-py310-cu117', 'anyscale/ray:2.42.0-py310-cu118', 'anyscale/ray:2.42.0-py310-cu121', 'anyscale/ray:2.42.0-py310-cu123', 'anyscale/ray:2.42.0-py310-cu124', 'anyscale/ray:2.42.0-py311', 'anyscale/ray:2.42.0-py311-cu117', 'anyscale/ray:2.42.0-py311-cu118', 'anyscale/ray:2.42.0-py311-cu121', 'anyscale/ray:2.42.0-py311-cu123', 'anyscale/ray:2.42.0-py311-cu124', 'anyscale/ray:2.42.0-py312', 'anyscale/ray:2.42.0-py312-cu117', 'anyscale/ray:2.42.0-py312-cu118', 'anyscale/ray:2.42.0-py312-cu121', 'anyscale/ray:2.42.0-py312-cu123', 'anyscale/ray:2.42.0-py312-cu124', 'anyscale/ray:2.42.0-py39', 'anyscale/ray:2.42.0-py39-cu117', 'anyscale/ray:2.42.0-py39-cu118', 'anyscale/ray:2.42.0-py39-cu121', 'anyscale/ray:2.42.0-py39-cu123', 'anyscale/ray:2.42.0-py39-cu124', 'anyscale/ray:2.42.0-slim-py310', 'anyscale/ray:2.42.0-slim-py310-cu118', 'anyscale/ray:2.42.0-slim-py310-cu121', 'anyscale/ray:2.42.0-slim-py310-cu123', 'anyscale/ray:2.42.0-slim-py310-cu124', 'anyscale/ray:2.42.0-slim-py311', 'anyscale/ray:2.42.0-slim-py311-cu118', 'anyscale/ray:2.42.0-slim-py311-cu121', 'anyscale/ray:2.42.0-slim-py311-cu123', 'anyscale/ray:2.42.0-slim-py311-cu124', 'anyscale/ray:2.42.0-slim-py312', 'anyscale/ray:2.42.0-slim-py312-cu118', 'anyscale/ray:2.42.0-slim-py312-cu121', 'anyscale/ray:2.42.0-slim-py312-cu123', 'anyscale/ray:2.42.0-slim-py312-cu124', 'anyscale/ray:2.42.0-slim-py39', 'anyscale/ray:2.42.0-slim-py39-cu118', 'anyscale/ray:2.42.0-slim-py39-cu121', 'anyscale/ray:2.42.0-slim-py39-cu123', 'anyscale/ray:2.42.0-slim-py39-cu124', 'anyscale/ray:2.42.1-py310', 'anyscale/ray:2.42.1-py310-cu117', 'anyscale/ray:2.42.1-py310-cu118', 'anyscale/ray:2.42.1-py310-cu121', 'anyscale/ray:2.42.1-py310-cu123', 'anyscale/ray:2.42.1-py310-cu124', 'anyscale/ray:2.42.1-py311', 'anyscale/ray:2.42.1-py311-cu117', 'anyscale/ray:2.42.1-py311-cu118', 'anyscale/ray:2.42.1-py311-cu121', 'anyscale/ray:2.42.1-py311-cu123', 'anyscale/ray:2.42.1-py311-cu124', 'anyscale/ray:2.42.1-py312', 'anyscale/ray:2.42.1-py312-cu117', 'anyscale/ray:2.42.1-py312-cu118', 'anyscale/ray:2.42.1-py312-cu121', 'anyscale/ray:2.42.1-py312-cu123', 'anyscale/ray:2.42.1-py312-cu124', 'anyscale/ray:2.42.1-py39', 'anyscale/ray:2.42.1-py39-cu117', 'anyscale/ray:2.42.1-py39-cu118', 'anyscale/ray:2.42.1-py39-cu121', 'anyscale/ray:2.42.1-py39-cu123', 'anyscale/ray:2.42.1-py39-cu124', 'anyscale/ray:2.42.1-slim-py310', 'anyscale/ray:2.42.1-slim-py310-cu118', 'anyscale/ray:2.42.1-slim-py310-cu121', 'anyscale/ray:2.42.1-slim-py310-cu123', 'anyscale/ray:2.42.1-slim-py310-cu124', 'anyscale/ray:2.42.1-slim-py311', 'anyscale/ray:2.42.1-slim-py311-cu118', 'anyscale/ray:2.42.1-slim-py311-cu121', 'anyscale/ray:2.42.1-slim-py311-cu123', 'anyscale/ray:2.42.1-slim-py311-cu124', 'anyscale/ray:2.42.1-slim-py312', 'anyscale/ray:2.42.1-slim-py312-cu118', 'anyscale/ray:2.42.1-slim-py312-cu121', 'anyscale/ray:2.42.1-slim-py312-cu123', 'anyscale/ray:2.42.1-slim-py312-cu124', 'anyscale/ray:2.42.1-slim-py39', 'anyscale/ray:2.42.1-slim-py39-cu118', 'anyscale/ray:2.42.1-slim-py39-cu121', 'anyscale/ray:2.42.1-slim-py39-cu123', 'anyscale/ray:2.42.1-slim-py39-cu124', 'anyscale/ray:2.43.0-py310', 'anyscale/ray:2.43.0-py310-cu117', 'anyscale/ray:2.43.0-py310-cu118', 'anyscale/ray:2.43.0-py310-cu121', 'anyscale/ray:2.43.0-py310-cu123', 'anyscale/ray:2.43.0-py310-cu124', 'anyscale/ray:2.43.0-py310-cu125', 'anyscale/ray:2.43.0-py311', 'anyscale/ray:2.43.0-py311-cu117', 'anyscale/ray:2.43.0-py311-cu118', 'anyscale/ray:2.43.0-py311-cu121', 'anyscale/ray:2.43.0-py311-cu123', 'anyscale/ray:2.43.0-py311-cu124', 'anyscale/ray:2.43.0-py311-cu125', 'anyscale/ray:2.43.0-py312', 'anyscale/ray:2.43.0-py312-cu117', 'anyscale/ray:2.43.0-py312-cu118', 'anyscale/ray:2.43.0-py312-cu121', 'anyscale/ray:2.43.0-py312-cu123', 'anyscale/ray:2.43.0-py312-cu124', 'anyscale/ray:2.43.0-py312-cu125', 'anyscale/ray:2.43.0-py39', 'anyscale/ray:2.43.0-py39-cu117', 'anyscale/ray:2.43.0-py39-cu118', 'anyscale/ray:2.43.0-py39-cu121', 'anyscale/ray:2.43.0-py39-cu123', 'anyscale/ray:2.43.0-py39-cu124', 'anyscale/ray:2.43.0-py39-cu125', 'anyscale/ray:2.43.0-slim-py310', 'anyscale/ray:2.43.0-slim-py310-cu118', 'anyscale/ray:2.43.0-slim-py310-cu121', 'anyscale/ray:2.43.0-slim-py310-cu123', 'anyscale/ray:2.43.0-slim-py310-cu124', 'anyscale/ray:2.43.0-slim-py310-cu125', 'anyscale/ray:2.43.0-slim-py311', 'anyscale/ray:2.43.0-slim-py311-cu118', 'anyscale/ray:2.43.0-slim-py311-cu121', 'anyscale/ray:2.43.0-slim-py311-cu123', 'anyscale/ray:2.43.0-slim-py311-cu124', 'anyscale/ray:2.43.0-slim-py311-cu125', 'anyscale/ray:2.43.0-slim-py312', 'anyscale/ray:2.43.0-slim-py312-cu118', 'anyscale/ray:2.43.0-slim-py312-cu121', 'anyscale/ray:2.43.0-slim-py312-cu123', 'anyscale/ray:2.43.0-slim-py312-cu124', 'anyscale/ray:2.43.0-slim-py312-cu125', 'anyscale/ray:2.43.0-slim-py39', 'anyscale/ray:2.43.0-slim-py39-cu118', 'anyscale/ray:2.43.0-slim-py39-cu121', 'anyscale/ray:2.43.0-slim-py39-cu123', 'anyscale/ray:2.43.0-slim-py39-cu124', 'anyscale/ray:2.43.0-slim-py39-cu125', 'anyscale/ray:2.44.0-py310', 'anyscale/ray:2.44.0-py310-cu117', 'anyscale/ray:2.44.0-py310-cu118', 'anyscale/ray:2.44.0-py310-cu121', 'anyscale/ray:2.44.0-py310-cu123', 'anyscale/ray:2.44.0-py310-cu124', 'anyscale/ray:2.44.0-py310-cu125', 'anyscale/ray:2.44.0-py310-cu128', 'anyscale/ray:2.44.0-py311', 'anyscale/ray:2.44.0-py311-cu117', 'anyscale/ray:2.44.0-py311-cu118', 'anyscale/ray:2.44.0-py311-cu121', 'anyscale/ray:2.44.0-py311-cu123', 'anyscale/ray:2.44.0-py311-cu124', 'anyscale/ray:2.44.0-py311-cu125', 'anyscale/ray:2.44.0-py311-cu128', 'anyscale/ray:2.44.0-py312', 'anyscale/ray:2.44.0-py312-cu117', 'anyscale/ray:2.44.0-py312-cu118', 'anyscale/ray:2.44.0-py312-cu121', 'anyscale/ray:2.44.0-py312-cu123', 'anyscale/ray:2.44.0-py312-cu124', 'anyscale/ray:2.44.0-py312-cu125', 'anyscale/ray:2.44.0-py312-cu128', 'anyscale/ray:2.44.0-py39', 'anyscale/ray:2.44.0-py39-cu117', 'anyscale/ray:2.44.0-py39-cu118', 'anyscale/ray:2.44.0-py39-cu121', 'anyscale/ray:2.44.0-py39-cu123', 'anyscale/ray:2.44.0-py39-cu124', 'anyscale/ray:2.44.0-py39-cu125', 'anyscale/ray:2.44.0-py39-cu128', 'anyscale/ray:2.44.0-slim-py310', 'anyscale/ray:2.44.0-slim-py310-cu118', 'anyscale/ray:2.44.0-slim-py310-cu121', 'anyscale/ray:2.44.0-slim-py310-cu123', 'anyscale/ray:2.44.0-slim-py310-cu124', 'anyscale/ray:2.44.0-slim-py310-cu125', 'anyscale/ray:2.44.0-slim-py310-cu128', 'anyscale/ray:2.44.0-slim-py311', 'anyscale/ray:2.44.0-slim-py311-cu118', 'anyscale/ray:2.44.0-slim-py311-cu121', 'anyscale/ray:2.44.0-slim-py311-cu123', 'anyscale/ray:2.44.0-slim-py311-cu124', 'anyscale/ray:2.44.0-slim-py311-cu125', 'anyscale/ray:2.44.0-slim-py311-cu128', 'anyscale/ray:2.44.0-slim-py312', 'anyscale/ray:2.44.0-slim-py312-cu118', 'anyscale/ray:2.44.0-slim-py312-cu121', 'anyscale/ray:2.44.0-slim-py312-cu123', 'anyscale/ray:2.44.0-slim-py312-cu124', 'anyscale/ray:2.44.0-slim-py312-cu125', 'anyscale/ray:2.44.0-slim-py312-cu128', 'anyscale/ray:2.44.0-slim-py39', 'anyscale/ray:2.44.0-slim-py39-cu118', 'anyscale/ray:2.44.0-slim-py39-cu121', 'anyscale/ray:2.44.0-slim-py39-cu123', 'anyscale/ray:2.44.0-slim-py39-cu124', 'anyscale/ray:2.44.0-slim-py39-cu125', 'anyscale/ray:2.44.0-slim-py39-cu128', 'anyscale/ray:2.44.1-py310', 'anyscale/ray:2.44.1-py310-cu117', 'anyscale/ray:2.44.1-py310-cu118', 'anyscale/ray:2.44.1-py310-cu121', 'anyscale/ray:2.44.1-py310-cu123', 'anyscale/ray:2.44.1-py310-cu124', 'anyscale/ray:2.44.1-py310-cu125', 'anyscale/ray:2.44.1-py310-cu128', 'anyscale/ray:2.44.1-py311', 'anyscale/ray:2.44.1-py311-cu117', 'anyscale/ray:2.44.1-py311-cu118', 'anyscale/ray:2.44.1-py311-cu121', 'anyscale/ray:2.44.1-py311-cu123', 'anyscale/ray:2.44.1-py311-cu124', 'anyscale/ray:2.44.1-py311-cu125', 'anyscale/ray:2.44.1-py311-cu128', 'anyscale/ray:2.44.1-py312', 'anyscale/ray:2.44.1-py312-cu117', 'anyscale/ray:2.44.1-py312-cu118', 'anyscale/ray:2.44.1-py312-cu121', 'anyscale/ray:2.44.1-py312-cu123', 'anyscale/ray:2.44.1-py312-cu124', 'anyscale/ray:2.44.1-py312-cu125', 'anyscale/ray:2.44.1-py312-cu128', 'anyscale/ray:2.44.1-py39', 'anyscale/ray:2.44.1-py39-cu117', 'anyscale/ray:2.44.1-py39-cu118', 'anyscale/ray:2.44.1-py39-cu121', 'anyscale/ray:2.44.1-py39-cu123', 'anyscale/ray:2.44.1-py39-cu124', 'anyscale/ray:2.44.1-py39-cu125', 'anyscale/ray:2.44.1-py39-cu128', 'anyscale/ray:2.44.1-slim-py310', 'anyscale/ray:2.44.1-slim-py310-cu118', 'anyscale/ray:2.44.1-slim-py310-cu121', 'anyscale/ray:2.44.1-slim-py310-cu123', 'anyscale/ray:2.44.1-slim-py310-cu124', 'anyscale/ray:2.44.1-slim-py310-cu125', 'anyscale/ray:2.44.1-slim-py310-cu128', 'anyscale/ray:2.44.1-slim-py311', 'anyscale/ray:2.44.1-slim-py311-cu118', 'anyscale/ray:2.44.1-slim-py311-cu121', 'anyscale/ray:2.44.1-slim-py311-cu123', 'anyscale/ray:2.44.1-slim-py311-cu124', 'anyscale/ray:2.44.1-slim-py311-cu125', 'anyscale/ray:2.44.1-slim-py311-cu128', 'anyscale/ray:2.44.1-slim-py312', 'anyscale/ray:2.44.1-slim-py312-cu118', 'anyscale/ray:2.44.1-slim-py312-cu121', 'anyscale/ray:2.44.1-slim-py312-cu123', 'anyscale/ray:2.44.1-slim-py312-cu124', 'anyscale/ray:2.44.1-slim-py312-cu125', 'anyscale/ray:2.44.1-slim-py312-cu128', 'anyscale/ray:2.44.1-slim-py39', 'anyscale/ray:2.44.1-slim-py39-cu118', 'anyscale/ray:2.44.1-slim-py39-cu121', 'anyscale/ray:2.44.1-slim-py39-cu123', 'anyscale/ray:2.44.1-slim-py39-cu124', 'anyscale/ray:2.44.1-slim-py39-cu125', 'anyscale/ray:2.44.1-slim-py39-cu128', 'anyscale/ray:2.45.0-py310', 'anyscale/ray:2.45.0-py310-cu117', 'anyscale/ray:2.45.0-py310-cu118', 'anyscale/ray:2.45.0-py310-cu121', 'anyscale/ray:2.45.0-py310-cu123', 'anyscale/ray:2.45.0-py310-cu124', 'anyscale/ray:2.45.0-py310-cu125', 'anyscale/ray:2.45.0-py310-cu128', 'anyscale/ray:2.45.0-py311', 'anyscale/ray:2.45.0-py311-cu117', 'anyscale/ray:2.45.0-py311-cu118', 'anyscale/ray:2.45.0-py311-cu121', 'anyscale/ray:2.45.0-py311-cu123', 'anyscale/ray:2.45.0-py311-cu124', 'anyscale/ray:2.45.0-py311-cu125', 'anyscale/ray:2.45.0-py311-cu128', 'anyscale/ray:2.45.0-py312', 'anyscale/ray:2.45.0-py312-cu117', 'anyscale/ray:2.45.0-py312-cu118', 'anyscale/ray:2.45.0-py312-cu121', 'anyscale/ray:2.45.0-py312-cu123', 'anyscale/ray:2.45.0-py312-cu124', 'anyscale/ray:2.45.0-py312-cu125', 'anyscale/ray:2.45.0-py312-cu128', 'anyscale/ray:2.45.0-py39', 'anyscale/ray:2.45.0-py39-cu117', 'anyscale/ray:2.45.0-py39-cu118', 'anyscale/ray:2.45.0-py39-cu121', 'anyscale/ray:2.45.0-py39-cu123', 'anyscale/ray:2.45.0-py39-cu124', 'anyscale/ray:2.45.0-py39-cu125', 'anyscale/ray:2.45.0-py39-cu128', 'anyscale/ray:2.45.0-slim-py310', 'anyscale/ray:2.45.0-slim-py310-cu118', 'anyscale/ray:2.45.0-slim-py310-cu121', 'anyscale/ray:2.45.0-slim-py310-cu123', 'anyscale/ray:2.45.0-slim-py310-cu124', 'anyscale/ray:2.45.0-slim-py310-cu125', 'anyscale/ray:2.45.0-slim-py310-cu128', 'anyscale/ray:2.45.0-slim-py311', 'anyscale/ray:2.45.0-slim-py311-cu118', 'anyscale/ray:2.45.0-slim-py311-cu121', 'anyscale/ray:2.45.0-slim-py311-cu123', 'anyscale/ray:2.45.0-slim-py311-cu124', 'anyscale/ray:2.45.0-slim-py311-cu125', 'anyscale/ray:2.45.0-slim-py311-cu128', 'anyscale/ray:2.45.0-slim-py312', 'anyscale/ray:2.45.0-slim-py312-cu118', 'anyscale/ray:2.45.0-slim-py312-cu121', 'anyscale/ray:2.45.0-slim-py312-cu123', 'anyscale/ray:2.45.0-slim-py312-cu124', 'anyscale/ray:2.45.0-slim-py312-cu125', 'anyscale/ray:2.45.0-slim-py312-cu128', 'anyscale/ray:2.45.0-slim-py39', 'anyscale/ray:2.45.0-slim-py39-cu118', 'anyscale/ray:2.45.0-slim-py39-cu121', 'anyscale/ray:2.45.0-slim-py39-cu123', 'anyscale/ray:2.45.0-slim-py39-cu124', 'anyscale/ray:2.45.0-slim-py39-cu125', 'anyscale/ray:2.45.0-slim-py39-cu128', 'anyscale/ray:2.46.0-py310', 'anyscale/ray:2.46.0-py310-cu117', 'anyscale/ray:2.46.0-py310-cu118', 'anyscale/ray:2.46.0-py310-cu121', 'anyscale/ray:2.46.0-py310-cu123', 'anyscale/ray:2.46.0-py310-cu124', 'anyscale/ray:2.46.0-py310-cu125', 'anyscale/ray:2.46.0-py310-cu128', 'anyscale/ray:2.46.0-py311', 'anyscale/ray:2.46.0-py311-cu117', 'anyscale/ray:2.46.0-py311-cu118', 'anyscale/ray:2.46.0-py311-cu121', 'anyscale/ray:2.46.0-py311-cu123', 'anyscale/ray:2.46.0-py311-cu124', 'anyscale/ray:2.46.0-py311-cu125', 'anyscale/ray:2.46.0-py311-cu128', 'anyscale/ray:2.46.0-py312', 'anyscale/ray:2.46.0-py312-cu117', 'anyscale/ray:2.46.0-py312-cu118', 'anyscale/ray:2.46.0-py312-cu121', 'anyscale/ray:2.46.0-py312-cu123', 'anyscale/ray:2.46.0-py312-cu124', 'anyscale/ray:2.46.0-py312-cu125', 'anyscale/ray:2.46.0-py312-cu128', 'anyscale/ray:2.46.0-py39', 'anyscale/ray:2.46.0-py39-cu117', 'anyscale/ray:2.46.0-py39-cu118', 'anyscale/ray:2.46.0-py39-cu121', 'anyscale/ray:2.46.0-py39-cu123', 'anyscale/ray:2.46.0-py39-cu124', 'anyscale/ray:2.46.0-py39-cu125', 'anyscale/ray:2.46.0-py39-cu128', 'anyscale/ray:2.46.0-slim-py310', 'anyscale/ray:2.46.0-slim-py310-cu118', 'anyscale/ray:2.46.0-slim-py310-cu121', 'anyscale/ray:2.46.0-slim-py310-cu123', 'anyscale/ray:2.46.0-slim-py310-cu124', 'anyscale/ray:2.46.0-slim-py310-cu125', 'anyscale/ray:2.46.0-slim-py310-cu128', 'anyscale/ray:2.46.0-slim-py311', 'anyscale/ray:2.46.0-slim-py311-cu118', 'anyscale/ray:2.46.0-slim-py311-cu121', 'anyscale/ray:2.46.0-slim-py311-cu123', 'anyscale/ray:2.46.0-slim-py311-cu124', 'anyscale/ray:2.46.0-slim-py311-cu125', 'anyscale/ray:2.46.0-slim-py311-cu128', 'anyscale/ray:2.46.0-slim-py312', 'anyscale/ray:2.46.0-slim-py312-cu118', 'anyscale/ray:2.46.0-slim-py312-cu121', 'anyscale/ray:2.46.0-slim-py312-cu123', 'anyscale/ray:2.46.0-slim-py312-cu124', 'anyscale/ray:2.46.0-slim-py312-cu125', 'anyscale/ray:2.46.0-slim-py312-cu128', 'anyscale/ray:2.46.0-slim-py39', 'anyscale/ray:2.46.0-slim-py39-cu118', 'anyscale/ray:2.46.0-slim-py39-cu121', 'anyscale/ray:2.46.0-slim-py39-cu123', 'anyscale/ray:2.46.0-slim-py39-cu124', 'anyscale/ray:2.46.0-slim-py39-cu125', 'anyscale/ray:2.46.0-slim-py39-cu128', 'anyscale/ray:2.47.0-py310', 'anyscale/ray:2.47.0-py310-cu117', 'anyscale/ray:2.47.0-py310-cu118', 'anyscale/ray:2.47.0-py310-cu121', 'anyscale/ray:2.47.0-py310-cu123', 'anyscale/ray:2.47.0-py310-cu124', 'anyscale/ray:2.47.0-py310-cu125', 'anyscale/ray:2.47.0-py310-cu128', 'anyscale/ray:2.47.0-py311', 'anyscale/ray:2.47.0-py311-cu117', 'anyscale/ray:2.47.0-py311-cu118', 'anyscale/ray:2.47.0-py311-cu121', 'anyscale/ray:2.47.0-py311-cu123', 'anyscale/ray:2.47.0-py311-cu124', 'anyscale/ray:2.47.0-py311-cu125', 'anyscale/ray:2.47.0-py311-cu128', 'anyscale/ray:2.47.0-py312', 'anyscale/ray:2.47.0-py312-cu117', 'anyscale/ray:2.47.0-py312-cu118', 'anyscale/ray:2.47.0-py312-cu121', 'anyscale/ray:2.47.0-py312-cu123', 'anyscale/ray:2.47.0-py312-cu124', 'anyscale/ray:2.47.0-py312-cu125', 'anyscale/ray:2.47.0-py312-cu128', 'anyscale/ray:2.47.0-py39', 'anyscale/ray:2.47.0-py39-cu117', 'anyscale/ray:2.47.0-py39-cu118', 'anyscale/ray:2.47.0-py39-cu121', 'anyscale/ray:2.47.0-py39-cu123', 'anyscale/ray:2.47.0-py39-cu124', 'anyscale/ray:2.47.0-py39-cu125', 'anyscale/ray:2.47.0-py39-cu128', 'anyscale/ray:2.47.0-slim-py310', 'anyscale/ray:2.47.0-slim-py310-cu118', 'anyscale/ray:2.47.0-slim-py310-cu121', 'anyscale/ray:2.47.0-slim-py310-cu123', 'anyscale/ray:2.47.0-slim-py310-cu124', 'anyscale/ray:2.47.0-slim-py310-cu125', 'anyscale/ray:2.47.0-slim-py310-cu128', 'anyscale/ray:2.47.0-slim-py311', 'anyscale/ray:2.47.0-slim-py311-cu118', 'anyscale/ray:2.47.0-slim-py311-cu121', 'anyscale/ray:2.47.0-slim-py311-cu123', 'anyscale/ray:2.47.0-slim-py311-cu124', 'anyscale/ray:2.47.0-slim-py311-cu125', 'anyscale/ray:2.47.0-slim-py311-cu128', 'anyscale/ray:2.47.0-slim-py312', 'anyscale/ray:2.47.0-slim-py312-cu118', 'anyscale/ray:2.47.0-slim-py312-cu121', 'anyscale/ray:2.47.0-slim-py312-cu123', 'anyscale/ray:2.47.0-slim-py312-cu124', 'anyscale/ray:2.47.0-slim-py312-cu125', 'anyscale/ray:2.47.0-slim-py312-cu128', 'anyscale/ray:2.47.0-slim-py39', 'anyscale/ray:2.47.0-slim-py39-cu118', 'anyscale/ray:2.47.0-slim-py39-cu121', 'anyscale/ray:2.47.0-slim-py39-cu123', 'anyscale/ray:2.47.0-slim-py39-cu124', 'anyscale/ray:2.47.0-slim-py39-cu125', 'anyscale/ray:2.47.0-slim-py39-cu128', 'anyscale/ray:2.47.1-py310', 'anyscale/ray:2.47.1-py310-cu117', 'anyscale/ray:2.47.1-py310-cu118', 'anyscale/ray:2.47.1-py310-cu121', 'anyscale/ray:2.47.1-py310-cu123', 'anyscale/ray:2.47.1-py310-cu124', 'anyscale/ray:2.47.1-py310-cu125', 'anyscale/ray:2.47.1-py310-cu128', 'anyscale/ray:2.47.1-py311', 'anyscale/ray:2.47.1-py311-cu117', 'anyscale/ray:2.47.1-py311-cu118', 'anyscale/ray:2.47.1-py311-cu121', 'anyscale/ray:2.47.1-py311-cu123', 'anyscale/ray:2.47.1-py311-cu124', 'anyscale/ray:2.47.1-py311-cu125', 'anyscale/ray:2.47.1-py311-cu128', 'anyscale/ray:2.47.1-py312', 'anyscale/ray:2.47.1-py312-cu117', 'anyscale/ray:2.47.1-py312-cu118', 'anyscale/ray:2.47.1-py312-cu121', 'anyscale/ray:2.47.1-py312-cu123', 'anyscale/ray:2.47.1-py312-cu124', 'anyscale/ray:2.47.1-py312-cu125', 'anyscale/ray:2.47.1-py312-cu128', 'anyscale/ray:2.47.1-py39', 'anyscale/ray:2.47.1-py39-cu117', 'anyscale/ray:2.47.1-py39-cu118', 'anyscale/ray:2.47.1-py39-cu121', 'anyscale/ray:2.47.1-py39-cu123', 'anyscale/ray:2.47.1-py39-cu124', 'anyscale/ray:2.47.1-py39-cu125', 'anyscale/ray:2.47.1-py39-cu128', 'anyscale/ray:2.47.1-slim-py310', 'anyscale/ray:2.47.1-slim-py310-cu118', 'anyscale/ray:2.47.1-slim-py310-cu121', 'anyscale/ray:2.47.1-slim-py310-cu123', 'anyscale/ray:2.47.1-slim-py310-cu124', 'anyscale/ray:2.47.1-slim-py310-cu125', 'anyscale/ray:2.47.1-slim-py310-cu128', 'anyscale/ray:2.47.1-slim-py311', 'anyscale/ray:2.47.1-slim-py311-cu118', 'anyscale/ray:2.47.1-slim-py311-cu121', 'anyscale/ray:2.47.1-slim-py311-cu123', 'anyscale/ray:2.47.1-slim-py311-cu124', 'anyscale/ray:2.47.1-slim-py311-cu125', 'anyscale/ray:2.47.1-slim-py311-cu128', 'anyscale/ray:2.47.1-slim-py312', 'anyscale/ray:2.47.1-slim-py312-cu118', 'anyscale/ray:2.47.1-slim-py312-cu121', 'anyscale/ray:2.47.1-slim-py312-cu123', 'anyscale/ray:2.47.1-slim-py312-cu124', 'anyscale/ray:2.47.1-slim-py312-cu125', 'anyscale/ray:2.47.1-slim-py312-cu128', 'anyscale/ray:2.47.1-slim-py39', 'anyscale/ray:2.47.1-slim-py39-cu118', 'anyscale/ray:2.47.1-slim-py39-cu121', 'anyscale/ray:2.47.1-slim-py39-cu123', 'anyscale/ray:2.47.1-slim-py39-cu124', 'anyscale/ray:2.47.1-slim-py39-cu125', 'anyscale/ray:2.47.1-slim-py39-cu128', 'anyscale/ray:2.48.0-py310', 'anyscale/ray:2.48.0-py310-cu117', 'anyscale/ray:2.48.0-py310-cu118', 'anyscale/ray:2.48.0-py310-cu121', 'anyscale/ray:2.48.0-py310-cu123', 'anyscale/ray:2.48.0-py310-cu124', 'anyscale/ray:2.48.0-py310-cu125', 'anyscale/ray:2.48.0-py310-cu128', 'anyscale/ray:2.48.0-py311', 'anyscale/ray:2.48.0-py311-cu117', 'anyscale/ray:2.48.0-py311-cu118', 'anyscale/ray:2.48.0-py311-cu121', 'anyscale/ray:2.48.0-py311-cu123', 'anyscale/ray:2.48.0-py311-cu124', 'anyscale/ray:2.48.0-py311-cu125', 'anyscale/ray:2.48.0-py311-cu128', 'anyscale/ray:2.48.0-py312', 'anyscale/ray:2.48.0-py312-cu117', 'anyscale/ray:2.48.0-py312-cu118', 'anyscale/ray:2.48.0-py312-cu121', 'anyscale/ray:2.48.0-py312-cu123', 'anyscale/ray:2.48.0-py312-cu124', 'anyscale/ray:2.48.0-py312-cu125', 'anyscale/ray:2.48.0-py312-cu128', 'anyscale/ray:2.48.0-py39', 'anyscale/ray:2.48.0-py39-cu117', 'anyscale/ray:2.48.0-py39-cu118', 'anyscale/ray:2.48.0-py39-cu121', 'anyscale/ray:2.48.0-py39-cu123', 'anyscale/ray:2.48.0-py39-cu124', 'anyscale/ray:2.48.0-py39-cu125', 'anyscale/ray:2.48.0-py39-cu128', 'anyscale/ray:2.48.0-slim-py310', 'anyscale/ray:2.48.0-slim-py310-cu118', 'anyscale/ray:2.48.0-slim-py310-cu121', 'anyscale/ray:2.48.0-slim-py310-cu123', 'anyscale/ray:2.48.0-slim-py310-cu124', 'anyscale/ray:2.48.0-slim-py310-cu125', 'anyscale/ray:2.48.0-slim-py310-cu128', 'anyscale/ray:2.48.0-slim-py311', 'anyscale/ray:2.48.0-slim-py311-cu118', 'anyscale/ray:2.48.0-slim-py311-cu121', 'anyscale/ray:2.48.0-slim-py311-cu123', 'anyscale/ray:2.48.0-slim-py311-cu124', 'anyscale/ray:2.48.0-slim-py311-cu125', 'anyscale/ray:2.48.0-slim-py311-cu128', 'anyscale/ray:2.48.0-slim-py312', 'anyscale/ray:2.48.0-slim-py312-cu118', 'anyscale/ray:2.48.0-slim-py312-cu121', 'anyscale/ray:2.48.0-slim-py312-cu123', 'anyscale/ray:2.48.0-slim-py312-cu124', 'anyscale/ray:2.48.0-slim-py312-cu125', 'anyscale/ray:2.48.0-slim-py312-cu128', 'anyscale/ray:2.48.0-slim-py39', 'anyscale/ray:2.48.0-slim-py39-cu118', 'anyscale/ray:2.48.0-slim-py39-cu121', 'anyscale/ray:2.48.0-slim-py39-cu123', 'anyscale/ray:2.48.0-slim-py39-cu124', 'anyscale/ray:2.48.0-slim-py39-cu125', 'anyscale/ray:2.48.0-slim-py39-cu128', 'anyscale/ray:2.49.0-py310', 'anyscale/ray:2.49.0-py310-cu117', 'anyscale/ray:2.49.0-py310-cu118', 'anyscale/ray:2.49.0-py310-cu121', 'anyscale/ray:2.49.0-py310-cu123', 'anyscale/ray:2.49.0-py310-cu124', 'anyscale/ray:2.49.0-py310-cu125', 'anyscale/ray:2.49.0-py310-cu126', 'anyscale/ray:2.49.0-py310-cu128', 'anyscale/ray:2.49.0-py311', 'anyscale/ray:2.49.0-py311-cu117', 'anyscale/ray:2.49.0-py311-cu118', 'anyscale/ray:2.49.0-py311-cu121', 'anyscale/ray:2.49.0-py311-cu123', 'anyscale/ray:2.49.0-py311-cu124', 'anyscale/ray:2.49.0-py311-cu125', 'anyscale/ray:2.49.0-py311-cu126', 'anyscale/ray:2.49.0-py311-cu128', 'anyscale/ray:2.49.0-py312', 'anyscale/ray:2.49.0-py312-cu117', 'anyscale/ray:2.49.0-py312-cu118', 'anyscale/ray:2.49.0-py312-cu121', 'anyscale/ray:2.49.0-py312-cu123', 'anyscale/ray:2.49.0-py312-cu124', 'anyscale/ray:2.49.0-py312-cu125', 'anyscale/ray:2.49.0-py312-cu126', 'anyscale/ray:2.49.0-py312-cu128', 'anyscale/ray:2.49.0-py39', 'anyscale/ray:2.49.0-py39-cu117', 'anyscale/ray:2.49.0-py39-cu118', 'anyscale/ray:2.49.0-py39-cu121', 'anyscale/ray:2.49.0-py39-cu123', 'anyscale/ray:2.49.0-py39-cu124', 'anyscale/ray:2.49.0-py39-cu125', 'anyscale/ray:2.49.0-py39-cu126', 'anyscale/ray:2.49.0-py39-cu128', 'anyscale/ray:2.49.0-slim-py310', 'anyscale/ray:2.49.0-slim-py310-cu118', 'anyscale/ray:2.49.0-slim-py310-cu121', 'anyscale/ray:2.49.0-slim-py310-cu123', 'anyscale/ray:2.49.0-slim-py310-cu124', 'anyscale/ray:2.49.0-slim-py310-cu125', 'anyscale/ray:2.49.0-slim-py310-cu126', 'anyscale/ray:2.49.0-slim-py310-cu128', 'anyscale/ray:2.49.0-slim-py311', 'anyscale/ray:2.49.0-slim-py311-cu118', 'anyscale/ray:2.49.0-slim-py311-cu121', 'anyscale/ray:2.49.0-slim-py311-cu123', 'anyscale/ray:2.49.0-slim-py311-cu124', 'anyscale/ray:2.49.0-slim-py311-cu125', 'anyscale/ray:2.49.0-slim-py311-cu126', 'anyscale/ray:2.49.0-slim-py311-cu128', 'anyscale/ray:2.49.0-slim-py312', 'anyscale/ray:2.49.0-slim-py312-cu118', 'anyscale/ray:2.49.0-slim-py312-cu121', 'anyscale/ray:2.49.0-slim-py312-cu123', 'anyscale/ray:2.49.0-slim-py312-cu124', 'anyscale/ray:2.49.0-slim-py312-cu125', 'anyscale/ray:2.49.0-slim-py312-cu126', 'anyscale/ray:2.49.0-slim-py312-cu128', 'anyscale/ray:2.49.0-slim-py39', 'anyscale/ray:2.49.0-slim-py39-cu118', 'anyscale/ray:2.49.0-slim-py39-cu121', 'anyscale/ray:2.49.0-slim-py39-cu123', 'anyscale/ray:2.49.0-slim-py39-cu124', 'anyscale/ray:2.49.0-slim-py39-cu125', 'anyscale/ray:2.49.0-slim-py39-cu126', 'anyscale/ray:2.49.0-slim-py39-cu128', 'anyscale/ray:2.49.1-py310', 'anyscale/ray:2.49.1-py310-cu117', 'anyscale/ray:2.49.1-py310-cu118', 'anyscale/ray:2.49.1-py310-cu121', 'anyscale/ray:2.49.1-py310-cu123', 'anyscale/ray:2.49.1-py310-cu124', 'anyscale/ray:2.49.1-py310-cu125', 'anyscale/ray:2.49.1-py310-cu126', 'anyscale/ray:2.49.1-py310-cu128', 'anyscale/ray:2.49.1-py311', 'anyscale/ray:2.49.1-py311-cu117', 'anyscale/ray:2.49.1-py311-cu118', 'anyscale/ray:2.49.1-py311-cu121', 'anyscale/ray:2.49.1-py311-cu123', 'anyscale/ray:2.49.1-py311-cu124', 'anyscale/ray:2.49.1-py311-cu125', 'anyscale/ray:2.49.1-py311-cu126', 'anyscale/ray:2.49.1-py311-cu128', 'anyscale/ray:2.49.1-py312', 'anyscale/ray:2.49.1-py312-cu117', 'anyscale/ray:2.49.1-py312-cu118', 'anyscale/ray:2.49.1-py312-cu121', 'anyscale/ray:2.49.1-py312-cu123', 'anyscale/ray:2.49.1-py312-cu124', 'anyscale/ray:2.49.1-py312-cu125', 'anyscale/ray:2.49.1-py312-cu126', 'anyscale/ray:2.49.1-py312-cu128', 'anyscale/ray:2.49.1-py39', 'anyscale/ray:2.49.1-py39-cu117', 'anyscale/ray:2.49.1-py39-cu118', 'anyscale/ray:2.49.1-py39-cu121', 'anyscale/ray:2.49.1-py39-cu123', 'anyscale/ray:2.49.1-py39-cu124', 'anyscale/ray:2.49.1-py39-cu125', 'anyscale/ray:2.49.1-py39-cu126', 'anyscale/ray:2.49.1-py39-cu128', 'anyscale/ray:2.49.1-slim-py310', 'anyscale/ray:2.49.1-slim-py310-cu118', 'anyscale/ray:2.49.1-slim-py310-cu121', 'anyscale/ray:2.49.1-slim-py310-cu123', 'anyscale/ray:2.49.1-slim-py310-cu124', 'anyscale/ray:2.49.1-slim-py310-cu125', 'anyscale/ray:2.49.1-slim-py310-cu126', 'anyscale/ray:2.49.1-slim-py310-cu128', 'anyscale/ray:2.49.1-slim-py311', 'anyscale/ray:2.49.1-slim-py311-cu118', 'anyscale/ray:2.49.1-slim-py311-cu121', 'anyscale/ray:2.49.1-slim-py311-cu123', 'anyscale/ray:2.49.1-slim-py311-cu124', 'anyscale/ray:2.49.1-slim-py311-cu125', 'anyscale/ray:2.49.1-slim-py311-cu126', 'anyscale/ray:2.49.1-slim-py311-cu128', 'anyscale/ray:2.49.1-slim-py312', 'anyscale/ray:2.49.1-slim-py312-cu118', 'anyscale/ray:2.49.1-slim-py312-cu121', 'anyscale/ray:2.49.1-slim-py312-cu123', 'anyscale/ray:2.49.1-slim-py312-cu124', 'anyscale/ray:2.49.1-slim-py312-cu125', 'anyscale/ray:2.49.1-slim-py312-cu126', 'anyscale/ray:2.49.1-slim-py312-cu128', 'anyscale/ray:2.49.1-slim-py39', 'anyscale/ray:2.49.1-slim-py39-cu118', 'anyscale/ray:2.49.1-slim-py39-cu121', 'anyscale/ray:2.49.1-slim-py39-cu123', 'anyscale/ray:2.49.1-slim-py39-cu124', 'anyscale/ray:2.49.1-slim-py39-cu125', 'anyscale/ray:2.49.1-slim-py39-cu126', 'anyscale/ray:2.49.1-slim-py39-cu128', 'anyscale/ray:2.5.0-py310', 'anyscale/ray:2.5.0-py310-cu101', 'anyscale/ray:2.5.0-py310-cu102', 'anyscale/ray:2.5.0-py310-cu110', 'anyscale/ray:2.5.0-py310-cu111', 'anyscale/ray:2.5.0-py310-cu112', 'anyscale/ray:2.5.0-py310-cu113', 'anyscale/ray:2.5.0-py310-cu116', 'anyscale/ray:2.5.0-py310-cu118', 'anyscale/ray:2.5.0-py37', 'anyscale/ray:2.5.0-py37-cu101', 'anyscale/ray:2.5.0-py37-cu102', 'anyscale/ray:2.5.0-py37-cu110', 'anyscale/ray:2.5.0-py37-cu111', 'anyscale/ray:2.5.0-py37-cu112', 'anyscale/ray:2.5.0-py37-cu113', 'anyscale/ray:2.5.0-py37-cu116', 'anyscale/ray:2.5.0-py37-cu118', 'anyscale/ray:2.5.0-py38', 'anyscale/ray:2.5.0-py38-cu101', 'anyscale/ray:2.5.0-py38-cu102', 'anyscale/ray:2.5.0-py38-cu110', 'anyscale/ray:2.5.0-py38-cu111', 'anyscale/ray:2.5.0-py38-cu112', 'anyscale/ray:2.5.0-py38-cu113', 'anyscale/ray:2.5.0-py38-cu116', 'anyscale/ray:2.5.0-py38-cu118', 'anyscale/ray:2.5.0-py39', 'anyscale/ray:2.5.0-py39-cu101', 'anyscale/ray:2.5.0-py39-cu102', 'anyscale/ray:2.5.0-py39-cu110', 'anyscale/ray:2.5.0-py39-cu111', 'anyscale/ray:2.5.0-py39-cu112', 'anyscale/ray:2.5.0-py39-cu113', 'anyscale/ray:2.5.0-py39-cu116', 'anyscale/ray:2.5.0-py39-cu118', 'anyscale/ray:2.5.1-py310', 'anyscale/ray:2.5.1-py310-cu101', 'anyscale/ray:2.5.1-py310-cu102', 'anyscale/ray:2.5.1-py310-cu110', 'anyscale/ray:2.5.1-py310-cu111', 'anyscale/ray:2.5.1-py310-cu112', 'anyscale/ray:2.5.1-py310-cu113', 'anyscale/ray:2.5.1-py310-cu116', 'anyscale/ray:2.5.1-py310-cu118', 'anyscale/ray:2.5.1-py37', 'anyscale/ray:2.5.1-py37-cu101', 'anyscale/ray:2.5.1-py37-cu102', 'anyscale/ray:2.5.1-py37-cu110', 'anyscale/ray:2.5.1-py37-cu111', 'anyscale/ray:2.5.1-py37-cu112', 'anyscale/ray:2.5.1-py37-cu113', 'anyscale/ray:2.5.1-py37-cu116', 'anyscale/ray:2.5.1-py37-cu118', 'anyscale/ray:2.5.1-py38', 'anyscale/ray:2.5.1-py38-cu101', 'anyscale/ray:2.5.1-py38-cu102', 'anyscale/ray:2.5.1-py38-cu110', 'anyscale/ray:2.5.1-py38-cu111', 'anyscale/ray:2.5.1-py38-cu112', 'anyscale/ray:2.5.1-py38-cu113', 'anyscale/ray:2.5.1-py38-cu116', 'anyscale/ray:2.5.1-py38-cu118', 'anyscale/ray:2.5.1-py39', 'anyscale/ray:2.5.1-py39-cu101', 'anyscale/ray:2.5.1-py39-cu102', 'anyscale/ray:2.5.1-py39-cu110', 'anyscale/ray:2.5.1-py39-cu111', 'anyscale/ray:2.5.1-py39-cu112', 'anyscale/ray:2.5.1-py39-cu113', 'anyscale/ray:2.5.1-py39-cu116', 'anyscale/ray:2.5.1-py39-cu118', 'anyscale/ray:2.6.0-py310', 'anyscale/ray:2.6.0-py310-cu115', 'anyscale/ray:2.6.0-py310-cu116', 'anyscale/ray:2.6.0-py310-cu117', 'anyscale/ray:2.6.0-py310-cu118', 'anyscale/ray:2.6.0-py37', 'anyscale/ray:2.6.0-py37-cu115', 'anyscale/ray:2.6.0-py37-cu116', 'anyscale/ray:2.6.0-py37-cu117', 'anyscale/ray:2.6.0-py37-cu118', 'anyscale/ray:2.6.0-py38', 'anyscale/ray:2.6.0-py38-cu115', 'anyscale/ray:2.6.0-py38-cu116', 'anyscale/ray:2.6.0-py38-cu117', 'anyscale/ray:2.6.0-py38-cu118', 'anyscale/ray:2.6.0-py39', 'anyscale/ray:2.6.0-py39-cu115', 'anyscale/ray:2.6.0-py39-cu116', 'anyscale/ray:2.6.0-py39-cu117', 'anyscale/ray:2.6.0-py39-cu118', 'anyscale/ray:2.6.1-py310', 'anyscale/ray:2.6.1-py310-cu115', 'anyscale/ray:2.6.1-py310-cu116', 'anyscale/ray:2.6.1-py310-cu117', 'anyscale/ray:2.6.1-py310-cu118', 'anyscale/ray:2.6.1-py37', 'anyscale/ray:2.6.1-py37-cu115', 'anyscale/ray:2.6.1-py37-cu116', 'anyscale/ray:2.6.1-py37-cu117', 'anyscale/ray:2.6.1-py37-cu118', 'anyscale/ray:2.6.1-py38', 'anyscale/ray:2.6.1-py38-cu115', 'anyscale/ray:2.6.1-py38-cu116', 'anyscale/ray:2.6.1-py38-cu117', 'anyscale/ray:2.6.1-py38-cu118', 'anyscale/ray:2.6.1-py39', 'anyscale/ray:2.6.1-py39-cu115', 'anyscale/ray:2.6.1-py39-cu116', 'anyscale/ray:2.6.1-py39-cu117', 'anyscale/ray:2.6.1-py39-cu118', 'anyscale/ray:2.6.2-py310', 'anyscale/ray:2.6.2-py310-cu115', 'anyscale/ray:2.6.2-py310-cu116', 'anyscale/ray:2.6.2-py310-cu117', 'anyscale/ray:2.6.2-py310-cu118', 'anyscale/ray:2.6.2-py37', 'anyscale/ray:2.6.2-py37-cu115', 'anyscale/ray:2.6.2-py37-cu116', 'anyscale/ray:2.6.2-py37-cu117', 'anyscale/ray:2.6.2-py37-cu118', 'anyscale/ray:2.6.2-py38', 'anyscale/ray:2.6.2-py38-cu115', 'anyscale/ray:2.6.2-py38-cu116', 'anyscale/ray:2.6.2-py38-cu117', 'anyscale/ray:2.6.2-py38-cu118', 'anyscale/ray:2.6.2-py39', 'anyscale/ray:2.6.2-py39-cu115', 'anyscale/ray:2.6.2-py39-cu116', 'anyscale/ray:2.6.2-py39-cu117', 'anyscale/ray:2.6.2-py39-cu118', 'anyscale/ray:2.6.3-py310', 'anyscale/ray:2.6.3-py310-cu115', 'anyscale/ray:2.6.3-py310-cu116', 'anyscale/ray:2.6.3-py310-cu117', 'anyscale/ray:2.6.3-py310-cu118', 'anyscale/ray:2.6.3-py37', 'anyscale/ray:2.6.3-py37-cu115', 'anyscale/ray:2.6.3-py37-cu116', 'anyscale/ray:2.6.3-py37-cu117', 'anyscale/ray:2.6.3-py37-cu118', 'anyscale/ray:2.6.3-py38', 'anyscale/ray:2.6.3-py38-cu115', 'anyscale/ray:2.6.3-py38-cu116', 'anyscale/ray:2.6.3-py38-cu117', 'anyscale/ray:2.6.3-py38-cu118', 'anyscale/ray:2.6.3-py39', 'anyscale/ray:2.6.3-py39-cu115', 'anyscale/ray:2.6.3-py39-cu116', 'anyscale/ray:2.6.3-py39-cu117', 'anyscale/ray:2.6.3-py39-cu118', 'anyscale/ray:2.7.0optimized-py310', 'anyscale/ray:2.7.0optimized-py310-cu115', 'anyscale/ray:2.7.0optimized-py310-cu116', 'anyscale/ray:2.7.0optimized-py310-cu117', 'anyscale/ray:2.7.0optimized-py310-cu118', 'anyscale/ray:2.7.0optimized-py310-cu121', 'anyscale/ray:2.7.0optimized-py311', 'anyscale/ray:2.7.0optimized-py311-cu115', 'anyscale/ray:2.7.0optimized-py311-cu116', 'anyscale/ray:2.7.0optimized-py311-cu117', 'anyscale/ray:2.7.0optimized-py311-cu118', 'anyscale/ray:2.7.0optimized-py311-cu121', 'anyscale/ray:2.7.0optimized-py37', 'anyscale/ray:2.7.0optimized-py37-cu115', 'anyscale/ray:2.7.0optimized-py37-cu116', 'anyscale/ray:2.7.0optimized-py37-cu117', 'anyscale/ray:2.7.0optimized-py37-cu118', 'anyscale/ray:2.7.0optimized-py37-cu121', 'anyscale/ray:2.7.0optimized-py38', 'anyscale/ray:2.7.0optimized-py38-cu115', 'anyscale/ray:2.7.0optimized-py38-cu116', 'anyscale/ray:2.7.0optimized-py38-cu117', 'anyscale/ray:2.7.0optimized-py38-cu118', 'anyscale/ray:2.7.0optimized-py38-cu121', 'anyscale/ray:2.7.0optimized-py39', 'anyscale/ray:2.7.0optimized-py39-cu115', 'anyscale/ray:2.7.0optimized-py39-cu116', 'anyscale/ray:2.7.0optimized-py39-cu117', 'anyscale/ray:2.7.0optimized-py39-cu118', 'anyscale/ray:2.7.0optimized-py39-cu121', 'anyscale/ray:2.7.1optimized-py310', 'anyscale/ray:2.7.1optimized-py310-cu115', 'anyscale/ray:2.7.1optimized-py310-cu116', 'anyscale/ray:2.7.1optimized-py310-cu117', 'anyscale/ray:2.7.1optimized-py310-cu118', 'anyscale/ray:2.7.1optimized-py310-cu121', 'anyscale/ray:2.7.1optimized-py311', 'anyscale/ray:2.7.1optimized-py311-cu115', 'anyscale/ray:2.7.1optimized-py311-cu116', 'anyscale/ray:2.7.1optimized-py311-cu117', 'anyscale/ray:2.7.1optimized-py311-cu118', 'anyscale/ray:2.7.1optimized-py311-cu121', 'anyscale/ray:2.7.1optimized-py37', 'anyscale/ray:2.7.1optimized-py37-cu115', 'anyscale/ray:2.7.1optimized-py37-cu116', 'anyscale/ray:2.7.1optimized-py37-cu117', 'anyscale/ray:2.7.1optimized-py37-cu118', 'anyscale/ray:2.7.1optimized-py37-cu121', 'anyscale/ray:2.7.1optimized-py38', 'anyscale/ray:2.7.1optimized-py38-cu115', 'anyscale/ray:2.7.1optimized-py38-cu116', 'anyscale/ray:2.7.1optimized-py38-cu117', 'anyscale/ray:2.7.1optimized-py38-cu118', 'anyscale/ray:2.7.1optimized-py38-cu121', 'anyscale/ray:2.7.1optimized-py39', 'anyscale/ray:2.7.1optimized-py39-cu115', 'anyscale/ray:2.7.1optimized-py39-cu116', 'anyscale/ray:2.7.1optimized-py39-cu117', 'anyscale/ray:2.7.1optimized-py39-cu118', 'anyscale/ray:2.7.1optimized-py39-cu121', 'anyscale/ray:2.7.2optimized-py310', 'anyscale/ray:2.7.2optimized-py310-cu115', 'anyscale/ray:2.7.2optimized-py310-cu116', 'anyscale/ray:2.7.2optimized-py310-cu117', 'anyscale/ray:2.7.2optimized-py310-cu118', 'anyscale/ray:2.7.2optimized-py310-cu121', 'anyscale/ray:2.7.2optimized-py311', 'anyscale/ray:2.7.2optimized-py311-cu115', 'anyscale/ray:2.7.2optimized-py311-cu116', 'anyscale/ray:2.7.2optimized-py311-cu117', 'anyscale/ray:2.7.2optimized-py311-cu118', 'anyscale/ray:2.7.2optimized-py311-cu121', 'anyscale/ray:2.7.2optimized-py37', 'anyscale/ray:2.7.2optimized-py37-cu115', 'anyscale/ray:2.7.2optimized-py37-cu116', 'anyscale/ray:2.7.2optimized-py37-cu117', 'anyscale/ray:2.7.2optimized-py37-cu118', 'anyscale/ray:2.7.2optimized-py37-cu121', 'anyscale/ray:2.7.2optimized-py38', 'anyscale/ray:2.7.2optimized-py38-cu115', 'anyscale/ray:2.7.2optimized-py38-cu116', 'anyscale/ray:2.7.2optimized-py38-cu117', 'anyscale/ray:2.7.2optimized-py38-cu118', 'anyscale/ray:2.7.2optimized-py38-cu121', 'anyscale/ray:2.7.2optimized-py39', 'anyscale/ray:2.7.2optimized-py39-cu115', 'anyscale/ray:2.7.2optimized-py39-cu116', 'anyscale/ray:2.7.2optimized-py39-cu117', 'anyscale/ray:2.7.2optimized-py39-cu118', 'anyscale/ray:2.7.2optimized-py39-cu121', 'anyscale/ray:2.8.0-py310', 'anyscale/ray:2.8.0-py310-cu115', 'anyscale/ray:2.8.0-py310-cu116', 'anyscale/ray:2.8.0-py310-cu117', 'anyscale/ray:2.8.0-py310-cu118', 'anyscale/ray:2.8.0-py310-cu121', 'anyscale/ray:2.8.0-py311', 'anyscale/ray:2.8.0-py311-cu115', 'anyscale/ray:2.8.0-py311-cu116', 'anyscale/ray:2.8.0-py311-cu117', 'anyscale/ray:2.8.0-py311-cu118', 'anyscale/ray:2.8.0-py311-cu121', 'anyscale/ray:2.8.0-py38', 'anyscale/ray:2.8.0-py38-cu115', 'anyscale/ray:2.8.0-py38-cu116', 'anyscale/ray:2.8.0-py38-cu117', 'anyscale/ray:2.8.0-py38-cu118', 'anyscale/ray:2.8.0-py38-cu121', 'anyscale/ray:2.8.0-py39', 'anyscale/ray:2.8.0-py39-cu115', 'anyscale/ray:2.8.0-py39-cu116', 'anyscale/ray:2.8.0-py39-cu117', 'anyscale/ray:2.8.0-py39-cu118', 'anyscale/ray:2.8.0-py39-cu121', 'anyscale/ray:2.8.1-py310', 'anyscale/ray:2.8.1-py310-cu115', 'anyscale/ray:2.8.1-py310-cu116', 'anyscale/ray:2.8.1-py310-cu117', 'anyscale/ray:2.8.1-py310-cu118', 'anyscale/ray:2.8.1-py310-cu121', 'anyscale/ray:2.8.1-py311', 'anyscale/ray:2.8.1-py311-cu115', 'anyscale/ray:2.8.1-py311-cu116', 'anyscale/ray:2.8.1-py311-cu117', 'anyscale/ray:2.8.1-py311-cu118', 'anyscale/ray:2.8.1-py311-cu121', 'anyscale/ray:2.8.1-py38', 'anyscale/ray:2.8.1-py38-cu115', 'anyscale/ray:2.8.1-py38-cu116', 'anyscale/ray:2.8.1-py38-cu117', 'anyscale/ray:2.8.1-py38-cu118', 'anyscale/ray:2.8.1-py38-cu121', 'anyscale/ray:2.8.1-py39', 'anyscale/ray:2.8.1-py39-cu115', 'anyscale/ray:2.8.1-py39-cu116', 'anyscale/ray:2.8.1-py39-cu117', 'anyscale/ray:2.8.1-py39-cu118', 'anyscale/ray:2.8.1-py39-cu121', 'anyscale/ray:2.9.0-py310', 'anyscale/ray:2.9.0-py310-cu115', 'anyscale/ray:2.9.0-py310-cu116', 'anyscale/ray:2.9.0-py310-cu117', 'anyscale/ray:2.9.0-py310-cu118', 'anyscale/ray:2.9.0-py310-cu121', 'anyscale/ray:2.9.0-py311', 'anyscale/ray:2.9.0-py311-cu115', 'anyscale/ray:2.9.0-py311-cu116', 'anyscale/ray:2.9.0-py311-cu117', 'anyscale/ray:2.9.0-py311-cu118', 'anyscale/ray:2.9.0-py311-cu121', 'anyscale/ray:2.9.0-py38', 'anyscale/ray:2.9.0-py38-cu115', 'anyscale/ray:2.9.0-py38-cu116', 'anyscale/ray:2.9.0-py38-cu117', 'anyscale/ray:2.9.0-py38-cu118', 'anyscale/ray:2.9.0-py38-cu121', 'anyscale/ray:2.9.0-py39', 'anyscale/ray:2.9.0-py39-cu115', 'anyscale/ray:2.9.0-py39-cu116', 'anyscale/ray:2.9.0-py39-cu117', 'anyscale/ray:2.9.0-py39-cu118', 'anyscale/ray:2.9.0-py39-cu121', 'anyscale/ray:2.9.1-py310', 'anyscale/ray:2.9.1-py310-cu115', 'anyscale/ray:2.9.1-py310-cu116', 'anyscale/ray:2.9.1-py310-cu117', 'anyscale/ray:2.9.1-py310-cu118', 'anyscale/ray:2.9.1-py310-cu121', 'anyscale/ray:2.9.1-py311', 'anyscale/ray:2.9.1-py311-cu115', 'anyscale/ray:2.9.1-py311-cu116', 'anyscale/ray:2.9.1-py311-cu117', 'anyscale/ray:2.9.1-py311-cu118', 'anyscale/ray:2.9.1-py311-cu121', 'anyscale/ray:2.9.1-py38', 'anyscale/ray:2.9.1-py38-cu115', 'anyscale/ray:2.9.1-py38-cu116', 'anyscale/ray:2.9.1-py38-cu117', 'anyscale/ray:2.9.1-py38-cu118', 'anyscale/ray:2.9.1-py38-cu121', 'anyscale/ray:2.9.1-py39', 'anyscale/ray:2.9.1-py39-cu115', 'anyscale/ray:2.9.1-py39-cu116', 'anyscale/ray:2.9.1-py39-cu117', 'anyscale/ray:2.9.1-py39-cu118', 'anyscale/ray:2.9.1-py39-cu121', 'anyscale/ray:2.9.2-py310', 'anyscale/ray:2.9.2-py310-cu115', 'anyscale/ray:2.9.2-py310-cu116', 'anyscale/ray:2.9.2-py310-cu117', 'anyscale/ray:2.9.2-py310-cu118', 'anyscale/ray:2.9.2-py310-cu121', 'anyscale/ray:2.9.2-py311', 'anyscale/ray:2.9.2-py311-cu115', 'anyscale/ray:2.9.2-py311-cu116', 'anyscale/ray:2.9.2-py311-cu117', 'anyscale/ray:2.9.2-py311-cu118', 'anyscale/ray:2.9.2-py311-cu121', 'anyscale/ray:2.9.2-py38', 'anyscale/ray:2.9.2-py38-cu115', 'anyscale/ray:2.9.2-py38-cu116', 'anyscale/ray:2.9.2-py38-cu117', 'anyscale/ray:2.9.2-py38-cu118', 'anyscale/ray:2.9.2-py38-cu121', 'anyscale/ray:2.9.2-py39', 'anyscale/ray:2.9.2-py39-cu115', 'anyscale/ray:2.9.2-py39-cu116', 'anyscale/ray:2.9.2-py39-cu117', 'anyscale/ray:2.9.2-py39-cu118', 'anyscale/ray:2.9.2-py39-cu121', 'anyscale/ray:2.9.3-py310', 'anyscale/ray:2.9.3-py310-cu115', 'anyscale/ray:2.9.3-py310-cu116', 'anyscale/ray:2.9.3-py310-cu117', 'anyscale/ray:2.9.3-py310-cu118', 'anyscale/ray:2.9.3-py310-cu121', 'anyscale/ray:2.9.3-py311', 'anyscale/ray:2.9.3-py311-cu115', 'anyscale/ray:2.9.3-py311-cu116', 'anyscale/ray:2.9.3-py311-cu117', 'anyscale/ray:2.9.3-py311-cu118', 'anyscale/ray:2.9.3-py311-cu121', 'anyscale/ray:2.9.3-py38', 'anyscale/ray:2.9.3-py38-cu115', 'anyscale/ray:2.9.3-py38-cu116', 'anyscale/ray:2.9.3-py38-cu117', 'anyscale/ray:2.9.3-py38-cu118', 'anyscale/ray:2.9.3-py38-cu121', 'anyscale/ray:2.9.3-py39', 'anyscale/ray:2.9.3-py39-cu115', 'anyscale/ray:2.9.3-py39-cu116', 'anyscale/ray:2.9.3-py39-cu117', 'anyscale/ray:2.9.3-py39-cu118', 'anyscale/ray:2.9.3-py39-cu121', 'anyscale/ray:latest', 'anyscale/ray:nightly', 'anyscale/ray:nightly-gpu', 'anyscale/ray:nightly-py310', 'anyscale/ray:nightly-py310-cu117', 'anyscale/ray:nightly-py310-cu118', 'anyscale/ray:nightly-py310-cu121', 'anyscale/ray:nightly-py310-cu123', 'anyscale/ray:nightly-py310-cu124', 'anyscale/ray:nightly-py310-cu125', 'anyscale/ray:nightly-py310-cu126', 'anyscale/ray:nightly-py310-cu128', 'anyscale/ray:nightly-py311', 'anyscale/ray:nightly-py311-cu117', 'anyscale/ray:nightly-py311-cu118', 'anyscale/ray:nightly-py311-cu121', 'anyscale/ray:nightly-py311-cu123', 'anyscale/ray:nightly-py311-cu124', 'anyscale/ray:nightly-py311-cu125', 'anyscale/ray:nightly-py311-cu126', 'anyscale/ray:nightly-py311-cu128', 'anyscale/ray:nightly-py312', 'anyscale/ray:nightly-py312-cu117', 'anyscale/ray:nightly-py312-cu118', 'anyscale/ray:nightly-py312-cu121', 'anyscale/ray:nightly-py312-cu123', 'anyscale/ray:nightly-py312-cu124', 'anyscale/ray:nightly-py312-cu125', 'anyscale/ray:nightly-py312-cu126', 'anyscale/ray:nightly-py312-cu128', 'anyscale/ray:nightly-py36', 'anyscale/ray:nightly-py36-cu117', 'anyscale/ray:nightly-py36-cu118', 'anyscale/ray:nightly-py36-cu121', 'anyscale/ray:nightly-py36-cu123', 'anyscale/ray:nightly-py36-cu124', 'anyscale/ray:nightly-py36-cu125', 'anyscale/ray:nightly-py36-cu126', 'anyscale/ray:nightly-py36-cu128', 'anyscale/ray:nightly-py37', 'anyscale/ray:nightly-py37-cu117', 'anyscale/ray:nightly-py37-cu118', 'anyscale/ray:nightly-py37-cu121', 'anyscale/ray:nightly-py37-cu123', 'anyscale/ray:nightly-py37-cu124', 'anyscale/ray:nightly-py37-cu125', 'anyscale/ray:nightly-py37-cu126', 'anyscale/ray:nightly-py37-cu128', 'anyscale/ray:nightly-py38', 'anyscale/ray:nightly-py38-cu117', 'anyscale/ray:nightly-py38-cu118', 'anyscale/ray:nightly-py38-cu121', 'anyscale/ray:nightly-py38-cu123', 'anyscale/ray:nightly-py38-cu124', 'anyscale/ray:nightly-py38-cu125', 'anyscale/ray:nightly-py38-cu126', 'anyscale/ray:nightly-py38-cu128', 'anyscale/ray:nightly-py39', 'anyscale/ray:nightly-py39-cu117', 'anyscale/ray:nightly-py39-cu118', 'anyscale/ray:nightly-py39-cu121', 'anyscale/ray:nightly-py39-cu123', 'anyscale/ray:nightly-py39-cu124', 'anyscale/ray:nightly-py39-cu125', 'anyscale/ray:nightly-py39-cu126', 'anyscale/ray:nightly-py39-cu128', 'unknown']

## BaseJobStatus

An enumeration.

Possible Values:
['RUNNING', 'COMPLETED', 'PENDING', 'STOPPED', 'SUCCEEDED', 'FAILED', 'UNKNOWN']

## Build

Model used to create a Build.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**application_template_id** | **str** | ID of the App Config this Build belongs to. | [default to null]
**config_json** | [**AppConfigConfigSchema**](#appconfigconfigschema) | Config JSON used to create this Build. | [optional] [default to null]
**containerfile** | **str** | The containerfile used to build the image. | [optional] [default to null]
**docker_image_name** | **str** | The name of the docker image for this build. | [optional] [default to null]
**registry_login_secret** | **str** | The name or identifier of a secret containing credentials to authenticate to the docker registry hosting the image. | [optional] [default to null]
**ray_version** | **str** | The Ray version to use for this build. | [optional] [default to null]
**id** | **str** | Server assigned unique identifier. | [default to null]
**application_template** | [**AppConfig**](#appconfig) | App Config this Build belongs to. | [default to null]
**revision** | **int** | Auto incrementing version number for this Build | [default to null]
**creator_id** | **str** | ID of the user who created this Build. | [default to null]
**error_message** | **str** | Detailed error message. This will only be populated if the Build operation failed. | [optional] [default to null]
**status** | [**BuildStatus**](#buildstatus) |      Status of the Build.      &#x60;pending&#x60; - Build operation is queued and has not started yet.     &#x60;in_progress&#x60; - Build operation is in progress.     &#x60;succeeded&#x60; - Build operation completed successfully.     &#x60;failed&#x60; - Build operation completed unsuccessfully.     &#x60;pending_cancellation&#x60; - Build operation is marked for cancellation.     &#x60;cancelled&#x60; - Build operation was cancelled before it completed.      | [default to null]
**created_at** | **datetime** | Timestamp of when this Build was created. | [default to null]
**last_modified_at** | **datetime** | Timestamp of when this Build was last updated. | [default to null]
**deleted_at** | **datetime** | Timestamp of when this Build was deleted. | [optional] [default to null]
**is_byod** | **bool** | True if the image URI used in this build was user-specified. | [default to null]
**cloud_id** | **str** | The build cloud associated with this build. If None, the build is a v1 build. | [optional] [default to null]
**digest** | **str** | The digest of the image created by this build. | [optional] [default to null]

## BuildResponse

A response from the API. Contains a field \"result\" which has the contents of the response.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**result** | [**Build**](#build) |  | [default to null]

## BuildStatus

An enumeration.

Possible Values:
['pending', 'in_progress', 'succeeded', 'failed', 'pending_cancellation', 'canceled']

## Cloud

Model used to create a Cloud.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**name** | **str** | Name of this Cloud. | [default to null]
**provider** | [**CloudProviders**](#cloudproviders) | Provider of this Cloud (e.g. AWS). | [default to null]
**compute_stack** | [**ComputeStack**](#computestack) | The compute stack associated with this cloud&#39;s primary cloud resource. | [optional] [default to null]
**region** | **str** | Region this Cloud is operating in. This value needs to be supported by this Cloud&#39;s provider. (e.g. us-west-2) | [default to null]
**credentials** | **str** | Credentials needed to interact with this Cloud. | [default to null]
**config** | [**CloudConfig**](#cloudconfig) | Additional configurable properties of this Cloud. | [optional] [default to null]
**is_k8s** | **bool** | Whether this cloud is managed via Kubernetes. | [optional] [default to false]
**is_aioa** | **bool** | Whether this cloud is an AIOA cloud. | [optional] [default to false]
**availability_zones** | **List[str]** | The availability zones that instances of this cloud are allowed to be launched in. | [optional] [default to null]
**is_bring_your_own_resource** | **bool** | Whether the resources of this cloud are provided by the customer. | [optional] [default to null]
**is_private_cloud** | **bool** | Whether this cloud is a private cloud. | [optional] [default to false]
**cluster_management_stack_version** | [**ClusterManagementStackVersions**](#clustermanagementstackversions) | The cluster management stack version of the cloud. | [optional] [default to null]
**is_private_service_cloud** | **bool** | Whether services created in this cloud should be private. | [optional] [default to null]
**auto_add_user** | **bool** | Whether all users in the organization should be automatically added to this cloud. This field is only relevant for organizations with cloud isolation enabled, because all users in the organization automatically have access to all clouds if cloud isolation is not enabled. | [optional] [default to false]
**external_id** | **str** | The trust policy external ID specified by the user for the cloud control plane role. It must start with the organization ID. | [optional] [default to null]
**id** | **str** | Server assigned unique identifier. | [default to null]
**type** | [**CloudTypes**](#cloudtypes) |  | [default to null]
**creator_id** | **str** | ID of the User who created this Cloud. | [default to null]
**created_at** | **datetime** | Time when this Cloud was created. | [default to null]
**status** | [**CloudStatus**](#cloudstatus) | The status of this cloud. | [optional] [default to null]
**state** | [**CloudState**](#cloudstate) | The state of this cloud. | [optional] [default to null]
**version** | [**CloudVersion**](#cloudversion) | The version of the cloud. | [optional] [default to null]
**is_default** | **bool** | Whether this cloud is the default cloud. | [default to null]
**customer_aggregated_logs_config_id** | **str** | the id of the customer aggregated logs config associated with this cloud. | [default to null]
**additional_instance_types** | [**List[UXInstance]**](#uxinstance) | the list of instance types supported in the UI and through API (SDK/CLI). | [optional] [default to null]
**is_aggregated_logs_enabled** | **bool** | Whether the aggregated logs are enabled for this cloud. | [optional] [default to null]
**system_cluster_config_id** | **str** | the id of the system cluster config associated with this cloud. | [optional] [default to null]

## CloudConfig


Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**max_stopped_instances** | **int** | Maximum number of instances that can be retained for reuse after a Cluster has terminated. This may help Clusters start up faster, but stopped instances will accrue some costs. Defaults to 0, which means no instances will be retained for reuse. A value of -1 means all instances will be retained. | [optional] [default to 0]
**vpc_peering_ip_range** | **str** | VPC IP range for this Cloud. | [optional] [default to null]
**vpc_peering_target_project_id** | **str** | Project ID of the VPC to peer with. | [optional] [default to null]
**vpc_peering_target_vpc_id** | **str** | ID of the VPC to peer with. | [optional] [default to null]

## CloudDeploymentComputeConfig


Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**cloud_deployment** | **str** | The name of the cloud deployment to use for this compute config. If not specified, the primary cloud deployment for the cloud will be used. | [optional] [default to null]
**allowed_azs** | **List[str]** | The availability zones that sessions are allowed to be launched in, e.g. \&quot;us-west-2a\&quot;. If not specified or \&quot;any\&quot; is provided as the option, any AZ may be used. If \&quot;any\&quot; is provided, it must be the only item in the list. | [optional] [default to null]
**head_node_type** | [**ComputeNodeType**](#computenodetype) | Node configuration to use for the head node.  | [default to null]
**worker_node_types** | [**List[WorkerNodeType]**](#workernodetype) | A list of node types to use for worker nodes.  | [optional] [default to null]
**advanced_configurations_json** | [**object**](#) | Advanced configurations for this compute node type to pass to the cloud provider when launching this instance. | [optional] [default to null]
**auto_select_worker_config** | **bool** | If set to true, worker node groups will automatically be selected based on workload. | [optional] [default to false]
**flags** | [**object**](#) | A set of advanced cluster-level flags that can be used to configure a particular workload. | [optional] [default to null]

## CloudListResponse

A list response form the API. Contains a field \"results\" which has the contents of the response.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**results** | [**List[Cloud]**](#cloud) |  | [default to null]
**metadata** | [**ListResponseMetadata**](#listresponsemetadata) |  | [optional] [default to null]

## CloudProviders

An enumeration.

Possible Values:
['AWS', 'GCP', 'CLOUDGATEWAY', 'PCP', 'GENERIC', 'AZURE']

## CloudResponse

A response from the API. Contains a field \"result\" which has the contents of the response.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**result** | [**Cloud**](#cloud) |  | [default to null]

## CloudState

An enumeration.

Possible Values:
['CREATING', 'ACTIVE', 'VERIFICATION_FAILED', 'DELETING', 'DELETED', 'CLAIMED']

## CloudStatus

An enumeration.

Possible Values:
['pending', 'ready']

## CloudType

An enumeration.

Possible Values:
['AWS', 'GCP']

## CloudTypes

An enumeration.

Possible Values:
['PUBLIC', 'INTERNAL']

## CloudVersion

An enumeration.

Possible Values:
['v1', 'v2']

## CloudsQuery

Query object used to search Clouds.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**name** | [**TextQuery**](#textquery) | Filters ComputeTemplates by name. If this field is absent, no filtering is done. | [optional] [default to null]
**paging** | [**PageQuery**](#pagequery) | Pagination info. | [optional] [default to null]

## Cluster

Read model for a Cluster.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**name** | **str** | Name of this Cluster. | [default to null]
**project_id** | **str** | Project that this Cluster belongs to. If none, this Cluster will use the default Project. | [optional] [default to null]
**cluster_environment_build_id** | **str** | Cluster Environment Build that this Cluster is using. | [default to null]
**cluster_compute_id** | **str** | Cluster Compute that this Cluster is using. | [default to null]
**cluster_compute_config** | [**CreateClusterComputeConfig**](#createclustercomputeconfig) | One-off cluster compute that this cluster is using. | [optional] [default to null]
**idle_timeout_minutes** | **int** | Idle timeout (in minutes), after which the Cluster is terminated. Idle time is defined as the time during which a Cluster is not running a user command (through &#39;anyscale exec&#39; or the Web UI), and does not have an attached driver. Time spent running Jupyter commands, or commands run through ssh, is still considered &#39;idle&#39;. | [optional] [default to 120]
**allow_public_internet_traffic** | **bool** | Whether public internet traffic can access Serve endpoints or if an authentication token is required. | [optional] [default to false]
**user_service_access** | [**UserServiceAccessTypes**](#userserviceaccesstypes) | Whether user service can be accessed by public internet traffic. | [optional] [default to null]
**user_service_token** | **str** | User service token that is used to authenticate access to public user services. This must be a valid 32 byte URL safe string and can be generated by calling &#x60;secrets.token_urlsafe(32))&#x60;. This is ignored if the user service has private access. If not specified for a public user service, a token is autogenerated. | [optional] [default to null]
**ha_job_id** | **str** | This is used internally by Anyscale to associate clusters to a job. It is set automatically and should *not* be used directly. | [optional] [default to null]
**id** | **str** | Server assigned unique identifier. | [default to null]
**state** | [**ClusterState**](#clusterstate) | Current state of the Cluster. | [default to null]
**goal_state** | [**ClusterState**](#clusterstate) | State that this Cluster will eventually transition to. This will not be populated if there are no pending transitions. | [optional] [default to null]
**creator_id** | **str** | User who created this Cluster. | [default to null]
**created_at** | **datetime** | Time at which this Cluster was created. | [default to null]
**access_token** | **str** | Access token for web based services (e.g. jupyter, tensorboard, etc). This field will be populated when the web based services are available after the Cluster finishes starting. | [default to null]
**services_urls** | [**ClusterServicesUrls**](#clusterservicesurls) | URLs for additional services running on this Cluster (e.g. Jupyter, Ray Dashboard, etc.). | [default to null]
**head_node_info** | [**ClusterHeadNodeInfo**](#clusterheadnodeinfo) | Detailed information about this Cluster&#39;s head node. This will only be populated for Clusters that have finished starting. | [optional] [default to null]
**ssh_authorized_keys** | **List[str]** | Serialized SSH Public Keys to be placed in the machine&#39;s authorized_keys. | [default to null]
**ssh_private_key** | **str** | SSH Private key that can be used to access the Cluster&#39;s servers. | [default to null]
**ray_version** | **str** | The last known ray version running on this cluster. | [optional] [default to null]
**ray_version_last_updated_at** | **datetime** | The time in which the ray version of this cluster was updated. | [optional] [default to null]
**is_system_cluster** | **bool** | If this cluster corresponds to system workload. | [optional] [default to false]
**system_workload_names** | [**List[SystemWorkloadName]**](#systemworkloadname) | List of system workloads on this cluster. | [default to null]

## ClusterCompute


Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**id** | **str** |  | [default to null]
**name** | **str** |  | [default to null]
**creator_id** | **str** |  | [default to null]
**organization_id** | **str** |  | [default to null]
**project_id** | **str** |  | [optional] [default to null]
**created_at** | **datetime** |  | [default to null]
**last_modified_at** | **datetime** |  | [default to null]
**deleted_at** | **datetime** |  | [optional] [default to null]
**archived_at** | **datetime** |  | [optional] [default to null]
**config** | [**ClusterComputeConfig**](#clustercomputeconfig) |  | [default to null]
**version** | **int** |  | [default to null]
**anonymous** | **bool** |  | [default to null]

## ClusterComputeConfig

Configuration of compute resources to use for launching a Cluster. Used when reading a cluster compute.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**cloud_id** | **str** | The ID of the Anyscale cloud to use for launching Clusters. | [default to null]
**maximum_uptime_minutes** | **int** | If set to a positive number, Anyscale will terminate the cluster this many minutes after cluster start. | [optional] [default to null]
**deployment_configs** | [**List[CloudDeploymentComputeConfig]**](#clouddeploymentcomputeconfig) | A list of cloud deployment-specific configs to use. | [optional] [default to null]
**max_workers** | **int** | DEPRECATED. This attribute will be ignored - please use the \&quot;max_resources\&quot; flag to configure resource limits. | [optional] [default to null]
**region** | **str** | The region to launch Clusters in, e.g. \&quot;us-west-2\&quot;. | [optional] [default to null]
**allowed_azs** | **List[str]** | The availability zones that sessions are allowed to be launched in, e.g. \&quot;us-west-2a\&quot;. If not specified or \&quot;any\&quot; is provided as the option, any AZ may be used. If \&quot;any\&quot; is provided, it must be the only item in the list. | [optional] [default to null]
**head_node_type** | [**ComputeNodeType**](#computenodetype) | Node configuration to use for the head node.  | [default to null]
**worker_node_types** | [**List[WorkerNodeType]**](#workernodetype) | A list of node types to use for worker nodes.  | [optional] [default to null]
**aws_advanced_configurations_json** | [**object**](#) | [DEPRECATED: use advanced_configurations_json instead] The advanced configuration json that we pass directly AWS APIs when launching an instance. We may do some validation on this json and reject the json if it is using a configuration that Anyscale does not support. | [optional] [default to null]
**gcp_advanced_configurations_json** | [**object**](#) | [DEPRECATED: use advanced_configurations_json instead] The advanced configuration json that we pass directly GCP APIs when launching an instance. We may do some validation on this json and reject the json if it is using a configuration that Anyscale does not support. | [optional] [default to null]
**advanced_configurations_json** | [**object**](#) | Advanced configurations for this compute node type to pass to the cloud provider when launching this instance. | [optional] [default to null]
**auto_select_worker_config** | **bool** | If set to true, worker node groups will automatically be selected based on workload. | [optional] [default to false]
**flags** | [**object**](#) | A set of advanced cluster-level flags that can be used to configure a particular workload. | [optional] [default to null]
**idle_termination_minutes** | **int** | If set to a positive number, Anyscale will terminate the cluster this many minutes after the cluster is idle. Idle time is defined as the time during which a Cluster is not running a user command or a Ray driver. Time spent running commands on Jupyter or ssh is still considered &#39;idle&#39;. To disable, set this field to 0. | [optional] [default to null]

## ClusterComputesQuery


Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**project_id** | **str** | Filters Cluster Computes by project. If this field is absent, no filtering is done. | [optional] [default to null]
**creator_id** | **str** | Filters Cluster Computes by creator. If this field is absent, no filtering is done. | [optional] [default to null]
**name** | [**TextQuery**](#textquery) | Filters Cluster Computes by name. If this field is absent, no filtering is done. | [optional] [default to null]
**include_anonymous** | **bool** | Whether to include anonymous Cluster Computes in the search. | [optional] [default to false]
**paging** | [**PageQuery**](#pagequery) | Pagination information. | [optional] [default to null]
**cloud_id** | **str** | Filters Compute Computes by cloud. If this field is absent, no filtering is done. | [optional] [default to null]
**version** | **int** | Filters Cluster Computes by version. Versions are positive integers. Setting this field to -1 will return only the latest version of each Cluster Compute. Setting this field to -2 will not filter by version. For example, this can be used to fetch all versions of a Cluster Compute. Deprecated behavior: Setting version to None is equivalent to setting version to &#39;-1&#39;. | [optional] [default to null]

## ClusterEnvironment


Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**id** | **str** | Server assigned unique identifier. | [default to null]
**name** | **str** | Name of the Cluster Environment. | [default to null]
**project_id** | **str** | ID of the Project this Cluster Environment is for. | [optional] [default to null]
**organization_id** | **str** | ID of the Organization this Cluster Environment was created in. | [default to null]
**creator_id** | **str** | ID of the User that created this record. | [default to null]
**created_at** | **datetime** | Timestamp of when this record was created. | [default to null]
**last_modified_at** | **datetime** | Timestamp of when this record was last updated. | [default to null]
**deleted_at** | **datetime** | Timestamp of when this record was deleted. | [optional] [default to null]
**anonymous** | **bool** | True if this is an anonymous Cluster Environment. | [optional] [default to false]
**is_default** | **bool** | True if this Cluster Environment is created and managed by anyscale | [optional] [default to false]

## ClusterEnvironmentBuild

Usable Cluster Environment Build to start a Cluster.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**cluster_environment_id** | **str** | ID of the Cluster Environment this Build belongs to. | [default to null]
**config_json** | [**AppConfigConfigSchema**](#appconfigconfigschema) | Config JSON used to create this Cluster Environment Build. | [optional] [default to null]
**containerfile** | **str** | The containerfile used to build the image. | [optional] [default to null]
**docker_image_name** | **str** | The name of the docker image for this Build. | [optional] [default to null]
**registry_login_secret** | **str** | The name or identifier of a secret containing credentials to authenticate to the docker registry hosting the image. | [optional] [default to null]
**ray_version** | **str** | The Ray version to use for this build. | [optional] [default to null]
**id** | **str** | Server assigned unique identifier. | [default to null]
**revision** | **int** | Auto incrementing version number for this Build | [default to null]
**creator_id** | **str** | ID of the user who created this Build. | [default to null]
**error_message** | **str** | Detailed error message. This will only be populated if the Build operation failed. | [optional] [default to null]
**status** | [**ClusterEnvironmentBuildStatus**](#clusterenvironmentbuildstatus) |      Status of the Build.      &#x60;pending&#x60; - Build operation is queued and has not started yet.     &#x60;in_progress&#x60; - Build operation is in progress.     &#x60;succeeded&#x60; - Build operation completed successfully.     &#x60;failed&#x60; - Build operation completed unsuccessfully.     &#x60;pending_cancellation&#x60; - Build operation is marked for cancellation.     &#x60;cancelled&#x60; - Build operation was cancelled before it completed.      | [default to null]
**created_at** | **datetime** | Timestamp of when this Build was created. | [default to null]
**last_modified_at** | **datetime** | Timestamp of when this Build was last updated. | [default to null]
**deleted_at** | **datetime** | Timestamp of when this Build was deleted. | [optional] [default to null]
**is_byod** | **bool** | True if the image URI used in this build was user-specified. | [default to null]
**cloud_id** | **str** | The build cloud associated with this build. If None, the build is a v1 build. | [optional] [default to null]
**digest** | **str** | The digest of the image for this Build. | [optional] [default to null]

## ClusterEnvironmentBuildOperation

Describes a long running operation that will eventually complete. Consider this an abstract class. Specific kinds of operations should subclass this.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**id** | **str** | ID of this operation. | [default to null]
**completed** | **bool** | Boolean indicating if this operation is completed. | [default to null]
**progress** | [**OperationProgress**](#operationprogress) | Details about the progress of this operation at the time of the request.             This will be absent for completed operations. | [optional] [default to null]
**result** | [**OperationResult**](#operationresult) | The result of this operation after it has completed.             This is always provided when the operation is complete. | [optional] [default to null]
**cluster_environment_build_id** | **str** | ID of the Cluster Environment Build this operation is for. | [default to null]

## ClusterEnvironmentBuildStatus

An enumeration.

Possible Values:
['pending', 'in_progress', 'succeeded', 'failed', 'pending_cancellation', 'canceled']

## ClusterEnvironmentsQuery


Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**project_id** | **str** | Filters Cluster Environments by project id. If absent, no filtering is done. | [optional] [default to null]
**creator_id** | **str** | Filters Cluster Environments by creator id. If absent, no filtering is done. | [optional] [default to null]
**name** | [**TextQuery**](#textquery) | Filters Cluster Environments by name. Currently only contains is supported.If absent, no filtering is done. | [optional] [default to null]
**image_name** | [**TextQuery**](#textquery) | Filters Cluster Environments by image name. Image name is a virtual concept. It starts with &#39;anyscale/image&#39; (for customer-built images) or &#39;anyscale/ray&#39; (default images).Currently only contains is supported. If absent, no filtering is done. | [optional] [default to null]
**paging** | [**PageQuery**](#pagequery) | Pagination information. | [optional] [default to null]
**include_archived** | **bool** | Whether to include archived Cluster Environments in the results. | [optional] [default to false]
**include_anonymous** | **bool** | Whether to include anonymous Cluster Environments in the results. | [optional] [default to false]

## ClusterHeadNodeInfo

Details about the head node of a running Cluster.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**url** | **str** | URL for the head node of this Cluster. | [default to null]
**ip_address** | **str** | IP address for the head node of this Cluster. | [default to null]

## ClusterListResponse

A list response form the API. Contains a field \"results\" which has the contents of the response.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**results** | [**List[Cluster]**](#cluster) |  | [default to null]
**metadata** | [**ListResponseMetadata**](#listresponsemetadata) |  | [optional] [default to null]

## ClusterManagementStackVersions

An enumeration.

Possible Values:
['v1', 'v2']

## ClusterOperation

Describes a long running Cluster operation that will eventually complete.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**id** | **str** | ID of this operation. | [default to null]
**completed** | **bool** | Boolean indicating if this operation is completed. | [default to null]
**progress** | [**OperationProgress**](#operationprogress) | Details about the progress of this operation at the time of the request.             This will be absent for completed operations. | [optional] [default to null]
**result** | [**OperationResult**](#operationresult) | The result of this operation after it has completed.             This is always provided when the operation is complete. | [optional] [default to null]
**cluster_id** | **str** | ID of the Cluster that is being updated. | [default to null]
**cluster_operation_type** | [**ClusterOperationType**](#clusteroperationtype) | The variety of operation being performed:             start sets the Cluster&#39;s goal state to Running,             terminate sets the Cluster&#39;s goal state to Terminated | [default to null]

## ClusterOperationType

Type of Cluster operation.

Possible Values:
['start', 'terminate', 'unknown']

## ClusterResponse

A response from the API. Contains a field \"result\" which has the contents of the response.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**result** | [**Cluster**](#cluster) |  | [default to null]

## ClusterServicesUrls

URLs for additional services running in the Cluster. (ex/ Jupyter, Ray Dashboard).  This fields can only be populated after the Cluster has finished starting. An absent field indicates the service is not available.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**webterminal_auth_url** | **str** | URL to authenticate with the webterminal | [optional] [default to null]
**metrics_dashboard_url** | **str** | URL for Grafana (metrics) dashboard. | [optional] [default to null]
**data_metrics_dashboard_url** | **str** | URL for the data Grafana dashboard. | [optional] [default to null]
**train_metrics_dashboard_url** | **str** | URL for the train Grafana dashboard. | [optional] [default to null]
**serve_metrics_dashboard_url** | **str** | URL for the serve Grafana dashboard. | [optional] [default to null]
**serve_deployment_metrics_dashboard_url** | **str** | URL for the serve deployment Grafana dashboard. | [optional] [default to null]
**serve_llm_metrics_dashboard_url** | **str** | URL for the serve LLM Grafana dashboard. | [optional] [default to null]
**persistent_metrics_url** | **str** | URL for the persistent Grafana (metrics) dashboard in the non-running cluster state. | [optional] [default to null]
**connect_url** | **str** | URL for Anyscale connect. | [optional] [default to null]
**jupyter_notebook_url** | **str** | URL for Jupyter Lab. | [optional] [default to null]
**ray_dashboard_url** | **str** | URL for Ray dashboard. | [optional] [default to null]
**service_proxy_url** | **str** | URL for web services proxy (e.g. jupyter, tensorboard, etc). | [optional] [default to null]
**user_service_url** | **str** | URL to access user services (e.g. Ray Serve) | [optional] [default to null]

## ClusterState

Possible States for a Cluster.

Possible Values:
['Terminated', 'StartingUp', 'StartupErrored', 'Running', 'Updating', 'UpdatingErrored', 'Terminating', 'AwaitingStartup', 'TerminatingErrored', 'Unknown']

## ClusterStatus

An enumeration.

Possible Values:
['STARTING', 'RUNNING', 'RECOVERING', 'RESTARTING', 'TERMINATING', 'TERMINATED']

## ClusterStatusDetails

ClusterStatusDetails is a more granular status than ClusterStatus.

Possible Values:
['LAUNCHING_NODES', 'CONFIGURING_HEAD_NODE', 'UPDATING_CONTAINERS']

## ClustercomputeListResponse

A list response form the API. Contains a field \"results\" which has the contents of the response.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**results** | [**List[ClusterCompute]**](#clustercompute) |  | [default to null]
**metadata** | [**ListResponseMetadata**](#listresponsemetadata) |  | [optional] [default to null]

## ClustercomputeResponse

A response from the API. Contains a field \"result\" which has the contents of the response.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**result** | [**ClusterCompute**](#clustercompute) |  | [default to null]

## ClusterenvironmentListResponse

A list response form the API. Contains a field \"results\" which has the contents of the response.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**results** | [**List[ClusterEnvironment]**](#clusterenvironment) |  | [default to null]
**metadata** | [**ListResponseMetadata**](#listresponsemetadata) |  | [optional] [default to null]

## ClusterenvironmentResponse

A response from the API. Contains a field \"result\" which has the contents of the response.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**result** | [**ClusterEnvironment**](#clusterenvironment) |  | [default to null]

## ClusterenvironmentbuildListResponse

A list response form the API. Contains a field \"results\" which has the contents of the response.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**results** | [**List[ClusterEnvironmentBuild]**](#clusterenvironmentbuild) |  | [default to null]
**metadata** | [**ListResponseMetadata**](#listresponsemetadata) |  | [optional] [default to null]

## ClusterenvironmentbuildResponse

A response from the API. Contains a field \"result\" which has the contents of the response.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**result** | [**ClusterEnvironmentBuild**](#clusterenvironmentbuild) |  | [default to null]

## ClusterenvironmentbuildoperationResponse

A response from the API. Contains a field \"result\" which has the contents of the response.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**result** | [**ClusterEnvironmentBuildOperation**](#clusterenvironmentbuildoperation) |  | [default to null]

## ClusteroperationResponse

A response from the API. Contains a field \"result\" which has the contents of the response.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**result** | [**ClusterOperation**](#clusteroperation) |  | [default to null]

## ClustersQuery

Query model used to filter Clusters.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**project_id** | **str** | Filters Clusters belonging to a Project. If this field is absent, no filtering is done. | [optional] [default to null]
**name** | [**TextQuery**](#textquery) | Filters Clusters by name. If this field is absent, no filtering is done. | [optional] [default to null]
**paging** | [**PageQuery**](#pagequery) | Pagination information. | [optional] [default to null]
**state_filter** | [**List[ClusterState]**](#clusterstate) | Filter Sessions by Session State. If this field is an empty set, no filtering is done. | [optional] [default to []]
**archive_status** | [**ArchiveStatus**](#archivestatus) | The archive status to filter by. Defaults to unarchived. | [optional] [default to null]

## ComputeNodeType


Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**name** | **str** | An arbitrary name for this node type, which will be registered with OSS available_node_types.  | [default to null]
**instance_type** | **str** | The cloud provider instance type to use for this node. | [default to null]
**resources** | [**Resources**](#resources) | Declaration of node resources for Autoscaler. | [optional] [default to null]
**aws_advanced_configurations_json** | [**object**](#) | The advanced configuration json that we pass directly AWS APIs when launching an instance. We may do some validation on this json and reject the json if it is using a configuration that Anyscale does not support. | [optional] [default to null]
**gcp_advanced_configurations_json** | [**object**](#) | The advanced configuration json that we pass directly GCP APIs when launching an instance. We may do some validation on this json and reject the json if it is using a configuration that Anyscale does not support. | [optional] [default to null]
**advanced_configurations_json** | [**object**](#) | Advanced configurations for this compute node type to pass to the cloud provider when launching this instance. | [optional] [default to null]
**flags** | [**object**](#) | A set of advanced node-level flags that can be used to configure a particular workload. | [optional] [default to null]

## ComputeStack

An enumeration.

Possible Values:
['VM', 'K8S']

## ComputeTemplate

DEPRECATED: Please use ClusterCompute instead.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**id** | **str** |  | [default to null]
**name** | **str** |  | [default to null]
**creator_id** | **str** |  | [default to null]
**organization_id** | **str** |  | [default to null]
**project_id** | **str** |  | [optional] [default to null]
**created_at** | **datetime** |  | [default to null]
**last_modified_at** | **datetime** |  | [default to null]
**deleted_at** | **datetime** |  | [optional] [default to null]
**archived_at** | **datetime** |  | [optional] [default to null]
**config** | [**ComputeTemplateConfig**](#computetemplateconfig) |  | [default to null]
**version** | **int** |  | [default to null]
**anonymous** | **bool** |  | [default to null]

## ComputeTemplateConfig

DEPRECATED: Please use ClusterCompute and the corresponding ClusterComputeConfig instead. Configuration of compute resources to use for launching a session. Used when reading a compute template.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**cloud_id** | **str** | The ID of the Anyscale cloud to use for launching sessions. | [default to null]
**maximum_uptime_minutes** | **int** | If set to a positive number, Anyscale will terminate the cluster this many minutes after cluster start. | [optional] [default to null]
**deployment_configs** | [**List[CloudDeploymentComputeConfig]**](#clouddeploymentcomputeconfig) | A list of cloud deployment-specific configs to use. | [optional] [default to null]
**max_workers** | **int** | DEPRECATED. This attribute will be ignored - please use the \&quot;max_resources\&quot; flag to configure resource limits. | [optional] [default to null]
**region** | **str** | The region to launch sessions in, e.g. \&quot;us-west-2\&quot;. | [optional] [default to null]
**allowed_azs** | **List[str]** | The availability zones that sessions are allowed to be launched in, e.g. \&quot;us-west-2a\&quot;. If not specified or \&quot;any\&quot; is provided as the option, any AZ may be used. If \&quot;any\&quot; is provided, it must be the only item in the list. | [optional] [default to null]
**head_node_type** | [**ComputeNodeType**](#computenodetype) | Node configuration to use for the head node.  | [default to null]
**worker_node_types** | [**List[WorkerNodeType]**](#workernodetype) | A list of node types to use for worker nodes.  | [optional] [default to null]
**aws_advanced_configurations_json** | [**object**](#) | The advanced configuration json that we pass directly AWS APIs when launching an instance. We may do some validation on this json and reject the json if it is using a configuration that Anyscale does not support. | [optional] [default to null]
**gcp_advanced_configurations_json** | [**object**](#) | The advanced configuration json that we pass directly GCP APIs when launching an instance. We may do some validation on this json and reject the json if it is using a configuration that Anyscale does not support. | [optional] [default to null]
**advanced_configurations_json** | [**object**](#) | Advanced configurations for this compute node type to pass to the cloud provider when launching this instance. | [optional] [default to null]
**auto_select_worker_config** | **bool** | If set to true, worker node groups will automatically be selected based on workload. | [optional] [default to false]
**flags** | [**object**](#) | A set of advanced cluster-level flags that can be used to configure a particular workload. | [optional] [default to null]
**idle_termination_minutes** | **int** | If set to a positive number, Anyscale will terminate the cluster this many minutes after the cluster is idle. Idle time is defined as the time during which a Cluster is not running a user command or a Ray driver. Time spent running commands on Jupyter or ssh is still considered &#39;idle&#39;. To disable, set this field to 0. | [optional] [default to null]

## ComputetemplateResponse

A response from the API. Contains a field \"result\" which has the contents of the response.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**result** | [**ComputeTemplate**](#computetemplate) |  | [default to null]

## ComputetemplateconfigResponse

A response from the API. Contains a field \"result\" which has the contents of the response.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**result** | [**ComputeTemplateConfig**](#computetemplateconfig) |  | [default to null]

## CreateAppConfigConfigurationSchema


Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**base_image** | [**SUPPORTEDBASEIMAGESENUM**](#supportedbaseimagesenum) | The base image to use to create a new app config. It needs to be one of the images that we currently support (SupportedBaseImages). | [default to null]
**env_vars** | [**object**](#) | Environment varibles in the docker image that&#39;ll be used at runtime. | [optional] [default to null]
**debian_packages** | **List[str]** | List of debian packages that&#39;ll be included in the image. | [optional] [default to null]
**python** | [**PythonModules**](#pythonmodules) | Python related dependencies. | [optional] [default to null]
**post_build_cmds** | **List[str]** | List of post build commands that&#39;ll be included in the image. For multi-line commands, please make sure those are provided as a single string and not split across multiple strings in the list. | [optional] [default to null]

## CreateBYODAppConfigConfigurationSchema


Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**docker_image** | **str** | The custom docker image to use to create a new app config. | [default to null]
**ray_version** | **str** |  | [default to null]
**env_vars** | [**object**](#) | Environment variables in the docker image that&#39;ll be used at runtime. | [optional] [default to null]
**registry_login_secret** | **str** | The name or identifier of a secret containing credentials to authenticate to the docker registry hosting the image. | [optional] [default to null]

## CreateBYODClusterEnvironment

Model used to create a BYOD Cluster Environment.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**name** | **str** | Name of the Cluster Environment. | [default to null]
**config_json** | [**CreateBYODClusterEnvironmentConfigurationSchema**](#createbyodclusterenvironmentconfigurationschema) | Config JSON to use to create a new BYOD Cluster Environment. | [default to null]
**anonymous** | **bool** | True if this is an anonymous Cluster Environment. | [optional] [default to false]

## CreateBYODClusterEnvironmentBuild

Model used to create a BYOD Cluster Environment Build.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**cluster_environment_id** | **str** | ID of the Cluster Environment this Build belongs to. | [default to null]
**config_json** | [**CreateBYODAppConfigConfigurationSchema**](#createbyodappconfigconfigurationschema) | Config JSON to use to create a new BYOD Build. | [default to null]

## CreateBYODClusterEnvironmentConfigurationSchema


Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**docker_image** | **str** | The custom container base image used in the Cluster Environment. | [default to null]
**ray_version** | **str** | The version of Ray used in the customer docker image. | [default to null]
**env_vars** | [**object**](#) | Environment variables in the docker image that will be used at runtime. | [optional] [default to null]
**registry_login_secret** | **str** | The name or identifier of a secret containing credentials to authenticate to the docker registry hosting the image. | [optional] [default to null]

## CreateCluster

Model used to create a new Cluster.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**name** | **str** | Name of this Cluster. | [default to null]
**project_id** | **str** | Project that this Cluster belongs to. If none, this Cluster will use the default Project. | [optional] [default to null]
**cluster_environment_build_id** | **str** | Cluster Environment Build that this Cluster is using. | [default to null]
**cluster_compute_id** | **str** | Cluster Compute that this Cluster is using. | [optional] [default to null]
**cluster_compute_config** | [**CreateClusterComputeConfig**](#createclustercomputeconfig) | One-off cluster compute that this cluster is using. | [optional] [default to null]
**idle_timeout_minutes** | **int** | Idle timeout (in minutes), after which the Cluster is terminated. Idle time is defined as the time during which a Cluster is not running a user command (through &#39;anyscale exec&#39; or the Web UI), and does not have an attached driver. Time spent running Jupyter commands, or commands run through ssh, is still considered &#39;idle&#39;. | [optional] [default to null]
**allow_public_internet_traffic** | **bool** | Whether public internet traffic can access Serve endpoints or if an authentication token is required. | [optional] [default to false]
**user_service_access** | [**UserServiceAccessTypes**](#userserviceaccesstypes) | Whether user service can be accessed by public internet traffic. | [optional] [default to null]
**user_service_token** | **str** | User service token that is used to authenticate access to public user services. This must be a valid 32 byte URL safe string and can be generated by calling &#x60;secrets.token_urlsafe(32))&#x60;. This is ignored if the user service has private access. If not specified for a public user service, a token is autogenerated. | [optional] [default to null]
**ha_job_id** | **str** | This is used internally by Anyscale to associate clusters to a job. It is set automatically and should *not* be used directly. | [optional] [default to null]

## CreateClusterCompute


Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**name** | **str** |  | [optional] [default to null]
**project_id** | **str** |  | [optional] [default to null]
**config** | [**CreateClusterComputeConfig**](#createclustercomputeconfig) |  | [default to null]
**anonymous** | **bool** | An anonymous Cluster Compute does not show up in the list of cluster configs. They can still have a name so they can be easily identified. | [optional] [default to false]
**new_version** | **bool** | If a Cluster Compute with the same name already exists, create this config as a new version. | [optional] [default to false]

## CreateClusterComputeConfig

Configuration of compute resources to use for launching a Cluster. Used when creating a cluster compute.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**cloud_id** | **str** | The ID of the Anyscale cloud to use for launching Clusters. | [default to null]
**maximum_uptime_minutes** | **int** | If set to a positive number, Anyscale will terminate the cluster this many minutes after cluster start. | [optional] [default to null]
**deployment_configs** | [**List[CloudDeploymentComputeConfig]**](#clouddeploymentcomputeconfig) | A list of cloud deployment-specific configs to use. | [optional] [default to null]
**max_workers** | **int** | DEPRECATED. This attribute will be ignored - please use the \&quot;max_resources\&quot; flag to configure resource limits. | [optional] [default to null]
**region** | **str** | Deprecated! When creating a cluster compute, a region does not have to be provided. Instead we will use the value from the cloud. | [optional] [default to USE_CLOUD]
**allowed_azs** | **List[str]** | The availability zones that sessions are allowed to be launched in, e.g. \&quot;us-west-2a\&quot;. If not specified or \&quot;any\&quot; is provided as the option, any AZ may be used. If \&quot;any\&quot; is provided, it must be the only item in the list. | [optional] [default to null]
**head_node_type** | [**ComputeNodeType**](#computenodetype) | Node configuration to use for the head node.  | [default to null]
**worker_node_types** | [**List[WorkerNodeType]**](#workernodetype) | A list of node types to use for worker nodes.  | [optional] [default to null]
**aws_advanced_configurations_json** | [**object**](#) | [DEPRECATED: use advanced_configurations_json instead] The advanced configuration json that we pass directly AWS APIs when launching an instance. We may do some validation on this json and reject the json if it is using a configuration that Anyscale does not support. | [optional] [default to null]
**gcp_advanced_configurations_json** | [**object**](#) | [DEPRECATED: use advanced_configurations_json instead] The advanced configuration json that we pass directly GCP APIs when launching an instance. We may do some validation on this json and reject the json if it is using a configuration that Anyscale does not support. | [optional] [default to null]
**advanced_configurations_json** | [**object**](#) | Advanced configurations for this compute node type to pass to the cloud provider when launching this instance. | [optional] [default to null]
**auto_select_worker_config** | **bool** | If set to true, worker node groups will automatically be selected based on workload. | [optional] [default to false]
**flags** | [**object**](#) | A set of advanced cluster-level flags that can be used to configure a particular workload. | [optional] [default to null]
**idle_termination_minutes** | **int** | If set to a positive number, Anyscale will terminate the cluster this many minutes after the cluster is idle. Idle time is defined as the time during which a Cluster is not running a user command or a Ray driver. Time spent running commands on Jupyter or ssh is still considered &#39;idle&#39;. To disable, set this field to 0. | [optional] [default to 120]

## CreateClusterEnvironment

Model used to create an Cluster Environment.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**name** | **str** | Name of the Cluster Environment. | [default to null]
**project_id** | **str** | ID of the Project this Cluster Environment is for. | [optional] [default to null]
**config_json** | [**CreateClusterEnvironmentConfigurationSchema**](#createclusterenvironmentconfigurationschema) | Config JSON to use to create a new Cluster Environment. | [optional] [default to null]
**containerfile** | **str** | Containerfile to use to create a new Cluster Environment. | [optional] [default to null]
**anonymous** | **bool** | True if this is an anonymous Cluster Environment. | [optional] [default to false]

## CreateClusterEnvironmentBuild

Model used to create a Cluster Environment Build.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**cluster_environment_id** | **str** | ID of the Cluster Environment this Build belongs to. | [default to null]
**config_json** | [**CreateAppConfigConfigurationSchema**](#createappconfigconfigurationschema) | Config JSON to use to create a new Build. | [optional] [default to null]
**containerfile** | **str** | The containerfile used to build the image. | [optional] [default to null]
**docker_image_name** | **str** | The name of the docker image for this Build. | [optional] [default to null]
**registry_login_secret** | **str** | The name or identifier of a secret containing credentials to authenticate to the docker registry hosting the image. | [optional] [default to null]
**ray_version** | **str** | The Ray version to use for this build. | [optional] [default to null]

## CreateClusterEnvironmentConfigurationSchema


Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**base_image** | [**SUPPORTEDBASEIMAGESENUM**](#supportedbaseimagesenum) | The base image to use to create a new Cluster Environment. It needs to be one of the images that we currently support (SupportedBaseImages). | [default to null]
**env_vars** | [**object**](#) | Environment varibles in the docker image that&#39;ll be used at runtime. | [optional] [default to null]
**debian_packages** | **List[str]** | List of debian packages that&#39;ll be included in the image. | [optional] [default to null]
**python** | [**PythonModules**](#pythonmodules) | Python related dependencies. | [optional] [default to null]
**post_build_cmds** | **List[str]** | List of post build commands that&#39;ll be included in the image. | [optional] [default to null]

## CreateJobQueueConfig

Specifies configuration of the job being added to a Job Queue

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**priority** | **int** | Job&#39;s relative priority (only relevant for Job Queues of type PRIORITY). Valid values range from 0 (highest) to +inf (lowest). Default value is None | [optional] [default to null]
**target_job_queue_id** | **str** | Identifier of the existing Job Queue this job should be added to. Note, only one of &#x60;target_job_queue_id&#x60;, &#x60;target_job_queue_name&#x60; or &#x60;job_queue_spec&#x60; could be provided | [optional] [default to null]
**target_job_queue_name** | **str** | Existing Job Queue user-provided name (identifier), this job should be added to. Note, only one of &#x60;target_job_queue_id&#x60;, &#x60;target_job_queue_name&#x60; or &#x60;job_queue_spec&#x60; could be provided | [optional] [default to null]
**job_queue_spec** | [**JobQueueSpec**](#jobqueuespec) | Spec of the Job Queue definition that should be created and associated with this job. Note, only one of &#x60;target_job_queue_id&#x60;, &#x60;target_job_queue_name&#x60; or &#x60;job_queue_spec&#x60; could be provided | [optional] [default to null]

## CreateProductionJob


Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**name** | **str** | Name of the job | [default to null]
**description** | **str** | Description of the job | [optional] [default to null]
**project_id** | **str** | Id of the project this job will start clusters in | [optional] [default to null]
**config** | [**CreateProductionJobConfig**](#createproductionjobconfig) |  | [default to null]
**job_queue_config** | [**CreateJobQueueConfig**](#createjobqueueconfig) | Configuration specifying semantic of the execution using job queues | [optional] [default to null]

## CreateProductionJobConfig


Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**entrypoint** | **str** | A script that will be run to start your job.This command will be run in the root directory of the specified runtime env. Eg. &#39;python script.py&#39; | [optional] [default to ]
**ray_serve_config** | **object** | The Ray Serve config to use for this Production service. This config defines your Ray Serve application, and will be passed directly to Ray Serve. You can learn more about Ray Serve config files here: https://docs.ray.io/en/latest/serve/production-guide/config.html | [optional] [default to null]
**runtime_env** | [**RayRuntimeEnvConfig**](#rayruntimeenvconfig) | A ray runtime env json. Your entrypoint will be run in the environment specified by this runtime env. | [optional] [default to null]
**build_id** | **str** | The id of the cluster env build. This id will determine the docker image your job is run on. | [default to null]
**compute_config_id** | **str** | The id of the compute configuration that you want to use. This id will specify the resources required for your job | [optional] [default to null]
**compute_config** | [**CreateClusterComputeConfig**](#createclustercomputeconfig) | One-off compute that the cluster will use. | [optional] [default to null]
**max_retries** | **int** | The number of retries this job will attempt on failure. Set to None to set infinite retries | [optional] [default to 5]
**timeout_s** | **int** | The timeout in seconds for each job run. Set to None for no limit to be set | [optional] [default to null]
**runtime_env_config** | [**RayRuntimeEnvConfig**](#rayruntimeenvconfig) | DEPRECATED: Use runtime_env | [optional] [default to null]

## CreateProject

Model used to create a Project.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**name** | **str** | Name of the Project to be created. | [default to null]
**cluster_config** | **str** | Cluster config associated with the Project. This can later be used to start a Session. Default will be used if not provided. | [optional] [default to null]
**description** | **str** | Description of Project. | [optional] [default to null]
**parent_cloud_id** | **str** | Cloud that all resources in this project should be scoped to. | [optional] [default to null]

## CreateSSOConfig

Model used to create an SSOConfig. Must contain at least one of idp_metadata_url or static_config.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**idp_metadata_url** | **str** | Identity provider (IdP) metadata url. If given along with the other static identity provider fields, Anyscale will first attempt metadata exchange to get IdP attributes. If Anyscale can&#39;t reach the metadata endpoint or if the metadata url isn&#39;t given, Anyscale will use static_idp_config as a backup. Either idp_metadata_url or static_idp_config is required. | [optional] [default to null]
**static_idp_config** | [**StaticSSOConfig**](#staticssoconfig) | Static identity provider configuration. | [optional] [default to null]

## CreateSchedule


Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**name** | **str** | Name of the job | [default to null]
**description** | **str** | Description of the job | [optional] [default to null]
**project_id** | **str** | Id of the project this job will start clusters in | [optional] [default to null]
**config** | [**CreateProductionJobConfig**](#createproductionjobconfig) |  | [default to null]
**job_queue_config** | [**CreateJobQueueConfig**](#createjobqueueconfig) | Configuration specifying semantic of the execution using job queues | [optional] [default to null]
**schedule** | [**ScheduleConfig**](#scheduleconfig) | The configuration for this schedule | [default to null]

## GrpcProtocolConfig


Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**enabled** | **bool** | Flag to enable the protocol in alb | [optional] [default to false]
**port** | **int** | The port this protocol listens on. | [optional] [default to 9000]
**service_names** | **List[str]** | List of service names used to create routing | [optional] [default to []]

## HTTPValidationError


Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**detail** | [**List[ValidationError]**](#validationerror) |  | [optional] [default to null]

## HaJobGoalStates

An enumeration.

Possible Values:
['SCHEDULED', 'RUNNING', 'TERMINATED', 'SUCCESS']

## HaJobStates

An enumeration.

Possible Values:
['PENDING', 'AWAITING_CLUSTER_START', 'UPDATING', 'RUNNING', 'SUCCESS', 'ERRORED', 'TERMINATED', 'CLEANING_UP', 'BROKEN', 'OUT_OF_RETRIES', 'RESTARTING']

## HttpProtocolConfig


Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**enabled** | **bool** | Flag to enable the protocol in alb | [optional] [default to true]
**port** | **int** | The port this protocol listens on. | [optional] [default to 8000]

## IdleTerminationStatus

An enumeration.

Possible Values:
['ACTIVE_RAY', 'ACTIVE_COMMAND', 'ACTIVE_WORKSPACE', 'IDLE', 'ERROR', 'DISABLED']

## Job


Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**id** | **str** | Server assigned unique identifier. | [default to null]
**ray_session_name** | **str** | Name of the Session provided from Ray | [default to null]
**ray_job_id** | **str** | ID of the Job provided from Ray | [default to null]
**name** | **str** | Name of this Job. | [optional] [default to null]
**status** | [**JobStatus**](#jobstatus) | Status of this Job&#39;s execution. | [default to null]
**created_at** | **datetime** | Time at which this Job was created. | [default to null]
**finished_at** | **datetime** | Time at which this Job finished. If absent, this Job is still running. | [optional] [default to null]
**ray_job_submission_id** | **str** | ID of the submitted Ray Job that this Job corresponds to. | [optional] [default to null]
**cluster_id** | **str** | ID of the Anyscale Cluster this Job is on. | [default to null]
**namespace_id** | **str** | ID of the Anyscale Namespace this Job is using. | [optional] [default to DEPRECATED_NAMESPACE_ID]
**runtime_environment_id** | **str** | ID of the Anyscale Runtime Environment this Job is using. | [default to null]
**project_id** | **str** | ID of the Project this Job belongs to. | [optional] [default to null]
**creator_id** | **str** | ID of the user who created this Job. | [default to null]

## JobListResponse

A list response form the API. Contains a field \"results\" which has the contents of the response.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**results** | [**List[Job]**](#job) |  | [default to null]
**metadata** | [**ListResponseMetadata**](#listresponsemetadata) |  | [optional] [default to null]

## JobQueueConfig

Captures job's configuration in the context of its scheduling & execution via Job Queues

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**priority** | **int** | Job&#39;s relative priority (only relevant for Job Queues of type PRIORITY). Valid values range from 0 (highest) to +inf (lowest). Default value is None | [optional] [default to null]

## JobQueueExecutionMode

An enumeration.

Possible Values:
['FIFO', 'LIFO', 'PRIORITY']

## JobQueueSpec

Specifies definition of the Job Queue to be created

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**job_queue_name** | **str** | Optional user-provided identifier of the queue that could be subsequently used to reference the queue when submitting jobs. Note that name has to be unique within the project. | [optional] [default to null]
**execution_mode** | [**JobQueueExecutionMode**](#jobqueueexecutionmode) | Execution mode of the jobs submitted into the queue (one of: FIFO,LIFO,PRIORITY | [optional] [default to null]
**compute_config_id** | **str** | The id of the compute configuration that will be used to create cluster associated with the queue. Defaults to default compute config in the given project | [optional] [default to null]
**cluster_environment_build_id** | **str** | The id of the cluster environment build that will be used to create cluster associated with the queue. | [optional] [default to null]
**max_concurrency** | **int** | Max number of jobs to be run concurrently. Defaults to 1, ie running no more than 1 job at a time. | [optional] [default to 1]
**idle_timeout_sec** | **int** | Max period of time queue will be accepting new jobs, before being sealed off and its associated cluster being shutdown | [default to null]
**auto_termination_threshold_job_count** | **int** | Maximum number of jobs the cluster can run before it becomes eligible for termination. | [optional] [default to null]

## JobRunType

An enumeration.

Possible Values:
['INTERACTIVE_SESSION', 'RUN', 'RAY_SUBMIT']

## JobStatus

An enumeration.

Possible Values:
['RUNNING', 'COMPLETED', 'PENDING', 'STOPPED', 'SUCCEEDED', 'FAILED', 'UNKNOWN']

## JobsQuery

Query model used to filter Jobs.  Priority for filtering job type is: `ha_job_id` > `type_filter` > `show_ray_client_runs_only` (deprecated). Only one or none of these fields will be used to filter: - Specifying `ha_job_id` is equivalent to `type_filter = {JobRunType.RUN}` - Specifying `show_ray_client_runs_only` (deprecated) is equivalent to `type_filter = {JobRunType.INTERACTIVE_SESSION, JobRunType.RAY_SUBMIT}`

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**name** | [**TextQuery**](#textquery) | Filters Jobs by name. If this field is absent, no filtering is done. | [optional] [default to null]
**runtime_environment_id** | **str** | Filters Jobs by runtime enviornment id. If this field is absent, no filtering is done. | [optional] [default to null]
**cluster_id** | **str** | Filters Jobs by cluster id. If this field is absent, no filtering is done. | [optional] [default to null]
**creator_id** | **str** | Filters Jobs by creator_id. If this field is absent, no filtering is done. | [optional] [default to null]
**ray_job_id** | **str** | Filters Jobs by ray_job_id. If this field is absent, no filtering is done. Note: the ray_job_id is only unique for one cluster. | [optional] [default to null]
**project_id** | **str** | Filters Jobs by project_id. If this field is absent, no filtering is done. | [optional] [default to null]
**include_child_jobs** | **bool** | Include jobs that have parents | [optional] [default to false]
**ha_job_id** | **str** | Filter by Anyscale job. Shows all jobs (jobs attempts) if not specified. Prioritized first for filtering type. | [optional] [default to null]
**show_ray_client_runs_only** | **bool** | DEPRECATED: use &#x60;type_filter&#x60;. Shows only Ray client runs. Prioritized third for filtering type. | [optional] [default to null]
**paging** | [**PageQuery**](#pagequery) | Pagination information. | [optional] [default to null]
**state_filter** | [**List[BaseJobStatus]**](#basejobstatus) | Filter Jobs by Job Status. If this field is an empty set, no filtering is done. | [optional] [default to []]
**type_filter** | [**List[JobRunType]**](#jobruntype) | Filter Jobs by their type. Their type is determined by their usage within the product e.g. Interactive sessions, job runs. Prioritized second for filtering type. | [optional] [default to []]
**sort_by_clauses** | [**List[SortByClauseJobsSortField]**](#sortbyclausejobssortfield) | The order used to specify results. The list will be used to construct ORDER BY database queries. If not specified, the fallback order by clauses are 1. Creation time (desc) 2. Name (ascending) and 3. ID (ascending) | [optional] [default to [{"sort_field":"CREATED_AT","sort_order":"DESC"},{"sort_field":"NAME","sort_order":"ASC"},{"sort_field":"ID","sort_order":"ASC"}]]

## JobsSortField

An enumeration.

Possible Values:
['STATUS', 'CREATED_AT', 'FINISHED_AT', 'NAME', 'ID']

## ListResponseMetadata

Metadata for a ListResponse containing common info like pagination

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**total** | **int** |  | [optional] [default to null]
**next_paging_token** | **str** |  | [optional] [default to null]

## ListServiceModel

The list model for Services. Please note that this model can be used for both Service v1 and v2. You can use the `type` field to differentiate between the two.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**id** | **str** |  | [default to null]
**name** | **str** |  | [default to null]
**creator_id** | **str** | Id of the user who created the Service | [default to null]
**created_at** | **datetime** | Time the Service was created | [default to null]
**project_id** | **str** | Id of the project this Service will start clusters in. This configuration cannot be changed after the service is created. | [default to null]
**current_state** | [**ServiceEventCurrentState**](#serviceeventcurrentstate) | The current state of this service | [default to null]
**endtime** | **datetime** |  | [optional] [default to null]
**type** | [**ServiceType**](#servicetype) | Type of the Service | [optional] [default to null]
**service_observability_urls** | [**ServiceObservabilityUrls**](#serviceobservabilityurls) | A JSON object with useful urls pointing to Grafana dashboards. | [default to null]

## ListservicemodelListResponse

A list response form the API. Contains a field \"results\" which has the contents of the response.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**results** | [**List[ListServiceModel]**](#listservicemodel) |  | [default to null]
**metadata** | [**ListResponseMetadata**](#listresponsemetadata) |  | [optional] [default to null]

## LogDownloadResult

The result from a call to /logs/get_log_files.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**log_chunks** | [**List[LogFileChunk]**](#logfilechunk) | A list of log file chunks. | [default to null]
**next_page_token** | **str** | Page token to fetch newer logs. | [optional] [default to null]
**previous_page_token** | **str** | Page token to fetch older logs. | [optional] [default to null]
**bearer_token** | **str** | Token to be used as a Bearer token passed in via Authorization header to access the log chunks. | [optional] [default to null]

## LogFileChunk

When we retrieve log file chunks from a cloud storage bucket, we infer properties about the chunks using a combination of (a) the filename/path, and (b) the chunk labels/metadata. We pass this metadata down to the client, so the client can group/categorize/process chunks as needed.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**cluster_id** | **str** | The cluster ID that this file originates from. | [default to null]
**chunk_name** | **str** | The full object name of a chunk (e.g. .../dashboard_agent.log/chunk-one.log) | [default to null]
**chunk_url** | **str** | A presigned URL to download this chunk. | [default to null]
**size** | **int** | The size of this chunk (should never exceed 10MB). | [default to null]
**file_name** | **str** | The full file name (path) of a file (e.g. .../dashboard_agent.log | [default to null]
**node_type** | [**NodeType**](#nodetype) | The type of node that this file originated from (e.g. head-node, worker-nodes | [default to null]
**node_ip** | **str** | The node IP that this file originated from. | [default to null]
**instance_id** | **str** | The instance ID that this file originated from. | [default to null]
**session_id** | **str** | The session ID that this file originated from. | [default to null]
**ray_pid** | **str** | The PID that this file originated from, if appropriate. | [optional] [default to null]
**ray_worker_id** | **str** | The Ray worker ID that this file originated from, if appropriate. | [optional] [default to null]
**job_id** | **str** | The Ray job ID that this file originated from, if appropriate. | [optional] [default to null]

## LogStream


Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**http_url** | **str** | HTTP URL for retrieving initial lines. | [default to null]
**stream_url** | **str** | HTTP/WebSocket URL for streaming Ray logs. | [optional] [default to null]

## LogdownloadresultResponse

A response from the API. Contains a field \"result\" which has the contents of the response.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**result** | [**LogDownloadResult**](#logdownloadresult) |  | [default to null]

## LogstreamResponse

A response from the API. Contains a field \"result\" which has the contents of the response.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**result** | [**LogStream**](#logstream) |  | [default to null]

## NodeType

The type of node (head or worker).

Possible Values:
['head-node', 'worker-nodes', 'unknown']

## OperationError

The response of this operation in case of failure     

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**message** | **str** | Human readable message explaining why this operation failed. | [default to null]

## OperationProgress

Provides detailed information about how this operation is progressing.     

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**message** | **str** | Human readable message about the progress of an operation. | [default to null]

## OperationResult

The result of an Operation upon completion. Exactly one of `error` or `data` will be set.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**data** | **object** | The response of this operation in case of success.        This is typically the resource that this operation acted on. | [optional] [default to null]
**error** | [**OperationError**](#operationerror) | The response of this operation in case of failure | [optional] [default to null]

## Organization

Fields representing an Organization

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**id** | **str** | Server assigned unique identifier. | [default to null]
**name** | **str** | Organization&#39;s display name. | [default to null]
**public_identifier** | **str** | Organization&#39;s public identifier. | [default to null]
**sso_required** | **bool** | Require users to log in to your organization using single sign on (SSO). | [optional] [default to false]
**sso_mode** | [**SSOMode**](#ssomode) | Mode for use of single sign on (SSO) for your organization. | [optional] [default to null]

## OrganizationResponse

A response from the API. Contains a field \"result\" which has the contents of the response.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**result** | [**Organization**](#organization) |  | [default to null]

## PageQuery

Query model for paginating results.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**count** | **int** | Number of elements to fetch. Defaults to 10. | [optional] [default to 10]
**paging_token** | **str** | Token used for pagination. If absent, server will return elements from the first page. | [optional] [default to null]

## PauseSchedule


Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**is_paused** | **bool** | Whether to pause or unpause this cron job | [default to null]

## ProductionJob

Model of a Production Job for use in the SDK.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**id** | **str** | The id of this job | [default to null]
**name** | **str** | Name of the job | [default to null]
**description** | **str** | Description of the job | [optional] [default to null]
**created_at** | **datetime** | The time this job was created | [default to null]
**creator_id** | **str** | The id of the user who created this job | [default to null]
**config** | [**ProductionJobConfig**](#productionjobconfig) | The config that was used to create this job | [default to null]
**job_queue_config** | [**JobQueueConfig**](#jobqueueconfig) | Job Queue configuration of this job (if applicable) | [optional] [default to null]
**state** | [**ProductionJobStateTransition**](#productionjobstatetransition) | The current state of this job | [default to null]
**project_id** | **str** | Id of the project this job will start clusters in | [default to null]
**last_job_run_id** | **str** | The id of the last job run | [optional] [default to null]
**schedule_id** | **str** | If the job was launched via Scheduled job, this will contain the id of that schedule. | [optional] [default to null]
**job_queue_id** | **str** | Id of the job queue this job is being enqueued to | [optional] [default to null]

## ProductionJobConfig


Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**entrypoint** | **str** | A script that will be run to start your job.This command will be run in the root directory of the specified runtime env. Eg. &#39;python script.py&#39; | [optional] [default to ]
**ray_serve_config** | **object** | The Ray Serve config to use for this Production service. This config defines your Ray Serve application, and will be passed directly to Ray Serve. You can learn more about Ray Serve config files here: https://docs.ray.io/en/latest/serve/production-guide/config.html | [optional] [default to null]
**runtime_env** | [**RayRuntimeEnvConfig**](#rayruntimeenvconfig) | A ray runtime env json. Your entrypoint will be run in the environment specified by this runtime env. | [optional] [default to null]
**build_id** | **str** | The id of the cluster env build. This id will determine the docker image your job is run on. | [default to null]
**compute_config_id** | **str** | The id of the compute configuration that you want to use. This id will specify the resources required for your job | [default to null]
**compute_config** | [**CreateClusterComputeConfig**](#createclustercomputeconfig) | One-off compute that the cluster will use. | [optional] [default to null]
**max_retries** | **int** | The number of retries this job will attempt on failure. Set to None to set infinite retries | [optional] [default to 5]
**timeout_s** | **int** | The timeout in seconds for each job run. Set to None for no limit to be set | [optional] [default to null]
**runtime_env_config** | [**RayRuntimeEnvConfig**](#rayruntimeenvconfig) | DEPRECATED: Use runtime_env | [optional] [default to null]

## ProductionJobStateTransition


Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**id** | **str** | The id of this job state transition | [default to null]
**state_transitioned_at** | **datetime** | The last time the state of this job was updated | [default to null]
**current_state** | [**HaJobStates**](#hajobstates) | The current state of the job | [default to null]
**goal_state** | [**HaJobGoalStates**](#hajobgoalstates) | The goal state of the job | [optional] [default to null]
**error** | **str** | An error message that occurred in this job state transition | [optional] [default to null]
**operation_message** | **str** | The logging message for this job state transition | [optional] [default to null]
**cluster_id** | **str** | The id of the cluster the job is running on | [optional] [default to null]

## ProductionServiceV2Model

DEPRECATED. Please use ServiceModel with new sdk calls.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**id** | **str** | Id of the Service | [default to null]
**name** | **str** | Name of the Service | [default to null]
**description** | **str** | Description of the Service | [optional] [default to null]
**project_id** | **str** | Id of the project this Service will start clusters in. This configuration cannot be changed after the service is created. | [default to null]
**cloud_id** | **str** | Id of the cloud this Service belongs to, and will launch clusters in. This configuration cannot be changed. | [default to null]
**creator_id** | **str** | Id of the user who created the Service | [default to null]
**created_at** | **datetime** | Time the Service was created | [default to null]
**hostname** | **str** | The hostname of the service | [default to null]
**current_state** | [**ServiceEventCurrentState**](#serviceeventcurrentstate) | The current state of this service | [default to null]
**goal_state** | [**ServiceGoalStates**](#servicegoalstates) | The goal state of this service | [default to null]
**auth_token** | **str** | Token to use for service auth. To use the token, add it as a header with the key &#39;Authorization&#39; and the value &#39;Bearer &lt;token&gt;&#39; | [optional] [default to null]
**auto_rollout_enabled** | **bool** | Whether or not the service is using auto rollout | [default to null]
**versions** | [**List[ProductionServiceV2VersionModel]**](#productionservicev2versionmodel) | DEPRECATED. Please use &#x60;primary_version&#x60; and &#x60;canary_version&#x60; fields. Active versions of this service, sorted by creation time in ascending order. | [default to null]
**primary_version** | [**ProductionServiceV2VersionModel**](#productionservicev2versionmodel) | Primary version of this service. If the service is terminated, this field refers to the most recently active version. | [default to null]
**canary_version** | [**ProductionServiceV2VersionModel**](#productionservicev2versionmodel) | Canary version of this service. Present only if the service is in the &#x60;ROLLING_OUT&#x60; state. | [optional] [default to null]
**service_observability_urls** | [**ServiceObservabilityUrls**](#serviceobservabilityurls) | A JSON object with useful urls pointing to Grafana dashboards. | [default to null]
**base_url** | **str** | The base url of this service | [default to null]
**ended_at** | **datetime** | Time the Service was terminated | [optional] [default to null]

## ProductionServiceV2VersionModel


Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**id** | **str** | Id of the Service Version | [default to null]
**created_at** | **datetime** | Time the version was created | [default to null]
**weight** | **int** | The target percentage of traffic sent to this version. This is a number between 0 and 100. | [default to null]
**current_weight** | **int** | The current percentage of traffic sent to this version. This is a number between 0 and 100. | [optional] [default to null]
**version** | **str** | The version string identifier for this version | [default to null]
**ray_serve_config** | [**object**](#) |  | [default to null]
**ray_gcs_external_storage_config** | [**RayGCSExternalStorageConfig**](#raygcsexternalstorageconfig) | Config for the Ray GCS to connect to external storage. If populated, head node fault tolerance is enabled for this service. | [optional] [default to null]
**tracing_config** | [**TracingConfig**](#tracingconfig) | Config for initializing tracing within Anyscale runtime. | [optional] [default to null]
**build_id** | **str** | The id of the cluster env build. This id will determine the docker image your Service is run using. | [default to null]
**compute_config_id** | **str** | The id of the compute configuration that you want to use. This id will specify the resources required for your Service.The compute template includes a &#x60;cloud_id&#x60; that cannot be updated. | [default to null]
**production_job_ids** | **List[str]** | The list of production job ids associated with this service version. | [default to null]
**current_state** | [**ServiceVersionState**](#serviceversionstate) | The current state of the service version. | [default to null]

## ProductionjobListResponse

A list response form the API. Contains a field \"results\" which has the contents of the response.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**results** | [**List[ProductionJob]**](#productionjob) |  | [default to null]
**metadata** | [**ListResponseMetadata**](#listresponsemetadata) |  | [optional] [default to null]

## ProductionjobResponse

A response from the API. Contains a field \"result\" which has the contents of the response.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**result** | [**ProductionJob**](#productionjob) |  | [default to null]

## Productionservicev2ModelResponse

A response from the API. Contains a field \"result\" which has the contents of the response.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**result** | [**ProductionServiceV2Model**](#productionservicev2model) |  | [default to null]

## Project

Model used to read a Project.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**name** | **str** | Name of the Project to be created. | [default to null]
**cluster_config** | **str** | Cluster config associated with the Project. This can later be used to start a Session. | [default to null]
**description** | **str** | Description of Project. | [optional] [default to null]
**parent_cloud_id** | **str** | Cloud that all resources in this project should be scoped to. | [optional] [default to null]
**id** | **str** | Server assigned unique identifier of the Project. | [default to null]
**creator_id** | **str** | Identifier of user who created the Project. | [optional] [default to null]
**created_at** | **datetime** | Time at which Project was created. | [default to null]
**organization_id** | **str** | Organization that the Project is associated with. | [default to null]
**last_used_cloud_id** | **str** | ID of the last cloud used in this project, or by the user if this is a new project.  | [optional] [default to null]
**is_default** | **bool** | True if this project is the default project for the organization. | [default to null]
**directory_name** | **str** | Directory name of project to be used as working directory of clusters. | [default to null]
**active_sessions** | **int** | DEPRECATED. Number of active sessions for this project. | [optional] [default to 0]
**last_activity_at** | **datetime** | DEPRECATED. The most recent activity for this project. This is based on the most recently created sessions | [optional] [default to null]

## ProjectListResponse

A list response form the API. Contains a field \"results\" which has the contents of the response.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**results** | [**List[Project]**](#project) |  | [default to null]
**metadata** | [**ListResponseMetadata**](#listresponsemetadata) |  | [optional] [default to null]

## ProjectResponse

A response from the API. Contains a field \"result\" which has the contents of the response.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**result** | [**Project**](#project) |  | [default to null]

## ProjectsQuery

Query model used to filter Projects. It is used in the SDK.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**name** | [**TextQuery**](#textquery) | Filters Projects by name. If this field is absent, no filtering is done. | [optional] [default to null]
**creator_id** | [**TextQuery**](#textquery) | Filters Projects by creator_id. If this field is absent, no filtering is done. | [optional] [default to null]
**paging** | [**PageQuery**](#pagequery) | Pagination information. | [optional] [default to null]
**parent_cloud_id** | [**TextQuery**](#textquery) | Filters Projects by parent_cloud_id. If this field is absent, no filtering is done. | [optional] [default to null]
**include_defaults** | **bool** | Whether to include default projects in the results. | [optional] [default to true]

## Protocols


Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**http** | [**HttpProtocolConfig**](#httpprotocolconfig) | The protocol setup for HTTP. | [optional] [default to null]
**grpc** | [**GrpcProtocolConfig**](#grpcprotocolconfig) | The protocol setup for gRPC. | [optional] [default to null]

## PythonModules


Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**pip_packages** | **List[str]** | List of pip packages that&#39;ll be included in the image. | [optional] [default to null]
**conda_packages** | **List[str]** | List of conda packages that&#39;ll be included in the image. | [optional] [default to null]

## PythonVersion

An enumeration.

Possible Values:
['py36', 'py37', 'py38', 'py39', 'py310', 'py311', 'py312']

## RayGCSExternalStorageConfig

This model is derived from ClusterGCSExternalStorageConfig and includes an additional `enable` field. RayGCSExternalStorageConfig is converted into ClusterGCSExternalStorageConfig to filter for fields that are relevant when creating ray_gcs_external_storage_config.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**address** | **str** | Address to connect to external storage at. Must be accessible from instances running in the provided cloud. | [optional] [default to null]
**redis_certificate_path** | **str** | Path to the certificate on the head node. This path is only relevant when TLS is enabled. | [optional] [default to /etc/ssl/certs/ca-certificates.crt]
**enable** | **bool** | Enable GCS Fault Tolerance (FT) for the service. Default is set to True. | [optional] [default to true]

## RayRuntimeEnvConfig

A runtime env config. Can be used to start a production job.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**working_dir** | **str** | The working directory that your code will run in. Must be a remote URI like an s3 or git path. | [optional] [default to null]
**py_modules** | **List[str]** | Python modules that will be installed along with your runtime env. These must be remote URIs. | [optional] [default to null]
**relative_working_dir** | **str** | Relative path to the working directory that your code will run in. The appropriate cloud deployment object storage will be prepended to this path. | [optional] [default to null]
**relative_py_modules** | **List[str]** | Relative paths to python modules that will be installed along with your runtime env. The appropriate cloud deployment object storage will be prepended to these paths. If &#x60;py_modules&#x60; are specified, they will be also be installed. | [optional] [default to null]
**py_executable** | **str** | Specifies the executable used for running the Ray workers. It can include arguments as well. | [optional] [default to null]
**pip** | **List[str]** | A list of pip packages to install. | [optional] [default to null]
**conda** | **object** | [Union[Dict[str, Any], str]: Either the conda YAML config or the name of a local conda env (e.g., \&quot;pytorch_p36\&quot;),  | [optional] [default to null]
**env_vars** | **Dict(str, str)** | Environment variables to set. | [optional] [default to null]
**config** | [**object**](#) | Config for runtime environment. Can be used to setup setup_timeout_seconds, the timeout of runtime environment creation. | [optional] [default to null]
**image_uri** | **str** | Specifies the image URI of the container in which the job will run. | [optional] [default to null]

## Resources


Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**cpu** | **int** | Number of CPUs in this node type. If left blank, Ray may automatically detect it for you; see https://docs.ray.io/en/master/cluster/vms/references/ray-cluster-configuration.html#resources for more. | [optional] [default to null]
**gpu** | **int** | Number of GPUs in this node type. If left blank, Ray may automatically detect it for you; see https://docs.ray.io/en/master/cluster/vms/references/ray-cluster-configuration.html#resources for more. | [optional] [default to null]
**memory** | **int** | Amount of memory to allocate to the Python worker. If left blank, Ray will choose an appropriate amount based on available resources; see https://docs.ray.io/en/master/cluster/vms/references/ray-cluster-configuration.html#resources for more. | [optional] [default to null]
**object_store_memory** | **int** | The amount of memory in bytes allocated for the Ray object store on this node. If left blank, Ray will choose an appropriate amount; see https://docs.ray.io/en/master/cluster/vms/references/ray-cluster-configuration.html#resources for more. | [optional] [default to null]
**custom_resources** | **Dict(str, int)** | Declare custom resources for this node to be used by Ray autoscaler. | [optional] [default to {}]

## RollbackServiceModel

The rollback model for Services.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**max_surge_percent** | **int** | The max_surge_percent to use when rolling back. | [optional] [default to null]

## RolloutStrategy

An enumeration.

Possible Values:
['ROLLOUT', 'IN_PLACE']

## SSOConfig

Read model of an SSOConfig     

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**idp_metadata_url** | **str** | Identity provider (IdP) metadata url. If given along with the other static identity provider fields, Anyscale will first attempt metadata exchange to get IdP attributes. If Anyscale can&#39;t reach the metadata endpoint or if the metadata url isn&#39;t given, Anyscale will use static_idp_config as a backup. Either idp_metadata_url or static_idp_config is required. | [optional] [default to null]
**static_idp_config** | [**StaticSSOConfig**](#staticssoconfig) | Static identity provider configuration. | [optional] [default to null]
**id** | **str** | ID of this SSO Config. | [default to null]
**created_at** | **datetime** | Time at which this SSO Config was created. | [default to null]
**creator_id** | **str** | ID of the user who created this SSO Config. | [default to null]

## SSOMode

An enumeration.

Possible Values:
['off', 'optional', 'required']

## SUPPORTEDBASEIMAGESENUM

An enumeration.

Possible Values:
['anyscale/ray-llm:2.44.0-py311-cu124', 'anyscale/ray-llm:2.44.1-py311-cu124', 'anyscale/ray-llm:2.45.0-py311-cu124', 'anyscale/ray-llm:2.46.0-py311-cu124', 'anyscale/ray-llm:2.47.0-py311-cu124', 'anyscale/ray-llm:2.47.1-py311-cu124', 'anyscale/ray-llm:2.48.0-py311-cu128', 'anyscale/ray-llm:2.49.0-py311-cu128', 'anyscale/ray-llm:2.49.1-py311-cu128', 'anyscale/ray-llm:nightly-py311-cu128', 'anyscale/ray-ml:2.0.0-py37-cpu', 'anyscale/ray-ml:2.0.0-py37-gpu', 'anyscale/ray-ml:2.0.0-py38-cpu', 'anyscale/ray-ml:2.0.0-py38-gpu', 'anyscale/ray-ml:2.0.1-py37-cpu', 'anyscale/ray-ml:2.0.1-py37-gpu', 'anyscale/ray-ml:2.0.1-py38-cpu', 'anyscale/ray-ml:2.0.1-py38-gpu', 'anyscale/ray-ml:2.1.0-py37-cpu', 'anyscale/ray-ml:2.1.0-py37-gpu', 'anyscale/ray-ml:2.1.0-py38-cpu', 'anyscale/ray-ml:2.1.0-py38-gpu', 'anyscale/ray-ml:2.10.0-py310-cpu', 'anyscale/ray-ml:2.10.0-py310-gpu', 'anyscale/ray-ml:2.10.0-py38-cpu', 'anyscale/ray-ml:2.10.0-py38-gpu', 'anyscale/ray-ml:2.10.0-py39-cpu', 'anyscale/ray-ml:2.10.0-py39-gpu', 'anyscale/ray-ml:2.11.0-py310-cpu', 'anyscale/ray-ml:2.11.0-py310-gpu', 'anyscale/ray-ml:2.11.0-py311-cpu', 'anyscale/ray-ml:2.11.0-py311-gpu', 'anyscale/ray-ml:2.11.0-py39-cpu', 'anyscale/ray-ml:2.11.0-py39-gpu', 'anyscale/ray-ml:2.12.0-py310-cpu', 'anyscale/ray-ml:2.12.0-py310-gpu', 'anyscale/ray-ml:2.12.0-py311-cpu', 'anyscale/ray-ml:2.12.0-py311-gpu', 'anyscale/ray-ml:2.12.0-py39-cpu', 'anyscale/ray-ml:2.12.0-py39-gpu', 'anyscale/ray-ml:2.2.0-py310-cpu', 'anyscale/ray-ml:2.2.0-py310-gpu', 'anyscale/ray-ml:2.2.0-py37-cpu', 'anyscale/ray-ml:2.2.0-py37-gpu', 'anyscale/ray-ml:2.2.0-py38-cpu', 'anyscale/ray-ml:2.2.0-py38-gpu', 'anyscale/ray-ml:2.2.0-py39-cpu', 'anyscale/ray-ml:2.2.0-py39-gpu', 'anyscale/ray-ml:2.20.0-py310-cpu', 'anyscale/ray-ml:2.20.0-py310-gpu', 'anyscale/ray-ml:2.20.0-py311-cpu', 'anyscale/ray-ml:2.20.0-py311-gpu', 'anyscale/ray-ml:2.20.0-py39-cpu', 'anyscale/ray-ml:2.20.0-py39-gpu', 'anyscale/ray-ml:2.21.0-py310-cpu', 'anyscale/ray-ml:2.21.0-py310-gpu', 'anyscale/ray-ml:2.21.0-py311-cpu', 'anyscale/ray-ml:2.21.0-py311-gpu', 'anyscale/ray-ml:2.21.0-py39-cpu', 'anyscale/ray-ml:2.21.0-py39-gpu', 'anyscale/ray-ml:2.22.0-py310-cpu', 'anyscale/ray-ml:2.22.0-py310-gpu', 'anyscale/ray-ml:2.22.0-py311-cpu', 'anyscale/ray-ml:2.22.0-py311-gpu', 'anyscale/ray-ml:2.22.0-py39-cpu', 'anyscale/ray-ml:2.22.0-py39-gpu', 'anyscale/ray-ml:2.23.0-py310-cpu', 'anyscale/ray-ml:2.23.0-py310-gpu', 'anyscale/ray-ml:2.23.0-py311-cpu', 'anyscale/ray-ml:2.23.0-py311-gpu', 'anyscale/ray-ml:2.23.0-py39-cpu', 'anyscale/ray-ml:2.23.0-py39-gpu', 'anyscale/ray-ml:2.24.0-py310-cpu', 'anyscale/ray-ml:2.24.0-py310-gpu', 'anyscale/ray-ml:2.24.0-py311-cpu', 'anyscale/ray-ml:2.24.0-py311-gpu', 'anyscale/ray-ml:2.24.0-py39-cpu', 'anyscale/ray-ml:2.24.0-py39-gpu', 'anyscale/ray-ml:2.3.0-py310-cpu', 'anyscale/ray-ml:2.3.0-py310-gpu', 'anyscale/ray-ml:2.3.0-py37-cpu', 'anyscale/ray-ml:2.3.0-py37-gpu', 'anyscale/ray-ml:2.3.0-py38-cpu', 'anyscale/ray-ml:2.3.0-py38-gpu', 'anyscale/ray-ml:2.3.0-py39-cpu', 'anyscale/ray-ml:2.3.0-py39-gpu', 'anyscale/ray-ml:2.3.1-py310-cpu', 'anyscale/ray-ml:2.3.1-py310-gpu', 'anyscale/ray-ml:2.3.1-py37-cpu', 'anyscale/ray-ml:2.3.1-py37-gpu', 'anyscale/ray-ml:2.3.1-py38-cpu', 'anyscale/ray-ml:2.3.1-py38-gpu', 'anyscale/ray-ml:2.3.1-py39-cpu', 'anyscale/ray-ml:2.3.1-py39-gpu', 'anyscale/ray-ml:2.30.0-py310-cpu', 'anyscale/ray-ml:2.30.0-py310-gpu', 'anyscale/ray-ml:2.30.0-py311-cpu', 'anyscale/ray-ml:2.30.0-py311-gpu', 'anyscale/ray-ml:2.30.0-py39-cpu', 'anyscale/ray-ml:2.30.0-py39-gpu', 'anyscale/ray-ml:2.31.0-py310-cpu', 'anyscale/ray-ml:2.31.0-py310-gpu', 'anyscale/ray-ml:2.31.0-py311-cpu', 'anyscale/ray-ml:2.31.0-py311-gpu', 'anyscale/ray-ml:2.31.0-py39-cpu', 'anyscale/ray-ml:2.31.0-py39-gpu', 'anyscale/ray-ml:2.32.0-py310-cpu', 'anyscale/ray-ml:2.32.0-py310-gpu', 'anyscale/ray-ml:2.32.0-py311-cpu', 'anyscale/ray-ml:2.32.0-py311-gpu', 'anyscale/ray-ml:2.32.0-py39-cpu', 'anyscale/ray-ml:2.32.0-py39-gpu', 'anyscale/ray-ml:2.33.0-py310-cpu', 'anyscale/ray-ml:2.33.0-py310-gpu', 'anyscale/ray-ml:2.33.0-py311-cpu', 'anyscale/ray-ml:2.33.0-py311-gpu', 'anyscale/ray-ml:2.33.0-py39-cpu', 'anyscale/ray-ml:2.33.0-py39-gpu', 'anyscale/ray-ml:2.34.0-py310-cpu', 'anyscale/ray-ml:2.34.0-py310-gpu', 'anyscale/ray-ml:2.34.0-py311-cpu', 'anyscale/ray-ml:2.34.0-py311-gpu', 'anyscale/ray-ml:2.34.0-py39-cpu', 'anyscale/ray-ml:2.34.0-py39-gpu', 'anyscale/ray-ml:2.35.0-py310-cpu', 'anyscale/ray-ml:2.35.0-py310-gpu', 'anyscale/ray-ml:2.35.0-py311-cpu', 'anyscale/ray-ml:2.35.0-py311-gpu', 'anyscale/ray-ml:2.35.0-py39-cpu', 'anyscale/ray-ml:2.35.0-py39-gpu', 'anyscale/ray-ml:2.36.0-py310-cpu', 'anyscale/ray-ml:2.36.0-py310-gpu', 'anyscale/ray-ml:2.36.0-py311-cpu', 'anyscale/ray-ml:2.36.0-py311-gpu', 'anyscale/ray-ml:2.36.0-py39-cpu', 'anyscale/ray-ml:2.36.0-py39-gpu', 'anyscale/ray-ml:2.36.1-py310-cpu', 'anyscale/ray-ml:2.36.1-py310-gpu', 'anyscale/ray-ml:2.36.1-py311-cpu', 'anyscale/ray-ml:2.36.1-py311-gpu', 'anyscale/ray-ml:2.36.1-py39-cpu', 'anyscale/ray-ml:2.36.1-py39-gpu', 'anyscale/ray-ml:2.37.0-py310-cpu', 'anyscale/ray-ml:2.37.0-py310-gpu', 'anyscale/ray-ml:2.37.0-py311-cpu', 'anyscale/ray-ml:2.37.0-py311-gpu', 'anyscale/ray-ml:2.37.0-py39-cpu', 'anyscale/ray-ml:2.37.0-py39-gpu', 'anyscale/ray-ml:2.38.0-py310-cpu', 'anyscale/ray-ml:2.38.0-py310-gpu', 'anyscale/ray-ml:2.38.0-py311-cpu', 'anyscale/ray-ml:2.38.0-py311-gpu', 'anyscale/ray-ml:2.38.0-py39-cpu', 'anyscale/ray-ml:2.38.0-py39-gpu', 'anyscale/ray-ml:2.39.0-py310-cpu', 'anyscale/ray-ml:2.39.0-py310-gpu', 'anyscale/ray-ml:2.39.0-py311-cpu', 'anyscale/ray-ml:2.39.0-py311-gpu', 'anyscale/ray-ml:2.39.0-py39-cpu', 'anyscale/ray-ml:2.39.0-py39-gpu', 'anyscale/ray-ml:2.4.0-py310-cpu', 'anyscale/ray-ml:2.4.0-py310-gpu', 'anyscale/ray-ml:2.4.0-py37-cpu', 'anyscale/ray-ml:2.4.0-py37-gpu', 'anyscale/ray-ml:2.4.0-py38-cpu', 'anyscale/ray-ml:2.4.0-py38-gpu', 'anyscale/ray-ml:2.4.0-py39-cpu', 'anyscale/ray-ml:2.4.0-py39-gpu', 'anyscale/ray-ml:2.40.0-py310-cpu', 'anyscale/ray-ml:2.40.0-py310-gpu', 'anyscale/ray-ml:2.40.0-py311-cpu', 'anyscale/ray-ml:2.40.0-py311-gpu', 'anyscale/ray-ml:2.40.0-py39-cpu', 'anyscale/ray-ml:2.40.0-py39-gpu', 'anyscale/ray-ml:2.41.0-py310-cpu', 'anyscale/ray-ml:2.41.0-py310-gpu', 'anyscale/ray-ml:2.41.0-py311-cpu', 'anyscale/ray-ml:2.41.0-py311-gpu', 'anyscale/ray-ml:2.41.0-py39-cpu', 'anyscale/ray-ml:2.41.0-py39-gpu', 'anyscale/ray-ml:2.42.0-py310-cpu', 'anyscale/ray-ml:2.42.0-py310-gpu', 'anyscale/ray-ml:2.42.0-py311-cpu', 'anyscale/ray-ml:2.42.0-py311-gpu', 'anyscale/ray-ml:2.42.0-py39-cpu', 'anyscale/ray-ml:2.42.0-py39-gpu', 'anyscale/ray-ml:2.42.1-py310-cpu', 'anyscale/ray-ml:2.42.1-py310-gpu', 'anyscale/ray-ml:2.42.1-py311-cpu', 'anyscale/ray-ml:2.42.1-py311-gpu', 'anyscale/ray-ml:2.42.1-py39-cpu', 'anyscale/ray-ml:2.42.1-py39-gpu', 'anyscale/ray-ml:2.43.0-py310-cpu', 'anyscale/ray-ml:2.43.0-py310-gpu', 'anyscale/ray-ml:2.43.0-py311-cpu', 'anyscale/ray-ml:2.43.0-py311-gpu', 'anyscale/ray-ml:2.43.0-py39-cpu', 'anyscale/ray-ml:2.43.0-py39-gpu', 'anyscale/ray-ml:2.44.0-py310-cpu', 'anyscale/ray-ml:2.44.0-py310-gpu', 'anyscale/ray-ml:2.44.0-py311-cpu', 'anyscale/ray-ml:2.44.0-py311-gpu', 'anyscale/ray-ml:2.44.0-py39-cpu', 'anyscale/ray-ml:2.44.0-py39-gpu', 'anyscale/ray-ml:2.44.1-py310-cpu', 'anyscale/ray-ml:2.44.1-py310-gpu', 'anyscale/ray-ml:2.44.1-py311-cpu', 'anyscale/ray-ml:2.44.1-py311-gpu', 'anyscale/ray-ml:2.44.1-py39-cpu', 'anyscale/ray-ml:2.44.1-py39-gpu', 'anyscale/ray-ml:2.45.0-py310-cpu', 'anyscale/ray-ml:2.45.0-py310-gpu', 'anyscale/ray-ml:2.45.0-py311-cpu', 'anyscale/ray-ml:2.45.0-py311-gpu', 'anyscale/ray-ml:2.45.0-py39-cpu', 'anyscale/ray-ml:2.45.0-py39-gpu', 'anyscale/ray-ml:2.46.0-py310-cpu', 'anyscale/ray-ml:2.46.0-py310-gpu', 'anyscale/ray-ml:2.46.0-py311-cpu', 'anyscale/ray-ml:2.46.0-py311-gpu', 'anyscale/ray-ml:2.46.0-py39-cpu', 'anyscale/ray-ml:2.46.0-py39-gpu', 'anyscale/ray-ml:2.47.0-py310-cpu', 'anyscale/ray-ml:2.47.0-py310-gpu', 'anyscale/ray-ml:2.47.0-py311-cpu', 'anyscale/ray-ml:2.47.0-py311-gpu', 'anyscale/ray-ml:2.47.0-py39-cpu', 'anyscale/ray-ml:2.47.0-py39-gpu', 'anyscale/ray-ml:2.47.1-py310-cpu', 'anyscale/ray-ml:2.47.1-py310-gpu', 'anyscale/ray-ml:2.47.1-py311-cpu', 'anyscale/ray-ml:2.47.1-py311-gpu', 'anyscale/ray-ml:2.47.1-py39-cpu', 'anyscale/ray-ml:2.47.1-py39-gpu', 'anyscale/ray-ml:2.48.0-py310-cpu', 'anyscale/ray-ml:2.48.0-py310-gpu', 'anyscale/ray-ml:2.48.0-py311-cpu', 'anyscale/ray-ml:2.48.0-py311-gpu', 'anyscale/ray-ml:2.48.0-py39-cpu', 'anyscale/ray-ml:2.48.0-py39-gpu', 'anyscale/ray-ml:2.49.0-py310-cpu', 'anyscale/ray-ml:2.49.0-py310-gpu', 'anyscale/ray-ml:2.49.0-py311-cpu', 'anyscale/ray-ml:2.49.0-py311-gpu', 'anyscale/ray-ml:2.49.0-py39-cpu', 'anyscale/ray-ml:2.49.0-py39-gpu', 'anyscale/ray-ml:2.49.1-py310-cpu', 'anyscale/ray-ml:2.49.1-py310-gpu', 'anyscale/ray-ml:2.49.1-py311-cpu', 'anyscale/ray-ml:2.49.1-py311-gpu', 'anyscale/ray-ml:2.49.1-py39-cpu', 'anyscale/ray-ml:2.49.1-py39-gpu', 'anyscale/ray-ml:2.5.0-py310-cpu', 'anyscale/ray-ml:2.5.0-py310-gpu', 'anyscale/ray-ml:2.5.0-py37-cpu', 'anyscale/ray-ml:2.5.0-py37-gpu', 'anyscale/ray-ml:2.5.0-py38-cpu', 'anyscale/ray-ml:2.5.0-py38-gpu', 'anyscale/ray-ml:2.5.0-py39-cpu', 'anyscale/ray-ml:2.5.0-py39-gpu', 'anyscale/ray-ml:2.5.1-py310-cpu', 'anyscale/ray-ml:2.5.1-py310-gpu', 'anyscale/ray-ml:2.5.1-py37-cpu', 'anyscale/ray-ml:2.5.1-py37-gpu', 'anyscale/ray-ml:2.5.1-py38-cpu', 'anyscale/ray-ml:2.5.1-py38-gpu', 'anyscale/ray-ml:2.5.1-py39-cpu', 'anyscale/ray-ml:2.5.1-py39-gpu', 'anyscale/ray-ml:2.6.0-py310-cpu', 'anyscale/ray-ml:2.6.0-py310-gpu', 'anyscale/ray-ml:2.6.0-py38-cpu', 'anyscale/ray-ml:2.6.0-py38-gpu', 'anyscale/ray-ml:2.6.0-py39-cpu', 'anyscale/ray-ml:2.6.0-py39-gpu', 'anyscale/ray-ml:2.6.1-py310-cpu', 'anyscale/ray-ml:2.6.1-py310-gpu', 'anyscale/ray-ml:2.6.1-py38-cpu', 'anyscale/ray-ml:2.6.1-py38-gpu', 'anyscale/ray-ml:2.6.1-py39-cpu', 'anyscale/ray-ml:2.6.1-py39-gpu', 'anyscale/ray-ml:2.6.2-py310-cpu', 'anyscale/ray-ml:2.6.2-py310-gpu', 'anyscale/ray-ml:2.6.2-py38-cpu', 'anyscale/ray-ml:2.6.2-py38-gpu', 'anyscale/ray-ml:2.6.2-py39-cpu', 'anyscale/ray-ml:2.6.2-py39-gpu', 'anyscale/ray-ml:2.6.3-py310-cpu', 'anyscale/ray-ml:2.6.3-py310-gpu', 'anyscale/ray-ml:2.6.3-py38-cpu', 'anyscale/ray-ml:2.6.3-py38-gpu', 'anyscale/ray-ml:2.6.3-py39-cpu', 'anyscale/ray-ml:2.6.3-py39-gpu', 'anyscale/ray-ml:2.7.0optimized-py310-cpu', 'anyscale/ray-ml:2.7.0optimized-py310-gpu', 'anyscale/ray-ml:2.7.0optimized-py38-cpu', 'anyscale/ray-ml:2.7.0optimized-py38-gpu', 'anyscale/ray-ml:2.7.0optimized-py39-cpu', 'anyscale/ray-ml:2.7.0optimized-py39-gpu', 'anyscale/ray-ml:2.7.1optimized-py310-cpu', 'anyscale/ray-ml:2.7.1optimized-py310-gpu', 'anyscale/ray-ml:2.7.1optimized-py38-cpu', 'anyscale/ray-ml:2.7.1optimized-py38-gpu', 'anyscale/ray-ml:2.7.1optimized-py39-cpu', 'anyscale/ray-ml:2.7.1optimized-py39-gpu', 'anyscale/ray-ml:2.7.2optimized-py310-cpu', 'anyscale/ray-ml:2.7.2optimized-py310-gpu', 'anyscale/ray-ml:2.7.2optimized-py38-cpu', 'anyscale/ray-ml:2.7.2optimized-py38-gpu', 'anyscale/ray-ml:2.7.2optimized-py39-cpu', 'anyscale/ray-ml:2.7.2optimized-py39-gpu', 'anyscale/ray-ml:2.8.0-py310-cpu', 'anyscale/ray-ml:2.8.0-py310-gpu', 'anyscale/ray-ml:2.8.0-py38-cpu', 'anyscale/ray-ml:2.8.0-py38-gpu', 'anyscale/ray-ml:2.8.0-py39-cpu', 'anyscale/ray-ml:2.8.0-py39-gpu', 'anyscale/ray-ml:2.8.1-py310-cpu', 'anyscale/ray-ml:2.8.1-py310-gpu', 'anyscale/ray-ml:2.8.1-py38-cpu', 'anyscale/ray-ml:2.8.1-py38-gpu', 'anyscale/ray-ml:2.8.1-py39-cpu', 'anyscale/ray-ml:2.8.1-py39-gpu', 'anyscale/ray-ml:2.9.0-py310-cpu', 'anyscale/ray-ml:2.9.0-py310-gpu', 'anyscale/ray-ml:2.9.0-py38-cpu', 'anyscale/ray-ml:2.9.0-py38-gpu', 'anyscale/ray-ml:2.9.0-py39-cpu', 'anyscale/ray-ml:2.9.0-py39-gpu', 'anyscale/ray-ml:2.9.1-py310-cpu', 'anyscale/ray-ml:2.9.1-py310-gpu', 'anyscale/ray-ml:2.9.1-py38-cpu', 'anyscale/ray-ml:2.9.1-py38-gpu', 'anyscale/ray-ml:2.9.1-py39-cpu', 'anyscale/ray-ml:2.9.1-py39-gpu', 'anyscale/ray-ml:2.9.2-py310-cpu', 'anyscale/ray-ml:2.9.2-py310-gpu', 'anyscale/ray-ml:2.9.2-py38-cpu', 'anyscale/ray-ml:2.9.2-py38-gpu', 'anyscale/ray-ml:2.9.2-py39-cpu', 'anyscale/ray-ml:2.9.2-py39-gpu', 'anyscale/ray-ml:2.9.3-py310-cpu', 'anyscale/ray-ml:2.9.3-py310-gpu', 'anyscale/ray-ml:2.9.3-py38-cpu', 'anyscale/ray-ml:2.9.3-py38-gpu', 'anyscale/ray-ml:2.9.3-py39-cpu', 'anyscale/ray-ml:2.9.3-py39-gpu', 'anyscale/ray-ml:nightly-py310-gpu', 'anyscale/ray-ml:nightly-py311-gpu', 'anyscale/ray-ml:nightly-py39-gpu', 'anyscale/ray:2.0.0-py310', 'anyscale/ray:2.0.0-py37', 'anyscale/ray:2.0.0-py37-cu101', 'anyscale/ray:2.0.0-py37-cu102', 'anyscale/ray:2.0.0-py37-cu110', 'anyscale/ray:2.0.0-py37-cu111', 'anyscale/ray:2.0.0-py37-cu112', 'anyscale/ray:2.0.0-py37-cu113', 'anyscale/ray:2.0.0-py38', 'anyscale/ray:2.0.0-py38-cu101', 'anyscale/ray:2.0.0-py38-cu102', 'anyscale/ray:2.0.0-py38-cu110', 'anyscale/ray:2.0.0-py38-cu111', 'anyscale/ray:2.0.0-py38-cu112', 'anyscale/ray:2.0.0-py38-cu113', 'anyscale/ray:2.0.0-py39', 'anyscale/ray:2.0.0-py39-cu101', 'anyscale/ray:2.0.0-py39-cu102', 'anyscale/ray:2.0.0-py39-cu110', 'anyscale/ray:2.0.0-py39-cu111', 'anyscale/ray:2.0.0-py39-cu112', 'anyscale/ray:2.0.0-py39-cu113', 'anyscale/ray:2.0.1-py310', 'anyscale/ray:2.0.1-py37', 'anyscale/ray:2.0.1-py37-cu101', 'anyscale/ray:2.0.1-py37-cu102', 'anyscale/ray:2.0.1-py37-cu110', 'anyscale/ray:2.0.1-py37-cu111', 'anyscale/ray:2.0.1-py37-cu112', 'anyscale/ray:2.0.1-py37-cu113', 'anyscale/ray:2.0.1-py37-cu116', 'anyscale/ray:2.0.1-py38', 'anyscale/ray:2.0.1-py38-cu101', 'anyscale/ray:2.0.1-py38-cu102', 'anyscale/ray:2.0.1-py38-cu110', 'anyscale/ray:2.0.1-py38-cu111', 'anyscale/ray:2.0.1-py38-cu112', 'anyscale/ray:2.0.1-py38-cu113', 'anyscale/ray:2.0.1-py38-cu116', 'anyscale/ray:2.0.1-py39', 'anyscale/ray:2.0.1-py39-cu101', 'anyscale/ray:2.0.1-py39-cu102', 'anyscale/ray:2.0.1-py39-cu110', 'anyscale/ray:2.0.1-py39-cu111', 'anyscale/ray:2.0.1-py39-cu112', 'anyscale/ray:2.0.1-py39-cu113', 'anyscale/ray:2.0.1-py39-cu116', 'anyscale/ray:2.1.0-py310', 'anyscale/ray:2.1.0-py310-cu101', 'anyscale/ray:2.1.0-py310-cu102', 'anyscale/ray:2.1.0-py310-cu110', 'anyscale/ray:2.1.0-py310-cu111', 'anyscale/ray:2.1.0-py310-cu112', 'anyscale/ray:2.1.0-py310-cu113', 'anyscale/ray:2.1.0-py310-cu116', 'anyscale/ray:2.1.0-py37', 'anyscale/ray:2.1.0-py37-cu101', 'anyscale/ray:2.1.0-py37-cu102', 'anyscale/ray:2.1.0-py37-cu110', 'anyscale/ray:2.1.0-py37-cu111', 'anyscale/ray:2.1.0-py37-cu112', 'anyscale/ray:2.1.0-py37-cu113', 'anyscale/ray:2.1.0-py37-cu116', 'anyscale/ray:2.1.0-py38', 'anyscale/ray:2.1.0-py38-cu101', 'anyscale/ray:2.1.0-py38-cu102', 'anyscale/ray:2.1.0-py38-cu110', 'anyscale/ray:2.1.0-py38-cu111', 'anyscale/ray:2.1.0-py38-cu112', 'anyscale/ray:2.1.0-py38-cu113', 'anyscale/ray:2.1.0-py38-cu116', 'anyscale/ray:2.1.0-py39', 'anyscale/ray:2.1.0-py39-cu101', 'anyscale/ray:2.1.0-py39-cu102', 'anyscale/ray:2.1.0-py39-cu110', 'anyscale/ray:2.1.0-py39-cu111', 'anyscale/ray:2.1.0-py39-cu112', 'anyscale/ray:2.1.0-py39-cu113', 'anyscale/ray:2.1.0-py39-cu116', 'anyscale/ray:2.10.0-py310', 'anyscale/ray:2.10.0-py310-cu115', 'anyscale/ray:2.10.0-py310-cu116', 'anyscale/ray:2.10.0-py310-cu117', 'anyscale/ray:2.10.0-py310-cu118', 'anyscale/ray:2.10.0-py310-cu121', 'anyscale/ray:2.10.0-py311', 'anyscale/ray:2.10.0-py311-cu115', 'anyscale/ray:2.10.0-py311-cu116', 'anyscale/ray:2.10.0-py311-cu117', 'anyscale/ray:2.10.0-py311-cu118', 'anyscale/ray:2.10.0-py311-cu121', 'anyscale/ray:2.10.0-py38', 'anyscale/ray:2.10.0-py38-cu115', 'anyscale/ray:2.10.0-py38-cu116', 'anyscale/ray:2.10.0-py38-cu117', 'anyscale/ray:2.10.0-py38-cu118', 'anyscale/ray:2.10.0-py38-cu121', 'anyscale/ray:2.10.0-py39', 'anyscale/ray:2.10.0-py39-cu115', 'anyscale/ray:2.10.0-py39-cu116', 'anyscale/ray:2.10.0-py39-cu117', 'anyscale/ray:2.10.0-py39-cu118', 'anyscale/ray:2.10.0-py39-cu121', 'anyscale/ray:2.11.0-py310', 'anyscale/ray:2.11.0-py310-cu115', 'anyscale/ray:2.11.0-py310-cu116', 'anyscale/ray:2.11.0-py310-cu117', 'anyscale/ray:2.11.0-py310-cu118', 'anyscale/ray:2.11.0-py310-cu121', 'anyscale/ray:2.11.0-py311', 'anyscale/ray:2.11.0-py311-cu115', 'anyscale/ray:2.11.0-py311-cu116', 'anyscale/ray:2.11.0-py311-cu117', 'anyscale/ray:2.11.0-py311-cu118', 'anyscale/ray:2.11.0-py311-cu121', 'anyscale/ray:2.11.0-py39', 'anyscale/ray:2.11.0-py39-cu115', 'anyscale/ray:2.11.0-py39-cu116', 'anyscale/ray:2.11.0-py39-cu117', 'anyscale/ray:2.11.0-py39-cu118', 'anyscale/ray:2.11.0-py39-cu121', 'anyscale/ray:2.12.0-py310', 'anyscale/ray:2.12.0-py310-cu115', 'anyscale/ray:2.12.0-py310-cu116', 'anyscale/ray:2.12.0-py310-cu117', 'anyscale/ray:2.12.0-py310-cu118', 'anyscale/ray:2.12.0-py310-cu121', 'anyscale/ray:2.12.0-py311', 'anyscale/ray:2.12.0-py311-cu115', 'anyscale/ray:2.12.0-py311-cu116', 'anyscale/ray:2.12.0-py311-cu117', 'anyscale/ray:2.12.0-py311-cu118', 'anyscale/ray:2.12.0-py311-cu121', 'anyscale/ray:2.12.0-py39', 'anyscale/ray:2.12.0-py39-cu115', 'anyscale/ray:2.12.0-py39-cu116', 'anyscale/ray:2.12.0-py39-cu117', 'anyscale/ray:2.12.0-py39-cu118', 'anyscale/ray:2.12.0-py39-cu121', 'anyscale/ray:2.2.0-py310', 'anyscale/ray:2.2.0-py310-cu101', 'anyscale/ray:2.2.0-py310-cu102', 'anyscale/ray:2.2.0-py310-cu110', 'anyscale/ray:2.2.0-py310-cu111', 'anyscale/ray:2.2.0-py310-cu112', 'anyscale/ray:2.2.0-py310-cu113', 'anyscale/ray:2.2.0-py310-cu116', 'anyscale/ray:2.2.0-py37', 'anyscale/ray:2.2.0-py37-cu101', 'anyscale/ray:2.2.0-py37-cu102', 'anyscale/ray:2.2.0-py37-cu110', 'anyscale/ray:2.2.0-py37-cu111', 'anyscale/ray:2.2.0-py37-cu112', 'anyscale/ray:2.2.0-py37-cu113', 'anyscale/ray:2.2.0-py37-cu116', 'anyscale/ray:2.2.0-py38', 'anyscale/ray:2.2.0-py38-cu101', 'anyscale/ray:2.2.0-py38-cu102', 'anyscale/ray:2.2.0-py38-cu110', 'anyscale/ray:2.2.0-py38-cu111', 'anyscale/ray:2.2.0-py38-cu112', 'anyscale/ray:2.2.0-py38-cu113', 'anyscale/ray:2.2.0-py38-cu116', 'anyscale/ray:2.2.0-py39', 'anyscale/ray:2.2.0-py39-cu101', 'anyscale/ray:2.2.0-py39-cu102', 'anyscale/ray:2.2.0-py39-cu110', 'anyscale/ray:2.2.0-py39-cu111', 'anyscale/ray:2.2.0-py39-cu112', 'anyscale/ray:2.2.0-py39-cu113', 'anyscale/ray:2.2.0-py39-cu116', 'anyscale/ray:2.20.0-py310', 'anyscale/ray:2.20.0-py310-cu115', 'anyscale/ray:2.20.0-py310-cu116', 'anyscale/ray:2.20.0-py310-cu117', 'anyscale/ray:2.20.0-py310-cu118', 'anyscale/ray:2.20.0-py310-cu121', 'anyscale/ray:2.20.0-py311', 'anyscale/ray:2.20.0-py311-cu115', 'anyscale/ray:2.20.0-py311-cu116', 'anyscale/ray:2.20.0-py311-cu117', 'anyscale/ray:2.20.0-py311-cu118', 'anyscale/ray:2.20.0-py311-cu121', 'anyscale/ray:2.20.0-py39', 'anyscale/ray:2.20.0-py39-cu115', 'anyscale/ray:2.20.0-py39-cu116', 'anyscale/ray:2.20.0-py39-cu117', 'anyscale/ray:2.20.0-py39-cu118', 'anyscale/ray:2.20.0-py39-cu121', 'anyscale/ray:2.21.0-py310', 'anyscale/ray:2.21.0-py310-cu115', 'anyscale/ray:2.21.0-py310-cu116', 'anyscale/ray:2.21.0-py310-cu117', 'anyscale/ray:2.21.0-py310-cu118', 'anyscale/ray:2.21.0-py310-cu121', 'anyscale/ray:2.21.0-py311', 'anyscale/ray:2.21.0-py311-cu115', 'anyscale/ray:2.21.0-py311-cu116', 'anyscale/ray:2.21.0-py311-cu117', 'anyscale/ray:2.21.0-py311-cu118', 'anyscale/ray:2.21.0-py311-cu121', 'anyscale/ray:2.21.0-py39', 'anyscale/ray:2.21.0-py39-cu115', 'anyscale/ray:2.21.0-py39-cu116', 'anyscale/ray:2.21.0-py39-cu117', 'anyscale/ray:2.21.0-py39-cu118', 'anyscale/ray:2.21.0-py39-cu121', 'anyscale/ray:2.21.0-slim-py310', 'anyscale/ray:2.21.0-slim-py310-cu118', 'anyscale/ray:2.21.0-slim-py310-cu121', 'anyscale/ray:2.21.0-slim-py311', 'anyscale/ray:2.21.0-slim-py311-cu118', 'anyscale/ray:2.21.0-slim-py311-cu121', 'anyscale/ray:2.21.0-slim-py39', 'anyscale/ray:2.21.0-slim-py39-cu118', 'anyscale/ray:2.21.0-slim-py39-cu121', 'anyscale/ray:2.22.0-py310', 'anyscale/ray:2.22.0-py310-cu115', 'anyscale/ray:2.22.0-py310-cu116', 'anyscale/ray:2.22.0-py310-cu117', 'anyscale/ray:2.22.0-py310-cu118', 'anyscale/ray:2.22.0-py310-cu121', 'anyscale/ray:2.22.0-py311', 'anyscale/ray:2.22.0-py311-cu115', 'anyscale/ray:2.22.0-py311-cu116', 'anyscale/ray:2.22.0-py311-cu117', 'anyscale/ray:2.22.0-py311-cu118', 'anyscale/ray:2.22.0-py311-cu121', 'anyscale/ray:2.22.0-py39', 'anyscale/ray:2.22.0-py39-cu115', 'anyscale/ray:2.22.0-py39-cu116', 'anyscale/ray:2.22.0-py39-cu117', 'anyscale/ray:2.22.0-py39-cu118', 'anyscale/ray:2.22.0-py39-cu121', 'anyscale/ray:2.22.0-slim-py310', 'anyscale/ray:2.22.0-slim-py310-cu118', 'anyscale/ray:2.22.0-slim-py310-cu121', 'anyscale/ray:2.22.0-slim-py311', 'anyscale/ray:2.22.0-slim-py311-cu118', 'anyscale/ray:2.22.0-slim-py311-cu121', 'anyscale/ray:2.22.0-slim-py39', 'anyscale/ray:2.22.0-slim-py39-cu118', 'anyscale/ray:2.22.0-slim-py39-cu121', 'anyscale/ray:2.23.0-py310', 'anyscale/ray:2.23.0-py310-cu115', 'anyscale/ray:2.23.0-py310-cu116', 'anyscale/ray:2.23.0-py310-cu117', 'anyscale/ray:2.23.0-py310-cu118', 'anyscale/ray:2.23.0-py310-cu121', 'anyscale/ray:2.23.0-py311', 'anyscale/ray:2.23.0-py311-cu115', 'anyscale/ray:2.23.0-py311-cu116', 'anyscale/ray:2.23.0-py311-cu117', 'anyscale/ray:2.23.0-py311-cu118', 'anyscale/ray:2.23.0-py311-cu121', 'anyscale/ray:2.23.0-py39', 'anyscale/ray:2.23.0-py39-cu115', 'anyscale/ray:2.23.0-py39-cu116', 'anyscale/ray:2.23.0-py39-cu117', 'anyscale/ray:2.23.0-py39-cu118', 'anyscale/ray:2.23.0-py39-cu121', 'anyscale/ray:2.23.0-slim-py310', 'anyscale/ray:2.23.0-slim-py310-cu118', 'anyscale/ray:2.23.0-slim-py310-cu121', 'anyscale/ray:2.23.0-slim-py311', 'anyscale/ray:2.23.0-slim-py311-cu118', 'anyscale/ray:2.23.0-slim-py311-cu121', 'anyscale/ray:2.23.0-slim-py39', 'anyscale/ray:2.23.0-slim-py39-cu118', 'anyscale/ray:2.23.0-slim-py39-cu121', 'anyscale/ray:2.24.0-py310', 'anyscale/ray:2.24.0-py310-cu115', 'anyscale/ray:2.24.0-py310-cu116', 'anyscale/ray:2.24.0-py310-cu117', 'anyscale/ray:2.24.0-py310-cu118', 'anyscale/ray:2.24.0-py310-cu121', 'anyscale/ray:2.24.0-py311', 'anyscale/ray:2.24.0-py311-cu115', 'anyscale/ray:2.24.0-py311-cu116', 'anyscale/ray:2.24.0-py311-cu117', 'anyscale/ray:2.24.0-py311-cu118', 'anyscale/ray:2.24.0-py311-cu121', 'anyscale/ray:2.24.0-py39', 'anyscale/ray:2.24.0-py39-cu115', 'anyscale/ray:2.24.0-py39-cu116', 'anyscale/ray:2.24.0-py39-cu117', 'anyscale/ray:2.24.0-py39-cu118', 'anyscale/ray:2.24.0-py39-cu121', 'anyscale/ray:2.24.0-slim-py310', 'anyscale/ray:2.24.0-slim-py310-cu118', 'anyscale/ray:2.24.0-slim-py310-cu121', 'anyscale/ray:2.24.0-slim-py311', 'anyscale/ray:2.24.0-slim-py311-cu118', 'anyscale/ray:2.24.0-slim-py311-cu121', 'anyscale/ray:2.24.0-slim-py39', 'anyscale/ray:2.24.0-slim-py39-cu118', 'anyscale/ray:2.24.0-slim-py39-cu121', 'anyscale/ray:2.3.0-py310', 'anyscale/ray:2.3.0-py310-cu101', 'anyscale/ray:2.3.0-py310-cu102', 'anyscale/ray:2.3.0-py310-cu110', 'anyscale/ray:2.3.0-py310-cu111', 'anyscale/ray:2.3.0-py310-cu112', 'anyscale/ray:2.3.0-py310-cu113', 'anyscale/ray:2.3.0-py310-cu116', 'anyscale/ray:2.3.0-py310-cu118', 'anyscale/ray:2.3.0-py37', 'anyscale/ray:2.3.0-py37-cu101', 'anyscale/ray:2.3.0-py37-cu102', 'anyscale/ray:2.3.0-py37-cu110', 'anyscale/ray:2.3.0-py37-cu111', 'anyscale/ray:2.3.0-py37-cu112', 'anyscale/ray:2.3.0-py37-cu113', 'anyscale/ray:2.3.0-py37-cu116', 'anyscale/ray:2.3.0-py37-cu118', 'anyscale/ray:2.3.0-py38', 'anyscale/ray:2.3.0-py38-cu101', 'anyscale/ray:2.3.0-py38-cu102', 'anyscale/ray:2.3.0-py38-cu110', 'anyscale/ray:2.3.0-py38-cu111', 'anyscale/ray:2.3.0-py38-cu112', 'anyscale/ray:2.3.0-py38-cu113', 'anyscale/ray:2.3.0-py38-cu116', 'anyscale/ray:2.3.0-py38-cu118', 'anyscale/ray:2.3.0-py39', 'anyscale/ray:2.3.0-py39-cu101', 'anyscale/ray:2.3.0-py39-cu102', 'anyscale/ray:2.3.0-py39-cu110', 'anyscale/ray:2.3.0-py39-cu111', 'anyscale/ray:2.3.0-py39-cu112', 'anyscale/ray:2.3.0-py39-cu113', 'anyscale/ray:2.3.0-py39-cu116', 'anyscale/ray:2.3.0-py39-cu118', 'anyscale/ray:2.3.1-py310', 'anyscale/ray:2.3.1-py310-cu101', 'anyscale/ray:2.3.1-py310-cu102', 'anyscale/ray:2.3.1-py310-cu110', 'anyscale/ray:2.3.1-py310-cu111', 'anyscale/ray:2.3.1-py310-cu112', 'anyscale/ray:2.3.1-py310-cu113', 'anyscale/ray:2.3.1-py310-cu116', 'anyscale/ray:2.3.1-py310-cu118', 'anyscale/ray:2.3.1-py37', 'anyscale/ray:2.3.1-py37-cu101', 'anyscale/ray:2.3.1-py37-cu102', 'anyscale/ray:2.3.1-py37-cu110', 'anyscale/ray:2.3.1-py37-cu111', 'anyscale/ray:2.3.1-py37-cu112', 'anyscale/ray:2.3.1-py37-cu113', 'anyscale/ray:2.3.1-py37-cu116', 'anyscale/ray:2.3.1-py37-cu118', 'anyscale/ray:2.3.1-py38', 'anyscale/ray:2.3.1-py38-cu101', 'anyscale/ray:2.3.1-py38-cu102', 'anyscale/ray:2.3.1-py38-cu110', 'anyscale/ray:2.3.1-py38-cu111', 'anyscale/ray:2.3.1-py38-cu112', 'anyscale/ray:2.3.1-py38-cu113', 'anyscale/ray:2.3.1-py38-cu116', 'anyscale/ray:2.3.1-py38-cu118', 'anyscale/ray:2.3.1-py39', 'anyscale/ray:2.3.1-py39-cu101', 'anyscale/ray:2.3.1-py39-cu102', 'anyscale/ray:2.3.1-py39-cu110', 'anyscale/ray:2.3.1-py39-cu111', 'anyscale/ray:2.3.1-py39-cu112', 'anyscale/ray:2.3.1-py39-cu113', 'anyscale/ray:2.3.1-py39-cu116', 'anyscale/ray:2.3.1-py39-cu118', 'anyscale/ray:2.30.0-py310', 'anyscale/ray:2.30.0-py310-cu117', 'anyscale/ray:2.30.0-py310-cu118', 'anyscale/ray:2.30.0-py310-cu121', 'anyscale/ray:2.30.0-py310-cu123', 'anyscale/ray:2.30.0-py311', 'anyscale/ray:2.30.0-py311-cu117', 'anyscale/ray:2.30.0-py311-cu118', 'anyscale/ray:2.30.0-py311-cu121', 'anyscale/ray:2.30.0-py311-cu123', 'anyscale/ray:2.30.0-py39', 'anyscale/ray:2.30.0-py39-cu117', 'anyscale/ray:2.30.0-py39-cu118', 'anyscale/ray:2.30.0-py39-cu121', 'anyscale/ray:2.30.0-py39-cu123', 'anyscale/ray:2.30.0-slim-py310', 'anyscale/ray:2.30.0-slim-py310-cu118', 'anyscale/ray:2.30.0-slim-py310-cu121', 'anyscale/ray:2.30.0-slim-py310-cu123', 'anyscale/ray:2.30.0-slim-py311', 'anyscale/ray:2.30.0-slim-py311-cu118', 'anyscale/ray:2.30.0-slim-py311-cu121', 'anyscale/ray:2.30.0-slim-py311-cu123', 'anyscale/ray:2.30.0-slim-py39', 'anyscale/ray:2.30.0-slim-py39-cu118', 'anyscale/ray:2.30.0-slim-py39-cu121', 'anyscale/ray:2.30.0-slim-py39-cu123', 'anyscale/ray:2.31.0-py310', 'anyscale/ray:2.31.0-py310-cu117', 'anyscale/ray:2.31.0-py310-cu118', 'anyscale/ray:2.31.0-py310-cu121', 'anyscale/ray:2.31.0-py310-cu123', 'anyscale/ray:2.31.0-py311', 'anyscale/ray:2.31.0-py311-cu117', 'anyscale/ray:2.31.0-py311-cu118', 'anyscale/ray:2.31.0-py311-cu121', 'anyscale/ray:2.31.0-py311-cu123', 'anyscale/ray:2.31.0-py39', 'anyscale/ray:2.31.0-py39-cu117', 'anyscale/ray:2.31.0-py39-cu118', 'anyscale/ray:2.31.0-py39-cu121', 'anyscale/ray:2.31.0-py39-cu123', 'anyscale/ray:2.31.0-slim-py310', 'anyscale/ray:2.31.0-slim-py310-cu118', 'anyscale/ray:2.31.0-slim-py310-cu121', 'anyscale/ray:2.31.0-slim-py310-cu123', 'anyscale/ray:2.31.0-slim-py311', 'anyscale/ray:2.31.0-slim-py311-cu118', 'anyscale/ray:2.31.0-slim-py311-cu121', 'anyscale/ray:2.31.0-slim-py311-cu123', 'anyscale/ray:2.31.0-slim-py39', 'anyscale/ray:2.31.0-slim-py39-cu118', 'anyscale/ray:2.31.0-slim-py39-cu121', 'anyscale/ray:2.31.0-slim-py39-cu123', 'anyscale/ray:2.32.0-py310', 'anyscale/ray:2.32.0-py310-cu117', 'anyscale/ray:2.32.0-py310-cu118', 'anyscale/ray:2.32.0-py310-cu121', 'anyscale/ray:2.32.0-py310-cu123', 'anyscale/ray:2.32.0-py311', 'anyscale/ray:2.32.0-py311-cu117', 'anyscale/ray:2.32.0-py311-cu118', 'anyscale/ray:2.32.0-py311-cu121', 'anyscale/ray:2.32.0-py311-cu123', 'anyscale/ray:2.32.0-py39', 'anyscale/ray:2.32.0-py39-cu117', 'anyscale/ray:2.32.0-py39-cu118', 'anyscale/ray:2.32.0-py39-cu121', 'anyscale/ray:2.32.0-py39-cu123', 'anyscale/ray:2.32.0-slim-py310', 'anyscale/ray:2.32.0-slim-py310-cu118', 'anyscale/ray:2.32.0-slim-py310-cu121', 'anyscale/ray:2.32.0-slim-py310-cu123', 'anyscale/ray:2.32.0-slim-py311', 'anyscale/ray:2.32.0-slim-py311-cu118', 'anyscale/ray:2.32.0-slim-py311-cu121', 'anyscale/ray:2.32.0-slim-py311-cu123', 'anyscale/ray:2.32.0-slim-py39', 'anyscale/ray:2.32.0-slim-py39-cu118', 'anyscale/ray:2.32.0-slim-py39-cu121', 'anyscale/ray:2.32.0-slim-py39-cu123', 'anyscale/ray:2.33.0-py310', 'anyscale/ray:2.33.0-py310-cu117', 'anyscale/ray:2.33.0-py310-cu118', 'anyscale/ray:2.33.0-py310-cu121', 'anyscale/ray:2.33.0-py310-cu123', 'anyscale/ray:2.33.0-py311', 'anyscale/ray:2.33.0-py311-cu117', 'anyscale/ray:2.33.0-py311-cu118', 'anyscale/ray:2.33.0-py311-cu121', 'anyscale/ray:2.33.0-py311-cu123', 'anyscale/ray:2.33.0-py39', 'anyscale/ray:2.33.0-py39-cu117', 'anyscale/ray:2.33.0-py39-cu118', 'anyscale/ray:2.33.0-py39-cu121', 'anyscale/ray:2.33.0-py39-cu123', 'anyscale/ray:2.33.0-slim-py310', 'anyscale/ray:2.33.0-slim-py310-cu118', 'anyscale/ray:2.33.0-slim-py310-cu121', 'anyscale/ray:2.33.0-slim-py310-cu123', 'anyscale/ray:2.33.0-slim-py311', 'anyscale/ray:2.33.0-slim-py311-cu118', 'anyscale/ray:2.33.0-slim-py311-cu121', 'anyscale/ray:2.33.0-slim-py311-cu123', 'anyscale/ray:2.33.0-slim-py39', 'anyscale/ray:2.33.0-slim-py39-cu118', 'anyscale/ray:2.33.0-slim-py39-cu121', 'anyscale/ray:2.33.0-slim-py39-cu123', 'anyscale/ray:2.34.0-py310', 'anyscale/ray:2.34.0-py310-cu117', 'anyscale/ray:2.34.0-py310-cu118', 'anyscale/ray:2.34.0-py310-cu121', 'anyscale/ray:2.34.0-py310-cu123', 'anyscale/ray:2.34.0-py311', 'anyscale/ray:2.34.0-py311-cu117', 'anyscale/ray:2.34.0-py311-cu118', 'anyscale/ray:2.34.0-py311-cu121', 'anyscale/ray:2.34.0-py311-cu123', 'anyscale/ray:2.34.0-py39', 'anyscale/ray:2.34.0-py39-cu117', 'anyscale/ray:2.34.0-py39-cu118', 'anyscale/ray:2.34.0-py39-cu121', 'anyscale/ray:2.34.0-py39-cu123', 'anyscale/ray:2.34.0-slim-py310', 'anyscale/ray:2.34.0-slim-py310-cu118', 'anyscale/ray:2.34.0-slim-py310-cu121', 'anyscale/ray:2.34.0-slim-py310-cu123', 'anyscale/ray:2.34.0-slim-py311', 'anyscale/ray:2.34.0-slim-py311-cu118', 'anyscale/ray:2.34.0-slim-py311-cu121', 'anyscale/ray:2.34.0-slim-py311-cu123', 'anyscale/ray:2.34.0-slim-py39', 'anyscale/ray:2.34.0-slim-py39-cu118', 'anyscale/ray:2.34.0-slim-py39-cu121', 'anyscale/ray:2.34.0-slim-py39-cu123', 'anyscale/ray:2.35.0-py310', 'anyscale/ray:2.35.0-py310-cu117', 'anyscale/ray:2.35.0-py310-cu118', 'anyscale/ray:2.35.0-py310-cu121', 'anyscale/ray:2.35.0-py310-cu123', 'anyscale/ray:2.35.0-py311', 'anyscale/ray:2.35.0-py311-cu117', 'anyscale/ray:2.35.0-py311-cu118', 'anyscale/ray:2.35.0-py311-cu121', 'anyscale/ray:2.35.0-py311-cu123', 'anyscale/ray:2.35.0-py312', 'anyscale/ray:2.35.0-py312-cu117', 'anyscale/ray:2.35.0-py312-cu118', 'anyscale/ray:2.35.0-py312-cu121', 'anyscale/ray:2.35.0-py312-cu123', 'anyscale/ray:2.35.0-py39', 'anyscale/ray:2.35.0-py39-cu117', 'anyscale/ray:2.35.0-py39-cu118', 'anyscale/ray:2.35.0-py39-cu121', 'anyscale/ray:2.35.0-py39-cu123', 'anyscale/ray:2.35.0-slim-py310', 'anyscale/ray:2.35.0-slim-py310-cu118', 'anyscale/ray:2.35.0-slim-py310-cu121', 'anyscale/ray:2.35.0-slim-py310-cu123', 'anyscale/ray:2.35.0-slim-py311', 'anyscale/ray:2.35.0-slim-py311-cu118', 'anyscale/ray:2.35.0-slim-py311-cu121', 'anyscale/ray:2.35.0-slim-py311-cu123', 'anyscale/ray:2.35.0-slim-py312', 'anyscale/ray:2.35.0-slim-py312-cu118', 'anyscale/ray:2.35.0-slim-py312-cu121', 'anyscale/ray:2.35.0-slim-py312-cu123', 'anyscale/ray:2.35.0-slim-py39', 'anyscale/ray:2.35.0-slim-py39-cu118', 'anyscale/ray:2.35.0-slim-py39-cu121', 'anyscale/ray:2.35.0-slim-py39-cu123', 'anyscale/ray:2.36.0-py310', 'anyscale/ray:2.36.0-py310-cu117', 'anyscale/ray:2.36.0-py310-cu118', 'anyscale/ray:2.36.0-py310-cu121', 'anyscale/ray:2.36.0-py310-cu123', 'anyscale/ray:2.36.0-py311', 'anyscale/ray:2.36.0-py311-cu117', 'anyscale/ray:2.36.0-py311-cu118', 'anyscale/ray:2.36.0-py311-cu121', 'anyscale/ray:2.36.0-py311-cu123', 'anyscale/ray:2.36.0-py312', 'anyscale/ray:2.36.0-py312-cu117', 'anyscale/ray:2.36.0-py312-cu118', 'anyscale/ray:2.36.0-py312-cu121', 'anyscale/ray:2.36.0-py312-cu123', 'anyscale/ray:2.36.0-py39', 'anyscale/ray:2.36.0-py39-cu117', 'anyscale/ray:2.36.0-py39-cu118', 'anyscale/ray:2.36.0-py39-cu121', 'anyscale/ray:2.36.0-py39-cu123', 'anyscale/ray:2.36.0-slim-py310', 'anyscale/ray:2.36.0-slim-py310-cu118', 'anyscale/ray:2.36.0-slim-py310-cu121', 'anyscale/ray:2.36.0-slim-py310-cu123', 'anyscale/ray:2.36.0-slim-py311', 'anyscale/ray:2.36.0-slim-py311-cu118', 'anyscale/ray:2.36.0-slim-py311-cu121', 'anyscale/ray:2.36.0-slim-py311-cu123', 'anyscale/ray:2.36.0-slim-py312', 'anyscale/ray:2.36.0-slim-py312-cu118', 'anyscale/ray:2.36.0-slim-py312-cu121', 'anyscale/ray:2.36.0-slim-py312-cu123', 'anyscale/ray:2.36.0-slim-py39', 'anyscale/ray:2.36.0-slim-py39-cu118', 'anyscale/ray:2.36.0-slim-py39-cu121', 'anyscale/ray:2.36.0-slim-py39-cu123', 'anyscale/ray:2.36.1-py310', 'anyscale/ray:2.36.1-py310-cu117', 'anyscale/ray:2.36.1-py310-cu118', 'anyscale/ray:2.36.1-py310-cu121', 'anyscale/ray:2.36.1-py310-cu123', 'anyscale/ray:2.36.1-py311', 'anyscale/ray:2.36.1-py311-cu117', 'anyscale/ray:2.36.1-py311-cu118', 'anyscale/ray:2.36.1-py311-cu121', 'anyscale/ray:2.36.1-py311-cu123', 'anyscale/ray:2.36.1-py312', 'anyscale/ray:2.36.1-py312-cu117', 'anyscale/ray:2.36.1-py312-cu118', 'anyscale/ray:2.36.1-py312-cu121', 'anyscale/ray:2.36.1-py312-cu123', 'anyscale/ray:2.36.1-py39', 'anyscale/ray:2.36.1-py39-cu117', 'anyscale/ray:2.36.1-py39-cu118', 'anyscale/ray:2.36.1-py39-cu121', 'anyscale/ray:2.36.1-py39-cu123', 'anyscale/ray:2.36.1-slim-py310', 'anyscale/ray:2.36.1-slim-py310-cu118', 'anyscale/ray:2.36.1-slim-py310-cu121', 'anyscale/ray:2.36.1-slim-py310-cu123', 'anyscale/ray:2.36.1-slim-py311', 'anyscale/ray:2.36.1-slim-py311-cu118', 'anyscale/ray:2.36.1-slim-py311-cu121', 'anyscale/ray:2.36.1-slim-py311-cu123', 'anyscale/ray:2.36.1-slim-py312', 'anyscale/ray:2.36.1-slim-py312-cu118', 'anyscale/ray:2.36.1-slim-py312-cu121', 'anyscale/ray:2.36.1-slim-py312-cu123', 'anyscale/ray:2.36.1-slim-py39', 'anyscale/ray:2.36.1-slim-py39-cu118', 'anyscale/ray:2.36.1-slim-py39-cu121', 'anyscale/ray:2.36.1-slim-py39-cu123', 'anyscale/ray:2.37.0-py310', 'anyscale/ray:2.37.0-py310-cu117', 'anyscale/ray:2.37.0-py310-cu118', 'anyscale/ray:2.37.0-py310-cu121', 'anyscale/ray:2.37.0-py310-cu123', 'anyscale/ray:2.37.0-py311', 'anyscale/ray:2.37.0-py311-cu117', 'anyscale/ray:2.37.0-py311-cu118', 'anyscale/ray:2.37.0-py311-cu121', 'anyscale/ray:2.37.0-py311-cu123', 'anyscale/ray:2.37.0-py312', 'anyscale/ray:2.37.0-py312-cu117', 'anyscale/ray:2.37.0-py312-cu118', 'anyscale/ray:2.37.0-py312-cu121', 'anyscale/ray:2.37.0-py312-cu123', 'anyscale/ray:2.37.0-py39', 'anyscale/ray:2.37.0-py39-cu117', 'anyscale/ray:2.37.0-py39-cu118', 'anyscale/ray:2.37.0-py39-cu121', 'anyscale/ray:2.37.0-py39-cu123', 'anyscale/ray:2.37.0-slim-py310', 'anyscale/ray:2.37.0-slim-py310-cu118', 'anyscale/ray:2.37.0-slim-py310-cu121', 'anyscale/ray:2.37.0-slim-py310-cu123', 'anyscale/ray:2.37.0-slim-py311', 'anyscale/ray:2.37.0-slim-py311-cu118', 'anyscale/ray:2.37.0-slim-py311-cu121', 'anyscale/ray:2.37.0-slim-py311-cu123', 'anyscale/ray:2.37.0-slim-py312', 'anyscale/ray:2.37.0-slim-py312-cu118', 'anyscale/ray:2.37.0-slim-py312-cu121', 'anyscale/ray:2.37.0-slim-py312-cu123', 'anyscale/ray:2.37.0-slim-py39', 'anyscale/ray:2.37.0-slim-py39-cu118', 'anyscale/ray:2.37.0-slim-py39-cu121', 'anyscale/ray:2.37.0-slim-py39-cu123', 'anyscale/ray:2.38.0-py310', 'anyscale/ray:2.38.0-py310-cu117', 'anyscale/ray:2.38.0-py310-cu118', 'anyscale/ray:2.38.0-py310-cu121', 'anyscale/ray:2.38.0-py310-cu123', 'anyscale/ray:2.38.0-py311', 'anyscale/ray:2.38.0-py311-cu117', 'anyscale/ray:2.38.0-py311-cu118', 'anyscale/ray:2.38.0-py311-cu121', 'anyscale/ray:2.38.0-py311-cu123', 'anyscale/ray:2.38.0-py312', 'anyscale/ray:2.38.0-py312-cu117', 'anyscale/ray:2.38.0-py312-cu118', 'anyscale/ray:2.38.0-py312-cu121', 'anyscale/ray:2.38.0-py312-cu123', 'anyscale/ray:2.38.0-py39', 'anyscale/ray:2.38.0-py39-cu117', 'anyscale/ray:2.38.0-py39-cu118', 'anyscale/ray:2.38.0-py39-cu121', 'anyscale/ray:2.38.0-py39-cu123', 'anyscale/ray:2.38.0-slim-py310', 'anyscale/ray:2.38.0-slim-py310-cu118', 'anyscale/ray:2.38.0-slim-py310-cu121', 'anyscale/ray:2.38.0-slim-py310-cu123', 'anyscale/ray:2.38.0-slim-py311', 'anyscale/ray:2.38.0-slim-py311-cu118', 'anyscale/ray:2.38.0-slim-py311-cu121', 'anyscale/ray:2.38.0-slim-py311-cu123', 'anyscale/ray:2.38.0-slim-py312', 'anyscale/ray:2.38.0-slim-py312-cu118', 'anyscale/ray:2.38.0-slim-py312-cu121', 'anyscale/ray:2.38.0-slim-py312-cu123', 'anyscale/ray:2.38.0-slim-py39', 'anyscale/ray:2.38.0-slim-py39-cu118', 'anyscale/ray:2.38.0-slim-py39-cu121', 'anyscale/ray:2.38.0-slim-py39-cu123', 'anyscale/ray:2.39.0-py310', 'anyscale/ray:2.39.0-py310-cu117', 'anyscale/ray:2.39.0-py310-cu118', 'anyscale/ray:2.39.0-py310-cu121', 'anyscale/ray:2.39.0-py310-cu123', 'anyscale/ray:2.39.0-py311', 'anyscale/ray:2.39.0-py311-cu117', 'anyscale/ray:2.39.0-py311-cu118', 'anyscale/ray:2.39.0-py311-cu121', 'anyscale/ray:2.39.0-py311-cu123', 'anyscale/ray:2.39.0-py312', 'anyscale/ray:2.39.0-py312-cu117', 'anyscale/ray:2.39.0-py312-cu118', 'anyscale/ray:2.39.0-py312-cu121', 'anyscale/ray:2.39.0-py312-cu123', 'anyscale/ray:2.39.0-py39', 'anyscale/ray:2.39.0-py39-cu117', 'anyscale/ray:2.39.0-py39-cu118', 'anyscale/ray:2.39.0-py39-cu121', 'anyscale/ray:2.39.0-py39-cu123', 'anyscale/ray:2.39.0-slim-py310', 'anyscale/ray:2.39.0-slim-py310-cu118', 'anyscale/ray:2.39.0-slim-py310-cu121', 'anyscale/ray:2.39.0-slim-py310-cu123', 'anyscale/ray:2.39.0-slim-py311', 'anyscale/ray:2.39.0-slim-py311-cu118', 'anyscale/ray:2.39.0-slim-py311-cu121', 'anyscale/ray:2.39.0-slim-py311-cu123', 'anyscale/ray:2.39.0-slim-py312', 'anyscale/ray:2.39.0-slim-py312-cu118', 'anyscale/ray:2.39.0-slim-py312-cu121', 'anyscale/ray:2.39.0-slim-py312-cu123', 'anyscale/ray:2.39.0-slim-py39', 'anyscale/ray:2.39.0-slim-py39-cu118', 'anyscale/ray:2.39.0-slim-py39-cu121', 'anyscale/ray:2.39.0-slim-py39-cu123', 'anyscale/ray:2.4.0-py310', 'anyscale/ray:2.4.0-py310-cu101', 'anyscale/ray:2.4.0-py310-cu102', 'anyscale/ray:2.4.0-py310-cu110', 'anyscale/ray:2.4.0-py310-cu111', 'anyscale/ray:2.4.0-py310-cu112', 'anyscale/ray:2.4.0-py310-cu113', 'anyscale/ray:2.4.0-py310-cu116', 'anyscale/ray:2.4.0-py310-cu118', 'anyscale/ray:2.4.0-py37', 'anyscale/ray:2.4.0-py37-cu101', 'anyscale/ray:2.4.0-py37-cu102', 'anyscale/ray:2.4.0-py37-cu110', 'anyscale/ray:2.4.0-py37-cu111', 'anyscale/ray:2.4.0-py37-cu112', 'anyscale/ray:2.4.0-py37-cu113', 'anyscale/ray:2.4.0-py37-cu116', 'anyscale/ray:2.4.0-py37-cu118', 'anyscale/ray:2.4.0-py38', 'anyscale/ray:2.4.0-py38-cu101', 'anyscale/ray:2.4.0-py38-cu102', 'anyscale/ray:2.4.0-py38-cu110', 'anyscale/ray:2.4.0-py38-cu111', 'anyscale/ray:2.4.0-py38-cu112', 'anyscale/ray:2.4.0-py38-cu113', 'anyscale/ray:2.4.0-py38-cu116', 'anyscale/ray:2.4.0-py38-cu118', 'anyscale/ray:2.4.0-py39', 'anyscale/ray:2.4.0-py39-cu101', 'anyscale/ray:2.4.0-py39-cu102', 'anyscale/ray:2.4.0-py39-cu110', 'anyscale/ray:2.4.0-py39-cu111', 'anyscale/ray:2.4.0-py39-cu112', 'anyscale/ray:2.4.0-py39-cu113', 'anyscale/ray:2.4.0-py39-cu116', 'anyscale/ray:2.4.0-py39-cu118', 'anyscale/ray:2.40.0-py310', 'anyscale/ray:2.40.0-py310-cu117', 'anyscale/ray:2.40.0-py310-cu118', 'anyscale/ray:2.40.0-py310-cu121', 'anyscale/ray:2.40.0-py310-cu123', 'anyscale/ray:2.40.0-py311', 'anyscale/ray:2.40.0-py311-cu117', 'anyscale/ray:2.40.0-py311-cu118', 'anyscale/ray:2.40.0-py311-cu121', 'anyscale/ray:2.40.0-py311-cu123', 'anyscale/ray:2.40.0-py312', 'anyscale/ray:2.40.0-py312-cu117', 'anyscale/ray:2.40.0-py312-cu118', 'anyscale/ray:2.40.0-py312-cu121', 'anyscale/ray:2.40.0-py312-cu123', 'anyscale/ray:2.40.0-py39', 'anyscale/ray:2.40.0-py39-cu117', 'anyscale/ray:2.40.0-py39-cu118', 'anyscale/ray:2.40.0-py39-cu121', 'anyscale/ray:2.40.0-py39-cu123', 'anyscale/ray:2.40.0-slim-py310', 'anyscale/ray:2.40.0-slim-py310-cu118', 'anyscale/ray:2.40.0-slim-py310-cu121', 'anyscale/ray:2.40.0-slim-py310-cu123', 'anyscale/ray:2.40.0-slim-py311', 'anyscale/ray:2.40.0-slim-py311-cu118', 'anyscale/ray:2.40.0-slim-py311-cu121', 'anyscale/ray:2.40.0-slim-py311-cu123', 'anyscale/ray:2.40.0-slim-py312', 'anyscale/ray:2.40.0-slim-py312-cu118', 'anyscale/ray:2.40.0-slim-py312-cu121', 'anyscale/ray:2.40.0-slim-py312-cu123', 'anyscale/ray:2.40.0-slim-py39', 'anyscale/ray:2.40.0-slim-py39-cu118', 'anyscale/ray:2.40.0-slim-py39-cu121', 'anyscale/ray:2.40.0-slim-py39-cu123', 'anyscale/ray:2.41.0-py310', 'anyscale/ray:2.41.0-py310-cu117', 'anyscale/ray:2.41.0-py310-cu118', 'anyscale/ray:2.41.0-py310-cu121', 'anyscale/ray:2.41.0-py310-cu123', 'anyscale/ray:2.41.0-py311', 'anyscale/ray:2.41.0-py311-cu117', 'anyscale/ray:2.41.0-py311-cu118', 'anyscale/ray:2.41.0-py311-cu121', 'anyscale/ray:2.41.0-py311-cu123', 'anyscale/ray:2.41.0-py312', 'anyscale/ray:2.41.0-py312-cu117', 'anyscale/ray:2.41.0-py312-cu118', 'anyscale/ray:2.41.0-py312-cu121', 'anyscale/ray:2.41.0-py312-cu123', 'anyscale/ray:2.41.0-py39', 'anyscale/ray:2.41.0-py39-cu117', 'anyscale/ray:2.41.0-py39-cu118', 'anyscale/ray:2.41.0-py39-cu121', 'anyscale/ray:2.41.0-py39-cu123', 'anyscale/ray:2.41.0-slim-py310', 'anyscale/ray:2.41.0-slim-py310-cu118', 'anyscale/ray:2.41.0-slim-py310-cu121', 'anyscale/ray:2.41.0-slim-py310-cu123', 'anyscale/ray:2.41.0-slim-py311', 'anyscale/ray:2.41.0-slim-py311-cu118', 'anyscale/ray:2.41.0-slim-py311-cu121', 'anyscale/ray:2.41.0-slim-py311-cu123', 'anyscale/ray:2.41.0-slim-py312', 'anyscale/ray:2.41.0-slim-py312-cu118', 'anyscale/ray:2.41.0-slim-py312-cu121', 'anyscale/ray:2.41.0-slim-py312-cu123', 'anyscale/ray:2.41.0-slim-py39', 'anyscale/ray:2.41.0-slim-py39-cu118', 'anyscale/ray:2.41.0-slim-py39-cu121', 'anyscale/ray:2.41.0-slim-py39-cu123', 'anyscale/ray:2.42.0-py310', 'anyscale/ray:2.42.0-py310-cu117', 'anyscale/ray:2.42.0-py310-cu118', 'anyscale/ray:2.42.0-py310-cu121', 'anyscale/ray:2.42.0-py310-cu123', 'anyscale/ray:2.42.0-py310-cu124', 'anyscale/ray:2.42.0-py311', 'anyscale/ray:2.42.0-py311-cu117', 'anyscale/ray:2.42.0-py311-cu118', 'anyscale/ray:2.42.0-py311-cu121', 'anyscale/ray:2.42.0-py311-cu123', 'anyscale/ray:2.42.0-py311-cu124', 'anyscale/ray:2.42.0-py312', 'anyscale/ray:2.42.0-py312-cu117', 'anyscale/ray:2.42.0-py312-cu118', 'anyscale/ray:2.42.0-py312-cu121', 'anyscale/ray:2.42.0-py312-cu123', 'anyscale/ray:2.42.0-py312-cu124', 'anyscale/ray:2.42.0-py39', 'anyscale/ray:2.42.0-py39-cu117', 'anyscale/ray:2.42.0-py39-cu118', 'anyscale/ray:2.42.0-py39-cu121', 'anyscale/ray:2.42.0-py39-cu123', 'anyscale/ray:2.42.0-py39-cu124', 'anyscale/ray:2.42.0-slim-py310', 'anyscale/ray:2.42.0-slim-py310-cu118', 'anyscale/ray:2.42.0-slim-py310-cu121', 'anyscale/ray:2.42.0-slim-py310-cu123', 'anyscale/ray:2.42.0-slim-py310-cu124', 'anyscale/ray:2.42.0-slim-py311', 'anyscale/ray:2.42.0-slim-py311-cu118', 'anyscale/ray:2.42.0-slim-py311-cu121', 'anyscale/ray:2.42.0-slim-py311-cu123', 'anyscale/ray:2.42.0-slim-py311-cu124', 'anyscale/ray:2.42.0-slim-py312', 'anyscale/ray:2.42.0-slim-py312-cu118', 'anyscale/ray:2.42.0-slim-py312-cu121', 'anyscale/ray:2.42.0-slim-py312-cu123', 'anyscale/ray:2.42.0-slim-py312-cu124', 'anyscale/ray:2.42.0-slim-py39', 'anyscale/ray:2.42.0-slim-py39-cu118', 'anyscale/ray:2.42.0-slim-py39-cu121', 'anyscale/ray:2.42.0-slim-py39-cu123', 'anyscale/ray:2.42.0-slim-py39-cu124', 'anyscale/ray:2.42.1-py310', 'anyscale/ray:2.42.1-py310-cu117', 'anyscale/ray:2.42.1-py310-cu118', 'anyscale/ray:2.42.1-py310-cu121', 'anyscale/ray:2.42.1-py310-cu123', 'anyscale/ray:2.42.1-py310-cu124', 'anyscale/ray:2.42.1-py311', 'anyscale/ray:2.42.1-py311-cu117', 'anyscale/ray:2.42.1-py311-cu118', 'anyscale/ray:2.42.1-py311-cu121', 'anyscale/ray:2.42.1-py311-cu123', 'anyscale/ray:2.42.1-py311-cu124', 'anyscale/ray:2.42.1-py312', 'anyscale/ray:2.42.1-py312-cu117', 'anyscale/ray:2.42.1-py312-cu118', 'anyscale/ray:2.42.1-py312-cu121', 'anyscale/ray:2.42.1-py312-cu123', 'anyscale/ray:2.42.1-py312-cu124', 'anyscale/ray:2.42.1-py39', 'anyscale/ray:2.42.1-py39-cu117', 'anyscale/ray:2.42.1-py39-cu118', 'anyscale/ray:2.42.1-py39-cu121', 'anyscale/ray:2.42.1-py39-cu123', 'anyscale/ray:2.42.1-py39-cu124', 'anyscale/ray:2.42.1-slim-py310', 'anyscale/ray:2.42.1-slim-py310-cu118', 'anyscale/ray:2.42.1-slim-py310-cu121', 'anyscale/ray:2.42.1-slim-py310-cu123', 'anyscale/ray:2.42.1-slim-py310-cu124', 'anyscale/ray:2.42.1-slim-py311', 'anyscale/ray:2.42.1-slim-py311-cu118', 'anyscale/ray:2.42.1-slim-py311-cu121', 'anyscale/ray:2.42.1-slim-py311-cu123', 'anyscale/ray:2.42.1-slim-py311-cu124', 'anyscale/ray:2.42.1-slim-py312', 'anyscale/ray:2.42.1-slim-py312-cu118', 'anyscale/ray:2.42.1-slim-py312-cu121', 'anyscale/ray:2.42.1-slim-py312-cu123', 'anyscale/ray:2.42.1-slim-py312-cu124', 'anyscale/ray:2.42.1-slim-py39', 'anyscale/ray:2.42.1-slim-py39-cu118', 'anyscale/ray:2.42.1-slim-py39-cu121', 'anyscale/ray:2.42.1-slim-py39-cu123', 'anyscale/ray:2.42.1-slim-py39-cu124', 'anyscale/ray:2.43.0-py310', 'anyscale/ray:2.43.0-py310-cu117', 'anyscale/ray:2.43.0-py310-cu118', 'anyscale/ray:2.43.0-py310-cu121', 'anyscale/ray:2.43.0-py310-cu123', 'anyscale/ray:2.43.0-py310-cu124', 'anyscale/ray:2.43.0-py310-cu125', 'anyscale/ray:2.43.0-py311', 'anyscale/ray:2.43.0-py311-cu117', 'anyscale/ray:2.43.0-py311-cu118', 'anyscale/ray:2.43.0-py311-cu121', 'anyscale/ray:2.43.0-py311-cu123', 'anyscale/ray:2.43.0-py311-cu124', 'anyscale/ray:2.43.0-py311-cu125', 'anyscale/ray:2.43.0-py312', 'anyscale/ray:2.43.0-py312-cu117', 'anyscale/ray:2.43.0-py312-cu118', 'anyscale/ray:2.43.0-py312-cu121', 'anyscale/ray:2.43.0-py312-cu123', 'anyscale/ray:2.43.0-py312-cu124', 'anyscale/ray:2.43.0-py312-cu125', 'anyscale/ray:2.43.0-py39', 'anyscale/ray:2.43.0-py39-cu117', 'anyscale/ray:2.43.0-py39-cu118', 'anyscale/ray:2.43.0-py39-cu121', 'anyscale/ray:2.43.0-py39-cu123', 'anyscale/ray:2.43.0-py39-cu124', 'anyscale/ray:2.43.0-py39-cu125', 'anyscale/ray:2.43.0-slim-py310', 'anyscale/ray:2.43.0-slim-py310-cu118', 'anyscale/ray:2.43.0-slim-py310-cu121', 'anyscale/ray:2.43.0-slim-py310-cu123', 'anyscale/ray:2.43.0-slim-py310-cu124', 'anyscale/ray:2.43.0-slim-py310-cu125', 'anyscale/ray:2.43.0-slim-py311', 'anyscale/ray:2.43.0-slim-py311-cu118', 'anyscale/ray:2.43.0-slim-py311-cu121', 'anyscale/ray:2.43.0-slim-py311-cu123', 'anyscale/ray:2.43.0-slim-py311-cu124', 'anyscale/ray:2.43.0-slim-py311-cu125', 'anyscale/ray:2.43.0-slim-py312', 'anyscale/ray:2.43.0-slim-py312-cu118', 'anyscale/ray:2.43.0-slim-py312-cu121', 'anyscale/ray:2.43.0-slim-py312-cu123', 'anyscale/ray:2.43.0-slim-py312-cu124', 'anyscale/ray:2.43.0-slim-py312-cu125', 'anyscale/ray:2.43.0-slim-py39', 'anyscale/ray:2.43.0-slim-py39-cu118', 'anyscale/ray:2.43.0-slim-py39-cu121', 'anyscale/ray:2.43.0-slim-py39-cu123', 'anyscale/ray:2.43.0-slim-py39-cu124', 'anyscale/ray:2.43.0-slim-py39-cu125', 'anyscale/ray:2.44.0-py310', 'anyscale/ray:2.44.0-py310-cu117', 'anyscale/ray:2.44.0-py310-cu118', 'anyscale/ray:2.44.0-py310-cu121', 'anyscale/ray:2.44.0-py310-cu123', 'anyscale/ray:2.44.0-py310-cu124', 'anyscale/ray:2.44.0-py310-cu125', 'anyscale/ray:2.44.0-py310-cu128', 'anyscale/ray:2.44.0-py311', 'anyscale/ray:2.44.0-py311-cu117', 'anyscale/ray:2.44.0-py311-cu118', 'anyscale/ray:2.44.0-py311-cu121', 'anyscale/ray:2.44.0-py311-cu123', 'anyscale/ray:2.44.0-py311-cu124', 'anyscale/ray:2.44.0-py311-cu125', 'anyscale/ray:2.44.0-py311-cu128', 'anyscale/ray:2.44.0-py312', 'anyscale/ray:2.44.0-py312-cu117', 'anyscale/ray:2.44.0-py312-cu118', 'anyscale/ray:2.44.0-py312-cu121', 'anyscale/ray:2.44.0-py312-cu123', 'anyscale/ray:2.44.0-py312-cu124', 'anyscale/ray:2.44.0-py312-cu125', 'anyscale/ray:2.44.0-py312-cu128', 'anyscale/ray:2.44.0-py39', 'anyscale/ray:2.44.0-py39-cu117', 'anyscale/ray:2.44.0-py39-cu118', 'anyscale/ray:2.44.0-py39-cu121', 'anyscale/ray:2.44.0-py39-cu123', 'anyscale/ray:2.44.0-py39-cu124', 'anyscale/ray:2.44.0-py39-cu125', 'anyscale/ray:2.44.0-py39-cu128', 'anyscale/ray:2.44.0-slim-py310', 'anyscale/ray:2.44.0-slim-py310-cu118', 'anyscale/ray:2.44.0-slim-py310-cu121', 'anyscale/ray:2.44.0-slim-py310-cu123', 'anyscale/ray:2.44.0-slim-py310-cu124', 'anyscale/ray:2.44.0-slim-py310-cu125', 'anyscale/ray:2.44.0-slim-py310-cu128', 'anyscale/ray:2.44.0-slim-py311', 'anyscale/ray:2.44.0-slim-py311-cu118', 'anyscale/ray:2.44.0-slim-py311-cu121', 'anyscale/ray:2.44.0-slim-py311-cu123', 'anyscale/ray:2.44.0-slim-py311-cu124', 'anyscale/ray:2.44.0-slim-py311-cu125', 'anyscale/ray:2.44.0-slim-py311-cu128', 'anyscale/ray:2.44.0-slim-py312', 'anyscale/ray:2.44.0-slim-py312-cu118', 'anyscale/ray:2.44.0-slim-py312-cu121', 'anyscale/ray:2.44.0-slim-py312-cu123', 'anyscale/ray:2.44.0-slim-py312-cu124', 'anyscale/ray:2.44.0-slim-py312-cu125', 'anyscale/ray:2.44.0-slim-py312-cu128', 'anyscale/ray:2.44.0-slim-py39', 'anyscale/ray:2.44.0-slim-py39-cu118', 'anyscale/ray:2.44.0-slim-py39-cu121', 'anyscale/ray:2.44.0-slim-py39-cu123', 'anyscale/ray:2.44.0-slim-py39-cu124', 'anyscale/ray:2.44.0-slim-py39-cu125', 'anyscale/ray:2.44.0-slim-py39-cu128', 'anyscale/ray:2.44.1-py310', 'anyscale/ray:2.44.1-py310-cu117', 'anyscale/ray:2.44.1-py310-cu118', 'anyscale/ray:2.44.1-py310-cu121', 'anyscale/ray:2.44.1-py310-cu123', 'anyscale/ray:2.44.1-py310-cu124', 'anyscale/ray:2.44.1-py310-cu125', 'anyscale/ray:2.44.1-py310-cu128', 'anyscale/ray:2.44.1-py311', 'anyscale/ray:2.44.1-py311-cu117', 'anyscale/ray:2.44.1-py311-cu118', 'anyscale/ray:2.44.1-py311-cu121', 'anyscale/ray:2.44.1-py311-cu123', 'anyscale/ray:2.44.1-py311-cu124', 'anyscale/ray:2.44.1-py311-cu125', 'anyscale/ray:2.44.1-py311-cu128', 'anyscale/ray:2.44.1-py312', 'anyscale/ray:2.44.1-py312-cu117', 'anyscale/ray:2.44.1-py312-cu118', 'anyscale/ray:2.44.1-py312-cu121', 'anyscale/ray:2.44.1-py312-cu123', 'anyscale/ray:2.44.1-py312-cu124', 'anyscale/ray:2.44.1-py312-cu125', 'anyscale/ray:2.44.1-py312-cu128', 'anyscale/ray:2.44.1-py39', 'anyscale/ray:2.44.1-py39-cu117', 'anyscale/ray:2.44.1-py39-cu118', 'anyscale/ray:2.44.1-py39-cu121', 'anyscale/ray:2.44.1-py39-cu123', 'anyscale/ray:2.44.1-py39-cu124', 'anyscale/ray:2.44.1-py39-cu125', 'anyscale/ray:2.44.1-py39-cu128', 'anyscale/ray:2.44.1-slim-py310', 'anyscale/ray:2.44.1-slim-py310-cu118', 'anyscale/ray:2.44.1-slim-py310-cu121', 'anyscale/ray:2.44.1-slim-py310-cu123', 'anyscale/ray:2.44.1-slim-py310-cu124', 'anyscale/ray:2.44.1-slim-py310-cu125', 'anyscale/ray:2.44.1-slim-py310-cu128', 'anyscale/ray:2.44.1-slim-py311', 'anyscale/ray:2.44.1-slim-py311-cu118', 'anyscale/ray:2.44.1-slim-py311-cu121', 'anyscale/ray:2.44.1-slim-py311-cu123', 'anyscale/ray:2.44.1-slim-py311-cu124', 'anyscale/ray:2.44.1-slim-py311-cu125', 'anyscale/ray:2.44.1-slim-py311-cu128', 'anyscale/ray:2.44.1-slim-py312', 'anyscale/ray:2.44.1-slim-py312-cu118', 'anyscale/ray:2.44.1-slim-py312-cu121', 'anyscale/ray:2.44.1-slim-py312-cu123', 'anyscale/ray:2.44.1-slim-py312-cu124', 'anyscale/ray:2.44.1-slim-py312-cu125', 'anyscale/ray:2.44.1-slim-py312-cu128', 'anyscale/ray:2.44.1-slim-py39', 'anyscale/ray:2.44.1-slim-py39-cu118', 'anyscale/ray:2.44.1-slim-py39-cu121', 'anyscale/ray:2.44.1-slim-py39-cu123', 'anyscale/ray:2.44.1-slim-py39-cu124', 'anyscale/ray:2.44.1-slim-py39-cu125', 'anyscale/ray:2.44.1-slim-py39-cu128', 'anyscale/ray:2.45.0-py310', 'anyscale/ray:2.45.0-py310-cu117', 'anyscale/ray:2.45.0-py310-cu118', 'anyscale/ray:2.45.0-py310-cu121', 'anyscale/ray:2.45.0-py310-cu123', 'anyscale/ray:2.45.0-py310-cu124', 'anyscale/ray:2.45.0-py310-cu125', 'anyscale/ray:2.45.0-py310-cu128', 'anyscale/ray:2.45.0-py311', 'anyscale/ray:2.45.0-py311-cu117', 'anyscale/ray:2.45.0-py311-cu118', 'anyscale/ray:2.45.0-py311-cu121', 'anyscale/ray:2.45.0-py311-cu123', 'anyscale/ray:2.45.0-py311-cu124', 'anyscale/ray:2.45.0-py311-cu125', 'anyscale/ray:2.45.0-py311-cu128', 'anyscale/ray:2.45.0-py312', 'anyscale/ray:2.45.0-py312-cu117', 'anyscale/ray:2.45.0-py312-cu118', 'anyscale/ray:2.45.0-py312-cu121', 'anyscale/ray:2.45.0-py312-cu123', 'anyscale/ray:2.45.0-py312-cu124', 'anyscale/ray:2.45.0-py312-cu125', 'anyscale/ray:2.45.0-py312-cu128', 'anyscale/ray:2.45.0-py39', 'anyscale/ray:2.45.0-py39-cu117', 'anyscale/ray:2.45.0-py39-cu118', 'anyscale/ray:2.45.0-py39-cu121', 'anyscale/ray:2.45.0-py39-cu123', 'anyscale/ray:2.45.0-py39-cu124', 'anyscale/ray:2.45.0-py39-cu125', 'anyscale/ray:2.45.0-py39-cu128', 'anyscale/ray:2.45.0-slim-py310', 'anyscale/ray:2.45.0-slim-py310-cu118', 'anyscale/ray:2.45.0-slim-py310-cu121', 'anyscale/ray:2.45.0-slim-py310-cu123', 'anyscale/ray:2.45.0-slim-py310-cu124', 'anyscale/ray:2.45.0-slim-py310-cu125', 'anyscale/ray:2.45.0-slim-py310-cu128', 'anyscale/ray:2.45.0-slim-py311', 'anyscale/ray:2.45.0-slim-py311-cu118', 'anyscale/ray:2.45.0-slim-py311-cu121', 'anyscale/ray:2.45.0-slim-py311-cu123', 'anyscale/ray:2.45.0-slim-py311-cu124', 'anyscale/ray:2.45.0-slim-py311-cu125', 'anyscale/ray:2.45.0-slim-py311-cu128', 'anyscale/ray:2.45.0-slim-py312', 'anyscale/ray:2.45.0-slim-py312-cu118', 'anyscale/ray:2.45.0-slim-py312-cu121', 'anyscale/ray:2.45.0-slim-py312-cu123', 'anyscale/ray:2.45.0-slim-py312-cu124', 'anyscale/ray:2.45.0-slim-py312-cu125', 'anyscale/ray:2.45.0-slim-py312-cu128', 'anyscale/ray:2.45.0-slim-py39', 'anyscale/ray:2.45.0-slim-py39-cu118', 'anyscale/ray:2.45.0-slim-py39-cu121', 'anyscale/ray:2.45.0-slim-py39-cu123', 'anyscale/ray:2.45.0-slim-py39-cu124', 'anyscale/ray:2.45.0-slim-py39-cu125', 'anyscale/ray:2.45.0-slim-py39-cu128', 'anyscale/ray:2.46.0-py310', 'anyscale/ray:2.46.0-py310-cu117', 'anyscale/ray:2.46.0-py310-cu118', 'anyscale/ray:2.46.0-py310-cu121', 'anyscale/ray:2.46.0-py310-cu123', 'anyscale/ray:2.46.0-py310-cu124', 'anyscale/ray:2.46.0-py310-cu125', 'anyscale/ray:2.46.0-py310-cu128', 'anyscale/ray:2.46.0-py311', 'anyscale/ray:2.46.0-py311-cu117', 'anyscale/ray:2.46.0-py311-cu118', 'anyscale/ray:2.46.0-py311-cu121', 'anyscale/ray:2.46.0-py311-cu123', 'anyscale/ray:2.46.0-py311-cu124', 'anyscale/ray:2.46.0-py311-cu125', 'anyscale/ray:2.46.0-py311-cu128', 'anyscale/ray:2.46.0-py312', 'anyscale/ray:2.46.0-py312-cu117', 'anyscale/ray:2.46.0-py312-cu118', 'anyscale/ray:2.46.0-py312-cu121', 'anyscale/ray:2.46.0-py312-cu123', 'anyscale/ray:2.46.0-py312-cu124', 'anyscale/ray:2.46.0-py312-cu125', 'anyscale/ray:2.46.0-py312-cu128', 'anyscale/ray:2.46.0-py39', 'anyscale/ray:2.46.0-py39-cu117', 'anyscale/ray:2.46.0-py39-cu118', 'anyscale/ray:2.46.0-py39-cu121', 'anyscale/ray:2.46.0-py39-cu123', 'anyscale/ray:2.46.0-py39-cu124', 'anyscale/ray:2.46.0-py39-cu125', 'anyscale/ray:2.46.0-py39-cu128', 'anyscale/ray:2.46.0-slim-py310', 'anyscale/ray:2.46.0-slim-py310-cu118', 'anyscale/ray:2.46.0-slim-py310-cu121', 'anyscale/ray:2.46.0-slim-py310-cu123', 'anyscale/ray:2.46.0-slim-py310-cu124', 'anyscale/ray:2.46.0-slim-py310-cu125', 'anyscale/ray:2.46.0-slim-py310-cu128', 'anyscale/ray:2.46.0-slim-py311', 'anyscale/ray:2.46.0-slim-py311-cu118', 'anyscale/ray:2.46.0-slim-py311-cu121', 'anyscale/ray:2.46.0-slim-py311-cu123', 'anyscale/ray:2.46.0-slim-py311-cu124', 'anyscale/ray:2.46.0-slim-py311-cu125', 'anyscale/ray:2.46.0-slim-py311-cu128', 'anyscale/ray:2.46.0-slim-py312', 'anyscale/ray:2.46.0-slim-py312-cu118', 'anyscale/ray:2.46.0-slim-py312-cu121', 'anyscale/ray:2.46.0-slim-py312-cu123', 'anyscale/ray:2.46.0-slim-py312-cu124', 'anyscale/ray:2.46.0-slim-py312-cu125', 'anyscale/ray:2.46.0-slim-py312-cu128', 'anyscale/ray:2.46.0-slim-py39', 'anyscale/ray:2.46.0-slim-py39-cu118', 'anyscale/ray:2.46.0-slim-py39-cu121', 'anyscale/ray:2.46.0-slim-py39-cu123', 'anyscale/ray:2.46.0-slim-py39-cu124', 'anyscale/ray:2.46.0-slim-py39-cu125', 'anyscale/ray:2.46.0-slim-py39-cu128', 'anyscale/ray:2.47.0-py310', 'anyscale/ray:2.47.0-py310-cu117', 'anyscale/ray:2.47.0-py310-cu118', 'anyscale/ray:2.47.0-py310-cu121', 'anyscale/ray:2.47.0-py310-cu123', 'anyscale/ray:2.47.0-py310-cu124', 'anyscale/ray:2.47.0-py310-cu125', 'anyscale/ray:2.47.0-py310-cu128', 'anyscale/ray:2.47.0-py311', 'anyscale/ray:2.47.0-py311-cu117', 'anyscale/ray:2.47.0-py311-cu118', 'anyscale/ray:2.47.0-py311-cu121', 'anyscale/ray:2.47.0-py311-cu123', 'anyscale/ray:2.47.0-py311-cu124', 'anyscale/ray:2.47.0-py311-cu125', 'anyscale/ray:2.47.0-py311-cu128', 'anyscale/ray:2.47.0-py312', 'anyscale/ray:2.47.0-py312-cu117', 'anyscale/ray:2.47.0-py312-cu118', 'anyscale/ray:2.47.0-py312-cu121', 'anyscale/ray:2.47.0-py312-cu123', 'anyscale/ray:2.47.0-py312-cu124', 'anyscale/ray:2.47.0-py312-cu125', 'anyscale/ray:2.47.0-py312-cu128', 'anyscale/ray:2.47.0-py39', 'anyscale/ray:2.47.0-py39-cu117', 'anyscale/ray:2.47.0-py39-cu118', 'anyscale/ray:2.47.0-py39-cu121', 'anyscale/ray:2.47.0-py39-cu123', 'anyscale/ray:2.47.0-py39-cu124', 'anyscale/ray:2.47.0-py39-cu125', 'anyscale/ray:2.47.0-py39-cu128', 'anyscale/ray:2.47.0-slim-py310', 'anyscale/ray:2.47.0-slim-py310-cu118', 'anyscale/ray:2.47.0-slim-py310-cu121', 'anyscale/ray:2.47.0-slim-py310-cu123', 'anyscale/ray:2.47.0-slim-py310-cu124', 'anyscale/ray:2.47.0-slim-py310-cu125', 'anyscale/ray:2.47.0-slim-py310-cu128', 'anyscale/ray:2.47.0-slim-py311', 'anyscale/ray:2.47.0-slim-py311-cu118', 'anyscale/ray:2.47.0-slim-py311-cu121', 'anyscale/ray:2.47.0-slim-py311-cu123', 'anyscale/ray:2.47.0-slim-py311-cu124', 'anyscale/ray:2.47.0-slim-py311-cu125', 'anyscale/ray:2.47.0-slim-py311-cu128', 'anyscale/ray:2.47.0-slim-py312', 'anyscale/ray:2.47.0-slim-py312-cu118', 'anyscale/ray:2.47.0-slim-py312-cu121', 'anyscale/ray:2.47.0-slim-py312-cu123', 'anyscale/ray:2.47.0-slim-py312-cu124', 'anyscale/ray:2.47.0-slim-py312-cu125', 'anyscale/ray:2.47.0-slim-py312-cu128', 'anyscale/ray:2.47.0-slim-py39', 'anyscale/ray:2.47.0-slim-py39-cu118', 'anyscale/ray:2.47.0-slim-py39-cu121', 'anyscale/ray:2.47.0-slim-py39-cu123', 'anyscale/ray:2.47.0-slim-py39-cu124', 'anyscale/ray:2.47.0-slim-py39-cu125', 'anyscale/ray:2.47.0-slim-py39-cu128', 'anyscale/ray:2.47.1-py310', 'anyscale/ray:2.47.1-py310-cu117', 'anyscale/ray:2.47.1-py310-cu118', 'anyscale/ray:2.47.1-py310-cu121', 'anyscale/ray:2.47.1-py310-cu123', 'anyscale/ray:2.47.1-py310-cu124', 'anyscale/ray:2.47.1-py310-cu125', 'anyscale/ray:2.47.1-py310-cu128', 'anyscale/ray:2.47.1-py311', 'anyscale/ray:2.47.1-py311-cu117', 'anyscale/ray:2.47.1-py311-cu118', 'anyscale/ray:2.47.1-py311-cu121', 'anyscale/ray:2.47.1-py311-cu123', 'anyscale/ray:2.47.1-py311-cu124', 'anyscale/ray:2.47.1-py311-cu125', 'anyscale/ray:2.47.1-py311-cu128', 'anyscale/ray:2.47.1-py312', 'anyscale/ray:2.47.1-py312-cu117', 'anyscale/ray:2.47.1-py312-cu118', 'anyscale/ray:2.47.1-py312-cu121', 'anyscale/ray:2.47.1-py312-cu123', 'anyscale/ray:2.47.1-py312-cu124', 'anyscale/ray:2.47.1-py312-cu125', 'anyscale/ray:2.47.1-py312-cu128', 'anyscale/ray:2.47.1-py39', 'anyscale/ray:2.47.1-py39-cu117', 'anyscale/ray:2.47.1-py39-cu118', 'anyscale/ray:2.47.1-py39-cu121', 'anyscale/ray:2.47.1-py39-cu123', 'anyscale/ray:2.47.1-py39-cu124', 'anyscale/ray:2.47.1-py39-cu125', 'anyscale/ray:2.47.1-py39-cu128', 'anyscale/ray:2.47.1-slim-py310', 'anyscale/ray:2.47.1-slim-py310-cu118', 'anyscale/ray:2.47.1-slim-py310-cu121', 'anyscale/ray:2.47.1-slim-py310-cu123', 'anyscale/ray:2.47.1-slim-py310-cu124', 'anyscale/ray:2.47.1-slim-py310-cu125', 'anyscale/ray:2.47.1-slim-py310-cu128', 'anyscale/ray:2.47.1-slim-py311', 'anyscale/ray:2.47.1-slim-py311-cu118', 'anyscale/ray:2.47.1-slim-py311-cu121', 'anyscale/ray:2.47.1-slim-py311-cu123', 'anyscale/ray:2.47.1-slim-py311-cu124', 'anyscale/ray:2.47.1-slim-py311-cu125', 'anyscale/ray:2.47.1-slim-py311-cu128', 'anyscale/ray:2.47.1-slim-py312', 'anyscale/ray:2.47.1-slim-py312-cu118', 'anyscale/ray:2.47.1-slim-py312-cu121', 'anyscale/ray:2.47.1-slim-py312-cu123', 'anyscale/ray:2.47.1-slim-py312-cu124', 'anyscale/ray:2.47.1-slim-py312-cu125', 'anyscale/ray:2.47.1-slim-py312-cu128', 'anyscale/ray:2.47.1-slim-py39', 'anyscale/ray:2.47.1-slim-py39-cu118', 'anyscale/ray:2.47.1-slim-py39-cu121', 'anyscale/ray:2.47.1-slim-py39-cu123', 'anyscale/ray:2.47.1-slim-py39-cu124', 'anyscale/ray:2.47.1-slim-py39-cu125', 'anyscale/ray:2.47.1-slim-py39-cu128', 'anyscale/ray:2.48.0-py310', 'anyscale/ray:2.48.0-py310-cu117', 'anyscale/ray:2.48.0-py310-cu118', 'anyscale/ray:2.48.0-py310-cu121', 'anyscale/ray:2.48.0-py310-cu123', 'anyscale/ray:2.48.0-py310-cu124', 'anyscale/ray:2.48.0-py310-cu125', 'anyscale/ray:2.48.0-py310-cu128', 'anyscale/ray:2.48.0-py311', 'anyscale/ray:2.48.0-py311-cu117', 'anyscale/ray:2.48.0-py311-cu118', 'anyscale/ray:2.48.0-py311-cu121', 'anyscale/ray:2.48.0-py311-cu123', 'anyscale/ray:2.48.0-py311-cu124', 'anyscale/ray:2.48.0-py311-cu125', 'anyscale/ray:2.48.0-py311-cu128', 'anyscale/ray:2.48.0-py312', 'anyscale/ray:2.48.0-py312-cu117', 'anyscale/ray:2.48.0-py312-cu118', 'anyscale/ray:2.48.0-py312-cu121', 'anyscale/ray:2.48.0-py312-cu123', 'anyscale/ray:2.48.0-py312-cu124', 'anyscale/ray:2.48.0-py312-cu125', 'anyscale/ray:2.48.0-py312-cu128', 'anyscale/ray:2.48.0-py39', 'anyscale/ray:2.48.0-py39-cu117', 'anyscale/ray:2.48.0-py39-cu118', 'anyscale/ray:2.48.0-py39-cu121', 'anyscale/ray:2.48.0-py39-cu123', 'anyscale/ray:2.48.0-py39-cu124', 'anyscale/ray:2.48.0-py39-cu125', 'anyscale/ray:2.48.0-py39-cu128', 'anyscale/ray:2.48.0-slim-py310', 'anyscale/ray:2.48.0-slim-py310-cu118', 'anyscale/ray:2.48.0-slim-py310-cu121', 'anyscale/ray:2.48.0-slim-py310-cu123', 'anyscale/ray:2.48.0-slim-py310-cu124', 'anyscale/ray:2.48.0-slim-py310-cu125', 'anyscale/ray:2.48.0-slim-py310-cu128', 'anyscale/ray:2.48.0-slim-py311', 'anyscale/ray:2.48.0-slim-py311-cu118', 'anyscale/ray:2.48.0-slim-py311-cu121', 'anyscale/ray:2.48.0-slim-py311-cu123', 'anyscale/ray:2.48.0-slim-py311-cu124', 'anyscale/ray:2.48.0-slim-py311-cu125', 'anyscale/ray:2.48.0-slim-py311-cu128', 'anyscale/ray:2.48.0-slim-py312', 'anyscale/ray:2.48.0-slim-py312-cu118', 'anyscale/ray:2.48.0-slim-py312-cu121', 'anyscale/ray:2.48.0-slim-py312-cu123', 'anyscale/ray:2.48.0-slim-py312-cu124', 'anyscale/ray:2.48.0-slim-py312-cu125', 'anyscale/ray:2.48.0-slim-py312-cu128', 'anyscale/ray:2.48.0-slim-py39', 'anyscale/ray:2.48.0-slim-py39-cu118', 'anyscale/ray:2.48.0-slim-py39-cu121', 'anyscale/ray:2.48.0-slim-py39-cu123', 'anyscale/ray:2.48.0-slim-py39-cu124', 'anyscale/ray:2.48.0-slim-py39-cu125', 'anyscale/ray:2.48.0-slim-py39-cu128', 'anyscale/ray:2.49.0-py310', 'anyscale/ray:2.49.0-py310-cu117', 'anyscale/ray:2.49.0-py310-cu118', 'anyscale/ray:2.49.0-py310-cu121', 'anyscale/ray:2.49.0-py310-cu123', 'anyscale/ray:2.49.0-py310-cu124', 'anyscale/ray:2.49.0-py310-cu125', 'anyscale/ray:2.49.0-py310-cu126', 'anyscale/ray:2.49.0-py310-cu128', 'anyscale/ray:2.49.0-py311', 'anyscale/ray:2.49.0-py311-cu117', 'anyscale/ray:2.49.0-py311-cu118', 'anyscale/ray:2.49.0-py311-cu121', 'anyscale/ray:2.49.0-py311-cu123', 'anyscale/ray:2.49.0-py311-cu124', 'anyscale/ray:2.49.0-py311-cu125', 'anyscale/ray:2.49.0-py311-cu126', 'anyscale/ray:2.49.0-py311-cu128', 'anyscale/ray:2.49.0-py312', 'anyscale/ray:2.49.0-py312-cu117', 'anyscale/ray:2.49.0-py312-cu118', 'anyscale/ray:2.49.0-py312-cu121', 'anyscale/ray:2.49.0-py312-cu123', 'anyscale/ray:2.49.0-py312-cu124', 'anyscale/ray:2.49.0-py312-cu125', 'anyscale/ray:2.49.0-py312-cu126', 'anyscale/ray:2.49.0-py312-cu128', 'anyscale/ray:2.49.0-py39', 'anyscale/ray:2.49.0-py39-cu117', 'anyscale/ray:2.49.0-py39-cu118', 'anyscale/ray:2.49.0-py39-cu121', 'anyscale/ray:2.49.0-py39-cu123', 'anyscale/ray:2.49.0-py39-cu124', 'anyscale/ray:2.49.0-py39-cu125', 'anyscale/ray:2.49.0-py39-cu126', 'anyscale/ray:2.49.0-py39-cu128', 'anyscale/ray:2.49.0-slim-py310', 'anyscale/ray:2.49.0-slim-py310-cu118', 'anyscale/ray:2.49.0-slim-py310-cu121', 'anyscale/ray:2.49.0-slim-py310-cu123', 'anyscale/ray:2.49.0-slim-py310-cu124', 'anyscale/ray:2.49.0-slim-py310-cu125', 'anyscale/ray:2.49.0-slim-py310-cu126', 'anyscale/ray:2.49.0-slim-py310-cu128', 'anyscale/ray:2.49.0-slim-py311', 'anyscale/ray:2.49.0-slim-py311-cu118', 'anyscale/ray:2.49.0-slim-py311-cu121', 'anyscale/ray:2.49.0-slim-py311-cu123', 'anyscale/ray:2.49.0-slim-py311-cu124', 'anyscale/ray:2.49.0-slim-py311-cu125', 'anyscale/ray:2.49.0-slim-py311-cu126', 'anyscale/ray:2.49.0-slim-py311-cu128', 'anyscale/ray:2.49.0-slim-py312', 'anyscale/ray:2.49.0-slim-py312-cu118', 'anyscale/ray:2.49.0-slim-py312-cu121', 'anyscale/ray:2.49.0-slim-py312-cu123', 'anyscale/ray:2.49.0-slim-py312-cu124', 'anyscale/ray:2.49.0-slim-py312-cu125', 'anyscale/ray:2.49.0-slim-py312-cu126', 'anyscale/ray:2.49.0-slim-py312-cu128', 'anyscale/ray:2.49.0-slim-py39', 'anyscale/ray:2.49.0-slim-py39-cu118', 'anyscale/ray:2.49.0-slim-py39-cu121', 'anyscale/ray:2.49.0-slim-py39-cu123', 'anyscale/ray:2.49.0-slim-py39-cu124', 'anyscale/ray:2.49.0-slim-py39-cu125', 'anyscale/ray:2.49.0-slim-py39-cu126', 'anyscale/ray:2.49.0-slim-py39-cu128', 'anyscale/ray:2.49.1-py310', 'anyscale/ray:2.49.1-py310-cu117', 'anyscale/ray:2.49.1-py310-cu118', 'anyscale/ray:2.49.1-py310-cu121', 'anyscale/ray:2.49.1-py310-cu123', 'anyscale/ray:2.49.1-py310-cu124', 'anyscale/ray:2.49.1-py310-cu125', 'anyscale/ray:2.49.1-py310-cu126', 'anyscale/ray:2.49.1-py310-cu128', 'anyscale/ray:2.49.1-py311', 'anyscale/ray:2.49.1-py311-cu117', 'anyscale/ray:2.49.1-py311-cu118', 'anyscale/ray:2.49.1-py311-cu121', 'anyscale/ray:2.49.1-py311-cu123', 'anyscale/ray:2.49.1-py311-cu124', 'anyscale/ray:2.49.1-py311-cu125', 'anyscale/ray:2.49.1-py311-cu126', 'anyscale/ray:2.49.1-py311-cu128', 'anyscale/ray:2.49.1-py312', 'anyscale/ray:2.49.1-py312-cu117', 'anyscale/ray:2.49.1-py312-cu118', 'anyscale/ray:2.49.1-py312-cu121', 'anyscale/ray:2.49.1-py312-cu123', 'anyscale/ray:2.49.1-py312-cu124', 'anyscale/ray:2.49.1-py312-cu125', 'anyscale/ray:2.49.1-py312-cu126', 'anyscale/ray:2.49.1-py312-cu128', 'anyscale/ray:2.49.1-py39', 'anyscale/ray:2.49.1-py39-cu117', 'anyscale/ray:2.49.1-py39-cu118', 'anyscale/ray:2.49.1-py39-cu121', 'anyscale/ray:2.49.1-py39-cu123', 'anyscale/ray:2.49.1-py39-cu124', 'anyscale/ray:2.49.1-py39-cu125', 'anyscale/ray:2.49.1-py39-cu126', 'anyscale/ray:2.49.1-py39-cu128', 'anyscale/ray:2.49.1-slim-py310', 'anyscale/ray:2.49.1-slim-py310-cu118', 'anyscale/ray:2.49.1-slim-py310-cu121', 'anyscale/ray:2.49.1-slim-py310-cu123', 'anyscale/ray:2.49.1-slim-py310-cu124', 'anyscale/ray:2.49.1-slim-py310-cu125', 'anyscale/ray:2.49.1-slim-py310-cu126', 'anyscale/ray:2.49.1-slim-py310-cu128', 'anyscale/ray:2.49.1-slim-py311', 'anyscale/ray:2.49.1-slim-py311-cu118', 'anyscale/ray:2.49.1-slim-py311-cu121', 'anyscale/ray:2.49.1-slim-py311-cu123', 'anyscale/ray:2.49.1-slim-py311-cu124', 'anyscale/ray:2.49.1-slim-py311-cu125', 'anyscale/ray:2.49.1-slim-py311-cu126', 'anyscale/ray:2.49.1-slim-py311-cu128', 'anyscale/ray:2.49.1-slim-py312', 'anyscale/ray:2.49.1-slim-py312-cu118', 'anyscale/ray:2.49.1-slim-py312-cu121', 'anyscale/ray:2.49.1-slim-py312-cu123', 'anyscale/ray:2.49.1-slim-py312-cu124', 'anyscale/ray:2.49.1-slim-py312-cu125', 'anyscale/ray:2.49.1-slim-py312-cu126', 'anyscale/ray:2.49.1-slim-py312-cu128', 'anyscale/ray:2.49.1-slim-py39', 'anyscale/ray:2.49.1-slim-py39-cu118', 'anyscale/ray:2.49.1-slim-py39-cu121', 'anyscale/ray:2.49.1-slim-py39-cu123', 'anyscale/ray:2.49.1-slim-py39-cu124', 'anyscale/ray:2.49.1-slim-py39-cu125', 'anyscale/ray:2.49.1-slim-py39-cu126', 'anyscale/ray:2.49.1-slim-py39-cu128', 'anyscale/ray:2.5.0-py310', 'anyscale/ray:2.5.0-py310-cu101', 'anyscale/ray:2.5.0-py310-cu102', 'anyscale/ray:2.5.0-py310-cu110', 'anyscale/ray:2.5.0-py310-cu111', 'anyscale/ray:2.5.0-py310-cu112', 'anyscale/ray:2.5.0-py310-cu113', 'anyscale/ray:2.5.0-py310-cu116', 'anyscale/ray:2.5.0-py310-cu118', 'anyscale/ray:2.5.0-py37', 'anyscale/ray:2.5.0-py37-cu101', 'anyscale/ray:2.5.0-py37-cu102', 'anyscale/ray:2.5.0-py37-cu110', 'anyscale/ray:2.5.0-py37-cu111', 'anyscale/ray:2.5.0-py37-cu112', 'anyscale/ray:2.5.0-py37-cu113', 'anyscale/ray:2.5.0-py37-cu116', 'anyscale/ray:2.5.0-py37-cu118', 'anyscale/ray:2.5.0-py38', 'anyscale/ray:2.5.0-py38-cu101', 'anyscale/ray:2.5.0-py38-cu102', 'anyscale/ray:2.5.0-py38-cu110', 'anyscale/ray:2.5.0-py38-cu111', 'anyscale/ray:2.5.0-py38-cu112', 'anyscale/ray:2.5.0-py38-cu113', 'anyscale/ray:2.5.0-py38-cu116', 'anyscale/ray:2.5.0-py38-cu118', 'anyscale/ray:2.5.0-py39', 'anyscale/ray:2.5.0-py39-cu101', 'anyscale/ray:2.5.0-py39-cu102', 'anyscale/ray:2.5.0-py39-cu110', 'anyscale/ray:2.5.0-py39-cu111', 'anyscale/ray:2.5.0-py39-cu112', 'anyscale/ray:2.5.0-py39-cu113', 'anyscale/ray:2.5.0-py39-cu116', 'anyscale/ray:2.5.0-py39-cu118', 'anyscale/ray:2.5.1-py310', 'anyscale/ray:2.5.1-py310-cu101', 'anyscale/ray:2.5.1-py310-cu102', 'anyscale/ray:2.5.1-py310-cu110', 'anyscale/ray:2.5.1-py310-cu111', 'anyscale/ray:2.5.1-py310-cu112', 'anyscale/ray:2.5.1-py310-cu113', 'anyscale/ray:2.5.1-py310-cu116', 'anyscale/ray:2.5.1-py310-cu118', 'anyscale/ray:2.5.1-py37', 'anyscale/ray:2.5.1-py37-cu101', 'anyscale/ray:2.5.1-py37-cu102', 'anyscale/ray:2.5.1-py37-cu110', 'anyscale/ray:2.5.1-py37-cu111', 'anyscale/ray:2.5.1-py37-cu112', 'anyscale/ray:2.5.1-py37-cu113', 'anyscale/ray:2.5.1-py37-cu116', 'anyscale/ray:2.5.1-py37-cu118', 'anyscale/ray:2.5.1-py38', 'anyscale/ray:2.5.1-py38-cu101', 'anyscale/ray:2.5.1-py38-cu102', 'anyscale/ray:2.5.1-py38-cu110', 'anyscale/ray:2.5.1-py38-cu111', 'anyscale/ray:2.5.1-py38-cu112', 'anyscale/ray:2.5.1-py38-cu113', 'anyscale/ray:2.5.1-py38-cu116', 'anyscale/ray:2.5.1-py38-cu118', 'anyscale/ray:2.5.1-py39', 'anyscale/ray:2.5.1-py39-cu101', 'anyscale/ray:2.5.1-py39-cu102', 'anyscale/ray:2.5.1-py39-cu110', 'anyscale/ray:2.5.1-py39-cu111', 'anyscale/ray:2.5.1-py39-cu112', 'anyscale/ray:2.5.1-py39-cu113', 'anyscale/ray:2.5.1-py39-cu116', 'anyscale/ray:2.5.1-py39-cu118', 'anyscale/ray:2.6.0-py310', 'anyscale/ray:2.6.0-py310-cu115', 'anyscale/ray:2.6.0-py310-cu116', 'anyscale/ray:2.6.0-py310-cu117', 'anyscale/ray:2.6.0-py310-cu118', 'anyscale/ray:2.6.0-py37', 'anyscale/ray:2.6.0-py37-cu115', 'anyscale/ray:2.6.0-py37-cu116', 'anyscale/ray:2.6.0-py37-cu117', 'anyscale/ray:2.6.0-py37-cu118', 'anyscale/ray:2.6.0-py38', 'anyscale/ray:2.6.0-py38-cu115', 'anyscale/ray:2.6.0-py38-cu116', 'anyscale/ray:2.6.0-py38-cu117', 'anyscale/ray:2.6.0-py38-cu118', 'anyscale/ray:2.6.0-py39', 'anyscale/ray:2.6.0-py39-cu115', 'anyscale/ray:2.6.0-py39-cu116', 'anyscale/ray:2.6.0-py39-cu117', 'anyscale/ray:2.6.0-py39-cu118', 'anyscale/ray:2.6.1-py310', 'anyscale/ray:2.6.1-py310-cu115', 'anyscale/ray:2.6.1-py310-cu116', 'anyscale/ray:2.6.1-py310-cu117', 'anyscale/ray:2.6.1-py310-cu118', 'anyscale/ray:2.6.1-py37', 'anyscale/ray:2.6.1-py37-cu115', 'anyscale/ray:2.6.1-py37-cu116', 'anyscale/ray:2.6.1-py37-cu117', 'anyscale/ray:2.6.1-py37-cu118', 'anyscale/ray:2.6.1-py38', 'anyscale/ray:2.6.1-py38-cu115', 'anyscale/ray:2.6.1-py38-cu116', 'anyscale/ray:2.6.1-py38-cu117', 'anyscale/ray:2.6.1-py38-cu118', 'anyscale/ray:2.6.1-py39', 'anyscale/ray:2.6.1-py39-cu115', 'anyscale/ray:2.6.1-py39-cu116', 'anyscale/ray:2.6.1-py39-cu117', 'anyscale/ray:2.6.1-py39-cu118', 'anyscale/ray:2.6.2-py310', 'anyscale/ray:2.6.2-py310-cu115', 'anyscale/ray:2.6.2-py310-cu116', 'anyscale/ray:2.6.2-py310-cu117', 'anyscale/ray:2.6.2-py310-cu118', 'anyscale/ray:2.6.2-py37', 'anyscale/ray:2.6.2-py37-cu115', 'anyscale/ray:2.6.2-py37-cu116', 'anyscale/ray:2.6.2-py37-cu117', 'anyscale/ray:2.6.2-py37-cu118', 'anyscale/ray:2.6.2-py38', 'anyscale/ray:2.6.2-py38-cu115', 'anyscale/ray:2.6.2-py38-cu116', 'anyscale/ray:2.6.2-py38-cu117', 'anyscale/ray:2.6.2-py38-cu118', 'anyscale/ray:2.6.2-py39', 'anyscale/ray:2.6.2-py39-cu115', 'anyscale/ray:2.6.2-py39-cu116', 'anyscale/ray:2.6.2-py39-cu117', 'anyscale/ray:2.6.2-py39-cu118', 'anyscale/ray:2.6.3-py310', 'anyscale/ray:2.6.3-py310-cu115', 'anyscale/ray:2.6.3-py310-cu116', 'anyscale/ray:2.6.3-py310-cu117', 'anyscale/ray:2.6.3-py310-cu118', 'anyscale/ray:2.6.3-py37', 'anyscale/ray:2.6.3-py37-cu115', 'anyscale/ray:2.6.3-py37-cu116', 'anyscale/ray:2.6.3-py37-cu117', 'anyscale/ray:2.6.3-py37-cu118', 'anyscale/ray:2.6.3-py38', 'anyscale/ray:2.6.3-py38-cu115', 'anyscale/ray:2.6.3-py38-cu116', 'anyscale/ray:2.6.3-py38-cu117', 'anyscale/ray:2.6.3-py38-cu118', 'anyscale/ray:2.6.3-py39', 'anyscale/ray:2.6.3-py39-cu115', 'anyscale/ray:2.6.3-py39-cu116', 'anyscale/ray:2.6.3-py39-cu117', 'anyscale/ray:2.6.3-py39-cu118', 'anyscale/ray:2.7.0optimized-py310', 'anyscale/ray:2.7.0optimized-py310-cu115', 'anyscale/ray:2.7.0optimized-py310-cu116', 'anyscale/ray:2.7.0optimized-py310-cu117', 'anyscale/ray:2.7.0optimized-py310-cu118', 'anyscale/ray:2.7.0optimized-py310-cu121', 'anyscale/ray:2.7.0optimized-py311', 'anyscale/ray:2.7.0optimized-py311-cu115', 'anyscale/ray:2.7.0optimized-py311-cu116', 'anyscale/ray:2.7.0optimized-py311-cu117', 'anyscale/ray:2.7.0optimized-py311-cu118', 'anyscale/ray:2.7.0optimized-py311-cu121', 'anyscale/ray:2.7.0optimized-py37', 'anyscale/ray:2.7.0optimized-py37-cu115', 'anyscale/ray:2.7.0optimized-py37-cu116', 'anyscale/ray:2.7.0optimized-py37-cu117', 'anyscale/ray:2.7.0optimized-py37-cu118', 'anyscale/ray:2.7.0optimized-py37-cu121', 'anyscale/ray:2.7.0optimized-py38', 'anyscale/ray:2.7.0optimized-py38-cu115', 'anyscale/ray:2.7.0optimized-py38-cu116', 'anyscale/ray:2.7.0optimized-py38-cu117', 'anyscale/ray:2.7.0optimized-py38-cu118', 'anyscale/ray:2.7.0optimized-py38-cu121', 'anyscale/ray:2.7.0optimized-py39', 'anyscale/ray:2.7.0optimized-py39-cu115', 'anyscale/ray:2.7.0optimized-py39-cu116', 'anyscale/ray:2.7.0optimized-py39-cu117', 'anyscale/ray:2.7.0optimized-py39-cu118', 'anyscale/ray:2.7.0optimized-py39-cu121', 'anyscale/ray:2.7.1optimized-py310', 'anyscale/ray:2.7.1optimized-py310-cu115', 'anyscale/ray:2.7.1optimized-py310-cu116', 'anyscale/ray:2.7.1optimized-py310-cu117', 'anyscale/ray:2.7.1optimized-py310-cu118', 'anyscale/ray:2.7.1optimized-py310-cu121', 'anyscale/ray:2.7.1optimized-py311', 'anyscale/ray:2.7.1optimized-py311-cu115', 'anyscale/ray:2.7.1optimized-py311-cu116', 'anyscale/ray:2.7.1optimized-py311-cu117', 'anyscale/ray:2.7.1optimized-py311-cu118', 'anyscale/ray:2.7.1optimized-py311-cu121', 'anyscale/ray:2.7.1optimized-py37', 'anyscale/ray:2.7.1optimized-py37-cu115', 'anyscale/ray:2.7.1optimized-py37-cu116', 'anyscale/ray:2.7.1optimized-py37-cu117', 'anyscale/ray:2.7.1optimized-py37-cu118', 'anyscale/ray:2.7.1optimized-py37-cu121', 'anyscale/ray:2.7.1optimized-py38', 'anyscale/ray:2.7.1optimized-py38-cu115', 'anyscale/ray:2.7.1optimized-py38-cu116', 'anyscale/ray:2.7.1optimized-py38-cu117', 'anyscale/ray:2.7.1optimized-py38-cu118', 'anyscale/ray:2.7.1optimized-py38-cu121', 'anyscale/ray:2.7.1optimized-py39', 'anyscale/ray:2.7.1optimized-py39-cu115', 'anyscale/ray:2.7.1optimized-py39-cu116', 'anyscale/ray:2.7.1optimized-py39-cu117', 'anyscale/ray:2.7.1optimized-py39-cu118', 'anyscale/ray:2.7.1optimized-py39-cu121', 'anyscale/ray:2.7.2optimized-py310', 'anyscale/ray:2.7.2optimized-py310-cu115', 'anyscale/ray:2.7.2optimized-py310-cu116', 'anyscale/ray:2.7.2optimized-py310-cu117', 'anyscale/ray:2.7.2optimized-py310-cu118', 'anyscale/ray:2.7.2optimized-py310-cu121', 'anyscale/ray:2.7.2optimized-py311', 'anyscale/ray:2.7.2optimized-py311-cu115', 'anyscale/ray:2.7.2optimized-py311-cu116', 'anyscale/ray:2.7.2optimized-py311-cu117', 'anyscale/ray:2.7.2optimized-py311-cu118', 'anyscale/ray:2.7.2optimized-py311-cu121', 'anyscale/ray:2.7.2optimized-py37', 'anyscale/ray:2.7.2optimized-py37-cu115', 'anyscale/ray:2.7.2optimized-py37-cu116', 'anyscale/ray:2.7.2optimized-py37-cu117', 'anyscale/ray:2.7.2optimized-py37-cu118', 'anyscale/ray:2.7.2optimized-py37-cu121', 'anyscale/ray:2.7.2optimized-py38', 'anyscale/ray:2.7.2optimized-py38-cu115', 'anyscale/ray:2.7.2optimized-py38-cu116', 'anyscale/ray:2.7.2optimized-py38-cu117', 'anyscale/ray:2.7.2optimized-py38-cu118', 'anyscale/ray:2.7.2optimized-py38-cu121', 'anyscale/ray:2.7.2optimized-py39', 'anyscale/ray:2.7.2optimized-py39-cu115', 'anyscale/ray:2.7.2optimized-py39-cu116', 'anyscale/ray:2.7.2optimized-py39-cu117', 'anyscale/ray:2.7.2optimized-py39-cu118', 'anyscale/ray:2.7.2optimized-py39-cu121', 'anyscale/ray:2.8.0-py310', 'anyscale/ray:2.8.0-py310-cu115', 'anyscale/ray:2.8.0-py310-cu116', 'anyscale/ray:2.8.0-py310-cu117', 'anyscale/ray:2.8.0-py310-cu118', 'anyscale/ray:2.8.0-py310-cu121', 'anyscale/ray:2.8.0-py311', 'anyscale/ray:2.8.0-py311-cu115', 'anyscale/ray:2.8.0-py311-cu116', 'anyscale/ray:2.8.0-py311-cu117', 'anyscale/ray:2.8.0-py311-cu118', 'anyscale/ray:2.8.0-py311-cu121', 'anyscale/ray:2.8.0-py38', 'anyscale/ray:2.8.0-py38-cu115', 'anyscale/ray:2.8.0-py38-cu116', 'anyscale/ray:2.8.0-py38-cu117', 'anyscale/ray:2.8.0-py38-cu118', 'anyscale/ray:2.8.0-py38-cu121', 'anyscale/ray:2.8.0-py39', 'anyscale/ray:2.8.0-py39-cu115', 'anyscale/ray:2.8.0-py39-cu116', 'anyscale/ray:2.8.0-py39-cu117', 'anyscale/ray:2.8.0-py39-cu118', 'anyscale/ray:2.8.0-py39-cu121', 'anyscale/ray:2.8.1-py310', 'anyscale/ray:2.8.1-py310-cu115', 'anyscale/ray:2.8.1-py310-cu116', 'anyscale/ray:2.8.1-py310-cu117', 'anyscale/ray:2.8.1-py310-cu118', 'anyscale/ray:2.8.1-py310-cu121', 'anyscale/ray:2.8.1-py311', 'anyscale/ray:2.8.1-py311-cu115', 'anyscale/ray:2.8.1-py311-cu116', 'anyscale/ray:2.8.1-py311-cu117', 'anyscale/ray:2.8.1-py311-cu118', 'anyscale/ray:2.8.1-py311-cu121', 'anyscale/ray:2.8.1-py38', 'anyscale/ray:2.8.1-py38-cu115', 'anyscale/ray:2.8.1-py38-cu116', 'anyscale/ray:2.8.1-py38-cu117', 'anyscale/ray:2.8.1-py38-cu118', 'anyscale/ray:2.8.1-py38-cu121', 'anyscale/ray:2.8.1-py39', 'anyscale/ray:2.8.1-py39-cu115', 'anyscale/ray:2.8.1-py39-cu116', 'anyscale/ray:2.8.1-py39-cu117', 'anyscale/ray:2.8.1-py39-cu118', 'anyscale/ray:2.8.1-py39-cu121', 'anyscale/ray:2.9.0-py310', 'anyscale/ray:2.9.0-py310-cu115', 'anyscale/ray:2.9.0-py310-cu116', 'anyscale/ray:2.9.0-py310-cu117', 'anyscale/ray:2.9.0-py310-cu118', 'anyscale/ray:2.9.0-py310-cu121', 'anyscale/ray:2.9.0-py311', 'anyscale/ray:2.9.0-py311-cu115', 'anyscale/ray:2.9.0-py311-cu116', 'anyscale/ray:2.9.0-py311-cu117', 'anyscale/ray:2.9.0-py311-cu118', 'anyscale/ray:2.9.0-py311-cu121', 'anyscale/ray:2.9.0-py38', 'anyscale/ray:2.9.0-py38-cu115', 'anyscale/ray:2.9.0-py38-cu116', 'anyscale/ray:2.9.0-py38-cu117', 'anyscale/ray:2.9.0-py38-cu118', 'anyscale/ray:2.9.0-py38-cu121', 'anyscale/ray:2.9.0-py39', 'anyscale/ray:2.9.0-py39-cu115', 'anyscale/ray:2.9.0-py39-cu116', 'anyscale/ray:2.9.0-py39-cu117', 'anyscale/ray:2.9.0-py39-cu118', 'anyscale/ray:2.9.0-py39-cu121', 'anyscale/ray:2.9.1-py310', 'anyscale/ray:2.9.1-py310-cu115', 'anyscale/ray:2.9.1-py310-cu116', 'anyscale/ray:2.9.1-py310-cu117', 'anyscale/ray:2.9.1-py310-cu118', 'anyscale/ray:2.9.1-py310-cu121', 'anyscale/ray:2.9.1-py311', 'anyscale/ray:2.9.1-py311-cu115', 'anyscale/ray:2.9.1-py311-cu116', 'anyscale/ray:2.9.1-py311-cu117', 'anyscale/ray:2.9.1-py311-cu118', 'anyscale/ray:2.9.1-py311-cu121', 'anyscale/ray:2.9.1-py38', 'anyscale/ray:2.9.1-py38-cu115', 'anyscale/ray:2.9.1-py38-cu116', 'anyscale/ray:2.9.1-py38-cu117', 'anyscale/ray:2.9.1-py38-cu118', 'anyscale/ray:2.9.1-py38-cu121', 'anyscale/ray:2.9.1-py39', 'anyscale/ray:2.9.1-py39-cu115', 'anyscale/ray:2.9.1-py39-cu116', 'anyscale/ray:2.9.1-py39-cu117', 'anyscale/ray:2.9.1-py39-cu118', 'anyscale/ray:2.9.1-py39-cu121', 'anyscale/ray:2.9.2-py310', 'anyscale/ray:2.9.2-py310-cu115', 'anyscale/ray:2.9.2-py310-cu116', 'anyscale/ray:2.9.2-py310-cu117', 'anyscale/ray:2.9.2-py310-cu118', 'anyscale/ray:2.9.2-py310-cu121', 'anyscale/ray:2.9.2-py311', 'anyscale/ray:2.9.2-py311-cu115', 'anyscale/ray:2.9.2-py311-cu116', 'anyscale/ray:2.9.2-py311-cu117', 'anyscale/ray:2.9.2-py311-cu118', 'anyscale/ray:2.9.2-py311-cu121', 'anyscale/ray:2.9.2-py38', 'anyscale/ray:2.9.2-py38-cu115', 'anyscale/ray:2.9.2-py38-cu116', 'anyscale/ray:2.9.2-py38-cu117', 'anyscale/ray:2.9.2-py38-cu118', 'anyscale/ray:2.9.2-py38-cu121', 'anyscale/ray:2.9.2-py39', 'anyscale/ray:2.9.2-py39-cu115', 'anyscale/ray:2.9.2-py39-cu116', 'anyscale/ray:2.9.2-py39-cu117', 'anyscale/ray:2.9.2-py39-cu118', 'anyscale/ray:2.9.2-py39-cu121', 'anyscale/ray:2.9.3-py310', 'anyscale/ray:2.9.3-py310-cu115', 'anyscale/ray:2.9.3-py310-cu116', 'anyscale/ray:2.9.3-py310-cu117', 'anyscale/ray:2.9.3-py310-cu118', 'anyscale/ray:2.9.3-py310-cu121', 'anyscale/ray:2.9.3-py311', 'anyscale/ray:2.9.3-py311-cu115', 'anyscale/ray:2.9.3-py311-cu116', 'anyscale/ray:2.9.3-py311-cu117', 'anyscale/ray:2.9.3-py311-cu118', 'anyscale/ray:2.9.3-py311-cu121', 'anyscale/ray:2.9.3-py38', 'anyscale/ray:2.9.3-py38-cu115', 'anyscale/ray:2.9.3-py38-cu116', 'anyscale/ray:2.9.3-py38-cu117', 'anyscale/ray:2.9.3-py38-cu118', 'anyscale/ray:2.9.3-py38-cu121', 'anyscale/ray:2.9.3-py39', 'anyscale/ray:2.9.3-py39-cu115', 'anyscale/ray:2.9.3-py39-cu116', 'anyscale/ray:2.9.3-py39-cu117', 'anyscale/ray:2.9.3-py39-cu118', 'anyscale/ray:2.9.3-py39-cu121', 'anyscale/ray:nightly-py310', 'anyscale/ray:nightly-py310-cu117', 'anyscale/ray:nightly-py310-cu118', 'anyscale/ray:nightly-py310-cu121', 'anyscale/ray:nightly-py310-cu123', 'anyscale/ray:nightly-py310-cu124', 'anyscale/ray:nightly-py310-cu125', 'anyscale/ray:nightly-py310-cu126', 'anyscale/ray:nightly-py310-cu128', 'anyscale/ray:nightly-py311', 'anyscale/ray:nightly-py311-cu117', 'anyscale/ray:nightly-py311-cu118', 'anyscale/ray:nightly-py311-cu121', 'anyscale/ray:nightly-py311-cu123', 'anyscale/ray:nightly-py311-cu124', 'anyscale/ray:nightly-py311-cu125', 'anyscale/ray:nightly-py311-cu126', 'anyscale/ray:nightly-py311-cu128', 'anyscale/ray:nightly-py312', 'anyscale/ray:nightly-py312-cu117', 'anyscale/ray:nightly-py312-cu118', 'anyscale/ray:nightly-py312-cu121', 'anyscale/ray:nightly-py312-cu123', 'anyscale/ray:nightly-py312-cu124', 'anyscale/ray:nightly-py312-cu125', 'anyscale/ray:nightly-py312-cu126', 'anyscale/ray:nightly-py312-cu128', 'anyscale/ray:nightly-py39', 'anyscale/ray:nightly-py39-cu117', 'anyscale/ray:nightly-py39-cu118', 'anyscale/ray:nightly-py39-cu121', 'anyscale/ray:nightly-py39-cu123', 'anyscale/ray:nightly-py39-cu124', 'anyscale/ray:nightly-py39-cu125', 'anyscale/ray:nightly-py39-cu126', 'anyscale/ray:nightly-py39-cu128']

## ScheduleAPIModel


Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**name** | **str** | Name of the job | [default to null]
**description** | **str** | Description of the job | [optional] [default to null]
**project_id** | **str** | Id of the project this job will start clusters in | [default to null]
**config** | [**ProductionJobConfig**](#productionjobconfig) | The config that was used to create this job | [default to null]
**job_queue_config** | [**CreateJobQueueConfig**](#createjobqueueconfig) | Configuration specifying semantic of the execution using job queues | [optional] [default to null]
**schedule** | [**ScheduleConfig**](#scheduleconfig) | The configuration for this schedule | [default to null]
**id** | **str** | The id of this job | [default to null]
**created_at** | **datetime** | The time this job was created | [default to null]
**updated_at** | **datetime** | The time this job was last updated | [default to null]
**creator_id** | **str** | The id of the user who created this job | [default to null]
**next_trigger_at** | **datetime** | The next UTC timestamp at which this cron job will trigger. | [optional] [default to null]
**controller_user_id** | **str** | The id of the user that started, paused or resumed the schedule most recently. | [optional] [default to null]
**cloud_id** | **str** | The id of the cloud to which the schedule belongs. | [default to null]

## ScheduleConfig


Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**cron_expression** | **str** | A cron expression to define the frequency at which to run this cron job, for example &#39;0 0 * * *&#39; is a cron expression that means &#39;run at midnight&#39;. Visit crontab.guru to construct a precise cron_expression. | [default to null]
**timezone** | **str** | The timezone in which to interpret the cron_expression. Default is Universal time (UTC). | [optional] [default to Universal]

## ScheduleapimodelListResponse

A list response form the API. Contains a field \"results\" which has the contents of the response.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**results** | [**List[ScheduleAPIModel]**](#scheduleapimodel) |  | [default to null]
**metadata** | [**ListResponseMetadata**](#listresponsemetadata) |  | [optional] [default to null]

## ScheduleapimodelResponse

A response from the API. Contains a field \"result\" which has the contents of the response.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**result** | [**ScheduleAPIModel**](#scheduleapimodel) |  | [default to null]

## ServiceConfig


Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**max_uptime_timeout_sec** | **int** | Auto-termination timeout (in seconds) for target Service to be unconditionally terminated after specified period. Setting this to 0 disables auto-termination (default). | [optional] [default to 0]
**access** | [**AccessConfig**](#accessconfig) | Access configuration | [optional] [default to null]
**protocols** | [**Protocols**](#protocols) | Protocol setups for the service | [optional] [default to null]
**env_vars** | [**object**](#) | Environment variables to set on the service cluster | [optional] [default to null]

## ServiceEventCurrentState

The possible 'current state' values for a service  These states may be shown in the UI as the primary state of the service

Possible Values:
['RUNNING', 'UNHEALTHY', 'SYSTEM_FAILURE', 'USER_ERROR_FAILURE', 'STARTING', 'TERMINATING', 'TERMINATED', 'UPDATING', 'ROLLING_OUT', 'ROLLING_BACK']

## ServiceGoalStates

An enumeration.

Possible Values:
['RUNNING', 'TERMINATED']

## ServiceModel

This is the Service model returned by the get path.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**id** | **str** | Id of the Service | [default to null]
**name** | **str** | Name of the Service | [default to null]
**description** | **str** | Description of the Service | [optional] [default to null]
**project_id** | **str** | Id of the project this Service will start clusters in. This configuration cannot be changed after the service is created. | [default to null]
**cloud_id** | **str** | Id of the cloud this Service belongs to, and will launch clusters in. This configuration cannot be changed. | [default to null]
**creator_id** | **str** | Id of the user who created the Service | [default to null]
**created_at** | **datetime** | Time the Service was created | [default to null]
**hostname** | **str** | The hostname of the service | [default to null]
**current_state** | [**ServiceEventCurrentState**](#serviceeventcurrentstate) | The current state of this service | [default to null]
**goal_state** | [**ServiceGoalStates**](#servicegoalstates) | The goal state of this service | [default to null]
**auth_token** | **str** | Token to use for service auth. To use the token, add it as a header with the key &#39;Authorization&#39; and the value &#39;Bearer &lt;token&gt;&#39; | [optional] [default to null]
**auto_rollout_enabled** | **bool** | Whether or not the service is using auto rollout | [default to null]
**versions** | [**List[ProductionServiceV2VersionModel]**](#productionservicev2versionmodel) | DEPRECATED. Please use &#x60;primary_version&#x60; and &#x60;canary_version&#x60; fields. Active versions of this service, sorted by creation time in ascending order. | [default to null]
**primary_version** | [**ProductionServiceV2VersionModel**](#productionservicev2versionmodel) | Primary version of this service. If the service is terminated, this field refers to the most recently active version. | [default to null]
**canary_version** | [**ProductionServiceV2VersionModel**](#productionservicev2versionmodel) | Canary version of this service. Present only if the service is in the &#x60;ROLLING_OUT&#x60; state. | [optional] [default to null]
**service_observability_urls** | [**ServiceObservabilityUrls**](#serviceobservabilityurls) | A JSON object with useful urls pointing to Grafana dashboards. | [default to null]
**base_url** | **str** | The base url of this service | [default to null]
**ended_at** | **datetime** | Time the Service was terminated | [optional] [default to null]

## ServiceObservabilityUrls


Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**service_dashboard_url** | **str** | URL that points to a dashboard with relevant graphs about the entire service. | [optional] [default to null]
**service_dashboard_embedding_url** | **str** | URL that points to a dashboard with relevant graphs about the entire service for embedding. | [optional] [default to null]
**serve_deployment_dashboard_url** | **str** | URL that points to a dashboard with relevant graphs about a single deployent or replica of a service. | [optional] [default to null]
**serve_deployment_dashboard_embedding_url** | **str** | URL that points to a dashboard with relevant graphs about a single deployent or replica of a service for embedding. | [optional] [default to null]

## ServiceSortField

An enumeration.

Possible Values:
['STATUS', 'NAME', 'CREATED_AT']

## ServiceType

An enumeration.

Possible Values:
['V1', 'V2']

## ServiceVersionState

The possible 'current state' values for a service version.  These states are used in the UI and SDK/CLI.

Possible Values:
['UNKNOWN', 'STARTING', 'UPDATING', 'RUNNING', 'UNHEALTHY', 'SYSTEM_FAILURE', 'TERMINATING', 'TERMINATED']

## ServicemodelListResponse

A list response form the API. Contains a field \"results\" which has the contents of the response.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**results** | [**List[ServiceModel]**](#servicemodel) |  | [default to null]
**metadata** | [**ListResponseMetadata**](#listresponsemetadata) |  | [optional] [default to null]

## ServicemodelResponse

A response from the API. Contains a field \"result\" which has the contents of the response.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**result** | [**ServiceModel**](#servicemodel) |  | [default to null]

## Session

Model used to read a Session.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**name** | **str** | Name of the session to be created. | [default to null]
**project_id** | **str** | Project that the session will be created in. | [default to null]
**cloud_id** | **str** | Cloud that the session will use. | [default to null]
**cluster_config** | **str** | Cluster config that the session can later be started with. | [default to null]
**build_id** | **str** | ID of the Build that this session was started with. | [optional] [default to null]
**compute_template_id** | **str** | ID of the compute template that this session was started with. | [optional] [default to null]
**idle_timeout** | **int** | Idle timeout (in minutes), after which the session is stopped. Idle time is defined as the time during which a session is not running a user command (through &#39;anyscale exec&#39; or the Web UI), and does not have an attached driver. Time spent running Jupyter commands, or commands run through ssh, is still considered &#39;idle&#39;. | [optional] [default to 120]
**uses_app_config** | **bool** | Whether or not the session uses app config. If true, it means this is not a legacy session started with cluster yaml. | [optional] [default to false]
**allow_public_internet_traffic** | **bool** | Whether public internet traffic can access Serve endpoints or if an authentication token is required. | [optional] [default to false]
**user_service_access** | [**UserServiceAccessTypes**](#userserviceaccesstypes) | Whether user service can be accessed by public internet traffic. | [optional] [default to null]
**user_service_token** | **str** | User service token that is used to authenticate access to public user services. This must be a valid 32 byte URL safe string and can be generated by calling &#x60;secrets.token_urlsafe(32))&#x60;. This is ignored if the user service has private access. If not specified for a public user service, a token is autogenerated. | [optional] [default to null]
**ha_job_id** | **str** | This is used internally by Anyscale to associate clusters to a job. It is set automatically and should *not* be used directly. | [optional] [default to null]
**id** | **str** | Server assigned unique identifier. | [default to null]
**state** | [**SessionState**](#sessionstate) | [DEPRECATED] Current state of the Session. Please use &#x60;cluster_status&#x60;. | [default to null]
**pending_state** | [**SessionState**](#sessionstate) | Pending state of the Session if a state transition has been requested. | [optional] [default to null]
**state_data** | [**SessionStateData**](#sessionstatedata) | Additional information about the current state | [optional] [default to null]
**status** | [**ClusterStatus**](#clusterstatus) | Current state of the Cluster. | [optional] [default to null]
**status_details** | [**ClusterStatusDetails**](#clusterstatusdetails) | Current state details of the Cluster. This is a more granular status than &#x60;status&#x60;. It should be used to get more details regarding the &#x60;status&#x60;. | [optional] [default to null]
**creator_id** | **str** | Identifier of user who created the Session. | [default to null]
**created_at** | **datetime** | Time at which session was created. | [default to null]
**archived_at** | **datetime** | The time in which this cluster is archived. | [optional] [default to null]
**webterminal_auth_url** | **str** | URL to authenticate with the webterminalThis field will only be populated after the Session finishes starting. | [optional] [default to null]
**metrics_dashboard_url** | **str** | URL for Grafana (metrics) dashboard for this Session in the running cluster state. This field will only be populated after the Session finishes starting. | [optional] [default to null]
**data_metrics_dashboard_url** | **str** | URL for Data Grafana dashboard for this Session. This field will only be populated after the Session finishes starting. | [optional] [default to null]
**train_metrics_dashboard_url** | **str** | URL for Train Grafana dashboard for this Session. This field will only be populated after the Session finishes starting. | [optional] [default to null]
**serve_metrics_dashboard_url** | **str** | URL for Serve Grafana dashboard for this Session. This field will only be populated after the Session finishes starting. | [optional] [default to null]
**serve_deployment_metrics_dashboard_url** | **str** | URL for Serve deployment Grafana dashboard for this Session. This field will only be populated after the Session finishes starting. | [optional] [default to null]
**serve_llm_metrics_dashboard_url** | **str** | URL for Serve LLM Grafana dashboard for this Session. This field will only be populated after the Session finishes starting. | [optional] [default to null]
**persistent_metrics_url** | **str** | URL for persistent Grafana (metrics) dashboard for this Session in the non-running cluster state. This field will only be populated after the Session finishes starting. | [optional] [default to null]
**connect_url** | **str** | URL for Anyscale connect for this Session. This field will only be populated after the Session finishes starting. | [optional] [default to null]
**jupyter_notebook_url** | **str** | URL for Jupyter Lab for this Session. This field will only be populated after the Session finishes starting. | [optional] [default to null]
**ray_dashboard_url** | **str** | URL for Ray dashboard for this Session. This field will only be populated after the Session finishes starting. | [optional] [default to null]
**access_token** | **str** | [DEPRECATED] Call GET /api/v2/authentication/{cluster_id}/cluster_access_token to get this. | [default to null]
**service_proxy_url** | **str** | Link to the web services proxy (e.g. jupyter, tensorboard, etc). This field will be populated when the web based services are available after the Session finishes starting. | [optional] [default to null]
**tensorboard_available** | **bool** | Represents whether Tensorboard is available. | [default to null]
**cluster_config_last_modified_at** | **datetime** | Time when the cluster config for the Session was last modified. | [default to null]
**host_name** | **str** | URL for the head node of the cluster. This field will be populated after the cluster finishes starting. | [optional] [default to null]
**head_node_ip** | **str** | Head IP of the Session. This field will be populated after the cluster finishes starting. | [optional] [default to null]
**ssh_authorized_keys** | **List[str]** | Serialized SSH Public Keys to be placed in the machine&#39;s authorized_keys. | [default to null]
**ssh_private_key** | **str** | SSH Private key that can be used to access the session&#39;s servers. | [default to null]
**anyscaled_config** | **str** | Serialized AnyscaleD config that is general to head and worker nodes. | [optional] [default to null]
**anyscaled_config_generated_at** | **datetime** | Time when AnyscaleD config was generated at. | [optional] [default to null]
**default_build_id** | **str** | Default build id used for the session. Only not null when using default builds. | [optional] [default to null]
**idle_timeout_last_activity_at** | **datetime** | The time when this session started idling. If idle_timeout is enabled and this value is None, then this session is still active. | [optional] [default to null]
**ray_version** | **str** | The last known ray version running on this cluster. | [optional] [default to null]
**ray_version_last_updated_at** | **datetime** | The time in which the ray version of this was updated. | [optional] [default to null]
**user_service_url** | **str** | URL to access user services (e.g. Ray Serve) | [optional] [default to null]
**ray_component_activities_last_reported_at** | **datetime** | When we last saw an observation from Ray Dashboard. This is populated even if we see an observation of no activity. | [optional] [default to null]
**activity_details** | [**object**](#) | Details of latest positive activity report for all relavant components. Format is mapping of activity type to activity details (includes timestamp and other activity specific fields). | [optional] [default to null]
**maximum_uptime_will_terminate_cluster_at** | **datetime** | The time the cluster will be terminated due to its maximum uptime. If None, the cluster will not be terminated for this reason. | [optional] [default to null]
**idle_termination_status** | [**IdleTerminationStatus**](#idleterminationstatus) | The status of autosuspend | [optional] [default to null]
**ray_dashboard_snapshot_last_reported_at** | **datetime** | The time of the last snapshot recorded from the ray dashboard | [optional] [default to null]

## SessionResponse

A response from the API. Contains a field \"result\" which has the contents of the response.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**result** | [**Session**](#session) |  | [default to null]

## SessionStartingUpData


Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**startup_progress** | **str** |  | [optional] [default to null]
**startup_error** | **str** |  | [optional] [default to null]

## SessionState

An enumeration.

Possible Values:
['Stopped', 'Terminated', 'StartingUp', 'StartupErrored', 'Running', 'Updating', 'UpdatingErrored', 'Stopping', 'Terminating', 'AwaitingStartup', 'AwaitingFileMounts', 'TerminatingErrored', 'StoppingErrored']

## SessionStateData

A way to support unions that gets around the code generator's lack of support for real unions.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**startup** | [**SessionStartingUpData**](#sessionstartingupdata) |  | [optional] [default to null]
**stopping** | [**SessionStoppingData**](#sessionstoppingdata) |  | [optional] [default to null]

## SessionStoppingData


Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**stop_progress** | **str** |  | [optional] [default to null]
**stop_error** | **str** |  | [optional] [default to null]

## SortByClauseJobsSortField

This model is used in the backend to represent the SQL ORDER BY clauses.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**sort_field** | [**JobsSortField**](#jobssortfield) |  | [default to null]
**sort_order** | [**SortOrder**](#sortorder) |  | [default to null]

## SortOrder

An enumeration.

Possible Values:
['ASC', 'DESC']

## SsoconfigResponse

A response from the API. Contains a field \"result\" which has the contents of the response.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**result** | [**SSOConfig**](#ssoconfig) |  | [default to null]

## StartClusterOptions

Options to set when starting a Cluster.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**cluster_environment_build_id** | **str** | Cluster Environment Build used to start Cluster. | [optional] [default to null]
**cluster_compute_id** | **str** | Cluster Compute used to start the Cluster. | [optional] [default to null]
**allow_public_internet_traffic** | **bool** | Whether public internet traffic can access Serve endpoints or if an authentication token is required. Will not update current value if not provided. | [optional] [default to null]

## StaticSSOConfig


Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**idp_entity_id** | **str** | Static configuration for the SAML 2.0 identity provider&#39;s entity id. | [default to null]
**idp_sso_url** | **str** | Static configuration for the SAML 2.0 identity provider&#39;s url. | [default to null]
**idp_sso_binding** | **str** | Static configuration for the SAML 2.0 identity provider&#39;s sso binding. | [default to null]
**idp_x509cert** | **str** | Static configuration for the SAML 2.0 identity provider&#39;s x509cert | [default to null]

## SystemWorkloadName

An enumeration.

Possible Values:
['RAY_OBS_EVENTS_API_SERVICE']

## TerminateClusterOptions

Options to set when terminating a Cluster.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**take_snapshot** | **bool** | DEPRECATED: Snapshotting is no longer supported.For reproducible environments between clusters, please use Cluster Environments or Runtime Environments. | [optional] [default to false]

## TextQuery

Query model to filter results based on Text properties (e.g. name, description).  Exactly one field should be populated.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**equals** | **str** | Property is an exact match of this value. | [optional] [default to null]
**not_equal** | **str** | Property does not match of this value. | [optional] [default to null]
**contains** | **str** | Property contains this value as a substring. The value should not have opening and closing wildcard characters. | [optional] [default to null]

## TracingConfig

Config used to initialize tracing in Anyscale runtime.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**exporter_import_path** | **str** | Path to exporter function. Should be of the form \&quot;module.submodule_1...submodule_n.export_tracing\&quot;. This is equivalent to \&quot;from module.submodule_1...submodule_n import export_tracing. Exporter function takes no arguments and returns List[SpanProcessor]. | [optional] [default to null]
**sampling_ratio** | **float** | Ratio of traces to record and export. Reducing the ratio can help with minimizing serving latency and storage overhead. | [optional] [default to 1.0]
**enabled** | **bool** | Flag to enable tracing in Serve application. If tracing is enabled and no &#x60;exporter_import_path&#x60; path is defined, then the default tracing exporter will be used to export traces to serve logs. | [optional] [default to true]

## UXInstance

This shared model represents an instance type that is supported by Anyscale. It is a shared model for both AWS and GCP instance types, and should not be used directly.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**cpu_count** | **int** | The number of CPUs | [default to null]
**memory_in_gib** | **float** | The amount of memory in GiB | [default to null]
**gpu_type** | **str** | The type of GPU | [optional] [default to null]
**gpu_count** | **int** | The number of GPUs | [optional] [default to null]
**cloud_type** | [**CloudType**](#cloudtype) | The cloud provider | [default to null]
**support_type** | **str** | The instance should be shown in the UI and through API (SDK/CLI). | [default to null]
**name** | **str** | Name of this instance type. | [default to null]
**family** | **str** | Family of this instance type. | [default to null]
**group_key** | **str** | The groupKey indicates which instance types are similar and should be grouped together | [default to null]
**anyscale_credits_per_hour** | **float** | Anyscale credits per hour for the instance. | [default to null]
**available_in_anyscale_hosted** | **bool** | If the instance type is available for anyscale hosted. | [default to null]
**machine_pool_name** | **str** | The machine pool name the instance belongs to if it is PCP machine type, otherwise it is empty string. | [default to null]
**billing_error_message** | **str** | If there was an error in the price calculation for this instance, this message should be shown to the user. | [optional] [default to null]

## UpdateCluster

Model used to update a Cluster. A field will not be updated if its value is absent.

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**name** | **str** | Name of this Cluster. | [optional] [default to null]
**idle_timeout_minutes** | **int** | Idle timeout in minutes. | [optional] [default to null]
**cluster_environment_build_id** | **str** | Cluster Environment Build that this Cluster is using. This property may only be changed if the Cluster is in the Terminated state.Use the Start Cluster operation if you wish to change this for a non-Terminated Cluster. | [optional] [default to null]
**cluster_compute_id** | **str** | Cluster Compute that this Cluster is using. This property may only be changed if the Cluster is in the Terminated state. Use the Start Cluster operation if you wish to change this for a non-Terminated Cluster. | [optional] [default to null]

## UpdateOrganization

Fields to update in the organization.     

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**sso_mode** | [**SSOMode**](#ssomode) | Mode for use of single sign on (SSO) for your organization.WARNING: It is dangerous to require SSO if you are not confident it is correctly configured. Once SSO is required, users may not log into Anyscale without using SSO. If you lock all users out of your organization by requiring incorrectly configured SSO, you may need to contact Anyscale for support. | [default to null]

## UserServiceAccessTypes

An enumeration.

Possible Values:
['private', 'public']

## ValidationError


Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**loc** | **List[str]** |  | [default to null]
**msg** | **str** |  | [default to null]
**type** | **str** |  | [default to null]

## WorkerNodeType


Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**name** | **str** | An arbitrary name for this node type, which will be registered with OSS available_node_types.  | [default to null]
**instance_type** | **str** | The cloud provider instance type to use for this node. | [default to null]
**resources** | [**Resources**](#resources) | Declaration of node resources for Autoscaler. | [optional] [default to null]
**aws_advanced_configurations_json** | [**object**](#) | The advanced configuration json that we pass directly AWS APIs when launching an instance. We may do some validation on this json and reject the json if it is using a configuration that Anyscale does not support. | [optional] [default to null]
**gcp_advanced_configurations_json** | [**object**](#) | The advanced configuration json that we pass directly GCP APIs when launching an instance. We may do some validation on this json and reject the json if it is using a configuration that Anyscale does not support. | [optional] [default to null]
**advanced_configurations_json** | [**object**](#) | Advanced configurations for this compute node type to pass to the cloud provider when launching this instance. | [optional] [default to null]
**flags** | [**object**](#) | A set of advanced node-level flags that can be used to configure a particular workload. | [optional] [default to null]
**min_workers** | **int** | The minimum number of nodes of this type that Anyscale should spin up. | [optional] [default to null]
**max_workers** | **int** | The maximum number of nodes of this type that Anyscale should spin up. | [optional] [default to null]
**use_spot** | **bool** | Whether or not to use spot instances for this node type. | [optional] [default to false]
**fallback_to_ondemand** | **bool** | If use_spot is True, then we will attempt to use spot instances. If this is true as well, then we will fall back to on demand instances if spot instances are not available. If use_spot is False, this value is ignored. | [optional] [default to false]

