# AUTOGENERATED - modify shared_anyscale_util in root directory to make changes
import pytest

from shared_anyscale_utils.utils.ray_semver import (
    _number_prefix_split,
    _number_suffix_split,
    _number_value,
    ray_semver_compare,
)


def test_number_value():
    assert _number_value("1") == 1
    assert _number_value("0") == 0
    assert _number_value("11") == 11
    assert _number_value("1.2") == 0
    assert _number_value("1.2.3") == 0
    assert _number_value("") == 0


def test_number_suffix_split():
    assert _number_suffix_split("") == ("", "")
    assert _number_suffix_split("ray2") == ("ray", "2")
    assert _number_suffix_split("ray11") == ("ray", "11")
    assert _number_suffix_split("ray11a") == ("ray11a", "")


def test_number_prefix_split():
    assert _number_prefix_split("1") == ("1", "")
    assert _number_prefix_split("2rc") == ("2", "rc")
    assert _number_prefix_split("11opt") == ("11", "opt")
    assert _number_prefix_split("x11") == ("", "x11")


@pytest.mark.parametrize(
    ("a", "b", "expected_result"),
    [
        ("2.7.0", "2.7.0", 0),
        ("ray2.7.0", "ray2.7.0", 0),
        ("2.7.0", "ray2.7.0", -1),
        ("rayml2.7.0", "ray2.7.0", 1),
        ("2.7.0optimized", "2.7.0", 1),
        ("2.7.0", "2.7.0optimized", -1),
        ("2.0.1rc1", "2.0.1rc2", -1),
        ("2.7.0", "2.7.0oss", -1),
        ("2.0.1rc", "2.0.1", 1),
        ("3.5.1customsuffix", "3.5.1", 1),
        ("1.2.3", "1.2.3.dev456", -1),
        ("2.0.0.final", "2.0.0", 1),
        ("2.0.0", "2.0.0.final", -1),
        ("2.6.0", "2.7.0", -1),
        ("2.6.0", "2.11.0", -1),
        ("2.0.1rc", "2.0.2", -1),
        ("2.7.0optimized", "2.7.0oss", -1),
        ("nightly", "2.7.0", 1),
    ],
)
def test_ray_semver_compare(a, b, expected_result):
    if a != b:
        assert expected_result != 0
    assert ray_semver_compare(a, b) == expected_result
    if expected_result != 0:
        assert ray_semver_compare(b, a) == -expected_result
