import logging

from typing_extensions import Literal

from anyscale.sdk.anyscale_client.api.default_api import DefaultApi as BaseApi
from anyscale.util import get_cluster_model_for_current_workspace


logger = logging.getLogger(__name__)
from anyscale.anyscale_pydantic import BaseModel


WORKSPACE_NOTIFICATION_ADDRESS = "http://localhost:8266/simplefileserver/notifications"


class WorkspaceNotificationAction(BaseModel):
    type: Literal["navigate-service", "navigate-workspace-tab", "navigate-external-url"]
    title: str
    value: str


class WorkspaceNotification(BaseModel):
    body: str
    action: WorkspaceNotificationAction


def send_workspace_notification(
    anyscale_api_client: BaseApi, notification: WorkspaceNotification
):

    try:
        if get_cluster_model_for_current_workspace(anyscale_api_client) is None:
            # We are not in a workspace, so we don't want to send a notification
            return
        import requests

        requests.post(WORKSPACE_NOTIFICATION_ADDRESS, json=notification.dict())
    except Exception:
        logger.exception("Failed to send notification to UI")
