# PegasusTools

[![Actions Status][actions-badge]][actions-link]
[![pre-commit.ci status][pre-commit-badge]][pre-commit-link]
[![Documentation Status][rtd-badge]][rtd-link]

[![PyPI version][pypi-version]][pypi-link]
[![PyPI platforms][pypi-platforms]][pypi-link]
[![Code style: Ruff][ruff-badge]][ruff-link]

<!-- [![GitHub Discussion][github-discussions-badge]][github-discussions-link] -->

<!-- SPHINX-START -->

<!-- prettier-ignore-start -->
[actions-badge]:            https://github.com/PegasusPIC/pegasustools/workflows/CI/badge.svg
[actions-link]:             https://github.com/PegasusPIC/pegasustools/actions
<!-- [github-discussions-badge]: https://img.shields.io/static/v1?label=Discussions&message=Ask&color=blue&logo=github
[github-discussions-link]:  https://github.com/PegasusPIC/pegasustools/discussions -->
[pypi-link]:                https://pypi.org/project/pegasustools/
[pypi-platforms]:           https://img.shields.io/pypi/pyversions/pegasustools
[pypi-version]:             https://img.shields.io/pypi/v/pegasustools
[rtd-badge]:                https://readthedocs.org/projects/pegasustools/badge/?version=latest
[rtd-link]:                 https://pegasustools.readthedocs.io/en/latest/?badge=latest
[pre-commit-badge]:         https://results.pre-commit.ci/badge/github/PegasusPIC/pegasustools/main.svg
[pre-commit-link]:          https://results.pre-commit.ci/latest/github/PegasusPIC/pegasustools/main
[ruff-badge]:               https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/astral-sh/ruff/main/assets/badge/v2.json
[ruff-link]:                https://github.com/astral-sh/ruff

<!-- prettier-ignore-end -->

## Summary

[PegasusTools](https://github.com/PegasusPIC/pegasustools) is an analysis
package for the Pegasus++ Particle-In-Cell (PIC) code. It can be easily
installed with `pip install pegasustools` or `uv pip install pegasustools`. The
documentation for the latest stable version can be found
[here](https://pegasustools.readthedocs.io/en/stable/). Once installed it can be
imported directly into any Python program via `import pegasustools as pt`

## Found a Bug or Have a Feature Request?

Please open an issue and we'll figure out a solution.

## Contributing

If you wish to contribute please review the contribution guide in
[CONTRIBUTING.md](./.github/CONTRIBUTING.md). All contributions need to come via
pull requests. I recommend you fork this repo, make your changes, then submit a
PR from your feature branch.

## Citation

If `PegasusTools` has been significant to a project that leads to an academic
publication, please acknowledge our work by citing it using the information in
the included citation.cff file; citations in APA or BibTex format can be found
in the "About" section of the GitHub repository.

## Bibliography

- [M. W. Kunz, J. M. Stone, X.-N. Bai, 2014, JCoP, 259, 154 \
  _Pegasus: A new hybrid-kinetic particle-in-cell code for astrophysical plasma dynamics_](https://ui.adsabs.harvard.edu/abs/2014JCoPh.259..154K/abstract)
- Icon made by max.icons from [www.flaticon.com](https://www.flaticon.com)
