"""add preserve_on_migration to block

Revision ID: 341068089f14
Revises: 348214cbc081
Create Date: 2025-05-29 10:39:44.494643

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op
from letta.settings import settings

# revision identifiers, used by Alembic.
revision: str = "341068089f14"
down_revision: Union[str, None] = "348214cbc081"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # Skip this migration for SQLite
    if not settings.letta_pg_uri_no_default:
        return

    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("block", sa.Column("preserve_on_migration", sa.Boolean(), nullable=True))
    # ### end Alembic commands ###


def downgrade() -> None:
    # Skip this migration for SQLite
    if not settings.letta_pg_uri_no_default:
        return

    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("block", "preserve_on_migration")
    # ### end Alembic commands ###
