"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WatchApiGateway = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const constructs_1 = require("constructs");
const metrics_1 = require("./monitoring/aws/api-gateway/metrics");
class WatchApiGateway extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.api = props.restApi.node.findChild('Resource');
        this.apiName = this.api.name;
        this.stage = props.restApi.deploymentStage.stageName;
        this.watchful = props.watchful;
        this.metrics = new metrics_1.ApiGatewayMetricFactory();
        const alarmThreshold = props.serverErrorThreshold == null ? 1 : props.serverErrorThreshold;
        if (alarmThreshold) {
            const count5xxMetric = this.metrics.metricErrors(this.apiName, this.stage).count5XX.with({
                statistic: 'sum',
                period: aws_cdk_lib_1.Duration.minutes(5),
            });
            this.watchful.addAlarm(count5xxMetric.createAlarm(this, '5XXErrorAlarm', {
                alarmDescription: `at ${alarmThreshold}`,
                threshold: alarmThreshold,
                comparisonOperator: aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_OR_EQUAL_TO_THRESHOLD,
                evaluationPeriods: 1,
            }));
        }
        this.watchful.addSection(props.title, {
            links: [{ title: 'Amazon API Gateway Console', url: linkForApiGateway(props.restApi) }],
        });
        [undefined, ...props.watchedOperations || []].forEach(operation => this.watchful.addWidgets(this.createCallGraphWidget(operation, alarmThreshold), ...props.cacheGraph ? [this.createCacheGraphWidget(operation)] : [], this.createLatencyGraphWidget(operation), this.createIntegrationLatencyGraphWidget(operation)));
    }
    createCallGraphWidget(opts, alarmThreshold) {
        const leftAnnotations = alarmThreshold
            ? [{ value: alarmThreshold, color: '#ff0000', label: '5XX Errors Alarm' }]
            : [];
        return new aws_cloudwatch_1.GraphWidget({
            title: `${opts ? `${opts.httpMethod} ${opts.resourcePath}` : 'Overall'} Calls/min`,
            width: 12,
            stacked: false,
            left: [
                this.metrics.metricCalls(this.apiName, this.stage, opts),
                this.metrics.metricErrors(this.apiName, this.stage, opts).count4XX,
                this.metrics.metricErrors(this.apiName, this.stage, opts).count5XX,
            ],
            leftAnnotations,
        });
    }
    createCacheGraphWidget(opts) {
        return new aws_cloudwatch_1.GraphWidget({
            title: `${opts ? `${opts.httpMethod} ${opts.resourcePath}` : 'Overall'} Cache/min`,
            width: 12,
            stacked: false,
            left: [
                this.metrics.metricCalls(this.apiName, this.stage, opts),
                this.metrics.metricCache(this.apiName, this.stage, opts).hits,
                this.metrics.metricCache(this.apiName, this.stage, opts).misses,
            ],
        });
    }
    createLatencyGraphWidget(opts) {
        return new aws_cloudwatch_1.GraphWidget({
            title: `${opts ? `${opts.httpMethod} ${opts.resourcePath}` : 'Overall'} (1-minute periods)`,
            width: 12,
            stacked: false,
            left: Object.values(this.metrics.metricLatency(this.apiName, this.stage, opts)),
        });
    }
    createIntegrationLatencyGraphWidget(opts) {
        return new aws_cloudwatch_1.GraphWidget({
            title: `${opts ? `${opts.httpMethod} ${opts.resourcePath}` : 'Overall'} Integration (1-minute periods)`,
            width: 12,
            stacked: false,
            left: Object.values(this.metrics.metricIntegrationLatency(this.apiName, this.stage, opts)),
        });
    }
}
exports.WatchApiGateway = WatchApiGateway;
_a = JSII_RTTI_SYMBOL_1;
WatchApiGateway[_a] = { fqn: "cdk-watchful.WatchApiGateway", version: "0.6.417" };
function linkForApiGateway(api) {
    return `https://console.aws.amazon.com/apigateway/home?region=${api.stack.region}#/apis/${api.restApiId}`;
}
//# sourceMappingURL=data:application/json;base64,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