"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WatchfulAspect = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const apigw = require("aws-cdk-lib/aws-apigateway");
const dynamodb = require("aws-cdk-lib/aws-dynamodb");
const ecs_patterns = require("aws-cdk-lib/aws-ecs-patterns");
const lambda = require("aws-cdk-lib/aws-lambda");
const rds = require("aws-cdk-lib/aws-rds");
const stepfunctions = require("aws-cdk-lib/aws-stepfunctions");
/**
 * A CDK aspect that can automatically watch all resources within a scope.
 */
class WatchfulAspect {
    /**
     * Defines a watchful aspect
     * @param watchful The watchful to add those resources to
     * @param props Options
     */
    constructor(watchful, props = {}) {
        this.watchful = watchful;
        this.props = props;
    }
    visit(node) {
        const watchApiGateway = this.props.apiGateway === undefined ? true : this.props.apiGateway;
        const watchDynamo = this.props.dynamodb === undefined ? true : this.props.dynamodb;
        const watchLambda = this.props.lambda === undefined ? true : this.props.lambda;
        const watchStateMachine = this.props.stateMachine === undefined ? true : this.props.stateMachine;
        const watchRdsAuroraCluster = this.props.rdsaurora === undefined ? true : this.props.rdsaurora;
        const watchFargateEcs = this.props.fargateecs === undefined ? true : this.props.fargateecs;
        const watchEc2Ecs = this.props.ec2ecs === undefined ? true : this.props.ec2ecs;
        if (watchApiGateway && node instanceof apigw.RestApi) {
            this.watchful.watchApiGateway(node.node.path, node);
        }
        if (watchDynamo && node instanceof dynamodb.Table) {
            this.watchful.watchDynamoTable(node.node.path, node);
        }
        if (watchLambda && node instanceof lambda.Function) {
            this.watchful.watchLambdaFunction(node.node.path, node);
        }
        if (watchStateMachine && node instanceof stepfunctions.StateMachine) {
            this.watchful.watchStateMachine(node.node.path, node);
        }
        if (watchRdsAuroraCluster && node instanceof rds.DatabaseCluster) {
            this.watchful.watchRdsAuroraCluster(node.node.path, node);
        }
        if (watchFargateEcs && node instanceof ecs_patterns.ApplicationLoadBalancedFargateService) {
            this.watchful.watchFargateEcs(node.node.path, node.service, node.targetGroup);
        }
        if (watchEc2Ecs && node instanceof ecs_patterns.ApplicationLoadBalancedEc2Service) {
            this.watchful.watchEc2Ecs(node.node.path, node.service, node.targetGroup);
        }
    }
}
exports.WatchfulAspect = WatchfulAspect;
_a = JSII_RTTI_SYMBOL_1;
WatchfulAspect[_a] = { fqn: "cdk-watchful.WatchfulAspect", version: "0.6.417" };
//# sourceMappingURL=data:application/json;base64,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