"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiGatewayMetricFactory = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const Namespace = 'AWS/ApiGateway';
const StatisticP90 = 'p90';
const StatisticP95 = 'p95';
const StatisticP99 = 'p99';
class ApiGatewayMetricFactory {
    metricErrors(apiName, stage, op) {
        return {
            count4XX: this.metric("4XXError" /* FourHundredError */, apiName, stage, op).with({ label: '4XX Errors', statistic: aws_cloudwatch_1.Statistic.SUM, color: '#ff7f0e' }),
            count5XX: this.metric("5XXError" /* FiveHundredError */, apiName, stage, op).with({ label: '5XX Errors', statistic: aws_cloudwatch_1.Statistic.SUM, color: '#d62728' }),
        };
    }
    metricCache(apiName, stage, op) {
        return {
            hits: this.metric("CacheHitCount" /* CacheHitCount */, apiName, stage, op).with({ label: 'Cache Hit', statistic: aws_cloudwatch_1.Statistic.SUM, color: '#2ca02c' }),
            misses: this.metric("CacheMissCount" /* CacheMissCount */, apiName, stage, op).with({ label: 'Cache Miss', statistic: aws_cloudwatch_1.Statistic.SUM, color: '#d62728' }),
        };
    }
    metricCalls(apiName, stage, op) {
        return this.metric("Count" /* Count */, apiName, stage, op).with({ label: 'Calls', color: '#1f77b4', statistic: aws_cloudwatch_1.Statistic.SUM });
    }
    metricIntegrationLatency(apiName, stage, op) {
        const baseMetric = this.metric("IntegrationLatency" /* IntegrationLatency */, apiName, stage, op);
        return {
            min: baseMetric.with({ label: 'min', statistic: aws_cloudwatch_1.Statistic.MINIMUM }),
            avg: baseMetric.with({ label: 'avg', statistic: aws_cloudwatch_1.Statistic.AVERAGE }),
            p90: baseMetric.with({ label: 'p90', statistic: StatisticP90 }),
            p95: baseMetric.with({ label: 'p95', statistic: StatisticP95 }),
            p99: baseMetric.with({ label: 'p99', statistic: StatisticP99 }),
            max: baseMetric.with({ label: 'max', statistic: aws_cloudwatch_1.Statistic.MAXIMUM }),
        };
    }
    metricLatency(apiName, stage, op) {
        const baseMetric = this.metric("Latency" /* Latency */, apiName, stage, op);
        return {
            min: baseMetric.with({ label: 'min', statistic: aws_cloudwatch_1.Statistic.MINIMUM }),
            avg: baseMetric.with({ label: 'avg', statistic: aws_cloudwatch_1.Statistic.AVERAGE }),
            p90: baseMetric.with({ label: 'p90', statistic: StatisticP90 }),
            p95: baseMetric.with({ label: 'p95', statistic: StatisticP95 }),
            p99: baseMetric.with({ label: 'p99', statistic: StatisticP99 }),
            max: baseMetric.with({ label: 'max', statistic: aws_cloudwatch_1.Statistic.MAXIMUM }),
        };
    }
    metric(metricName, apiName, stage, op) {
        return new aws_cloudwatch_1.Metric({
            metricName,
            namespace: Namespace,
            period: aws_cdk_lib_1.Duration.minutes(1),
            dimensionsMap: {
                ApiName: apiName,
                Stage: stage,
                ...op && {
                    Method: op.httpMethod,
                    Resource: op.resourcePath,
                },
            },
        });
    }
}
exports.ApiGatewayMetricFactory = ApiGatewayMetricFactory;
//# sourceMappingURL=data:application/json;base64,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