"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RdsAuroraMetricFactory = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const Namespace = 'AWS/RDS';
/**
 * Metrics for RDS Aurora.
 */
class RdsAuroraMetricFactory {
    metricDmlThroughput(clusterIdentifier) {
        return {
            dbInsertThroughputMetric: this.metric("InsertThroughput" /* InsertThroughput */, clusterIdentifier).with({ statistic: aws_cloudwatch_1.Statistic.SUM }),
            dbUpdateThroughputMetric: this.metric("UpdateThroughput" /* UpdateThroughput */, clusterIdentifier).with({ statistic: aws_cloudwatch_1.Statistic.SUM }),
            dbSelectThroughputMetric: this.metric("SelectThroughput" /* SelectThroughput */, clusterIdentifier).with({ statistic: aws_cloudwatch_1.Statistic.SUM }),
            dbDeleteThroughputMetric: this.metric("DeleteThroughput" /* DeleteThroughput */, clusterIdentifier).with({ statistic: aws_cloudwatch_1.Statistic.SUM }),
        };
    }
    metricBufferCacheHitRatio(clusterIdentifier) {
        return this.metric("BufferCacheHitRatio" /* BufferCacheHitRatio */, clusterIdentifier).with({ statistic: aws_cloudwatch_1.Statistic.AVERAGE });
    }
    metricDbConnections(clusterIdentifier) {
        return this.metric("DatabaseConnections" /* DatabaseConnections */, clusterIdentifier).with({ statistic: aws_cloudwatch_1.Statistic.AVERAGE });
    }
    metricReplicaLag(clusterIdentifier) {
        return this.metric("AuroraReplicaLag" /* AuroraReplicaLag */, clusterIdentifier).with({ statistic: aws_cloudwatch_1.Statistic.AVERAGE });
    }
    metricCpuUtilization(clusterIdentifier) {
        return this.metric("CPUUtilization" /* CPUUtilization */, clusterIdentifier).with({ statistic: aws_cloudwatch_1.Statistic.AVERAGE });
    }
    metric(metric, clusterIdentifier) {
        return new aws_cloudwatch_1.Metric({
            metricName: metric,
            namespace: Namespace,
            period: aws_cdk_lib_1.Duration.minutes(5),
            statistic: aws_cloudwatch_1.Statistic.SUM,
            dimensionsMap: {
                DBClusterIdentifier: clusterIdentifier,
            },
        });
    }
}
exports.RdsAuroraMetricFactory = RdsAuroraMetricFactory;
//# sourceMappingURL=data:application/json;base64,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