"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SqsMetricFactory = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const Namespace = 'AWS/SQS';
class SqsMetricFactory {
    metricApproximateVisibleMessages(queueName) {
        return this.metric("ApproximateNumberOfMessagesVisible" /* ApproximateNumberOfMessagesVisible */, queueName).with({ statistic: aws_cloudwatch_1.Statistic.MAXIMUM });
    }
    metricIncomingMessages(queueName) {
        return this.metric("NumberOfMessagesSent" /* NumberOfMessagesSent */, queueName).with({ statistic: aws_cloudwatch_1.Statistic.SUM });
    }
    metricAgeOfOldestMessageInSeconds(queueName) {
        return this.metric("ApproximateAgeOfOldestMessage" /* ApproximateAgeOfOldestMessage */, queueName).with({ statistic: aws_cloudwatch_1.Statistic.MAXIMUM });
    }
    metricAverageMessageSizeInBytes(queueName) {
        return this.metric("SentMessageSize" /* SentMessageSize */, queueName).with({ statistic: aws_cloudwatch_1.Statistic.AVERAGE });
    }
    metric(metric, queueName) {
        return new aws_cloudwatch_1.Metric({
            metricName: metric,
            namespace: Namespace,
            period: aws_cdk_lib_1.Duration.minutes(5),
            dimensionsMap: {
                QueueName: queueName,
            },
        });
    }
}
exports.SqsMetricFactory = SqsMetricFactory;
//# sourceMappingURL=data:application/json;base64,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