"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WatchStateMachine = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const constructs_1 = require("constructs");
const metrics_1 = require("./monitoring/aws/state-machine/metrics");
class WatchStateMachine extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.title = props.title;
        this.watchful = props.watchful;
        this.stateMachine = props.stateMachine;
        this.metricFailedThreshold = props.metricFailedThreshold ?? 1;
        this.metrics = new metrics_1.StateMachineMetricFactory();
        this.createLinks();
        this.createExecutionMetrics();
    }
    createExecutionMetrics() {
        const execMetrics = this.metrics.metricExecutions(this.stateMachine.stateMachineArn);
        const { failed } = execMetrics;
        const failedWithPeriod = failed.with({
            statistic: 'sum',
            period: aws_cdk_lib_1.Duration.minutes(5),
        });
        const failureAlarm = failedWithPeriod.createAlarm(this, 'ExecutionFailures', {
            alarmDescription: `at ${this.metricFailedThreshold}`,
            threshold: this.metricFailedThreshold,
            comparisonOperator: aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_OR_EQUAL_TO_THRESHOLD,
            evaluationPeriods: 1,
        });
        this.watchful.addAlarm(failureAlarm);
        this.watchful.addWidgets(new aws_cloudwatch_1.GraphWidget({
            title: 'Overall Execution/min',
            width: 12,
            stacked: false,
            left: Object.values(execMetrics),
            leftAnnotations: [{ value: this.metricFailedThreshold, color: '#ff0000', label: 'Execution Failure Alarm' }],
        }));
    }
    createLinks() {
        this.watchful.addSection(this.title, {
            links: [{
                    title: 'Amazon State Machine',
                    url: `https://console.aws.amazon.com/states/home?region=${this.stateMachine.stack.region}#/statemachines/view/${this.stateMachine.stateMachineArn}`,
                }],
        });
    }
}
exports.WatchStateMachine = WatchStateMachine;
_a = JSII_RTTI_SYMBOL_1;
WatchStateMachine[_a] = { fqn: "cdk-watchful.WatchStateMachine", version: "0.6.417" };
//# sourceMappingURL=data:application/json;base64,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