"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SectionWidget = void 0;
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
/**
 * Renders a section header in the following format:
 *
 * # Header
 * Description
 * [button:label1](url1) [button:label2](url2)
 */
class SectionWidget extends aws_cloudwatch_1.TextWidget {
    static toMarkdown(props) {
        const lines = [];
        // title
        const titlePrefix = '#'.repeat(props.titleLevel ?? 1);
        lines.push(`${titlePrefix} ${props.titleMarkdown}`);
        // description
        if (props.descriptionMarkdown) {
            lines.push(props.descriptionMarkdown);
        }
        // quick links
        if (props.quicklinks && props.quicklinks.length > 0) {
            lines.push(props.quicklinks.map(link => `[button:${link.title}](${link.url})`).join(' '));
        }
        return lines.join('\n\n');
    }
    constructor(props) {
        super({ width: props.width ?? 24, height: props.height ?? 2, markdown: SectionWidget.toMarkdown(props) });
    }
}
exports.SectionWidget = SectionWidget;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2VjdGlvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy93aWRnZXQvc2VjdGlvbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSwrREFBd0Q7QUFzQ3hEOzs7Ozs7R0FNRztBQUNILE1BQWEsYUFBYyxTQUFRLDJCQUFVO0lBQ25DLE1BQU0sQ0FBQyxVQUFVLENBQUMsS0FBeUI7UUFDakQsTUFBTSxLQUFLLEdBQWEsRUFBRSxDQUFDO1FBRTNCLFFBQVE7UUFFUixNQUFNLFdBQVcsR0FBRyxHQUFHLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxVQUFVLElBQUksQ0FBQyxDQUFDLENBQUM7UUFDdEQsS0FBSyxDQUFDLElBQUksQ0FBQyxHQUFHLFdBQVcsSUFBSSxLQUFLLENBQUMsYUFBYSxFQUFFLENBQUMsQ0FBQztRQUVwRCxjQUFjO1FBRWQsSUFBSSxLQUFLLENBQUMsbUJBQW1CLEVBQUU7WUFDN0IsS0FBSyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsbUJBQW1CLENBQUMsQ0FBQztTQUN2QztRQUVELGNBQWM7UUFFZCxJQUFJLEtBQUssQ0FBQyxVQUFVLElBQUksS0FBSyxDQUFDLFVBQVUsQ0FBQyxNQUFNLEdBQUcsQ0FBQyxFQUFFO1lBQ25ELEtBQUssQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxXQUFXLElBQUksQ0FBQyxLQUFLLEtBQUssSUFBSSxDQUFDLEdBQUcsR0FBRyxDQUFDLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7U0FDM0Y7UUFFRCxPQUFPLEtBQUssQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDNUIsQ0FBQztJQUVELFlBQVksS0FBeUI7UUFDbkMsS0FBSyxDQUFDLEVBQUUsS0FBSyxFQUFFLEtBQUssQ0FBQyxLQUFLLElBQUksRUFBRSxFQUFFLE1BQU0sRUFBRSxLQUFLLENBQUMsTUFBTSxJQUFJLENBQUMsRUFBRSxRQUFRLEVBQUUsYUFBYSxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsRUFBRSxDQUFDLENBQUM7SUFDNUcsQ0FBQztDQUNGO0FBM0JELHNDQTJCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFRleHRXaWRnZXQgfSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtY2xvdWR3YXRjaCc7XG5pbXBvcnQgeyBRdWlja0xpbmsgfSBmcm9tICcuLi9hcGknO1xuXG4vKipcbiAqIFByb3BzIHRvIGNyZWF0ZSBTZWN0aW9uV2lkZ2V0LlxuICovXG5leHBvcnQgaW50ZXJmYWNlIFNlY3Rpb25XaWRnZXRQcm9wcyB7XG4gIC8qKlxuICAgKiB3aWRnZXQgd2lkdGhcbiAgICogQGRlZmF1bHQgZnVsbCB3aWR0aFxuICAgKi9cbiAgcmVhZG9ubHkgd2lkdGg/OiBudW1iZXI7XG4gIC8qKlxuICAgKiB3aWRnZXQgaGVpZ2h0XG4gICAqIEBkZWZhdWx0IDJcbiAgICovXG4gIHJlYWRvbmx5IGhlaWdodD86IG51bWJlcjtcbiAgLyoqXG4gICAqIHRpdGxlIGxldmVsICgxID0gSDEsIDIgPSBIMiwgZXRjKVxuICAgKiBAZGVmYXVsdCAxXG4gICAqL1xuICByZWFkb25seSB0aXRsZUxldmVsPzogbnVtYmVyO1xuICAvKipcbiAgICogc2VjdGlvbiB0aXRsZSAobWlnaHQgYmUgbWFya2Rvd24pXG4gICAqL1xuICByZWFkb25seSB0aXRsZU1hcmtkb3duOiBzdHJpbmc7XG4gIC8qKlxuICAgKiBzZWN0aW9uIGRlc2NyaXB0aW9uIChtaWdodCBiZSBtYXJrZG93bilcbiAgICogQGRlZmF1bHQgZW1wdHlcbiAgICovXG4gIHJlYWRvbmx5IGRlc2NyaXB0aW9uTWFya2Rvd24/OiBzdHJpbmc7XG4gIC8qKlxuICAgKiBxdWljayBsaW5rcywgdGhhdCB3aWxsIGJlIHJlbmRlcmVkIGFzIGJ1dHRvbnNcbiAgICogQGRlZmF1bHQgbm9uZVxuICAgKi9cbiAgcmVhZG9ubHkgcXVpY2tsaW5rcz86IFF1aWNrTGlua1tdO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgYSBzZWN0aW9uIGhlYWRlciBpbiB0aGUgZm9sbG93aW5nIGZvcm1hdDpcbiAqXG4gKiAjIEhlYWRlclxuICogRGVzY3JpcHRpb25cbiAqIFtidXR0b246bGFiZWwxXSh1cmwxKSBbYnV0dG9uOmxhYmVsMl0odXJsMilcbiAqL1xuZXhwb3J0IGNsYXNzIFNlY3Rpb25XaWRnZXQgZXh0ZW5kcyBUZXh0V2lkZ2V0IHtcbiAgcHJpdmF0ZSBzdGF0aWMgdG9NYXJrZG93bihwcm9wczogU2VjdGlvbldpZGdldFByb3BzKSB7XG4gICAgY29uc3QgbGluZXM6IHN0cmluZ1tdID0gW107XG5cbiAgICAvLyB0aXRsZVxuXG4gICAgY29uc3QgdGl0bGVQcmVmaXggPSAnIycucmVwZWF0KHByb3BzLnRpdGxlTGV2ZWwgPz8gMSk7XG4gICAgbGluZXMucHVzaChgJHt0aXRsZVByZWZpeH0gJHtwcm9wcy50aXRsZU1hcmtkb3dufWApO1xuXG4gICAgLy8gZGVzY3JpcHRpb25cblxuICAgIGlmIChwcm9wcy5kZXNjcmlwdGlvbk1hcmtkb3duKSB7XG4gICAgICBsaW5lcy5wdXNoKHByb3BzLmRlc2NyaXB0aW9uTWFya2Rvd24pO1xuICAgIH1cblxuICAgIC8vIHF1aWNrIGxpbmtzXG5cbiAgICBpZiAocHJvcHMucXVpY2tsaW5rcyAmJiBwcm9wcy5xdWlja2xpbmtzLmxlbmd0aCA+IDApIHtcbiAgICAgIGxpbmVzLnB1c2gocHJvcHMucXVpY2tsaW5rcy5tYXAobGluayA9PiBgW2J1dHRvbjoke2xpbmsudGl0bGV9XSgke2xpbmsudXJsfSlgKS5qb2luKCcgJykpO1xuICAgIH1cblxuICAgIHJldHVybiBsaW5lcy5qb2luKCdcXG5cXG4nKTtcbiAgfVxuXG4gIGNvbnN0cnVjdG9yKHByb3BzOiBTZWN0aW9uV2lkZ2V0UHJvcHMpIHtcbiAgICBzdXBlcih7IHdpZHRoOiBwcm9wcy53aWR0aCA/PyAyNCwgaGVpZ2h0OiBwcm9wcy5oZWlnaHQgPz8gMiwgbWFya2Rvd246IFNlY3Rpb25XaWRnZXQudG9NYXJrZG93bihwcm9wcykgfSk7XG4gIH1cbn1cbiJdfQ==