# This is an auto-generated file. Do not change it manually

from typing import Literal
from ..resource_type_helpers import ResourceTypeDescriptor

type Datasource = Literal[
    'aemet-grid',
    'era5',
    'merra2',
    'noaa',
    'pvgis',
]

type PvradarResourceType = Literal[
    'any',
    'ac_energy',
    'ac_power',
    'aemet_grid_table',
    'aerosol_angstrom_exponent',
    'aerosol_extinction_optical_thickness',
    'aerosol_mixing_ratio',
    'aerosol_mixing_ratio_table',
    'aerosol_scattering_optical_thickness',
    'air_density',
    'air_temperature',
    'angle_of_incidence',
    'cell_temperature',
    'dc_energy',
    'dc_power',
    'diffuse_horizontal_irradiance',
    'diffuse_poa_on_back',
    'diffuse_poa_on_front',
    'direct_normal_irradiance',
    'direct_poa_on_back',
    'direct_poa_on_front',
    'effective_poa',
    'energy_sales_price',
    'era5_single_level_table',
    'extraterrestrial_radiation',
    'fixed_design_spec',
    'global_horizontal_irradiance',
    'global_poa',
    'global_poa_on_back',
    'global_poa_on_front',
    'grid_energy',
    'grid_power',
    'ground_albedo',
    'ground_diffuse_poa_on_back',
    'ground_diffuse_poa_on_front',
    'interval',
    'inverter_energy',
    'inverter_power',
    'location',
    'merra2_aerosol_diagnostics_table',
    'merra2_aerosol_mixing_table',
    'merra2_land_surface_table',
    'merra2_meteo_table',
    'merra2_surface_flux_table',
    'meteo_station_table',
    'module_temperature',
    'particle_mass_concentration',
    'particle_mixing_ratio',
    'particle_volume_concentration',
    'pm10_volume_concentration',
    'pm2_5_volume_concentration',
    'pvgis_seriescalc_table',
    'rainfall',
    'rainfall_mass_rate',
    'rainfall_rate',
    'reflection_loss_factor',
    'relative_humidity',
    'revenue',
    'sky_diffuse_poa_on_back',
    'sky_diffuse_poa_on_front',
    'snow_coverage',
    'snow_density',
    'snow_depth',
    'snow_depth_water_equivalent',
    'snow_loss_factor',
    'snowfall',
    'snowfall_mass_rate',
    'snowfall_rate',
    'snowfall_water_equivalent',
    'soiling_cleaning_events',
    'soiling_loss_factor',
    'solar_azimuth_angle',
    'solar_elevation_angle',
    'solar_zenith_angle',
    'surface_azimuth_angle',
    'surface_tilt_angle',
    'total_precipitation',
    'total_precipitation_mass_rate',
    'tracker_design_spec',
    'tracker_rotation_angle',
    'uv_horizontal_irradiance',
    'wind_speed',
]

default_datasources: dict[PvradarResourceType, Datasource] = {
    'aemet_grid_table': 'aemet-grid',
    'aerosol_angstrom_exponent': 'merra2',
    'aerosol_extinction_optical_thickness': 'merra2',
    'aerosol_mixing_ratio': 'merra2',
    'aerosol_mixing_ratio_table': 'merra2',
    'aerosol_scattering_optical_thickness': 'merra2',
    'air_density': 'merra2',
    'air_temperature': 'merra2',
    'era5_single_level_table': 'era5',
    'global_horizontal_irradiance': 'pvgis',
    'merra2_aerosol_diagnostics_table': 'merra2',
    'merra2_aerosol_mixing_table': 'merra2',
    'merra2_land_surface_table': 'merra2',
    'merra2_meteo_table': 'merra2',
    'merra2_surface_flux_table': 'merra2',
    'meteo_station_table': 'noaa',
    'particle_mixing_ratio': 'merra2',
    'particle_volume_concentration': 'merra2',
    'pm10_volume_concentration': 'merra2',
    'pm2_5_volume_concentration': 'merra2',
    'pvgis_seriescalc_table': 'pvgis',
    'rainfall': 'merra2',
    'rainfall_mass_rate': 'merra2',
    'rainfall_rate': 'merra2',
    'relative_humidity': 'merra2',
    'snow_density': 'era5',
    'snow_depth': 'merra2',
    'snow_depth_water_equivalent': 'era5',
    'snowfall': 'merra2',
    'snowfall_mass_rate': 'merra2',
    'snowfall_rate': 'merra2',
    'snowfall_water_equivalent': 'era5',
    'total_precipitation': 'merra2',
    'total_precipitation_mass_rate': 'merra2',
    'uv_horizontal_irradiance': 'era5',
    'wind_speed': 'pvgis',
}

standard_mapping: dict[PvradarResourceType, dict] = {
    'ac_energy': ResourceTypeDescriptor.make_attrs(
        resource_type='ac_energy',
        to_unit='Wh',
        agg='sum',
    ),
    'ac_power': ResourceTypeDescriptor.make_attrs(
        resource_type='ac_power',
        to_unit='W',
        agg='mean',
    ),
    'aemet_grid_table': ResourceTypeDescriptor.make_attrs(
        resource_type='aemet_grid_table',
    ),
    'aerosol_angstrom_exponent': ResourceTypeDescriptor.make_attrs(
        resource_type='aerosol_angstrom_exponent',
        to_unit='dimensionless',
        agg='mean',
    ),
    'aerosol_extinction_optical_thickness': ResourceTypeDescriptor.make_attrs(
        resource_type='aerosol_extinction_optical_thickness',
        to_unit='dimensionless',
        agg='mean',
    ),
    'aerosol_mixing_ratio': ResourceTypeDescriptor.make_attrs(
        resource_type='aerosol_mixing_ratio',
        to_unit='kg/kg',
        agg='mean',
    ),
    'aerosol_mixing_ratio_table': ResourceTypeDescriptor.make_attrs(
        resource_type='aerosol_mixing_ratio_table',
    ),
    'aerosol_scattering_optical_thickness': ResourceTypeDescriptor.make_attrs(
        resource_type='aerosol_scattering_optical_thickness',
        to_unit='dimensionless',
        agg='mean',
    ),
    'air_density': ResourceTypeDescriptor.make_attrs(
        resource_type='air_density',
        to_unit='kg/m^3',
        agg='mean',
    ),
    'air_temperature': ResourceTypeDescriptor.make_attrs(
        resource_type='air_temperature',
        to_unit='degC',
        agg='mean',
    ),
    'angle_of_incidence': ResourceTypeDescriptor.make_attrs(
        resource_type='angle_of_incidence',
        to_unit='deg',
        agg='mean',
    ),
    'cell_temperature': ResourceTypeDescriptor.make_attrs(
        resource_type='cell_temperature',
        to_unit='degC',
        agg='mean',
    ),
    'dc_energy': ResourceTypeDescriptor.make_attrs(
        resource_type='dc_energy',
        to_unit='Wh',
        agg='sum',
    ),
    'dc_power': ResourceTypeDescriptor.make_attrs(
        resource_type='dc_power',
        to_unit='W',
        agg='mean',
    ),
    'diffuse_horizontal_irradiance': ResourceTypeDescriptor.make_attrs(
        resource_type='diffuse_horizontal_irradiance',
        to_unit='W/m^2',
        agg='mean',
    ),
    'diffuse_poa_on_back': ResourceTypeDescriptor.make_attrs(
        resource_type='diffuse_poa_on_back',
        to_unit='W/m^2',
        agg='mean',
    ),
    'diffuse_poa_on_front': ResourceTypeDescriptor.make_attrs(
        resource_type='diffuse_poa_on_front',
        to_unit='W/m^2',
        agg='mean',
    ),
    'direct_normal_irradiance': ResourceTypeDescriptor.make_attrs(
        resource_type='direct_normal_irradiance',
        to_unit='W/m^2',
        agg='mean',
    ),
    'direct_poa_on_back': ResourceTypeDescriptor.make_attrs(
        resource_type='direct_poa_on_back',
        to_unit='W/m^2',
        agg='mean',
    ),
    'direct_poa_on_front': ResourceTypeDescriptor.make_attrs(
        resource_type='direct_poa_on_front',
        to_unit='W/m^2',
        agg='mean',
    ),
    'effective_poa': ResourceTypeDescriptor.make_attrs(
        resource_type='effective_poa',
        to_unit='W/m^2',
        agg='mean',
    ),
    'energy_sales_price': ResourceTypeDescriptor.make_attrs(
        resource_type='energy_sales_price',
        to_unit='currency/MWh',
        agg='mean',
    ),
    'era5_single_level_table': ResourceTypeDescriptor.make_attrs(
        resource_type='era5_single_level_table',
    ),
    'extraterrestrial_radiation': ResourceTypeDescriptor.make_attrs(
        resource_type='extraterrestrial_radiation',
        to_unit='W/m^2',
        agg='mean',
    ),
    'fixed_design_spec': ResourceTypeDescriptor.make_attrs(
        resource_type='fixed_design_spec',
    ),
    'global_horizontal_irradiance': ResourceTypeDescriptor.make_attrs(
        resource_type='global_horizontal_irradiance',
        to_unit='W/m^2',
        agg='mean',
    ),
    'global_poa': ResourceTypeDescriptor.make_attrs(
        resource_type='global_poa',
        to_unit='W/m^2',
        agg='mean',
    ),
    'global_poa_on_back': ResourceTypeDescriptor.make_attrs(
        resource_type='global_poa_on_back',
        to_unit='W/m^2',
        agg='mean',
    ),
    'global_poa_on_front': ResourceTypeDescriptor.make_attrs(
        resource_type='global_poa_on_front',
        to_unit='W/m^2',
        agg='mean',
    ),
    'grid_energy': ResourceTypeDescriptor.make_attrs(
        resource_type='grid_energy',
        to_unit='Wh',
        agg='sum',
    ),
    'grid_power': ResourceTypeDescriptor.make_attrs(
        resource_type='grid_power',
        to_unit='W',
        agg='mean',
    ),
    'ground_albedo': ResourceTypeDescriptor.make_attrs(
        resource_type='ground_albedo',
        to_unit='fraction',
        agg='mean',
    ),
    'ground_diffuse_poa_on_back': ResourceTypeDescriptor.make_attrs(
        resource_type='ground_diffuse_poa_on_back',
        to_unit='W/m^2',
        agg='mean',
    ),
    'ground_diffuse_poa_on_front': ResourceTypeDescriptor.make_attrs(
        resource_type='ground_diffuse_poa_on_front',
        to_unit='W/m^2',
        agg='mean',
    ),
    'interval': ResourceTypeDescriptor.make_attrs(
        resource_type='interval',
    ),
    'inverter_energy': ResourceTypeDescriptor.make_attrs(
        resource_type='inverter_energy',
        to_unit='Wh',
        agg='sum',
    ),
    'inverter_power': ResourceTypeDescriptor.make_attrs(
        resource_type='inverter_power',
        to_unit='W',
        agg='mean',
    ),
    'location': ResourceTypeDescriptor.make_attrs(
        resource_type='location',
    ),
    'merra2_aerosol_diagnostics_table': ResourceTypeDescriptor.make_attrs(
        resource_type='merra2_aerosol_diagnostics_table',
    ),
    'merra2_aerosol_mixing_table': ResourceTypeDescriptor.make_attrs(
        resource_type='merra2_aerosol_mixing_table',
    ),
    'merra2_land_surface_table': ResourceTypeDescriptor.make_attrs(
        resource_type='merra2_land_surface_table',
    ),
    'merra2_meteo_table': ResourceTypeDescriptor.make_attrs(
        resource_type='merra2_meteo_table',
    ),
    'merra2_surface_flux_table': ResourceTypeDescriptor.make_attrs(
        resource_type='merra2_surface_flux_table',
    ),
    'meteo_station_table': ResourceTypeDescriptor.make_attrs(
        resource_type='meteo_station_table',
    ),
    'module_temperature': ResourceTypeDescriptor.make_attrs(
        resource_type='module_temperature',
        to_unit='degC',
        agg='mean',
    ),
    'particle_mass_concentration': ResourceTypeDescriptor.make_attrs(
        resource_type='particle_mass_concentration',
        to_unit='kg/m^3',
        agg='mean',
    ),
    'particle_mixing_ratio': ResourceTypeDescriptor.make_attrs(
        resource_type='particle_mixing_ratio',
        to_unit='kg/kg',
        agg='mean',
    ),
    'particle_volume_concentration': ResourceTypeDescriptor.make_attrs(
        resource_type='particle_volume_concentration',
        to_unit='kg/m^3',
        agg='mean',
    ),
    'pm10_volume_concentration': ResourceTypeDescriptor.make_attrs(
        resource_type='pm10_volume_concentration',
        to_unit='kg/m^3',
        agg='mean',
    ),
    'pm2_5_volume_concentration': ResourceTypeDescriptor.make_attrs(
        resource_type='pm2_5_volume_concentration',
        to_unit='kg/m^3',
        agg='mean',
    ),
    'pvgis_seriescalc_table': ResourceTypeDescriptor.make_attrs(
        resource_type='pvgis_seriescalc_table',
    ),
    'rainfall': ResourceTypeDescriptor.make_attrs(
        resource_type='rainfall',
        to_unit='mm',
        agg='sum',
    ),
    'rainfall_mass_rate': ResourceTypeDescriptor.make_attrs(
        resource_type='rainfall_mass_rate',
        to_unit='kg/m^2/h',
        agg='mean',
    ),
    'rainfall_rate': ResourceTypeDescriptor.make_attrs(
        resource_type='rainfall_rate',
        to_unit='mm/h',
        agg='mean',
    ),
    'reflection_loss_factor': ResourceTypeDescriptor.make_attrs(
        resource_type='reflection_loss_factor',
        to_unit='fraction',
        agg='mean',
    ),
    'relative_humidity': ResourceTypeDescriptor.make_attrs(
        resource_type='relative_humidity',
        to_unit='%',
        agg='mean',
    ),
    'revenue': ResourceTypeDescriptor.make_attrs(
        resource_type='revenue',
        to_unit='currency',
        agg='sum',
    ),
    'sky_diffuse_poa_on_back': ResourceTypeDescriptor.make_attrs(
        resource_type='sky_diffuse_poa_on_back',
        to_unit='W/m^2',
        agg='mean',
    ),
    'sky_diffuse_poa_on_front': ResourceTypeDescriptor.make_attrs(
        resource_type='sky_diffuse_poa_on_front',
        to_unit='W/m^2',
        agg='mean',
    ),
    'snow_coverage': ResourceTypeDescriptor.make_attrs(
        resource_type='snow_coverage',
        to_unit='fraction',
        agg='mean',
    ),
    'snow_density': ResourceTypeDescriptor.make_attrs(
        resource_type='snow_density',
        to_unit='kg/m^3',
        agg='mean',
    ),
    'snow_depth': ResourceTypeDescriptor.make_attrs(
        resource_type='snow_depth',
        to_unit='mm',
        agg='mean',
    ),
    'snow_depth_water_equivalent': ResourceTypeDescriptor.make_attrs(
        resource_type='snow_depth_water_equivalent',
        to_unit='mm',
        agg='mean',
    ),
    'snow_loss_factor': ResourceTypeDescriptor.make_attrs(
        resource_type='snow_loss_factor',
        to_unit='fraction',
        agg='mean',
    ),
    'snowfall': ResourceTypeDescriptor.make_attrs(
        resource_type='snowfall',
        to_unit='mm',
        agg='sum',
    ),
    'snowfall_mass_rate': ResourceTypeDescriptor.make_attrs(
        resource_type='snowfall_mass_rate',
        to_unit='kg/m^2/h',
        agg='mean',
    ),
    'snowfall_rate': ResourceTypeDescriptor.make_attrs(
        resource_type='snowfall_rate',
        to_unit='mm/h',
        agg='mean',
    ),
    'snowfall_water_equivalent': ResourceTypeDescriptor.make_attrs(
        resource_type='snowfall_water_equivalent',
        to_unit='mm',
        agg='sum',
    ),
    'soiling_cleaning_events': ResourceTypeDescriptor.make_attrs(
        resource_type='soiling_cleaning_events',
    ),
    'soiling_loss_factor': ResourceTypeDescriptor.make_attrs(
        resource_type='soiling_loss_factor',
        to_unit='fraction',
        agg='mean',
    ),
    'solar_azimuth_angle': ResourceTypeDescriptor.make_attrs(
        resource_type='solar_azimuth_angle',
        to_unit='deg',
        agg='mean',
    ),
    'solar_elevation_angle': ResourceTypeDescriptor.make_attrs(
        resource_type='solar_elevation_angle',
        to_unit='deg',
        agg='mean',
    ),
    'solar_zenith_angle': ResourceTypeDescriptor.make_attrs(
        resource_type='solar_zenith_angle',
        to_unit='deg',
        agg='mean',
    ),
    'surface_azimuth_angle': ResourceTypeDescriptor.make_attrs(
        resource_type='surface_azimuth_angle',
        to_unit='deg',
        agg='mean',
    ),
    'surface_tilt_angle': ResourceTypeDescriptor.make_attrs(
        resource_type='surface_tilt_angle',
        to_unit='deg',
        agg='mean',
    ),
    'total_precipitation': ResourceTypeDescriptor.make_attrs(
        resource_type='total_precipitation',
        to_unit='mm',
        agg='sum',
    ),
    'total_precipitation_mass_rate': ResourceTypeDescriptor.make_attrs(
        resource_type='total_precipitation_mass_rate',
        to_unit='kg/m^2/h',
        agg='mean',
    ),
    'tracker_design_spec': ResourceTypeDescriptor.make_attrs(
        resource_type='tracker_design_spec',
    ),
    'tracker_rotation_angle': ResourceTypeDescriptor.make_attrs(
        resource_type='tracker_rotation_angle',
        to_unit='deg',
        agg='mean',
    ),
    'uv_horizontal_irradiance': ResourceTypeDescriptor.make_attrs(
        resource_type='uv_horizontal_irradiance',
        to_unit='W/m^2',
        agg='mean',
    ),
    'wind_speed': ResourceTypeDescriptor.make_attrs(
        resource_type='wind_speed',
        to_unit='m/s',
        agg='mean',
    ),
}
