# PYSOLE

## You can finally test your code in real time without using idle!
### If you found [this repository](https://github.com/TzurSoffer/LiveDebugger) useful, please give it a ⭐!.

A fully-featured, **live Python console GUI** built with **CustomTkinter** and **Tkinter**, featuring:

*   Python syntax highlighting via **Pygments**
    
*   Autocomplete for **keywords, built-ins, and local/global variables**
    
*   Thread-safe execution of Python code
    
*   Output capturing for `stdout` and `stderr`
    
*   Multi-line input with auto-indentation
    
*   History of previous commands

* **Integrated Help Panel** for quick access to Python object documentation


## Installation

`pip install liveConsole`


## Features

### Syntax Highlighting

*   Real-time syntax highlighting using **Pygments** and the **Monokai** style.
    
*   Highlights Python keywords, built-ins, and expressions in the console.
    

### Autocomplete

*   Suggests **keywords**, **built-in functions**, and **variables** in scope.
    
*   Popup list appears after typing at least 2 characters.
    
*   Only inserts the **missing portion** of a word.
    
*   Navigate suggestions with **Up/Down arrows**, confirm with **Tab/Return**.
    

### Multi-Line Input

*   Supports **Shift+Enter** for inserting a new line with proper indentation.
    
*   Automatically detects incomplete statements and continues the prompt.
    

### Thread-Safe Execution

*   Executes user code in a separate thread to prevent GUI freezing.
    
*   Captures both `stdout` and `stderr` output and prints them in the console.
    
*   Supports both **expressions (`eval`)** and **statements (`exec`)**.
    

### Clickable History

*   Hover previous commands to see them highlighted.
    
*   Click to copy them back to the prompt for editing or re-execution.
    

### Help Panel

*   A resizable right-hand panel that displays Python documentation (help()) for any object.

*   Opens when clicking ctrl+click on a function/method and can be closed with the "X" button.

*   Scrollable and syntax-styled.

*   Perfect for quick reference without leaving the console.


### Easy Integration

*   Automatically grabs **caller frame globals and locals** if not provided.
    
*   Can be used standalone or embedded in larger CustomTkinter applications.

## Usage

```
import pysole
pysole.probe()
```

*   Type Python commands in the `>>>` prompt and see live output.

## Keyboard Shortcuts

| Key | Action |
| --- | --- |
| `Enter` | Execute command (if complete) |
| `Shift+Enter` | Insert newline with auto-indent |
| `Tab` | Complete the current word / show suggestions |
| `Up/Down` | Navigate suggestion list |
| `Escape` | Hide suggestions |
| `Mouse Click` | Select previous command from history |


## Customization

*   **Appearance mode**: Dark mode is default (`ctk.set_appearance_mode("dark")`)
    
*   **Font**: Consolas, 12pt by default, configurable in `InteractiveConsoleText` constructor
    
*   **Syntax Highlighting Style**: Change Pygments style by modifying `get_style_by_name("monokai")`



## License

MIT License – free to use, modify, and distribute.
