# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .raw_client import AsyncRawDashboardClient, RawDashboardClient

if typing.TYPE_CHECKING:
    from .settings.client import AsyncSettingsClient, SettingsClient


class DashboardClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawDashboardClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._settings: typing.Optional[SettingsClient] = None

    @property
    def with_raw_response(self) -> RawDashboardClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawDashboardClient
        """
        return self._raw_client

    @property
    def settings(self):
        if self._settings is None:
            from .settings.client import SettingsClient  # noqa: E402

            self._settings = SettingsClient(client_wrapper=self._client_wrapper)
        return self._settings


class AsyncDashboardClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawDashboardClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._settings: typing.Optional[AsyncSettingsClient] = None

    @property
    def with_raw_response(self) -> AsyncRawDashboardClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawDashboardClient
        """
        return self._raw_client

    @property
    def settings(self):
        if self._settings is None:
            from .settings.client import AsyncSettingsClient  # noqa: E402

            self._settings = AsyncSettingsClient(client_wrapper=self._client_wrapper)
        return self._settings
