# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.jsonable_encoder import jsonable_encoder
from ...core.request_options import RequestOptions
from ...core.serialization import convert_and_respect_annotation_metadata
from ...core.unchecked_base_model import construct_type
from ...errors.unprocessable_entity_error import UnprocessableEntityError
from ...types.agent_failure_response_example import AgentFailureResponseExample
from ...types.agent_successful_response_example import AgentSuccessfulResponseExample
from ...types.conversation_history_transcript_common_model_input import ConversationHistoryTranscriptCommonModelInput
from ...types.create_unit_test_response_model import CreateUnitTestResponseModel
from ...types.get_tests_page_response_model import GetTestsPageResponseModel
from ...types.get_tests_summaries_by_ids_response_model import GetTestsSummariesByIdsResponseModel
from ...types.get_unit_test_response_model import GetUnitTestResponseModel
from ...types.http_validation_error import HttpValidationError
from ...types.test_from_conversation_metadata_input import TestFromConversationMetadataInput
from ...types.unit_test_common_model_type import UnitTestCommonModelType
from ...types.unit_test_tool_call_evaluation_model_input import UnitTestToolCallEvaluationModelInput
from .types.create_unit_test_request_dynamic_variables_value import CreateUnitTestRequestDynamicVariablesValue
from .types.update_unit_test_request_dynamic_variables_value import UpdateUnitTestRequestDynamicVariablesValue

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawTestsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def create(
        self,
        *,
        chat_history: typing.Sequence[ConversationHistoryTranscriptCommonModelInput],
        success_condition: str,
        success_examples: typing.Sequence[AgentSuccessfulResponseExample],
        failure_examples: typing.Sequence[AgentFailureResponseExample],
        name: str,
        tool_call_parameters: typing.Optional[UnitTestToolCallEvaluationModelInput] = OMIT,
        dynamic_variables: typing.Optional[
            typing.Dict[str, typing.Optional[CreateUnitTestRequestDynamicVariablesValue]]
        ] = OMIT,
        type: typing.Optional[UnitTestCommonModelType] = OMIT,
        from_conversation_metadata: typing.Optional[TestFromConversationMetadataInput] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[CreateUnitTestResponseModel]:
        """
        Creates a new agent response test.

        Parameters
        ----------
        chat_history : typing.Sequence[ConversationHistoryTranscriptCommonModelInput]

        success_condition : str
            A prompt that evaluates whether the agent's response is successful. Should return True or False.

        success_examples : typing.Sequence[AgentSuccessfulResponseExample]
            Non-empty list of example responses that should be considered successful

        failure_examples : typing.Sequence[AgentFailureResponseExample]
            Non-empty list of example responses that should be considered failures

        name : str

        tool_call_parameters : typing.Optional[UnitTestToolCallEvaluationModelInput]
            How to evaluate the agent's tool call (if any). If empty, the tool call is not evaluated.

        dynamic_variables : typing.Optional[typing.Dict[str, typing.Optional[CreateUnitTestRequestDynamicVariablesValue]]]
            Dynamic variables to replace in the agent config during testing

        type : typing.Optional[UnitTestCommonModelType]

        from_conversation_metadata : typing.Optional[TestFromConversationMetadataInput]
            Metadata of a conversation this test was created from (if applicable).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CreateUnitTestResponseModel]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/convai/agent-testing/create",
            method="POST",
            json={
                "chat_history": convert_and_respect_annotation_metadata(
                    object_=chat_history,
                    annotation=typing.Sequence[ConversationHistoryTranscriptCommonModelInput],
                    direction="write",
                ),
                "success_condition": success_condition,
                "success_examples": convert_and_respect_annotation_metadata(
                    object_=success_examples,
                    annotation=typing.Sequence[AgentSuccessfulResponseExample],
                    direction="write",
                ),
                "failure_examples": convert_and_respect_annotation_metadata(
                    object_=failure_examples, annotation=typing.Sequence[AgentFailureResponseExample], direction="write"
                ),
                "tool_call_parameters": convert_and_respect_annotation_metadata(
                    object_=tool_call_parameters, annotation=UnitTestToolCallEvaluationModelInput, direction="write"
                ),
                "dynamic_variables": convert_and_respect_annotation_metadata(
                    object_=dynamic_variables,
                    annotation=typing.Dict[str, typing.Optional[CreateUnitTestRequestDynamicVariablesValue]],
                    direction="write",
                ),
                "type": type,
                "from_conversation_metadata": convert_and_respect_annotation_metadata(
                    object_=from_conversation_metadata, annotation=TestFromConversationMetadataInput, direction="write"
                ),
                "name": name,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CreateUnitTestResponseModel,
                    construct_type(
                        type_=CreateUnitTestResponseModel,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get(
        self, test_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[GetUnitTestResponseModel]:
        """
        Gets an agent response test by ID.

        Parameters
        ----------
        test_id : str
            The id of a chat response test. This is returned on test creation.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetUnitTestResponseModel]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/convai/agent-testing/{jsonable_encoder(test_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetUnitTestResponseModel,
                    construct_type(
                        type_=GetUnitTestResponseModel,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update(
        self,
        test_id: str,
        *,
        chat_history: typing.Sequence[ConversationHistoryTranscriptCommonModelInput],
        success_condition: str,
        success_examples: typing.Sequence[AgentSuccessfulResponseExample],
        failure_examples: typing.Sequence[AgentFailureResponseExample],
        name: str,
        tool_call_parameters: typing.Optional[UnitTestToolCallEvaluationModelInput] = OMIT,
        dynamic_variables: typing.Optional[
            typing.Dict[str, typing.Optional[UpdateUnitTestRequestDynamicVariablesValue]]
        ] = OMIT,
        type: typing.Optional[UnitTestCommonModelType] = OMIT,
        from_conversation_metadata: typing.Optional[TestFromConversationMetadataInput] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GetUnitTestResponseModel]:
        """
        Updates an agent response test by ID.

        Parameters
        ----------
        test_id : str
            The id of a chat response test. This is returned on test creation.

        chat_history : typing.Sequence[ConversationHistoryTranscriptCommonModelInput]

        success_condition : str
            A prompt that evaluates whether the agent's response is successful. Should return True or False.

        success_examples : typing.Sequence[AgentSuccessfulResponseExample]
            Non-empty list of example responses that should be considered successful

        failure_examples : typing.Sequence[AgentFailureResponseExample]
            Non-empty list of example responses that should be considered failures

        name : str

        tool_call_parameters : typing.Optional[UnitTestToolCallEvaluationModelInput]
            How to evaluate the agent's tool call (if any). If empty, the tool call is not evaluated.

        dynamic_variables : typing.Optional[typing.Dict[str, typing.Optional[UpdateUnitTestRequestDynamicVariablesValue]]]
            Dynamic variables to replace in the agent config during testing

        type : typing.Optional[UnitTestCommonModelType]

        from_conversation_metadata : typing.Optional[TestFromConversationMetadataInput]
            Metadata of a conversation this test was created from (if applicable).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetUnitTestResponseModel]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/convai/agent-testing/{jsonable_encoder(test_id)}",
            method="PUT",
            json={
                "chat_history": convert_and_respect_annotation_metadata(
                    object_=chat_history,
                    annotation=typing.Sequence[ConversationHistoryTranscriptCommonModelInput],
                    direction="write",
                ),
                "success_condition": success_condition,
                "success_examples": convert_and_respect_annotation_metadata(
                    object_=success_examples,
                    annotation=typing.Sequence[AgentSuccessfulResponseExample],
                    direction="write",
                ),
                "failure_examples": convert_and_respect_annotation_metadata(
                    object_=failure_examples, annotation=typing.Sequence[AgentFailureResponseExample], direction="write"
                ),
                "tool_call_parameters": convert_and_respect_annotation_metadata(
                    object_=tool_call_parameters, annotation=UnitTestToolCallEvaluationModelInput, direction="write"
                ),
                "dynamic_variables": convert_and_respect_annotation_metadata(
                    object_=dynamic_variables,
                    annotation=typing.Dict[str, typing.Optional[UpdateUnitTestRequestDynamicVariablesValue]],
                    direction="write",
                ),
                "type": type,
                "from_conversation_metadata": convert_and_respect_annotation_metadata(
                    object_=from_conversation_metadata, annotation=TestFromConversationMetadataInput, direction="write"
                ),
                "name": name,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetUnitTestResponseModel,
                    construct_type(
                        type_=GetUnitTestResponseModel,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete(
        self, test_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.Optional[typing.Any]]:
        """
        Deletes an agent response test by ID.

        Parameters
        ----------
        test_id : str
            The id of a chat response test. This is returned on test creation.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.Optional[typing.Any]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/convai/agent-testing/{jsonable_encoder(test_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if _response is None or not _response.text.strip():
                return HttpResponse(response=_response, data=None)
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[typing.Any],
                    construct_type(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def summaries(
        self, *, test_ids: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[GetTestsSummariesByIdsResponseModel]:
        """
        Gets multiple agent response tests by their IDs. Returns a dictionary mapping test IDs to test summaries.

        Parameters
        ----------
        test_ids : typing.Sequence[str]
            List of test IDs to fetch. No duplicates allowed.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetTestsSummariesByIdsResponseModel]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/convai/agent-testing/summaries",
            method="POST",
            json={
                "test_ids": test_ids,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetTestsSummariesByIdsResponseModel,
                    construct_type(
                        type_=GetTestsSummariesByIdsResponseModel,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def list(
        self,
        *,
        cursor: typing.Optional[str] = None,
        page_size: typing.Optional[int] = None,
        search: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GetTestsPageResponseModel]:
        """
        Lists all agent response tests with pagination support and optional search filtering.

        Parameters
        ----------
        cursor : typing.Optional[str]
            Used for fetching next page. Cursor is returned in the response.

        page_size : typing.Optional[int]
            How many Tests to return at maximum. Can not exceed 100, defaults to 30.

        search : typing.Optional[str]
            Search query to filter tests by name.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetTestsPageResponseModel]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/convai/agent-testing",
            method="GET",
            params={
                "cursor": cursor,
                "page_size": page_size,
                "search": search,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetTestsPageResponseModel,
                    construct_type(
                        type_=GetTestsPageResponseModel,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawTestsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def create(
        self,
        *,
        chat_history: typing.Sequence[ConversationHistoryTranscriptCommonModelInput],
        success_condition: str,
        success_examples: typing.Sequence[AgentSuccessfulResponseExample],
        failure_examples: typing.Sequence[AgentFailureResponseExample],
        name: str,
        tool_call_parameters: typing.Optional[UnitTestToolCallEvaluationModelInput] = OMIT,
        dynamic_variables: typing.Optional[
            typing.Dict[str, typing.Optional[CreateUnitTestRequestDynamicVariablesValue]]
        ] = OMIT,
        type: typing.Optional[UnitTestCommonModelType] = OMIT,
        from_conversation_metadata: typing.Optional[TestFromConversationMetadataInput] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[CreateUnitTestResponseModel]:
        """
        Creates a new agent response test.

        Parameters
        ----------
        chat_history : typing.Sequence[ConversationHistoryTranscriptCommonModelInput]

        success_condition : str
            A prompt that evaluates whether the agent's response is successful. Should return True or False.

        success_examples : typing.Sequence[AgentSuccessfulResponseExample]
            Non-empty list of example responses that should be considered successful

        failure_examples : typing.Sequence[AgentFailureResponseExample]
            Non-empty list of example responses that should be considered failures

        name : str

        tool_call_parameters : typing.Optional[UnitTestToolCallEvaluationModelInput]
            How to evaluate the agent's tool call (if any). If empty, the tool call is not evaluated.

        dynamic_variables : typing.Optional[typing.Dict[str, typing.Optional[CreateUnitTestRequestDynamicVariablesValue]]]
            Dynamic variables to replace in the agent config during testing

        type : typing.Optional[UnitTestCommonModelType]

        from_conversation_metadata : typing.Optional[TestFromConversationMetadataInput]
            Metadata of a conversation this test was created from (if applicable).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CreateUnitTestResponseModel]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/convai/agent-testing/create",
            method="POST",
            json={
                "chat_history": convert_and_respect_annotation_metadata(
                    object_=chat_history,
                    annotation=typing.Sequence[ConversationHistoryTranscriptCommonModelInput],
                    direction="write",
                ),
                "success_condition": success_condition,
                "success_examples": convert_and_respect_annotation_metadata(
                    object_=success_examples,
                    annotation=typing.Sequence[AgentSuccessfulResponseExample],
                    direction="write",
                ),
                "failure_examples": convert_and_respect_annotation_metadata(
                    object_=failure_examples, annotation=typing.Sequence[AgentFailureResponseExample], direction="write"
                ),
                "tool_call_parameters": convert_and_respect_annotation_metadata(
                    object_=tool_call_parameters, annotation=UnitTestToolCallEvaluationModelInput, direction="write"
                ),
                "dynamic_variables": convert_and_respect_annotation_metadata(
                    object_=dynamic_variables,
                    annotation=typing.Dict[str, typing.Optional[CreateUnitTestRequestDynamicVariablesValue]],
                    direction="write",
                ),
                "type": type,
                "from_conversation_metadata": convert_and_respect_annotation_metadata(
                    object_=from_conversation_metadata, annotation=TestFromConversationMetadataInput, direction="write"
                ),
                "name": name,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CreateUnitTestResponseModel,
                    construct_type(
                        type_=CreateUnitTestResponseModel,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get(
        self, test_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[GetUnitTestResponseModel]:
        """
        Gets an agent response test by ID.

        Parameters
        ----------
        test_id : str
            The id of a chat response test. This is returned on test creation.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetUnitTestResponseModel]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/convai/agent-testing/{jsonable_encoder(test_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetUnitTestResponseModel,
                    construct_type(
                        type_=GetUnitTestResponseModel,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update(
        self,
        test_id: str,
        *,
        chat_history: typing.Sequence[ConversationHistoryTranscriptCommonModelInput],
        success_condition: str,
        success_examples: typing.Sequence[AgentSuccessfulResponseExample],
        failure_examples: typing.Sequence[AgentFailureResponseExample],
        name: str,
        tool_call_parameters: typing.Optional[UnitTestToolCallEvaluationModelInput] = OMIT,
        dynamic_variables: typing.Optional[
            typing.Dict[str, typing.Optional[UpdateUnitTestRequestDynamicVariablesValue]]
        ] = OMIT,
        type: typing.Optional[UnitTestCommonModelType] = OMIT,
        from_conversation_metadata: typing.Optional[TestFromConversationMetadataInput] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GetUnitTestResponseModel]:
        """
        Updates an agent response test by ID.

        Parameters
        ----------
        test_id : str
            The id of a chat response test. This is returned on test creation.

        chat_history : typing.Sequence[ConversationHistoryTranscriptCommonModelInput]

        success_condition : str
            A prompt that evaluates whether the agent's response is successful. Should return True or False.

        success_examples : typing.Sequence[AgentSuccessfulResponseExample]
            Non-empty list of example responses that should be considered successful

        failure_examples : typing.Sequence[AgentFailureResponseExample]
            Non-empty list of example responses that should be considered failures

        name : str

        tool_call_parameters : typing.Optional[UnitTestToolCallEvaluationModelInput]
            How to evaluate the agent's tool call (if any). If empty, the tool call is not evaluated.

        dynamic_variables : typing.Optional[typing.Dict[str, typing.Optional[UpdateUnitTestRequestDynamicVariablesValue]]]
            Dynamic variables to replace in the agent config during testing

        type : typing.Optional[UnitTestCommonModelType]

        from_conversation_metadata : typing.Optional[TestFromConversationMetadataInput]
            Metadata of a conversation this test was created from (if applicable).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetUnitTestResponseModel]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/convai/agent-testing/{jsonable_encoder(test_id)}",
            method="PUT",
            json={
                "chat_history": convert_and_respect_annotation_metadata(
                    object_=chat_history,
                    annotation=typing.Sequence[ConversationHistoryTranscriptCommonModelInput],
                    direction="write",
                ),
                "success_condition": success_condition,
                "success_examples": convert_and_respect_annotation_metadata(
                    object_=success_examples,
                    annotation=typing.Sequence[AgentSuccessfulResponseExample],
                    direction="write",
                ),
                "failure_examples": convert_and_respect_annotation_metadata(
                    object_=failure_examples, annotation=typing.Sequence[AgentFailureResponseExample], direction="write"
                ),
                "tool_call_parameters": convert_and_respect_annotation_metadata(
                    object_=tool_call_parameters, annotation=UnitTestToolCallEvaluationModelInput, direction="write"
                ),
                "dynamic_variables": convert_and_respect_annotation_metadata(
                    object_=dynamic_variables,
                    annotation=typing.Dict[str, typing.Optional[UpdateUnitTestRequestDynamicVariablesValue]],
                    direction="write",
                ),
                "type": type,
                "from_conversation_metadata": convert_and_respect_annotation_metadata(
                    object_=from_conversation_metadata, annotation=TestFromConversationMetadataInput, direction="write"
                ),
                "name": name,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetUnitTestResponseModel,
                    construct_type(
                        type_=GetUnitTestResponseModel,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete(
        self, test_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.Optional[typing.Any]]:
        """
        Deletes an agent response test by ID.

        Parameters
        ----------
        test_id : str
            The id of a chat response test. This is returned on test creation.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.Optional[typing.Any]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/convai/agent-testing/{jsonable_encoder(test_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if _response is None or not _response.text.strip():
                return AsyncHttpResponse(response=_response, data=None)
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[typing.Any],
                    construct_type(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def summaries(
        self, *, test_ids: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[GetTestsSummariesByIdsResponseModel]:
        """
        Gets multiple agent response tests by their IDs. Returns a dictionary mapping test IDs to test summaries.

        Parameters
        ----------
        test_ids : typing.Sequence[str]
            List of test IDs to fetch. No duplicates allowed.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetTestsSummariesByIdsResponseModel]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/convai/agent-testing/summaries",
            method="POST",
            json={
                "test_ids": test_ids,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetTestsSummariesByIdsResponseModel,
                    construct_type(
                        type_=GetTestsSummariesByIdsResponseModel,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def list(
        self,
        *,
        cursor: typing.Optional[str] = None,
        page_size: typing.Optional[int] = None,
        search: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GetTestsPageResponseModel]:
        """
        Lists all agent response tests with pagination support and optional search filtering.

        Parameters
        ----------
        cursor : typing.Optional[str]
            Used for fetching next page. Cursor is returned in the response.

        page_size : typing.Optional[int]
            How many Tests to return at maximum. Can not exceed 100, defaults to 30.

        search : typing.Optional[str]
            Search query to filter tests by name.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetTestsPageResponseModel]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/convai/agent-testing",
            method="GET",
            params={
                "cursor": cursor,
                "page_size": page_size,
                "search": search,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetTestsPageResponseModel,
                    construct_type(
                        type_=GetTestsPageResponseModel,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
