# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from .. import core
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.delete_dubbing_response_model import DeleteDubbingResponseModel
from ..types.do_dubbing_response import DoDubbingResponse
from ..types.dubbing_metadata_page_response_model import DubbingMetadataPageResponseModel
from ..types.dubbing_metadata_response import DubbingMetadataResponse
from .raw_client import AsyncRawDubbingClient, RawDubbingClient
from .types.dubbing_create_request_mode import DubbingCreateRequestMode
from .types.dubbing_list_request_dubbing_status import DubbingListRequestDubbingStatus
from .types.dubbing_list_request_filter_by_creator import DubbingListRequestFilterByCreator
from .types.dubbing_list_request_order_direction import DubbingListRequestOrderDirection

if typing.TYPE_CHECKING:
    from .audio.client import AsyncAudioClient, AudioClient
    from .resource.client import AsyncResourceClient, ResourceClient
    from .transcript.client import AsyncTranscriptClient, TranscriptClient
# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class DubbingClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawDubbingClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._resource: typing.Optional[ResourceClient] = None
        self._audio: typing.Optional[AudioClient] = None
        self._transcript: typing.Optional[TranscriptClient] = None

    @property
    def with_raw_response(self) -> RawDubbingClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawDubbingClient
        """
        return self._raw_client

    def list(
        self,
        *,
        cursor: typing.Optional[str] = None,
        page_size: typing.Optional[int] = None,
        dubbing_status: typing.Optional[DubbingListRequestDubbingStatus] = None,
        filter_by_creator: typing.Optional[DubbingListRequestFilterByCreator] = None,
        order_by: typing.Optional[typing.Literal["created_at"]] = None,
        order_direction: typing.Optional[DubbingListRequestOrderDirection] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DubbingMetadataPageResponseModel:
        """
        List the dubs you have access to.

        Parameters
        ----------
        cursor : typing.Optional[str]
            Used for fetching next page. Cursor is returned in the response.

        page_size : typing.Optional[int]
            How many dubs to return at maximum. Can not exceed 200, defaults to 100.

        dubbing_status : typing.Optional[DubbingListRequestDubbingStatus]
            What state the dub is currently in.

        filter_by_creator : typing.Optional[DubbingListRequestFilterByCreator]
            Filters who created the resources being listed, whether it was the user running the request or someone else that shared the resource with them.

        order_by : typing.Optional[typing.Literal["created_at"]]
            The field to use for ordering results from this query.

        order_direction : typing.Optional[DubbingListRequestOrderDirection]
            The order direction to use for results from this query.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DubbingMetadataPageResponseModel
            Successful Response

        Examples
        --------
        from elevenlabs import ElevenLabs

        client = ElevenLabs(
            api_key="YOUR_API_KEY",
        )
        client.dubbing.list(
            cursor="cursor",
            page_size=1,
            dubbing_status="dubbing",
            filter_by_creator="personal",
            order_direction="DESCENDING",
        )
        """
        _response = self._raw_client.list(
            cursor=cursor,
            page_size=page_size,
            dubbing_status=dubbing_status,
            filter_by_creator=filter_by_creator,
            order_by=order_by,
            order_direction=order_direction,
            request_options=request_options,
        )
        return _response.data

    def create(
        self,
        *,
        file: core.File,
        csv_file: core.File,
        foreground_audio_file: core.File,
        background_audio_file: core.File,
        name: typing.Optional[str] = OMIT,
        source_url: typing.Optional[str] = OMIT,
        source_lang: typing.Optional[str] = OMIT,
        target_lang: typing.Optional[str] = OMIT,
        target_accent: typing.Optional[str] = OMIT,
        num_speakers: typing.Optional[int] = OMIT,
        watermark: typing.Optional[bool] = OMIT,
        start_time: typing.Optional[int] = OMIT,
        end_time: typing.Optional[int] = OMIT,
        highest_resolution: typing.Optional[bool] = OMIT,
        drop_background_audio: typing.Optional[bool] = OMIT,
        use_profanity_filter: typing.Optional[bool] = OMIT,
        dubbing_studio: typing.Optional[bool] = OMIT,
        disable_voice_cloning: typing.Optional[bool] = OMIT,
        mode: typing.Optional[DubbingCreateRequestMode] = OMIT,
        csv_fps: typing.Optional[float] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DoDubbingResponse:
        """
        Dubs a provided audio or video file into given language.

        Parameters
        ----------
        file : core.File
            See core.File for more documentation

        csv_file : core.File
            See core.File for more documentation

        foreground_audio_file : core.File
            See core.File for more documentation

        background_audio_file : core.File
            See core.File for more documentation

        name : typing.Optional[str]
            Name of the dubbing project.

        source_url : typing.Optional[str]
            URL of the source video/audio file.

        source_lang : typing.Optional[str]
            Source language.

        target_lang : typing.Optional[str]
            The Target language to dub the content into.

        target_accent : typing.Optional[str]
            [Experimental] An accent to apply when selecting voices from the library and to use to inform translation of the dialect to prefer.

        num_speakers : typing.Optional[int]
            Number of speakers to use for the dubbing. Set to 0 to automatically detect the number of speakers

        watermark : typing.Optional[bool]
            Whether to apply watermark to the output video.

        start_time : typing.Optional[int]
            Start time of the source video/audio file.

        end_time : typing.Optional[int]
            End time of the source video/audio file.

        highest_resolution : typing.Optional[bool]
            Whether to use the highest resolution available.

        drop_background_audio : typing.Optional[bool]
            An advanced setting. Whether to drop background audio from the final dub. This can improve dub quality where it's known that audio shouldn't have a background track such as for speeches or monologues.

        use_profanity_filter : typing.Optional[bool]
            [BETA] Whether transcripts should have profanities censored with the words '[censored]'

        dubbing_studio : typing.Optional[bool]
            Whether to prepare dub for edits in dubbing studio or edits as a dubbing resource.

        disable_voice_cloning : typing.Optional[bool]
            Instead of using a voice clone in dubbing, use a similar voice from the ElevenLabs Voice Library. Voices used from the library will contribute towards a workspace's custom voices limit, and if there aren't enough available slots the dub will fail. Using this feature requires the caller to have the 'add_voice_from_voice_library' permission on their workspace to access new voices.

        mode : typing.Optional[DubbingCreateRequestMode]
            The mode in which to run this Dubbing job. Defaults to automatic, use manual if specifically providing a CSV transcript to use.

        csv_fps : typing.Optional[float]
            Frames per second to use when parsing a CSV file for dubbing. If not provided, FPS will be inferred from timecodes.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DoDubbingResponse
            Successful Response

        Examples
        --------
        from elevenlabs import ElevenLabs

        client = ElevenLabs(
            api_key="YOUR_API_KEY",
        )
        client.dubbing.create()
        """
        _response = self._raw_client.create(
            file=file,
            csv_file=csv_file,
            foreground_audio_file=foreground_audio_file,
            background_audio_file=background_audio_file,
            name=name,
            source_url=source_url,
            source_lang=source_lang,
            target_lang=target_lang,
            target_accent=target_accent,
            num_speakers=num_speakers,
            watermark=watermark,
            start_time=start_time,
            end_time=end_time,
            highest_resolution=highest_resolution,
            drop_background_audio=drop_background_audio,
            use_profanity_filter=use_profanity_filter,
            dubbing_studio=dubbing_studio,
            disable_voice_cloning=disable_voice_cloning,
            mode=mode,
            csv_fps=csv_fps,
            request_options=request_options,
        )
        return _response.data

    def get(
        self, dubbing_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DubbingMetadataResponse:
        """
        Returns metadata about a dubbing project, including whether it's still in progress or not

        Parameters
        ----------
        dubbing_id : str
            ID of the dubbing project.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DubbingMetadataResponse
            Successful Response

        Examples
        --------
        from elevenlabs import ElevenLabs

        client = ElevenLabs(
            api_key="YOUR_API_KEY",
        )
        client.dubbing.get(
            dubbing_id="dubbing_id",
        )
        """
        _response = self._raw_client.get(dubbing_id, request_options=request_options)
        return _response.data

    def delete(
        self, dubbing_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeleteDubbingResponseModel:
        """
        Deletes a dubbing project.

        Parameters
        ----------
        dubbing_id : str
            ID of the dubbing project.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeleteDubbingResponseModel
            Successful Response

        Examples
        --------
        from elevenlabs import ElevenLabs

        client = ElevenLabs(
            api_key="YOUR_API_KEY",
        )
        client.dubbing.delete(
            dubbing_id="dubbing_id",
        )
        """
        _response = self._raw_client.delete(dubbing_id, request_options=request_options)
        return _response.data

    @property
    def resource(self):
        if self._resource is None:
            from .resource.client import ResourceClient  # noqa: E402

            self._resource = ResourceClient(client_wrapper=self._client_wrapper)
        return self._resource

    @property
    def audio(self):
        if self._audio is None:
            from .audio.client import AudioClient  # noqa: E402

            self._audio = AudioClient(client_wrapper=self._client_wrapper)
        return self._audio

    @property
    def transcript(self):
        if self._transcript is None:
            from .transcript.client import TranscriptClient  # noqa: E402

            self._transcript = TranscriptClient(client_wrapper=self._client_wrapper)
        return self._transcript


class AsyncDubbingClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawDubbingClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._resource: typing.Optional[AsyncResourceClient] = None
        self._audio: typing.Optional[AsyncAudioClient] = None
        self._transcript: typing.Optional[AsyncTranscriptClient] = None

    @property
    def with_raw_response(self) -> AsyncRawDubbingClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawDubbingClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        cursor: typing.Optional[str] = None,
        page_size: typing.Optional[int] = None,
        dubbing_status: typing.Optional[DubbingListRequestDubbingStatus] = None,
        filter_by_creator: typing.Optional[DubbingListRequestFilterByCreator] = None,
        order_by: typing.Optional[typing.Literal["created_at"]] = None,
        order_direction: typing.Optional[DubbingListRequestOrderDirection] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DubbingMetadataPageResponseModel:
        """
        List the dubs you have access to.

        Parameters
        ----------
        cursor : typing.Optional[str]
            Used for fetching next page. Cursor is returned in the response.

        page_size : typing.Optional[int]
            How many dubs to return at maximum. Can not exceed 200, defaults to 100.

        dubbing_status : typing.Optional[DubbingListRequestDubbingStatus]
            What state the dub is currently in.

        filter_by_creator : typing.Optional[DubbingListRequestFilterByCreator]
            Filters who created the resources being listed, whether it was the user running the request or someone else that shared the resource with them.

        order_by : typing.Optional[typing.Literal["created_at"]]
            The field to use for ordering results from this query.

        order_direction : typing.Optional[DubbingListRequestOrderDirection]
            The order direction to use for results from this query.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DubbingMetadataPageResponseModel
            Successful Response

        Examples
        --------
        import asyncio

        from elevenlabs import AsyncElevenLabs

        client = AsyncElevenLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.dubbing.list(
                cursor="cursor",
                page_size=1,
                dubbing_status="dubbing",
                filter_by_creator="personal",
                order_direction="DESCENDING",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            cursor=cursor,
            page_size=page_size,
            dubbing_status=dubbing_status,
            filter_by_creator=filter_by_creator,
            order_by=order_by,
            order_direction=order_direction,
            request_options=request_options,
        )
        return _response.data

    async def create(
        self,
        *,
        file: core.File,
        csv_file: core.File,
        foreground_audio_file: core.File,
        background_audio_file: core.File,
        name: typing.Optional[str] = OMIT,
        source_url: typing.Optional[str] = OMIT,
        source_lang: typing.Optional[str] = OMIT,
        target_lang: typing.Optional[str] = OMIT,
        target_accent: typing.Optional[str] = OMIT,
        num_speakers: typing.Optional[int] = OMIT,
        watermark: typing.Optional[bool] = OMIT,
        start_time: typing.Optional[int] = OMIT,
        end_time: typing.Optional[int] = OMIT,
        highest_resolution: typing.Optional[bool] = OMIT,
        drop_background_audio: typing.Optional[bool] = OMIT,
        use_profanity_filter: typing.Optional[bool] = OMIT,
        dubbing_studio: typing.Optional[bool] = OMIT,
        disable_voice_cloning: typing.Optional[bool] = OMIT,
        mode: typing.Optional[DubbingCreateRequestMode] = OMIT,
        csv_fps: typing.Optional[float] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DoDubbingResponse:
        """
        Dubs a provided audio or video file into given language.

        Parameters
        ----------
        file : core.File
            See core.File for more documentation

        csv_file : core.File
            See core.File for more documentation

        foreground_audio_file : core.File
            See core.File for more documentation

        background_audio_file : core.File
            See core.File for more documentation

        name : typing.Optional[str]
            Name of the dubbing project.

        source_url : typing.Optional[str]
            URL of the source video/audio file.

        source_lang : typing.Optional[str]
            Source language.

        target_lang : typing.Optional[str]
            The Target language to dub the content into.

        target_accent : typing.Optional[str]
            [Experimental] An accent to apply when selecting voices from the library and to use to inform translation of the dialect to prefer.

        num_speakers : typing.Optional[int]
            Number of speakers to use for the dubbing. Set to 0 to automatically detect the number of speakers

        watermark : typing.Optional[bool]
            Whether to apply watermark to the output video.

        start_time : typing.Optional[int]
            Start time of the source video/audio file.

        end_time : typing.Optional[int]
            End time of the source video/audio file.

        highest_resolution : typing.Optional[bool]
            Whether to use the highest resolution available.

        drop_background_audio : typing.Optional[bool]
            An advanced setting. Whether to drop background audio from the final dub. This can improve dub quality where it's known that audio shouldn't have a background track such as for speeches or monologues.

        use_profanity_filter : typing.Optional[bool]
            [BETA] Whether transcripts should have profanities censored with the words '[censored]'

        dubbing_studio : typing.Optional[bool]
            Whether to prepare dub for edits in dubbing studio or edits as a dubbing resource.

        disable_voice_cloning : typing.Optional[bool]
            Instead of using a voice clone in dubbing, use a similar voice from the ElevenLabs Voice Library. Voices used from the library will contribute towards a workspace's custom voices limit, and if there aren't enough available slots the dub will fail. Using this feature requires the caller to have the 'add_voice_from_voice_library' permission on their workspace to access new voices.

        mode : typing.Optional[DubbingCreateRequestMode]
            The mode in which to run this Dubbing job. Defaults to automatic, use manual if specifically providing a CSV transcript to use.

        csv_fps : typing.Optional[float]
            Frames per second to use when parsing a CSV file for dubbing. If not provided, FPS will be inferred from timecodes.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DoDubbingResponse
            Successful Response

        Examples
        --------
        import asyncio

        from elevenlabs import AsyncElevenLabs

        client = AsyncElevenLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.dubbing.create()


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            file=file,
            csv_file=csv_file,
            foreground_audio_file=foreground_audio_file,
            background_audio_file=background_audio_file,
            name=name,
            source_url=source_url,
            source_lang=source_lang,
            target_lang=target_lang,
            target_accent=target_accent,
            num_speakers=num_speakers,
            watermark=watermark,
            start_time=start_time,
            end_time=end_time,
            highest_resolution=highest_resolution,
            drop_background_audio=drop_background_audio,
            use_profanity_filter=use_profanity_filter,
            dubbing_studio=dubbing_studio,
            disable_voice_cloning=disable_voice_cloning,
            mode=mode,
            csv_fps=csv_fps,
            request_options=request_options,
        )
        return _response.data

    async def get(
        self, dubbing_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DubbingMetadataResponse:
        """
        Returns metadata about a dubbing project, including whether it's still in progress or not

        Parameters
        ----------
        dubbing_id : str
            ID of the dubbing project.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DubbingMetadataResponse
            Successful Response

        Examples
        --------
        import asyncio

        from elevenlabs import AsyncElevenLabs

        client = AsyncElevenLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.dubbing.get(
                dubbing_id="dubbing_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(dubbing_id, request_options=request_options)
        return _response.data

    async def delete(
        self, dubbing_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeleteDubbingResponseModel:
        """
        Deletes a dubbing project.

        Parameters
        ----------
        dubbing_id : str
            ID of the dubbing project.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeleteDubbingResponseModel
            Successful Response

        Examples
        --------
        import asyncio

        from elevenlabs import AsyncElevenLabs

        client = AsyncElevenLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.dubbing.delete(
                dubbing_id="dubbing_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(dubbing_id, request_options=request_options)
        return _response.data

    @property
    def resource(self):
        if self._resource is None:
            from .resource.client import AsyncResourceClient  # noqa: E402

            self._resource = AsyncResourceClient(client_wrapper=self._client_wrapper)
        return self._resource

    @property
    def audio(self):
        if self._audio is None:
            from .audio.client import AsyncAudioClient  # noqa: E402

            self._audio = AsyncAudioClient(client_wrapper=self._client_wrapper)
        return self._audio

    @property
    def transcript(self):
        if self._transcript is None:
            from .transcript.client import AsyncTranscriptClient  # noqa: E402

            self._transcript = AsyncTranscriptClient(client_wrapper=self._client_wrapper)
        return self._transcript
