# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from .. import core
from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.request_options import RequestOptions
from ..core.unchecked_base_model import construct_type
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.delete_dubbing_response_model import DeleteDubbingResponseModel
from ..types.do_dubbing_response import DoDubbingResponse
from ..types.dubbing_metadata_page_response_model import DubbingMetadataPageResponseModel
from ..types.dubbing_metadata_response import DubbingMetadataResponse
from ..types.http_validation_error import HttpValidationError
from .types.dubbing_create_request_mode import DubbingCreateRequestMode
from .types.dubbing_list_request_dubbing_status import DubbingListRequestDubbingStatus
from .types.dubbing_list_request_filter_by_creator import DubbingListRequestFilterByCreator
from .types.dubbing_list_request_order_direction import DubbingListRequestOrderDirection

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawDubbingClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self,
        *,
        cursor: typing.Optional[str] = None,
        page_size: typing.Optional[int] = None,
        dubbing_status: typing.Optional[DubbingListRequestDubbingStatus] = None,
        filter_by_creator: typing.Optional[DubbingListRequestFilterByCreator] = None,
        order_by: typing.Optional[typing.Literal["created_at"]] = None,
        order_direction: typing.Optional[DubbingListRequestOrderDirection] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[DubbingMetadataPageResponseModel]:
        """
        List the dubs you have access to.

        Parameters
        ----------
        cursor : typing.Optional[str]
            Used for fetching next page. Cursor is returned in the response.

        page_size : typing.Optional[int]
            How many dubs to return at maximum. Can not exceed 200, defaults to 100.

        dubbing_status : typing.Optional[DubbingListRequestDubbingStatus]
            What state the dub is currently in.

        filter_by_creator : typing.Optional[DubbingListRequestFilterByCreator]
            Filters who created the resources being listed, whether it was the user running the request or someone else that shared the resource with them.

        order_by : typing.Optional[typing.Literal["created_at"]]
            The field to use for ordering results from this query.

        order_direction : typing.Optional[DubbingListRequestOrderDirection]
            The order direction to use for results from this query.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DubbingMetadataPageResponseModel]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/dubbing",
            method="GET",
            params={
                "cursor": cursor,
                "page_size": page_size,
                "dubbing_status": dubbing_status,
                "filter_by_creator": filter_by_creator,
                "order_by": order_by,
                "order_direction": order_direction,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DubbingMetadataPageResponseModel,
                    construct_type(
                        type_=DubbingMetadataPageResponseModel,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create(
        self,
        *,
        file: core.File,
        csv_file: core.File,
        foreground_audio_file: core.File,
        background_audio_file: core.File,
        name: typing.Optional[str] = OMIT,
        source_url: typing.Optional[str] = OMIT,
        source_lang: typing.Optional[str] = OMIT,
        target_lang: typing.Optional[str] = OMIT,
        target_accent: typing.Optional[str] = OMIT,
        num_speakers: typing.Optional[int] = OMIT,
        watermark: typing.Optional[bool] = OMIT,
        start_time: typing.Optional[int] = OMIT,
        end_time: typing.Optional[int] = OMIT,
        highest_resolution: typing.Optional[bool] = OMIT,
        drop_background_audio: typing.Optional[bool] = OMIT,
        use_profanity_filter: typing.Optional[bool] = OMIT,
        dubbing_studio: typing.Optional[bool] = OMIT,
        disable_voice_cloning: typing.Optional[bool] = OMIT,
        mode: typing.Optional[DubbingCreateRequestMode] = OMIT,
        csv_fps: typing.Optional[float] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[DoDubbingResponse]:
        """
        Dubs a provided audio or video file into given language.

        Parameters
        ----------
        file : core.File
            See core.File for more documentation

        csv_file : core.File
            See core.File for more documentation

        foreground_audio_file : core.File
            See core.File for more documentation

        background_audio_file : core.File
            See core.File for more documentation

        name : typing.Optional[str]
            Name of the dubbing project.

        source_url : typing.Optional[str]
            URL of the source video/audio file.

        source_lang : typing.Optional[str]
            Source language.

        target_lang : typing.Optional[str]
            The Target language to dub the content into.

        target_accent : typing.Optional[str]
            [Experimental] An accent to apply when selecting voices from the library and to use to inform translation of the dialect to prefer.

        num_speakers : typing.Optional[int]
            Number of speakers to use for the dubbing. Set to 0 to automatically detect the number of speakers

        watermark : typing.Optional[bool]
            Whether to apply watermark to the output video.

        start_time : typing.Optional[int]
            Start time of the source video/audio file.

        end_time : typing.Optional[int]
            End time of the source video/audio file.

        highest_resolution : typing.Optional[bool]
            Whether to use the highest resolution available.

        drop_background_audio : typing.Optional[bool]
            An advanced setting. Whether to drop background audio from the final dub. This can improve dub quality where it's known that audio shouldn't have a background track such as for speeches or monologues.

        use_profanity_filter : typing.Optional[bool]
            [BETA] Whether transcripts should have profanities censored with the words '[censored]'

        dubbing_studio : typing.Optional[bool]
            Whether to prepare dub for edits in dubbing studio or edits as a dubbing resource.

        disable_voice_cloning : typing.Optional[bool]
            Instead of using a voice clone in dubbing, use a similar voice from the ElevenLabs Voice Library. Voices used from the library will contribute towards a workspace's custom voices limit, and if there aren't enough available slots the dub will fail. Using this feature requires the caller to have the 'add_voice_from_voice_library' permission on their workspace to access new voices.

        mode : typing.Optional[DubbingCreateRequestMode]
            The mode in which to run this Dubbing job. Defaults to automatic, use manual if specifically providing a CSV transcript to use.

        csv_fps : typing.Optional[float]
            Frames per second to use when parsing a CSV file for dubbing. If not provided, FPS will be inferred from timecodes.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DoDubbingResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/dubbing",
            method="POST",
            data={
                "name": name,
                "source_url": source_url,
                "source_lang": source_lang,
                "target_lang": target_lang,
                "target_accent": target_accent,
                "num_speakers": num_speakers,
                "watermark": watermark,
                "start_time": start_time,
                "end_time": end_time,
                "highest_resolution": highest_resolution,
                "drop_background_audio": drop_background_audio,
                "use_profanity_filter": use_profanity_filter,
                "dubbing_studio": dubbing_studio,
                "disable_voice_cloning": disable_voice_cloning,
                "mode": mode,
                "csv_fps": csv_fps,
            },
            files={
                "file": file,
                "csv_file": csv_file,
                "foreground_audio_file": foreground_audio_file,
                "background_audio_file": background_audio_file,
            },
            request_options=request_options,
            omit=OMIT,
            force_multipart=True,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DoDubbingResponse,
                    construct_type(
                        type_=DoDubbingResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get(
        self, dubbing_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[DubbingMetadataResponse]:
        """
        Returns metadata about a dubbing project, including whether it's still in progress or not

        Parameters
        ----------
        dubbing_id : str
            ID of the dubbing project.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DubbingMetadataResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/dubbing/{jsonable_encoder(dubbing_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DubbingMetadataResponse,
                    construct_type(
                        type_=DubbingMetadataResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete(
        self, dubbing_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[DeleteDubbingResponseModel]:
        """
        Deletes a dubbing project.

        Parameters
        ----------
        dubbing_id : str
            ID of the dubbing project.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DeleteDubbingResponseModel]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/dubbing/{jsonable_encoder(dubbing_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DeleteDubbingResponseModel,
                    construct_type(
                        type_=DeleteDubbingResponseModel,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawDubbingClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self,
        *,
        cursor: typing.Optional[str] = None,
        page_size: typing.Optional[int] = None,
        dubbing_status: typing.Optional[DubbingListRequestDubbingStatus] = None,
        filter_by_creator: typing.Optional[DubbingListRequestFilterByCreator] = None,
        order_by: typing.Optional[typing.Literal["created_at"]] = None,
        order_direction: typing.Optional[DubbingListRequestOrderDirection] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[DubbingMetadataPageResponseModel]:
        """
        List the dubs you have access to.

        Parameters
        ----------
        cursor : typing.Optional[str]
            Used for fetching next page. Cursor is returned in the response.

        page_size : typing.Optional[int]
            How many dubs to return at maximum. Can not exceed 200, defaults to 100.

        dubbing_status : typing.Optional[DubbingListRequestDubbingStatus]
            What state the dub is currently in.

        filter_by_creator : typing.Optional[DubbingListRequestFilterByCreator]
            Filters who created the resources being listed, whether it was the user running the request or someone else that shared the resource with them.

        order_by : typing.Optional[typing.Literal["created_at"]]
            The field to use for ordering results from this query.

        order_direction : typing.Optional[DubbingListRequestOrderDirection]
            The order direction to use for results from this query.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DubbingMetadataPageResponseModel]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/dubbing",
            method="GET",
            params={
                "cursor": cursor,
                "page_size": page_size,
                "dubbing_status": dubbing_status,
                "filter_by_creator": filter_by_creator,
                "order_by": order_by,
                "order_direction": order_direction,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DubbingMetadataPageResponseModel,
                    construct_type(
                        type_=DubbingMetadataPageResponseModel,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create(
        self,
        *,
        file: core.File,
        csv_file: core.File,
        foreground_audio_file: core.File,
        background_audio_file: core.File,
        name: typing.Optional[str] = OMIT,
        source_url: typing.Optional[str] = OMIT,
        source_lang: typing.Optional[str] = OMIT,
        target_lang: typing.Optional[str] = OMIT,
        target_accent: typing.Optional[str] = OMIT,
        num_speakers: typing.Optional[int] = OMIT,
        watermark: typing.Optional[bool] = OMIT,
        start_time: typing.Optional[int] = OMIT,
        end_time: typing.Optional[int] = OMIT,
        highest_resolution: typing.Optional[bool] = OMIT,
        drop_background_audio: typing.Optional[bool] = OMIT,
        use_profanity_filter: typing.Optional[bool] = OMIT,
        dubbing_studio: typing.Optional[bool] = OMIT,
        disable_voice_cloning: typing.Optional[bool] = OMIT,
        mode: typing.Optional[DubbingCreateRequestMode] = OMIT,
        csv_fps: typing.Optional[float] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[DoDubbingResponse]:
        """
        Dubs a provided audio or video file into given language.

        Parameters
        ----------
        file : core.File
            See core.File for more documentation

        csv_file : core.File
            See core.File for more documentation

        foreground_audio_file : core.File
            See core.File for more documentation

        background_audio_file : core.File
            See core.File for more documentation

        name : typing.Optional[str]
            Name of the dubbing project.

        source_url : typing.Optional[str]
            URL of the source video/audio file.

        source_lang : typing.Optional[str]
            Source language.

        target_lang : typing.Optional[str]
            The Target language to dub the content into.

        target_accent : typing.Optional[str]
            [Experimental] An accent to apply when selecting voices from the library and to use to inform translation of the dialect to prefer.

        num_speakers : typing.Optional[int]
            Number of speakers to use for the dubbing. Set to 0 to automatically detect the number of speakers

        watermark : typing.Optional[bool]
            Whether to apply watermark to the output video.

        start_time : typing.Optional[int]
            Start time of the source video/audio file.

        end_time : typing.Optional[int]
            End time of the source video/audio file.

        highest_resolution : typing.Optional[bool]
            Whether to use the highest resolution available.

        drop_background_audio : typing.Optional[bool]
            An advanced setting. Whether to drop background audio from the final dub. This can improve dub quality where it's known that audio shouldn't have a background track such as for speeches or monologues.

        use_profanity_filter : typing.Optional[bool]
            [BETA] Whether transcripts should have profanities censored with the words '[censored]'

        dubbing_studio : typing.Optional[bool]
            Whether to prepare dub for edits in dubbing studio or edits as a dubbing resource.

        disable_voice_cloning : typing.Optional[bool]
            Instead of using a voice clone in dubbing, use a similar voice from the ElevenLabs Voice Library. Voices used from the library will contribute towards a workspace's custom voices limit, and if there aren't enough available slots the dub will fail. Using this feature requires the caller to have the 'add_voice_from_voice_library' permission on their workspace to access new voices.

        mode : typing.Optional[DubbingCreateRequestMode]
            The mode in which to run this Dubbing job. Defaults to automatic, use manual if specifically providing a CSV transcript to use.

        csv_fps : typing.Optional[float]
            Frames per second to use when parsing a CSV file for dubbing. If not provided, FPS will be inferred from timecodes.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DoDubbingResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/dubbing",
            method="POST",
            data={
                "name": name,
                "source_url": source_url,
                "source_lang": source_lang,
                "target_lang": target_lang,
                "target_accent": target_accent,
                "num_speakers": num_speakers,
                "watermark": watermark,
                "start_time": start_time,
                "end_time": end_time,
                "highest_resolution": highest_resolution,
                "drop_background_audio": drop_background_audio,
                "use_profanity_filter": use_profanity_filter,
                "dubbing_studio": dubbing_studio,
                "disable_voice_cloning": disable_voice_cloning,
                "mode": mode,
                "csv_fps": csv_fps,
            },
            files={
                "file": file,
                "csv_file": csv_file,
                "foreground_audio_file": foreground_audio_file,
                "background_audio_file": background_audio_file,
            },
            request_options=request_options,
            omit=OMIT,
            force_multipart=True,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DoDubbingResponse,
                    construct_type(
                        type_=DoDubbingResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get(
        self, dubbing_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[DubbingMetadataResponse]:
        """
        Returns metadata about a dubbing project, including whether it's still in progress or not

        Parameters
        ----------
        dubbing_id : str
            ID of the dubbing project.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DubbingMetadataResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/dubbing/{jsonable_encoder(dubbing_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DubbingMetadataResponse,
                    construct_type(
                        type_=DubbingMetadataResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete(
        self, dubbing_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[DeleteDubbingResponseModel]:
        """
        Deletes a dubbing project.

        Parameters
        ----------
        dubbing_id : str
            ID of the dubbing project.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DeleteDubbingResponseModel]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/dubbing/{jsonable_encoder(dubbing_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DeleteDubbingResponseModel,
                    construct_type(
                        type_=DeleteDubbingResponseModel,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
