# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.music_prompt import MusicPrompt
from .raw_client import AsyncRawCompositionPlanClient, RawCompositionPlanClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class CompositionPlanClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawCompositionPlanClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawCompositionPlanClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawCompositionPlanClient
        """
        return self._raw_client

    def create(
        self,
        *,
        prompt: str,
        music_length_ms: typing.Optional[int] = OMIT,
        source_composition_plan: typing.Optional[MusicPrompt] = OMIT,
        model_id: typing.Optional[typing.Literal["music_v1"]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MusicPrompt:
        """
        Create a composition plan for music generation. Usage of this endpoint does not cost any credits but is subject to rate limiting depending on your tier.

        Parameters
        ----------
        prompt : str
            A simple text prompt to compose a plan from.

        music_length_ms : typing.Optional[int]
            The length of the composition plan to generate in milliseconds. Must be between 3000ms and 300000ms. Optional - if not provided, the model will choose a length based on the prompt.

        source_composition_plan : typing.Optional[MusicPrompt]
            An optional composition plan to use as a source for the new composition plan.

        model_id : typing.Optional[typing.Literal["music_v1"]]
            The model to use for the generation.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MusicPrompt
            Successful Response

        Examples
        --------
        from elevenlabs import ElevenLabs

        client = ElevenLabs(
            api_key="YOUR_API_KEY",
        )
        client.music.composition_plan.create(
            prompt="prompt",
        )
        """
        _response = self._raw_client.create(
            prompt=prompt,
            music_length_ms=music_length_ms,
            source_composition_plan=source_composition_plan,
            model_id=model_id,
            request_options=request_options,
        )
        return _response.data


class AsyncCompositionPlanClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawCompositionPlanClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawCompositionPlanClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawCompositionPlanClient
        """
        return self._raw_client

    async def create(
        self,
        *,
        prompt: str,
        music_length_ms: typing.Optional[int] = OMIT,
        source_composition_plan: typing.Optional[MusicPrompt] = OMIT,
        model_id: typing.Optional[typing.Literal["music_v1"]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MusicPrompt:
        """
        Create a composition plan for music generation. Usage of this endpoint does not cost any credits but is subject to rate limiting depending on your tier.

        Parameters
        ----------
        prompt : str
            A simple text prompt to compose a plan from.

        music_length_ms : typing.Optional[int]
            The length of the composition plan to generate in milliseconds. Must be between 3000ms and 300000ms. Optional - if not provided, the model will choose a length based on the prompt.

        source_composition_plan : typing.Optional[MusicPrompt]
            An optional composition plan to use as a source for the new composition plan.

        model_id : typing.Optional[typing.Literal["music_v1"]]
            The model to use for the generation.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MusicPrompt
            Successful Response

        Examples
        --------
        import asyncio

        from elevenlabs import AsyncElevenLabs

        client = AsyncElevenLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.music.composition_plan.create(
                prompt="prompt",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            prompt=prompt,
            music_length_ms=music_length_ms,
            source_composition_plan=source_composition_plan,
            model_id=model_id,
            request_options=request_options,
        )
        return _response.data
