# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.request_options import RequestOptions
from ...core.serialization import convert_and_respect_annotation_metadata
from ...core.unchecked_base_model import construct_type
from ...errors.unprocessable_entity_error import UnprocessableEntityError
from ...types.http_validation_error import HttpValidationError
from ...types.music_prompt import MusicPrompt

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawCompositionPlanClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def create(
        self,
        *,
        prompt: str,
        music_length_ms: typing.Optional[int] = OMIT,
        source_composition_plan: typing.Optional[MusicPrompt] = OMIT,
        model_id: typing.Optional[typing.Literal["music_v1"]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[MusicPrompt]:
        """
        Create a composition plan for music generation. Usage of this endpoint does not cost any credits but is subject to rate limiting depending on your tier.

        Parameters
        ----------
        prompt : str
            A simple text prompt to compose a plan from.

        music_length_ms : typing.Optional[int]
            The length of the composition plan to generate in milliseconds. Must be between 3000ms and 300000ms. Optional - if not provided, the model will choose a length based on the prompt.

        source_composition_plan : typing.Optional[MusicPrompt]
            An optional composition plan to use as a source for the new composition plan.

        model_id : typing.Optional[typing.Literal["music_v1"]]
            The model to use for the generation.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[MusicPrompt]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/music/plan",
            method="POST",
            json={
                "prompt": prompt,
                "music_length_ms": music_length_ms,
                "source_composition_plan": convert_and_respect_annotation_metadata(
                    object_=source_composition_plan, annotation=MusicPrompt, direction="write"
                ),
                "model_id": model_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    MusicPrompt,
                    construct_type(
                        type_=MusicPrompt,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawCompositionPlanClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def create(
        self,
        *,
        prompt: str,
        music_length_ms: typing.Optional[int] = OMIT,
        source_composition_plan: typing.Optional[MusicPrompt] = OMIT,
        model_id: typing.Optional[typing.Literal["music_v1"]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[MusicPrompt]:
        """
        Create a composition plan for music generation. Usage of this endpoint does not cost any credits but is subject to rate limiting depending on your tier.

        Parameters
        ----------
        prompt : str
            A simple text prompt to compose a plan from.

        music_length_ms : typing.Optional[int]
            The length of the composition plan to generate in milliseconds. Must be between 3000ms and 300000ms. Optional - if not provided, the model will choose a length based on the prompt.

        source_composition_plan : typing.Optional[MusicPrompt]
            An optional composition plan to use as a source for the new composition plan.

        model_id : typing.Optional[typing.Literal["music_v1"]]
            The model to use for the generation.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[MusicPrompt]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/music/plan",
            method="POST",
            json={
                "prompt": prompt,
                "music_length_ms": music_length_ms,
                "source_composition_plan": convert_and_respect_annotation_metadata(
                    object_=source_composition_plan, annotation=MusicPrompt, direction="write"
                ),
                "model_id": model_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    MusicPrompt,
                    construct_type(
                        type_=MusicPrompt,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
