# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.workspace_service_account_list_response_model import WorkspaceServiceAccountListResponseModel
from .raw_client import AsyncRawServiceAccountsClient, RawServiceAccountsClient

if typing.TYPE_CHECKING:
    from .api_keys.client import ApiKeysClient, AsyncApiKeysClient


class ServiceAccountsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawServiceAccountsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._api_keys: typing.Optional[ApiKeysClient] = None

    @property
    def with_raw_response(self) -> RawServiceAccountsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawServiceAccountsClient
        """
        return self._raw_client

    def list(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WorkspaceServiceAccountListResponseModel:
        """
        List all service accounts in the workspace

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkspaceServiceAccountListResponseModel
            Successful Response

        Examples
        --------
        from elevenlabs import ElevenLabs

        client = ElevenLabs(
            api_key="YOUR_API_KEY",
        )
        client.service_accounts.list()
        """
        _response = self._raw_client.list(request_options=request_options)
        return _response.data

    @property
    def api_keys(self):
        if self._api_keys is None:
            from .api_keys.client import ApiKeysClient  # noqa: E402

            self._api_keys = ApiKeysClient(client_wrapper=self._client_wrapper)
        return self._api_keys


class AsyncServiceAccountsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawServiceAccountsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._api_keys: typing.Optional[AsyncApiKeysClient] = None

    @property
    def with_raw_response(self) -> AsyncRawServiceAccountsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawServiceAccountsClient
        """
        return self._raw_client

    async def list(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WorkspaceServiceAccountListResponseModel:
        """
        List all service accounts in the workspace

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkspaceServiceAccountListResponseModel
            Successful Response

        Examples
        --------
        import asyncio

        from elevenlabs import AsyncElevenLabs

        client = AsyncElevenLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.service_accounts.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(request_options=request_options)
        return _response.data

    @property
    def api_keys(self):
        if self._api_keys is None:
            from .api_keys.client import AsyncApiKeysClient  # noqa: E402

            self._api_keys = AsyncApiKeysClient(client_wrapper=self._client_wrapper)
        return self._api_keys
