# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from .. import core
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.additional_formats import AdditionalFormats
from .raw_client import AsyncRawSpeechToTextClient, RawSpeechToTextClient
from .types.speech_to_text_convert_request_file_format import SpeechToTextConvertRequestFileFormat
from .types.speech_to_text_convert_request_timestamps_granularity import SpeechToTextConvertRequestTimestampsGranularity
from .types.speech_to_text_convert_request_webhook_metadata import SpeechToTextConvertRequestWebhookMetadata
from .types.speech_to_text_convert_response import SpeechToTextConvertResponse

if typing.TYPE_CHECKING:
    from .transcripts.client import AsyncTranscriptsClient, TranscriptsClient
# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class SpeechToTextClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSpeechToTextClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._transcripts: typing.Optional[TranscriptsClient] = None

    @property
    def with_raw_response(self) -> RawSpeechToTextClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSpeechToTextClient
        """
        return self._raw_client

    def convert(
        self,
        *,
        model_id: str,
        file: core.File,
        enable_logging: typing.Optional[bool] = None,
        language_code: typing.Optional[str] = OMIT,
        tag_audio_events: typing.Optional[bool] = OMIT,
        num_speakers: typing.Optional[int] = OMIT,
        timestamps_granularity: typing.Optional[SpeechToTextConvertRequestTimestampsGranularity] = OMIT,
        diarize: typing.Optional[bool] = OMIT,
        diarization_threshold: typing.Optional[float] = OMIT,
        additional_formats: typing.Optional[AdditionalFormats] = OMIT,
        file_format: typing.Optional[SpeechToTextConvertRequestFileFormat] = OMIT,
        cloud_storage_url: typing.Optional[str] = OMIT,
        webhook: typing.Optional[bool] = OMIT,
        webhook_id: typing.Optional[str] = OMIT,
        temperature: typing.Optional[float] = OMIT,
        seed: typing.Optional[int] = OMIT,
        use_multi_channel: typing.Optional[bool] = OMIT,
        webhook_metadata: typing.Optional[SpeechToTextConvertRequestWebhookMetadata] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SpeechToTextConvertResponse:
        """
        Transcribe an audio or video file. If webhook is set to true, the request will be processed asynchronously and results sent to configured webhooks. When use_multi_channel is true and the provided audio has multiple channels, a 'transcripts' object with separate transcripts for each channel is returned. Otherwise, returns a single transcript. The optional webhook_metadata parameter allows you to attach custom data that will be included in webhook responses for request correlation and tracking.

        Parameters
        ----------
        model_id : str
            The ID of the model to use for transcription, currently only 'scribe_v1' and 'scribe_v1_experimental' are available.

        file : core.File
            See core.File for more documentation

        enable_logging : typing.Optional[bool]
            When enable_logging is set to false zero retention mode will be used for the request. This will mean log and transcript storage features are unavailable for this request. Zero retention mode may only be used by enterprise customers.

        language_code : typing.Optional[str]
            An ISO-639-1 or ISO-639-3 language_code corresponding to the language of the audio file. Can sometimes improve transcription performance if known beforehand. Defaults to null, in this case the language is predicted automatically.

        tag_audio_events : typing.Optional[bool]
            Whether to tag audio events like (laughter), (footsteps), etc. in the transcription.

        num_speakers : typing.Optional[int]
            The maximum amount of speakers talking in the uploaded file. Can help with predicting who speaks when. The maximum amount of speakers that can be predicted is 32. Defaults to null, in this case the amount of speakers is set to the maximum value the model supports.

        timestamps_granularity : typing.Optional[SpeechToTextConvertRequestTimestampsGranularity]
            The granularity of the timestamps in the transcription. 'word' provides word-level timestamps and 'character' provides character-level timestamps per word.

        diarize : typing.Optional[bool]
            Whether to annotate which speaker is currently talking in the uploaded file.

        diarization_threshold : typing.Optional[float]
            Diarization threshold to apply during speaker diarization. A higher value means there will be a lower chance of one speaker being diarized as two different speakers but also a higher chance of two different speakers being diarized as one speaker (less total speakers predicted). A low value means there will be a higher chance of one speaker being diarized as two different speakers but also a lower chance of two different speakers being diarized as one speaker (more total speakers predicted). Can only be set when diarize=True and num_speakers=None. Defaults to None, in which case we will choose a threshold based on the model_id (0.22 usually).

        additional_formats : typing.Optional[AdditionalFormats]
            A list of additional formats to export the transcript to.

        file_format : typing.Optional[SpeechToTextConvertRequestFileFormat]
            The format of input audio. Options are 'pcm_s16le_16' or 'other' For `pcm_s16le_16`, the input audio must be 16-bit PCM at a 16kHz sample rate, single channel (mono), and little-endian byte order. Latency will be lower than with passing an encoded waveform.

        cloud_storage_url : typing.Optional[str]
            The HTTPS URL of the file to transcribe. Exactly one of the file or cloud_storage_url parameters must be provided. The file must be accessible via HTTPS and the file size must be less than 2GB. Any valid HTTPS URL is accepted, including URLs from cloud storage providers (AWS S3, Google Cloud Storage, Cloudflare R2, etc.), CDNs, or any other HTTPS source. URLs can be pre-signed or include authentication tokens in query parameters.

        webhook : typing.Optional[bool]
            Whether to send the transcription result to configured speech-to-text webhooks.  If set the request will return early without the transcription, which will be delivered later via webhook.

        webhook_id : typing.Optional[str]
            Optional specific webhook ID to send the transcription result to. Only valid when webhook is set to true. If not provided, transcription will be sent to all configured speech-to-text webhooks.

        temperature : typing.Optional[float]
            Controls the randomness of the transcription output. Accepts values between 0.0 and 2.0, where higher values result in more diverse and less deterministic results. If omitted, we will use a temperature based on the model you selected which is usually 0.

        seed : typing.Optional[int]
            If specified, our system will make a best effort to sample deterministically, such that repeated requests with the same seed and parameters should return the same result. Determinism is not guaranteed. Must be an integer between 0 and 2147483647.

        use_multi_channel : typing.Optional[bool]
            Whether the audio file contains multiple channels where each channel contains a single speaker. When enabled, each channel will be transcribed independently and the results will be combined. Each word in the response will include a 'channel_index' field indicating which channel it was spoken on. A maximum of 5 channels is supported.

        webhook_metadata : typing.Optional[SpeechToTextConvertRequestWebhookMetadata]
            Optional metadata to be included in the webhook response. This should be a JSON string representing an object with a maximum depth of 2 levels and maximum size of 16KB. Useful for tracking internal IDs, job references, or other contextual information.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SpeechToTextConvertResponse
            Synchronous transcription result

        Examples
        --------
        from elevenlabs import ElevenLabs

        client = ElevenLabs(
            api_key="YOUR_API_KEY",
        )
        client.speech_to_text.convert(
            enable_logging=True,
            model_id="model_id",
        )
        """
        _response = self._raw_client.convert(
            model_id=model_id,
            file=file,
            enable_logging=enable_logging,
            language_code=language_code,
            tag_audio_events=tag_audio_events,
            num_speakers=num_speakers,
            timestamps_granularity=timestamps_granularity,
            diarize=diarize,
            diarization_threshold=diarization_threshold,
            additional_formats=additional_formats,
            file_format=file_format,
            cloud_storage_url=cloud_storage_url,
            webhook=webhook,
            webhook_id=webhook_id,
            temperature=temperature,
            seed=seed,
            use_multi_channel=use_multi_channel,
            webhook_metadata=webhook_metadata,
            request_options=request_options,
        )
        return _response.data

    @property
    def transcripts(self):
        if self._transcripts is None:
            from .transcripts.client import TranscriptsClient  # noqa: E402

            self._transcripts = TranscriptsClient(client_wrapper=self._client_wrapper)
        return self._transcripts


class AsyncSpeechToTextClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSpeechToTextClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._transcripts: typing.Optional[AsyncTranscriptsClient] = None

    @property
    def with_raw_response(self) -> AsyncRawSpeechToTextClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSpeechToTextClient
        """
        return self._raw_client

    async def convert(
        self,
        *,
        model_id: str,
        file: core.File,
        enable_logging: typing.Optional[bool] = None,
        language_code: typing.Optional[str] = OMIT,
        tag_audio_events: typing.Optional[bool] = OMIT,
        num_speakers: typing.Optional[int] = OMIT,
        timestamps_granularity: typing.Optional[SpeechToTextConvertRequestTimestampsGranularity] = OMIT,
        diarize: typing.Optional[bool] = OMIT,
        diarization_threshold: typing.Optional[float] = OMIT,
        additional_formats: typing.Optional[AdditionalFormats] = OMIT,
        file_format: typing.Optional[SpeechToTextConvertRequestFileFormat] = OMIT,
        cloud_storage_url: typing.Optional[str] = OMIT,
        webhook: typing.Optional[bool] = OMIT,
        webhook_id: typing.Optional[str] = OMIT,
        temperature: typing.Optional[float] = OMIT,
        seed: typing.Optional[int] = OMIT,
        use_multi_channel: typing.Optional[bool] = OMIT,
        webhook_metadata: typing.Optional[SpeechToTextConvertRequestWebhookMetadata] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SpeechToTextConvertResponse:
        """
        Transcribe an audio or video file. If webhook is set to true, the request will be processed asynchronously and results sent to configured webhooks. When use_multi_channel is true and the provided audio has multiple channels, a 'transcripts' object with separate transcripts for each channel is returned. Otherwise, returns a single transcript. The optional webhook_metadata parameter allows you to attach custom data that will be included in webhook responses for request correlation and tracking.

        Parameters
        ----------
        model_id : str
            The ID of the model to use for transcription, currently only 'scribe_v1' and 'scribe_v1_experimental' are available.

        file : core.File
            See core.File for more documentation

        enable_logging : typing.Optional[bool]
            When enable_logging is set to false zero retention mode will be used for the request. This will mean log and transcript storage features are unavailable for this request. Zero retention mode may only be used by enterprise customers.

        language_code : typing.Optional[str]
            An ISO-639-1 or ISO-639-3 language_code corresponding to the language of the audio file. Can sometimes improve transcription performance if known beforehand. Defaults to null, in this case the language is predicted automatically.

        tag_audio_events : typing.Optional[bool]
            Whether to tag audio events like (laughter), (footsteps), etc. in the transcription.

        num_speakers : typing.Optional[int]
            The maximum amount of speakers talking in the uploaded file. Can help with predicting who speaks when. The maximum amount of speakers that can be predicted is 32. Defaults to null, in this case the amount of speakers is set to the maximum value the model supports.

        timestamps_granularity : typing.Optional[SpeechToTextConvertRequestTimestampsGranularity]
            The granularity of the timestamps in the transcription. 'word' provides word-level timestamps and 'character' provides character-level timestamps per word.

        diarize : typing.Optional[bool]
            Whether to annotate which speaker is currently talking in the uploaded file.

        diarization_threshold : typing.Optional[float]
            Diarization threshold to apply during speaker diarization. A higher value means there will be a lower chance of one speaker being diarized as two different speakers but also a higher chance of two different speakers being diarized as one speaker (less total speakers predicted). A low value means there will be a higher chance of one speaker being diarized as two different speakers but also a lower chance of two different speakers being diarized as one speaker (more total speakers predicted). Can only be set when diarize=True and num_speakers=None. Defaults to None, in which case we will choose a threshold based on the model_id (0.22 usually).

        additional_formats : typing.Optional[AdditionalFormats]
            A list of additional formats to export the transcript to.

        file_format : typing.Optional[SpeechToTextConvertRequestFileFormat]
            The format of input audio. Options are 'pcm_s16le_16' or 'other' For `pcm_s16le_16`, the input audio must be 16-bit PCM at a 16kHz sample rate, single channel (mono), and little-endian byte order. Latency will be lower than with passing an encoded waveform.

        cloud_storage_url : typing.Optional[str]
            The HTTPS URL of the file to transcribe. Exactly one of the file or cloud_storage_url parameters must be provided. The file must be accessible via HTTPS and the file size must be less than 2GB. Any valid HTTPS URL is accepted, including URLs from cloud storage providers (AWS S3, Google Cloud Storage, Cloudflare R2, etc.), CDNs, or any other HTTPS source. URLs can be pre-signed or include authentication tokens in query parameters.

        webhook : typing.Optional[bool]
            Whether to send the transcription result to configured speech-to-text webhooks.  If set the request will return early without the transcription, which will be delivered later via webhook.

        webhook_id : typing.Optional[str]
            Optional specific webhook ID to send the transcription result to. Only valid when webhook is set to true. If not provided, transcription will be sent to all configured speech-to-text webhooks.

        temperature : typing.Optional[float]
            Controls the randomness of the transcription output. Accepts values between 0.0 and 2.0, where higher values result in more diverse and less deterministic results. If omitted, we will use a temperature based on the model you selected which is usually 0.

        seed : typing.Optional[int]
            If specified, our system will make a best effort to sample deterministically, such that repeated requests with the same seed and parameters should return the same result. Determinism is not guaranteed. Must be an integer between 0 and 2147483647.

        use_multi_channel : typing.Optional[bool]
            Whether the audio file contains multiple channels where each channel contains a single speaker. When enabled, each channel will be transcribed independently and the results will be combined. Each word in the response will include a 'channel_index' field indicating which channel it was spoken on. A maximum of 5 channels is supported.

        webhook_metadata : typing.Optional[SpeechToTextConvertRequestWebhookMetadata]
            Optional metadata to be included in the webhook response. This should be a JSON string representing an object with a maximum depth of 2 levels and maximum size of 16KB. Useful for tracking internal IDs, job references, or other contextual information.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SpeechToTextConvertResponse
            Synchronous transcription result

        Examples
        --------
        import asyncio

        from elevenlabs import AsyncElevenLabs

        client = AsyncElevenLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.speech_to_text.convert(
                enable_logging=True,
                model_id="model_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.convert(
            model_id=model_id,
            file=file,
            enable_logging=enable_logging,
            language_code=language_code,
            tag_audio_events=tag_audio_events,
            num_speakers=num_speakers,
            timestamps_granularity=timestamps_granularity,
            diarize=diarize,
            diarization_threshold=diarization_threshold,
            additional_formats=additional_formats,
            file_format=file_format,
            cloud_storage_url=cloud_storage_url,
            webhook=webhook,
            webhook_id=webhook_id,
            temperature=temperature,
            seed=seed,
            use_multi_channel=use_multi_channel,
            webhook_metadata=webhook_metadata,
            request_options=request_options,
        )
        return _response.data

    @property
    def transcripts(self):
        if self._transcripts is None:
            from .transcripts.client import AsyncTranscriptsClient  # noqa: E402

            self._transcripts = AsyncTranscriptsClient(client_wrapper=self._client_wrapper)
        return self._transcripts
