# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .attached_test_model import AttachedTestModel


class AgentTestingSettings(UncheckedBaseModel):
    """
    Settings for agent testing configuration.
    """

    attached_tests: typing.Optional[typing.List[AttachedTestModel]] = pydantic.Field(default=None)
    """
    List of test IDs that should be run for this agent
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
