# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ..core.unchecked_base_model import UncheckedBaseModel, UnionMetadata
from .conversational_config_api_model_workflow_override_output import ConversationalConfigApiModelWorkflowOverrideOutput
from .knowledge_base_locator import KnowledgeBaseLocator
from .position_output import PositionOutput
from .transfer_type_enum import TransferTypeEnum
from .workflow_phone_number_node_model_output_transfer_destination import (
    WorkflowPhoneNumberNodeModelOutputTransferDestination,
)
from .workflow_tool_locator import WorkflowToolLocator


class AgentWorkflowResponseModelNodesValue_End(UncheckedBaseModel):
    type: typing.Literal["end"] = "end"
    position: PositionOutput
    edge_order: typing.List[str]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class AgentWorkflowResponseModelNodesValue_OverrideAgent(UncheckedBaseModel):
    type: typing.Literal["override_agent"] = "override_agent"
    conversation_config: ConversationalConfigApiModelWorkflowOverrideOutput
    additional_prompt: str
    additional_knowledge_base: typing.List[KnowledgeBaseLocator]
    additional_tool_ids: typing.List[str]
    position: PositionOutput
    edge_order: typing.List[str]
    label: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .array_json_schema_property_output import ArrayJsonSchemaPropertyOutput  # noqa: E402, F401, I001
from .object_json_schema_property_output import ObjectJsonSchemaPropertyOutput  # noqa: E402, F401, I001


class AgentWorkflowResponseModelNodesValue_PhoneNumber(UncheckedBaseModel):
    type: typing.Literal["phone_number"] = "phone_number"
    position: PositionOutput
    edge_order: typing.List[str]
    transfer_destination: WorkflowPhoneNumberNodeModelOutputTransferDestination
    transfer_type: TransferTypeEnum

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class AgentWorkflowResponseModelNodesValue_StandaloneAgent(UncheckedBaseModel):
    type: typing.Literal["standalone_agent"] = "standalone_agent"
    position: PositionOutput
    edge_order: typing.List[str]
    agent_id: str
    delay_ms: int
    transfer_message: typing.Optional[str] = None
    enable_transferred_agent_first_message: bool

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class AgentWorkflowResponseModelNodesValue_Start(UncheckedBaseModel):
    type: typing.Literal["start"] = "start"
    position: PositionOutput
    edge_order: typing.List[str]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class AgentWorkflowResponseModelNodesValue_Tool(UncheckedBaseModel):
    type: typing.Literal["tool"] = "tool"
    position: PositionOutput
    edge_order: typing.List[str]
    tools: typing.List[WorkflowToolLocator]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


AgentWorkflowResponseModelNodesValue = typing_extensions.Annotated[
    typing.Union[
        AgentWorkflowResponseModelNodesValue_End,
        AgentWorkflowResponseModelNodesValue_OverrideAgent,
        AgentWorkflowResponseModelNodesValue_PhoneNumber,
        AgentWorkflowResponseModelNodesValue_StandaloneAgent,
        AgentWorkflowResponseModelNodesValue_Start,
        AgentWorkflowResponseModelNodesValue_Tool,
    ],
    UnionMetadata(discriminant="type"),
]
update_forward_refs(AgentWorkflowResponseModelNodesValue_OverrideAgent)
