# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ..core.unchecked_base_model import UncheckedBaseModel
from .agent_metadata import AgentMetadata
from .conversation_history_multivoice_message_model import ConversationHistoryMultivoiceMessageModel
from .conversation_history_transcript_common_model_input_role import ConversationHistoryTranscriptCommonModelInputRole
from .conversation_history_transcript_common_model_input_source_medium import (
    ConversationHistoryTranscriptCommonModelInputSourceMedium,
)
from .conversation_history_transcript_common_model_input_tool_results_item import (
    ConversationHistoryTranscriptCommonModelInputToolResultsItem,
)
from .conversation_history_transcript_tool_call_common_model import ConversationHistoryTranscriptToolCallCommonModel
from .conversation_turn_metrics import ConversationTurnMetrics
from .llm_usage_input import LlmUsageInput
from .rag_retrieval_info import RagRetrievalInfo
from .user_feedback import UserFeedback


class ConversationHistoryTranscriptCommonModelInput(UncheckedBaseModel):
    role: ConversationHistoryTranscriptCommonModelInputRole
    agent_metadata: typing.Optional[AgentMetadata] = None
    message: typing.Optional[str] = None
    multivoice_message: typing.Optional[ConversationHistoryMultivoiceMessageModel] = None
    tool_calls: typing.Optional[typing.List[ConversationHistoryTranscriptToolCallCommonModel]] = None
    tool_results: typing.Optional[typing.List[ConversationHistoryTranscriptCommonModelInputToolResultsItem]] = None
    feedback: typing.Optional[UserFeedback] = None
    llm_override: typing.Optional[str] = None
    time_in_call_secs: int
    conversation_turn_metrics: typing.Optional[ConversationTurnMetrics] = None
    rag_retrieval_info: typing.Optional[RagRetrievalInfo] = None
    llm_usage: typing.Optional[LlmUsageInput] = None
    interrupted: typing.Optional[bool] = None
    original_message: typing.Optional[str] = None
    source_medium: typing.Optional[ConversationHistoryTranscriptCommonModelInputSourceMedium] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .conversation_history_transcript_workflow_tools_result_common_model_input import (
    ConversationHistoryTranscriptWorkflowToolsResultCommonModelInput,
)  # noqa: E402, F401, I001
from .workflow_tool_nested_tools_step_model_input import WorkflowToolNestedToolsStepModelInput  # noqa: E402, F401, I001
from .workflow_tool_response_model_input import WorkflowToolResponseModelInput  # noqa: E402, F401, I001

update_forward_refs(ConversationHistoryTranscriptCommonModelInput)
