# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ..core.unchecked_base_model import UncheckedBaseModel
from .agent_config_api_model_workflow_override_output import AgentConfigApiModelWorkflowOverrideOutput
from .asr_conversational_config_workflow_override import AsrConversationalConfigWorkflowOverride
from .conversation_config_workflow_override import ConversationConfigWorkflowOverride
from .language_preset_output import LanguagePresetOutput
from .tts_conversational_config_workflow_override_output import TtsConversationalConfigWorkflowOverrideOutput
from .turn_config_workflow_override import TurnConfigWorkflowOverride
from .vad_config_workflow_override import VadConfigWorkflowOverride


class ConversationalConfigApiModelWorkflowOverrideOutput(UncheckedBaseModel):
    asr: typing.Optional[AsrConversationalConfigWorkflowOverride] = pydantic.Field(default=None)
    """
    Configuration for conversational transcription
    """

    turn: typing.Optional[TurnConfigWorkflowOverride] = pydantic.Field(default=None)
    """
    Configuration for turn detection
    """

    tts: typing.Optional[TtsConversationalConfigWorkflowOverrideOutput] = pydantic.Field(default=None)
    """
    Configuration for conversational text to speech
    """

    conversation: typing.Optional[ConversationConfigWorkflowOverride] = pydantic.Field(default=None)
    """
    Configuration for conversational events
    """

    language_presets: typing.Optional[typing.Dict[str, typing.Optional[LanguagePresetOutput]]] = pydantic.Field(
        default=None
    )
    """
    Language presets for conversations
    """

    vad: typing.Optional[VadConfigWorkflowOverride] = pydantic.Field(default=None)
    """
    Configuration for voice activity detection
    """

    agent: typing.Optional[AgentConfigApiModelWorkflowOverrideOutput] = pydantic.Field(default=None)
    """
    Agent specific configuration
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .array_json_schema_property_output import ArrayJsonSchemaPropertyOutput  # noqa: E402, F401, I001
from .object_json_schema_property_output import ObjectJsonSchemaPropertyOutput  # noqa: E402, F401, I001

update_forward_refs(ConversationalConfigApiModelWorkflowOverrideOutput)
