# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .music_prompt import MusicPrompt
from .song_metadata import SongMetadata


class DetailedMusicResponse(UncheckedBaseModel):
    """
    Response model for structured music generation endpoint
    """

    composition_plan: MusicPrompt = pydantic.Field()
    """
    The composition plan used to generate the song
    """

    song_metadata: SongMetadata = pydantic.Field()
    """
    The metadata of the generated song
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
