# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ..core.unchecked_base_model import UncheckedBaseModel
from .agent_failure_response_example import AgentFailureResponseExample
from .agent_successful_response_example import AgentSuccessfulResponseExample
from .conversation_history_transcript_common_model_output import ConversationHistoryTranscriptCommonModelOutput
from .get_unit_test_response_model_dynamic_variables_value import GetUnitTestResponseModelDynamicVariablesValue
from .test_from_conversation_metadata_output import TestFromConversationMetadataOutput
from .unit_test_common_model_type import UnitTestCommonModelType
from .unit_test_tool_call_evaluation_model_output import UnitTestToolCallEvaluationModelOutput


class GetUnitTestResponseModel(UncheckedBaseModel):
    chat_history: typing.List[ConversationHistoryTranscriptCommonModelOutput]
    success_condition: str = pydantic.Field()
    """
    A prompt that evaluates whether the agent's response is successful. Should return True or False.
    """

    success_examples: typing.List[AgentSuccessfulResponseExample] = pydantic.Field()
    """
    Non-empty list of example responses that should be considered successful
    """

    failure_examples: typing.List[AgentFailureResponseExample] = pydantic.Field()
    """
    Non-empty list of example responses that should be considered failures
    """

    tool_call_parameters: typing.Optional[UnitTestToolCallEvaluationModelOutput] = pydantic.Field(default=None)
    """
    How to evaluate the agent's tool call (if any). If empty, the tool call is not evaluated.
    """

    dynamic_variables: typing.Optional[
        typing.Dict[str, typing.Optional[GetUnitTestResponseModelDynamicVariablesValue]]
    ] = pydantic.Field(default=None)
    """
    Dynamic variables to replace in the agent config during testing
    """

    type: typing.Optional[UnitTestCommonModelType] = None
    from_conversation_metadata: typing.Optional[TestFromConversationMetadataOutput] = pydantic.Field(default=None)
    """
    Metadata of a conversation this test was created from (if applicable).
    """

    id: str
    name: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .conversation_history_transcript_workflow_tools_result_common_model_output import (
    ConversationHistoryTranscriptWorkflowToolsResultCommonModelOutput,
)  # noqa: E402, F401, I001
from .workflow_tool_nested_tools_step_model_output import WorkflowToolNestedToolsStepModelOutput  # noqa: E402, F401, I001
from .workflow_tool_response_model_output import WorkflowToolResponseModelOutput  # noqa: E402, F401, I001

update_forward_refs(GetUnitTestResponseModel)
