# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .invoice_response_model_payment_intent_status import InvoiceResponseModelPaymentIntentStatus


class InvoiceResponse(UncheckedBaseModel):
    amount_due_cents: int = pydantic.Field()
    """
    The amount due in cents.
    """

    discount_percent_off: typing.Optional[float] = pydantic.Field(default=None)
    """
    The discount applied to the invoice. E.g. [20.0f] for 20% off.
    """

    discount_amount_off: typing.Optional[float] = pydantic.Field(default=None)
    """
    The discount applied to the invoice. E.g. [20.0f] for 20% off.
    """

    next_payment_attempt_unix: int = pydantic.Field()
    """
    The Unix timestamp of the next payment attempt.
    """

    payment_intent_status: typing.Optional[InvoiceResponseModelPaymentIntentStatus] = pydantic.Field(default=None)
    """
    The status of this invoice's payment intent. None when there is no payment intent.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
