# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel, UnionMetadata
from .llm import Llm


class PromptAgentApiModelOutputBackupLlmConfig_Default(UncheckedBaseModel):
    """
    Configuration for backup LLM cascading. Can be disabled, use system defaults, or specify custom order.
    """

    preference: typing.Literal["default"] = "default"

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class PromptAgentApiModelOutputBackupLlmConfig_Disabled(UncheckedBaseModel):
    """
    Configuration for backup LLM cascading. Can be disabled, use system defaults, or specify custom order.
    """

    preference: typing.Literal["disabled"] = "disabled"

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class PromptAgentApiModelOutputBackupLlmConfig_Override(UncheckedBaseModel):
    """
    Configuration for backup LLM cascading. Can be disabled, use system defaults, or specify custom order.
    """

    preference: typing.Literal["override"] = "override"
    order: typing.List[Llm]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


PromptAgentApiModelOutputBackupLlmConfig = typing_extensions.Annotated[
    typing.Union[
        PromptAgentApiModelOutputBackupLlmConfig_Default,
        PromptAgentApiModelOutputBackupLlmConfig_Disabled,
        PromptAgentApiModelOutputBackupLlmConfig_Override,
    ],
    UnionMetadata(discriminant="preference"),
]
