# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ..core.unchecked_base_model import UncheckedBaseModel, UnionMetadata
from .dynamic_variable_assignment import DynamicVariableAssignment
from .dynamic_variables_config import DynamicVariablesConfig
from .system_tool_config_input_params import SystemToolConfigInputParams
from .tool_execution_mode import ToolExecutionMode
from .webhook_tool_api_schema_config_input import WebhookToolApiSchemaConfigInput


class PromptAgentApiModelWorkflowOverrideInputToolsItem_Client(UncheckedBaseModel):
    """
    The type of tool
    """

    type: typing.Literal["client"] = "client"
    name: str
    description: str
    response_timeout_secs: typing.Optional[int] = None
    disable_interruptions: typing.Optional[bool] = None
    force_pre_tool_speech: typing.Optional[bool] = None
    assignments: typing.Optional[typing.List[DynamicVariableAssignment]] = None
    parameters: typing.Optional["ObjectJsonSchemaPropertyInput"] = None
    expects_response: typing.Optional[bool] = None
    dynamic_variables: typing.Optional[DynamicVariablesConfig] = None
    execution_mode: typing.Optional[ToolExecutionMode] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class PromptAgentApiModelWorkflowOverrideInputToolsItem_Mcp(UncheckedBaseModel):
    value: typing.Optional[typing.Any] = None
    type: typing.Literal["mcp"] = "mcp"

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True


class PromptAgentApiModelWorkflowOverrideInputToolsItem_System(UncheckedBaseModel):
    """
    The type of tool
    """

    type: typing.Literal["system"] = "system"
    name: str
    description: typing.Optional[str] = None
    response_timeout_secs: typing.Optional[int] = None
    disable_interruptions: typing.Optional[bool] = None
    force_pre_tool_speech: typing.Optional[bool] = None
    assignments: typing.Optional[typing.List[DynamicVariableAssignment]] = None
    params: SystemToolConfigInputParams

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class PromptAgentApiModelWorkflowOverrideInputToolsItem_Webhook(UncheckedBaseModel):
    """
    The type of tool
    """

    type: typing.Literal["webhook"] = "webhook"
    name: str
    description: str
    response_timeout_secs: typing.Optional[int] = None
    disable_interruptions: typing.Optional[bool] = None
    force_pre_tool_speech: typing.Optional[bool] = None
    assignments: typing.Optional[typing.List[DynamicVariableAssignment]] = None
    api_schema: WebhookToolApiSchemaConfigInput
    dynamic_variables: typing.Optional[DynamicVariablesConfig] = None
    execution_mode: typing.Optional[ToolExecutionMode] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .array_json_schema_property_input import ArrayJsonSchemaPropertyInput  # noqa: E402, F401, I001
from .object_json_schema_property_input import ObjectJsonSchemaPropertyInput  # noqa: E402, F401, I001

PromptAgentApiModelWorkflowOverrideInputToolsItem = typing_extensions.Annotated[
    typing.Union[
        PromptAgentApiModelWorkflowOverrideInputToolsItem_Client,
        PromptAgentApiModelWorkflowOverrideInputToolsItem_Mcp,
        PromptAgentApiModelWorkflowOverrideInputToolsItem_System,
        PromptAgentApiModelWorkflowOverrideInputToolsItem_Webhook,
    ],
    UnionMetadata(discriminant="type"),
]
update_forward_refs(PromptAgentApiModelWorkflowOverrideInputToolsItem_Client)
update_forward_refs(PromptAgentApiModelWorkflowOverrideInputToolsItem_Webhook)
