# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ..core.unchecked_base_model import UncheckedBaseModel
from .built_in_tools_workflow_override_output import BuiltInToolsWorkflowOverrideOutput
from .custom_llm import CustomLlm
from .knowledge_base_locator import KnowledgeBaseLocator
from .llm import Llm
from .llm_reasoning_effort import LlmReasoningEffort
from .prompt_agent_api_model_workflow_override_output_backup_llm_config import (
    PromptAgentApiModelWorkflowOverrideOutputBackupLlmConfig,
)
from .prompt_agent_api_model_workflow_override_output_tools_item import (
    PromptAgentApiModelWorkflowOverrideOutputToolsItem,
)
from .rag_config_workflow_override import RagConfigWorkflowOverride


class PromptAgentApiModelWorkflowOverrideOutput(UncheckedBaseModel):
    prompt: typing.Optional[str] = pydantic.Field(default=None)
    """
    The prompt for the agent
    """

    llm: typing.Optional[Llm] = pydantic.Field(default=None)
    """
    The LLM to query with the prompt and the chat history. If using data residency, the LLM must be supported in the data residency environment
    """

    reasoning_effort: typing.Optional[LlmReasoningEffort] = pydantic.Field(default=None)
    """
    Reasoning effort of the model. Only available for some models.
    """

    thinking_budget: typing.Optional[int] = pydantic.Field(default=None)
    """
    Max number of tokens used for thinking. Use 0 to turn off if supported by the model.
    """

    temperature: typing.Optional[float] = pydantic.Field(default=None)
    """
    The temperature for the LLM
    """

    max_tokens: typing.Optional[int] = pydantic.Field(default=None)
    """
    If greater than 0, maximum number of tokens the LLM can predict
    """

    tool_ids: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    A list of IDs of tools used by the agent
    """

    built_in_tools: typing.Optional[BuiltInToolsWorkflowOverrideOutput] = pydantic.Field(default=None)
    """
    Built-in system tools to be used by the agent
    """

    mcp_server_ids: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    A list of MCP server ids to be used by the agent
    """

    native_mcp_server_ids: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    A list of Native MCP server ids to be used by the agent
    """

    knowledge_base: typing.Optional[typing.List[KnowledgeBaseLocator]] = pydantic.Field(default=None)
    """
    A list of knowledge bases to be used by the agent
    """

    custom_llm: typing.Optional[CustomLlm] = pydantic.Field(default=None)
    """
    Definition for a custom LLM if LLM field is set to 'CUSTOM_LLM'
    """

    ignore_default_personality: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether to remove the default personality lines from the system prompt
    """

    rag: typing.Optional[RagConfigWorkflowOverride] = pydantic.Field(default=None)
    """
    Configuration for RAG
    """

    timezone: typing.Optional[str] = pydantic.Field(default=None)
    """
    Timezone for displaying current time in system prompt. If set, the current time will be included in the system prompt using this timezone. Must be a valid timezone name (e.g., 'America/New_York', 'Europe/London', 'UTC').
    """

    backup_llm_config: typing.Optional[PromptAgentApiModelWorkflowOverrideOutputBackupLlmConfig] = pydantic.Field(
        default=None
    )
    """
    Configuration for backup LLM cascading. Can be disabled, use system defaults, or specify custom order.
    """

    tools: typing.Optional[typing.List[PromptAgentApiModelWorkflowOverrideOutputToolsItem]] = pydantic.Field(
        default=None
    )
    """
    A list of tools that the agent can use over the course of the conversation, use tool_ids instead
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .array_json_schema_property_output import ArrayJsonSchemaPropertyOutput  # noqa: E402, F401, I001
from .object_json_schema_property_output import ObjectJsonSchemaPropertyOutput  # noqa: E402, F401, I001

update_forward_refs(PromptAgentApiModelWorkflowOverrideOutput)
