# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .time_range import TimeRange


class SectionSource(UncheckedBaseModel):
    song_id: str = pydantic.Field()
    """
    The ID of the song to source the section from. You can find the song ID in the response headers when you generate a song.
    """

    range: TimeRange = pydantic.Field()
    """
    The range to extract from the source song.
    """

    negative_ranges: typing.Optional[typing.List[TimeRange]] = pydantic.Field(default=None)
    """
    The ranges to exclude from the 'range'.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
