# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .section_source import SectionSource


class SongSection(UncheckedBaseModel):
    section_name: str = pydantic.Field()
    """
    The name of the section. Must be between 1 and 100 characters.
    """

    positive_local_styles: typing.List[str] = pydantic.Field()
    """
    The styles that should be present in this section. Use English language for best result.
    """

    negative_local_styles: typing.List[str] = pydantic.Field()
    """
    The styles that should not be present in this section. Use English language for best result.
    """

    duration_ms: int = pydantic.Field()
    """
    The duration of the section in milliseconds. Must be between 3000ms and 120000ms.
    """

    lines: typing.List[str] = pydantic.Field()
    """
    The lyrics of the section.
    """

    source_from: typing.Optional[SectionSource] = pydantic.Field(default=None)
    """
    Optional source to extract the section from. Used for inpainting. Only available to enterprise clients with access to the inpainting API.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
