# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .dynamic_variable_assignment import DynamicVariableAssignment
from .system_tool_config_input_params import SystemToolConfigInputParams


class SystemToolConfigInput(UncheckedBaseModel):
    """
    A system tool is a tool that is used to call a system method in the server
    """

    name: str
    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of when the tool should be used and what it does. Leave empty to use the default description that's optimized for the specific tool type.
    """

    response_timeout_secs: typing.Optional[int] = pydantic.Field(default=None)
    """
    The maximum time in seconds to wait for the tool call to complete.
    """

    disable_interruptions: typing.Optional[bool] = pydantic.Field(default=None)
    """
    If true, the user will not be able to interrupt the agent while this tool is running.
    """

    force_pre_tool_speech: typing.Optional[bool] = pydantic.Field(default=None)
    """
    If true, the agent will speak before the tool call.
    """

    assignments: typing.Optional[typing.List[DynamicVariableAssignment]] = pydantic.Field(default=None)
    """
    Configuration for extracting values from tool responses and assigning them to dynamic variables
    """

    params: SystemToolConfigInputParams

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
