# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .resource_access_info import ResourceAccessInfo


class TestInvocationSummaryResponseModel(UncheckedBaseModel):
    id: str = pydantic.Field()
    """
    The ID of the test invocation
    """

    created_at_unix_secs: int = pydantic.Field()
    """
    Creation time of the test invocation in unix seconds
    """

    test_run_count: int = pydantic.Field()
    """
    Number of test runs in this invocation
    """

    passed_count: int = pydantic.Field()
    """
    Number of test runs that passed
    """

    failed_count: int = pydantic.Field()
    """
    Number of test runs that failed
    """

    pending_count: int = pydantic.Field()
    """
    Number of test runs that are pending
    """

    title: str = pydantic.Field()
    """
    Title of the test invocation - either the single test name or count of tests
    """

    access_info: typing.Optional[ResourceAccessInfo] = pydantic.Field(default=None)
    """
    The access information of the test invocation
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
