# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ..core.unchecked_base_model import UncheckedBaseModel
from .workflow_edge_model_input_backward_condition import WorkflowEdgeModelInputBackwardCondition
from .workflow_edge_model_input_forward_condition import WorkflowEdgeModelInputForwardCondition


class WorkflowEdgeModelInput(UncheckedBaseModel):
    source: str = pydantic.Field()
    """
    ID of the source node.
    """

    target: str = pydantic.Field()
    """
    ID of the target node.
    """

    forward_condition: typing.Optional[WorkflowEdgeModelInputForwardCondition] = pydantic.Field(default=None)
    """
    Condition that must be met for the edge to be traversed in the forward direction (source to target).
    """

    backward_condition: typing.Optional[WorkflowEdgeModelInputBackwardCondition] = pydantic.Field(default=None)
    """
    Condition that must be met for the edge to be traversed in the backward direction (target to source).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .ast_and_operator_node_input import AstAndOperatorNodeInput  # noqa: E402, F401, I001
from .ast_equals_operator_node_input import AstEqualsOperatorNodeInput  # noqa: E402, F401, I001
from .ast_greater_than_operator_node_input import AstGreaterThanOperatorNodeInput  # noqa: E402, F401, I001
from .ast_greater_than_or_equals_operator_node_input import AstGreaterThanOrEqualsOperatorNodeInput  # noqa: E402, F401, I001
from .ast_less_than_operator_node_input import AstLessThanOperatorNodeInput  # noqa: E402, F401, I001
from .ast_less_than_or_equals_operator_node_input import AstLessThanOrEqualsOperatorNodeInput  # noqa: E402, F401, I001
from .ast_not_equals_operator_node_input import AstNotEqualsOperatorNodeInput  # noqa: E402, F401, I001
from .ast_or_operator_node_input import AstOrOperatorNodeInput  # noqa: E402, F401, I001

update_forward_refs(WorkflowEdgeModelInput)
