# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ..core.unchecked_base_model import UncheckedBaseModel
from .conversational_config_api_model_workflow_override_input import ConversationalConfigApiModelWorkflowOverrideInput
from .knowledge_base_locator import KnowledgeBaseLocator
from .position_input import PositionInput


class WorkflowOverrideAgentNodeModelInput(UncheckedBaseModel):
    conversation_config: typing.Optional[ConversationalConfigApiModelWorkflowOverrideInput] = pydantic.Field(
        default=None
    )
    """
    Configuration overrides applied while the subagent is conducting the conversation.
    """

    additional_prompt: typing.Optional[str] = pydantic.Field(default=None)
    """
    Specific goal for this subagent. It will be added to the system prompt and can be used to further refine the agent's behavior in this specific context.
    """

    additional_knowledge_base: typing.Optional[typing.List[KnowledgeBaseLocator]] = pydantic.Field(default=None)
    """
    Additional knowledge base documents that the subagent has access to. These will be used in addition to the main agent's documents.
    """

    additional_tool_ids: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    IDs of additional tools that the subagent has access to. These will be used in addition to the main agent's tools.
    """

    position: typing.Optional[PositionInput] = pydantic.Field(default=None)
    """
    Position of the node in the workflow.
    """

    edge_order: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The ids of outgoing edges in the order they should be evaluated.
    """

    label: str = pydantic.Field()
    """
    Human-readable label for the node used throughout the UI.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .array_json_schema_property_input import ArrayJsonSchemaPropertyInput  # noqa: E402, F401, I001
from .object_json_schema_property_input import ObjectJsonSchemaPropertyInput  # noqa: E402, F401, I001

update_forward_refs(WorkflowOverrideAgentNodeModelInput)
