# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ..core.unchecked_base_model import UncheckedBaseModel
from .conversational_config_api_model_workflow_override_output import ConversationalConfigApiModelWorkflowOverrideOutput
from .knowledge_base_locator import KnowledgeBaseLocator
from .position_output import PositionOutput


class WorkflowOverrideAgentNodeModelOutput(UncheckedBaseModel):
    conversation_config: ConversationalConfigApiModelWorkflowOverrideOutput = pydantic.Field()
    """
    Configuration overrides applied while the subagent is conducting the conversation.
    """

    additional_prompt: str = pydantic.Field()
    """
    Specific goal for this subagent. It will be added to the system prompt and can be used to further refine the agent's behavior in this specific context.
    """

    additional_knowledge_base: typing.List[KnowledgeBaseLocator] = pydantic.Field()
    """
    Additional knowledge base documents that the subagent has access to. These will be used in addition to the main agent's documents.
    """

    additional_tool_ids: typing.List[str] = pydantic.Field()
    """
    IDs of additional tools that the subagent has access to. These will be used in addition to the main agent's tools.
    """

    position: PositionOutput = pydantic.Field()
    """
    Position of the node in the workflow.
    """

    edge_order: typing.List[str] = pydantic.Field()
    """
    The ids of outgoing edges in the order they should be evaluated.
    """

    label: str = pydantic.Field()
    """
    Human-readable label for the node used throughout the UI.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .array_json_schema_property_output import ArrayJsonSchemaPropertyOutput  # noqa: E402, F401, I001
from .object_json_schema_property_output import ObjectJsonSchemaPropertyOutput  # noqa: E402, F401, I001

update_forward_refs(WorkflowOverrideAgentNodeModelOutput)
