# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .position_input import PositionInput


class WorkflowStandaloneAgentNodeModelInput(UncheckedBaseModel):
    position: typing.Optional[PositionInput] = pydantic.Field(default=None)
    """
    Position of the node in the workflow.
    """

    edge_order: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The ids of outgoing edges in the order they should be evaluated.
    """

    agent_id: str = pydantic.Field()
    """
    The ID of the agent to transfer the conversation to.
    """

    delay_ms: typing.Optional[int] = pydantic.Field(default=None)
    """
    Artificial delay in milliseconds applied before transferring the conversation.
    """

    transfer_message: typing.Optional[str] = pydantic.Field(default=None)
    """
    Optional message sent to the user before the transfer is initiated.
    """

    enable_transferred_agent_first_message: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether to enable the transferred agent to send its configured first message after the transfer.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
