# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .position_output import PositionOutput


class WorkflowStandaloneAgentNodeModelOutput(UncheckedBaseModel):
    position: PositionOutput = pydantic.Field()
    """
    Position of the node in the workflow.
    """

    edge_order: typing.List[str] = pydantic.Field()
    """
    The ids of outgoing edges in the order they should be evaluated.
    """

    agent_id: str = pydantic.Field()
    """
    The ID of the agent to transfer the conversation to.
    """

    delay_ms: int = pydantic.Field()
    """
    Artificial delay in milliseconds applied before transferring the conversation.
    """

    transfer_message: typing.Optional[str] = pydantic.Field(default=None)
    """
    Optional message sent to the user before the transfer is initiated.
    """

    enable_transferred_agent_first_message: bool = pydantic.Field()
    """
    Whether to enable the transferred agent to send its configured first message after the transfer.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
