# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .position_output import PositionOutput
from .workflow_tool_locator import WorkflowToolLocator


class WorkflowToolNodeModelOutput(UncheckedBaseModel):
    position: PositionOutput = pydantic.Field()
    """
    Position of the node in the workflow.
    """

    edge_order: typing.List[str] = pydantic.Field()
    """
    The ids of outgoing edges in the order they should be evaluated.
    """

    tools: typing.List[WorkflowToolLocator] = pydantic.Field()
    """
    List of tools to execute in parallel. The entire node is considered successful if all tools are executed successfully.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
