# This file was auto-generated by Fern from our API Definition.

import typing

from ......core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ......core.request_options import RequestOptions
from ......types.speaker_audio_response_model import SpeakerAudioResponseModel
from .raw_client import AsyncRawAudioClient, RawAudioClient


class AudioClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAudioClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAudioClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAudioClient
        """
        return self._raw_client

    def get(
        self, voice_id: str, sample_id: str, speaker_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SpeakerAudioResponseModel:
        """
        Retrieve the separated audio for a specific speaker.

        Parameters
        ----------
        voice_id : str
            Voice ID to be used, you can use https://api.elevenlabs.io/v1/voices to list all the available voices.

        sample_id : str
            Sample ID to be used

        speaker_id : str
            Speaker ID to be used, you can use GET https://api.elevenlabs.io/v1/voices/{voice_id}/samples/{sample_id}/speakers to list all the available speakers for a sample.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SpeakerAudioResponseModel
            Successful Response

        Examples
        --------
        from elevenlabs import ElevenLabs

        client = ElevenLabs(
            api_key="YOUR_API_KEY",
        )
        client.voices.pvc.samples.speakers.audio.get(
            voice_id="21m00Tcm4TlvDq8ikWAM",
            sample_id="VW7YKqPnjY4h39yTbx2L",
            speaker_id="VW7YKqPnjY4h39yTbx2L",
        )
        """
        _response = self._raw_client.get(voice_id, sample_id, speaker_id, request_options=request_options)
        return _response.data


class AsyncAudioClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAudioClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAudioClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAudioClient
        """
        return self._raw_client

    async def get(
        self, voice_id: str, sample_id: str, speaker_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SpeakerAudioResponseModel:
        """
        Retrieve the separated audio for a specific speaker.

        Parameters
        ----------
        voice_id : str
            Voice ID to be used, you can use https://api.elevenlabs.io/v1/voices to list all the available voices.

        sample_id : str
            Sample ID to be used

        speaker_id : str
            Speaker ID to be used, you can use GET https://api.elevenlabs.io/v1/voices/{voice_id}/samples/{sample_id}/speakers to list all the available speakers for a sample.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SpeakerAudioResponseModel
            Successful Response

        Examples
        --------
        import asyncio

        from elevenlabs import AsyncElevenLabs

        client = AsyncElevenLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.voices.pvc.samples.speakers.audio.get(
                voice_id="21m00Tcm4TlvDq8ikWAM",
                sample_id="VW7YKqPnjY4h39yTbx2L",
                speaker_id="VW7YKqPnjY4h39yTbx2L",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(voice_id, sample_id, speaker_id, request_options=request_options)
        return _response.data
