# Axinite
A powerful open-source engine for advanced celestial mechanics, orbital dynamics, and planetary motion.

![axinite-1](https://github.com/user-attachments/assets/bcd7bc7e-627e-44e5-bfc6-d2ddd787a208)
![axinite-9](https://github.com/user-attachments/assets/8e07f586-3eda-439f-ab1c-8875da6b9e5a)

## Overview
**Axinite** is an engine for calculating celestial motion. 
You can use it to design your own solar systems, predict trajectories of rockets, simulate gravitational interactions and more.

Check out the docs [here](https://jewels86.gitbook.io/axinite/axinite/getting-started).
### What is `axtools`?
`axtools` is a library to help abstract and simplify Axinite. With `axtools`, Developers can deploy Axinite powered applications with ease. 
You can find the docs [here](https://jewels86.gitbook.io/axinite/axtools/quickstart).

## How can I use Axinite?
You can check out [the docs](https://jewels86.gitbook.io/axinite/) to learn about using the `axinite` module. Axinite also has a [command line interface](https://github.com/jewels86/axcli).

## Supporting Axinite
### Contributing
Feel free to open up a [pull request](https://github.com/jewels86/Axinite/pulls) or an [issue](https://github.com/jewels86/Axinite/issues) if there are any changes you'd like introduced to Axinite.
Any help will be appricated!
### Other ways to support
- Giving this repository a star! This really helps me to get Axinite out to other developers.
- Reaching out! I'd love to hear about your thoughts, ideas, and issues.
- Share the project! Help me spread the word to other students and developers.

## Gallery
![axinite-2](https://github.com/user-attachments/assets/2e952d41-5585-484d-bc3b-05c92aeefe2d)
![axinite-5](https://github.com/user-attachments/assets/c16db758-2ad2-47d8-9f1d-190727f9e881)
![axinite-6](https://github.com/user-attachments/assets/9f2b21b8-e90d-4c5b-9cde-027dfb0ee704)
![axinite-8](https://github.com/user-attachments/assets/e39cafc8-7670-4a9d-a0c8-c95682641a95)

## Todos
- Graceful load funciton exiting
- Phase out `astropy`
- Fix weird euler loading error where first positions are always the origin
- Add Velocity Verlet backend
- Add RK4 backend
- Add comments to code
