# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from ... import _utilities
from . import outputs
from ... import meta as _meta

__all__ = [
    'ApplyConfiguration',
    'ApplyConfigurationPatch',
    'AuditAnnotation',
    'AuditAnnotationPatch',
    'ExpressionWarning',
    'ExpressionWarningPatch',
    'JSONPatch',
    'JSONPatchPatch',
    'MatchCondition',
    'MatchConditionPatch',
    'MatchResources',
    'MatchResourcesPatch',
    'MutatingAdmissionPolicy',
    'MutatingAdmissionPolicyBinding',
    'MutatingAdmissionPolicyBindingSpec',
    'MutatingAdmissionPolicyBindingSpecPatch',
    'MutatingAdmissionPolicySpec',
    'MutatingAdmissionPolicySpecPatch',
    'Mutation',
    'MutationPatch',
    'NamedRuleWithOperations',
    'NamedRuleWithOperationsPatch',
    'ParamKind',
    'ParamKindPatch',
    'ParamRef',
    'ParamRefPatch',
    'TypeChecking',
    'TypeCheckingPatch',
    'ValidatingAdmissionPolicy',
    'ValidatingAdmissionPolicyBinding',
    'ValidatingAdmissionPolicyBindingSpec',
    'ValidatingAdmissionPolicyBindingSpecPatch',
    'ValidatingAdmissionPolicySpec',
    'ValidatingAdmissionPolicySpecPatch',
    'ValidatingAdmissionPolicyStatus',
    'ValidatingAdmissionPolicyStatusPatch',
    'Validation',
    'ValidationPatch',
    'Variable',
    'VariablePatch',
]

@pulumi.output_type
class ApplyConfiguration(dict):
    """
    ApplyConfiguration defines the desired configuration values of an object.
    """
    def __init__(__self__, *,
                 expression: Optional[_builtins.str] = None):
        """
        ApplyConfiguration defines the desired configuration values of an object.
        :param _builtins.str expression: expression will be evaluated by CEL to create an apply configuration. ref: https://github.com/google/cel-spec
               
               Apply configurations are declared in CEL using object initialization. For example, this CEL expression returns an apply configuration to set a single field:
               
               	Object{
               	  spec: Object.spec{
               	    serviceAccountName: "example"
               	  }
               	}
               
               Apply configurations may not modify atomic structs, maps or arrays due to the risk of accidental deletion of values not included in the apply configuration.
               
               CEL expressions have access to the object types needed to create apply configurations:
               
               - 'Object' - CEL type of the resource object. - 'Object.<fieldName>' - CEL type of object field (such as 'Object.spec') - 'Object.<fieldName1>.<fieldName2>...<fieldNameN>` - CEL type of nested field (such as 'Object.spec.containers')
               
               CEL expressions have access to the contents of the API request, organized into CEL variables as well as some other useful variables:
               
               - 'object' - The object from the incoming request. The value is null for DELETE requests. - 'oldObject' - The existing object. The value is null for CREATE requests. - 'request' - Attributes of the API request([ref](/pkg/apis/admission/types.go#AdmissionRequest)). - 'params' - Parameter resource referred to by the policy binding being evaluated. Only populated if the policy has a ParamKind. - 'namespaceObject' - The namespace object that the incoming object belongs to. The value is null for cluster-scoped resources. - 'variables' - Map of composited variables, from its name to its lazily evaluated value.
                 For example, a variable named 'foo' can be accessed as 'variables.foo'.
               - 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.
                 See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz
               - 'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the
                 request resource.
               
               The `apiVersion`, `kind`, `metadata.name` and `metadata.generateName` are always accessible from the root of the object. No other metadata properties are accessible.
               
               Only property names of the form `[a-zA-Z_.-/][a-zA-Z0-9_.-/]*` are accessible. Required.
        """
        if expression is not None:
            pulumi.set(__self__, "expression", expression)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> Optional[_builtins.str]:
        """
        expression will be evaluated by CEL to create an apply configuration. ref: https://github.com/google/cel-spec

        Apply configurations are declared in CEL using object initialization. For example, this CEL expression returns an apply configuration to set a single field:

        	Object{
        	  spec: Object.spec{
        	    serviceAccountName: "example"
        	  }
        	}

        Apply configurations may not modify atomic structs, maps or arrays due to the risk of accidental deletion of values not included in the apply configuration.

        CEL expressions have access to the object types needed to create apply configurations:

        - 'Object' - CEL type of the resource object. - 'Object.<fieldName>' - CEL type of object field (such as 'Object.spec') - 'Object.<fieldName1>.<fieldName2>...<fieldNameN>` - CEL type of nested field (such as 'Object.spec.containers')

        CEL expressions have access to the contents of the API request, organized into CEL variables as well as some other useful variables:

        - 'object' - The object from the incoming request. The value is null for DELETE requests. - 'oldObject' - The existing object. The value is null for CREATE requests. - 'request' - Attributes of the API request([ref](/pkg/apis/admission/types.go#AdmissionRequest)). - 'params' - Parameter resource referred to by the policy binding being evaluated. Only populated if the policy has a ParamKind. - 'namespaceObject' - The namespace object that the incoming object belongs to. The value is null for cluster-scoped resources. - 'variables' - Map of composited variables, from its name to its lazily evaluated value.
          For example, a variable named 'foo' can be accessed as 'variables.foo'.
        - 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.
          See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz
        - 'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the
          request resource.

        The `apiVersion`, `kind`, `metadata.name` and `metadata.generateName` are always accessible from the root of the object. No other metadata properties are accessible.

        Only property names of the form `[a-zA-Z_.-/][a-zA-Z0-9_.-/]*` are accessible. Required.
        """
        return pulumi.get(self, "expression")


@pulumi.output_type
class ApplyConfigurationPatch(dict):
    """
    ApplyConfiguration defines the desired configuration values of an object.
    """
    def __init__(__self__, *,
                 expression: Optional[_builtins.str] = None):
        """
        ApplyConfiguration defines the desired configuration values of an object.
        :param _builtins.str expression: expression will be evaluated by CEL to create an apply configuration. ref: https://github.com/google/cel-spec
               
               Apply configurations are declared in CEL using object initialization. For example, this CEL expression returns an apply configuration to set a single field:
               
               	Object{
               	  spec: Object.spec{
               	    serviceAccountName: "example"
               	  }
               	}
               
               Apply configurations may not modify atomic structs, maps or arrays due to the risk of accidental deletion of values not included in the apply configuration.
               
               CEL expressions have access to the object types needed to create apply configurations:
               
               - 'Object' - CEL type of the resource object. - 'Object.<fieldName>' - CEL type of object field (such as 'Object.spec') - 'Object.<fieldName1>.<fieldName2>...<fieldNameN>` - CEL type of nested field (such as 'Object.spec.containers')
               
               CEL expressions have access to the contents of the API request, organized into CEL variables as well as some other useful variables:
               
               - 'object' - The object from the incoming request. The value is null for DELETE requests. - 'oldObject' - The existing object. The value is null for CREATE requests. - 'request' - Attributes of the API request([ref](/pkg/apis/admission/types.go#AdmissionRequest)). - 'params' - Parameter resource referred to by the policy binding being evaluated. Only populated if the policy has a ParamKind. - 'namespaceObject' - The namespace object that the incoming object belongs to. The value is null for cluster-scoped resources. - 'variables' - Map of composited variables, from its name to its lazily evaluated value.
                 For example, a variable named 'foo' can be accessed as 'variables.foo'.
               - 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.
                 See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz
               - 'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the
                 request resource.
               
               The `apiVersion`, `kind`, `metadata.name` and `metadata.generateName` are always accessible from the root of the object. No other metadata properties are accessible.
               
               Only property names of the form `[a-zA-Z_.-/][a-zA-Z0-9_.-/]*` are accessible. Required.
        """
        if expression is not None:
            pulumi.set(__self__, "expression", expression)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> Optional[_builtins.str]:
        """
        expression will be evaluated by CEL to create an apply configuration. ref: https://github.com/google/cel-spec

        Apply configurations are declared in CEL using object initialization. For example, this CEL expression returns an apply configuration to set a single field:

        	Object{
        	  spec: Object.spec{
        	    serviceAccountName: "example"
        	  }
        	}

        Apply configurations may not modify atomic structs, maps or arrays due to the risk of accidental deletion of values not included in the apply configuration.

        CEL expressions have access to the object types needed to create apply configurations:

        - 'Object' - CEL type of the resource object. - 'Object.<fieldName>' - CEL type of object field (such as 'Object.spec') - 'Object.<fieldName1>.<fieldName2>...<fieldNameN>` - CEL type of nested field (such as 'Object.spec.containers')

        CEL expressions have access to the contents of the API request, organized into CEL variables as well as some other useful variables:

        - 'object' - The object from the incoming request. The value is null for DELETE requests. - 'oldObject' - The existing object. The value is null for CREATE requests. - 'request' - Attributes of the API request([ref](/pkg/apis/admission/types.go#AdmissionRequest)). - 'params' - Parameter resource referred to by the policy binding being evaluated. Only populated if the policy has a ParamKind. - 'namespaceObject' - The namespace object that the incoming object belongs to. The value is null for cluster-scoped resources. - 'variables' - Map of composited variables, from its name to its lazily evaluated value.
          For example, a variable named 'foo' can be accessed as 'variables.foo'.
        - 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.
          See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz
        - 'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the
          request resource.

        The `apiVersion`, `kind`, `metadata.name` and `metadata.generateName` are always accessible from the root of the object. No other metadata properties are accessible.

        Only property names of the form `[a-zA-Z_.-/][a-zA-Z0-9_.-/]*` are accessible. Required.
        """
        return pulumi.get(self, "expression")


@pulumi.output_type
class AuditAnnotation(dict):
    """
    AuditAnnotation describes how to produce an audit annotation for an API request.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueExpression":
            suggest = "value_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuditAnnotation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuditAnnotation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuditAnnotation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: _builtins.str,
                 value_expression: _builtins.str):
        """
        AuditAnnotation describes how to produce an audit annotation for an API request.
        :param _builtins.str key: key specifies the audit annotation key. The audit annotation keys of a ValidatingAdmissionPolicy must be unique. The key must be a qualified name ([A-Za-z0-9][-A-Za-z0-9_.]*) no more than 63 bytes in length.
               
               The key is combined with the resource name of the ValidatingAdmissionPolicy to construct an audit annotation key: "{ValidatingAdmissionPolicy name}/{key}".
               
               If an admission webhook uses the same resource name as this ValidatingAdmissionPolicy and the same audit annotation key, the annotation key will be identical. In this case, the first annotation written with the key will be included in the audit event and all subsequent annotations with the same key will be discarded.
               
               Required.
        :param _builtins.str value_expression: valueExpression represents the expression which is evaluated by CEL to produce an audit annotation value. The expression must evaluate to either a string or null value. If the expression evaluates to a string, the audit annotation is included with the string value. If the expression evaluates to null or empty string the audit annotation will be omitted. The valueExpression may be no longer than 5kb in length. If the result of the valueExpression is more than 10kb in length, it will be truncated to 10kb.
               
               If multiple ValidatingAdmissionPolicyBinding resources match an API request, then the valueExpression will be evaluated for each binding. All unique values produced by the valueExpressions will be joined together in a comma-separated list.
               
               Required.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value_expression", value_expression)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        key specifies the audit annotation key. The audit annotation keys of a ValidatingAdmissionPolicy must be unique. The key must be a qualified name ([A-Za-z0-9][-A-Za-z0-9_.]*) no more than 63 bytes in length.

        The key is combined with the resource name of the ValidatingAdmissionPolicy to construct an audit annotation key: "{ValidatingAdmissionPolicy name}/{key}".

        If an admission webhook uses the same resource name as this ValidatingAdmissionPolicy and the same audit annotation key, the annotation key will be identical. In this case, the first annotation written with the key will be included in the audit event and all subsequent annotations with the same key will be discarded.

        Required.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="valueExpression")
    def value_expression(self) -> _builtins.str:
        """
        valueExpression represents the expression which is evaluated by CEL to produce an audit annotation value. The expression must evaluate to either a string or null value. If the expression evaluates to a string, the audit annotation is included with the string value. If the expression evaluates to null or empty string the audit annotation will be omitted. The valueExpression may be no longer than 5kb in length. If the result of the valueExpression is more than 10kb in length, it will be truncated to 10kb.

        If multiple ValidatingAdmissionPolicyBinding resources match an API request, then the valueExpression will be evaluated for each binding. All unique values produced by the valueExpressions will be joined together in a comma-separated list.

        Required.
        """
        return pulumi.get(self, "value_expression")


@pulumi.output_type
class AuditAnnotationPatch(dict):
    """
    AuditAnnotation describes how to produce an audit annotation for an API request.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueExpression":
            suggest = "value_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuditAnnotationPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuditAnnotationPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuditAnnotationPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: Optional[_builtins.str] = None,
                 value_expression: Optional[_builtins.str] = None):
        """
        AuditAnnotation describes how to produce an audit annotation for an API request.
        :param _builtins.str key: key specifies the audit annotation key. The audit annotation keys of a ValidatingAdmissionPolicy must be unique. The key must be a qualified name ([A-Za-z0-9][-A-Za-z0-9_.]*) no more than 63 bytes in length.
               
               The key is combined with the resource name of the ValidatingAdmissionPolicy to construct an audit annotation key: "{ValidatingAdmissionPolicy name}/{key}".
               
               If an admission webhook uses the same resource name as this ValidatingAdmissionPolicy and the same audit annotation key, the annotation key will be identical. In this case, the first annotation written with the key will be included in the audit event and all subsequent annotations with the same key will be discarded.
               
               Required.
        :param _builtins.str value_expression: valueExpression represents the expression which is evaluated by CEL to produce an audit annotation value. The expression must evaluate to either a string or null value. If the expression evaluates to a string, the audit annotation is included with the string value. If the expression evaluates to null or empty string the audit annotation will be omitted. The valueExpression may be no longer than 5kb in length. If the result of the valueExpression is more than 10kb in length, it will be truncated to 10kb.
               
               If multiple ValidatingAdmissionPolicyBinding resources match an API request, then the valueExpression will be evaluated for each binding. All unique values produced by the valueExpressions will be joined together in a comma-separated list.
               
               Required.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value_expression is not None:
            pulumi.set(__self__, "value_expression", value_expression)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        key specifies the audit annotation key. The audit annotation keys of a ValidatingAdmissionPolicy must be unique. The key must be a qualified name ([A-Za-z0-9][-A-Za-z0-9_.]*) no more than 63 bytes in length.

        The key is combined with the resource name of the ValidatingAdmissionPolicy to construct an audit annotation key: "{ValidatingAdmissionPolicy name}/{key}".

        If an admission webhook uses the same resource name as this ValidatingAdmissionPolicy and the same audit annotation key, the annotation key will be identical. In this case, the first annotation written with the key will be included in the audit event and all subsequent annotations with the same key will be discarded.

        Required.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="valueExpression")
    def value_expression(self) -> Optional[_builtins.str]:
        """
        valueExpression represents the expression which is evaluated by CEL to produce an audit annotation value. The expression must evaluate to either a string or null value. If the expression evaluates to a string, the audit annotation is included with the string value. If the expression evaluates to null or empty string the audit annotation will be omitted. The valueExpression may be no longer than 5kb in length. If the result of the valueExpression is more than 10kb in length, it will be truncated to 10kb.

        If multiple ValidatingAdmissionPolicyBinding resources match an API request, then the valueExpression will be evaluated for each binding. All unique values produced by the valueExpressions will be joined together in a comma-separated list.

        Required.
        """
        return pulumi.get(self, "value_expression")


@pulumi.output_type
class ExpressionWarning(dict):
    """
    ExpressionWarning is a warning information that targets a specific expression.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldRef":
            suggest = "field_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExpressionWarning. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExpressionWarning.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExpressionWarning.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_ref: _builtins.str,
                 warning: _builtins.str):
        """
        ExpressionWarning is a warning information that targets a specific expression.
        :param _builtins.str field_ref: The path to the field that refers the expression. For example, the reference to the expression of the first item of validations is "spec.validations[0].expression"
        :param _builtins.str warning: The content of type checking information in a human-readable form. Each line of the warning contains the type that the expression is checked against, followed by the type check error from the compiler.
        """
        pulumi.set(__self__, "field_ref", field_ref)
        pulumi.set(__self__, "warning", warning)

    @_builtins.property
    @pulumi.getter(name="fieldRef")
    def field_ref(self) -> _builtins.str:
        """
        The path to the field that refers the expression. For example, the reference to the expression of the first item of validations is "spec.validations[0].expression"
        """
        return pulumi.get(self, "field_ref")

    @_builtins.property
    @pulumi.getter
    def warning(self) -> _builtins.str:
        """
        The content of type checking information in a human-readable form. Each line of the warning contains the type that the expression is checked against, followed by the type check error from the compiler.
        """
        return pulumi.get(self, "warning")


@pulumi.output_type
class ExpressionWarningPatch(dict):
    """
    ExpressionWarning is a warning information that targets a specific expression.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldRef":
            suggest = "field_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExpressionWarningPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExpressionWarningPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExpressionWarningPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_ref: Optional[_builtins.str] = None,
                 warning: Optional[_builtins.str] = None):
        """
        ExpressionWarning is a warning information that targets a specific expression.
        :param _builtins.str field_ref: The path to the field that refers the expression. For example, the reference to the expression of the first item of validations is "spec.validations[0].expression"
        :param _builtins.str warning: The content of type checking information in a human-readable form. Each line of the warning contains the type that the expression is checked against, followed by the type check error from the compiler.
        """
        if field_ref is not None:
            pulumi.set(__self__, "field_ref", field_ref)
        if warning is not None:
            pulumi.set(__self__, "warning", warning)

    @_builtins.property
    @pulumi.getter(name="fieldRef")
    def field_ref(self) -> Optional[_builtins.str]:
        """
        The path to the field that refers the expression. For example, the reference to the expression of the first item of validations is "spec.validations[0].expression"
        """
        return pulumi.get(self, "field_ref")

    @_builtins.property
    @pulumi.getter
    def warning(self) -> Optional[_builtins.str]:
        """
        The content of type checking information in a human-readable form. Each line of the warning contains the type that the expression is checked against, followed by the type check error from the compiler.
        """
        return pulumi.get(self, "warning")


@pulumi.output_type
class JSONPatch(dict):
    """
    JSONPatch defines a JSON Patch.
    """
    def __init__(__self__, *,
                 expression: Optional[_builtins.str] = None):
        """
        JSONPatch defines a JSON Patch.
        :param _builtins.str expression: expression will be evaluated by CEL to create a [JSON patch](https://jsonpatch.com/). ref: https://github.com/google/cel-spec
               
               expression must return an array of JSONPatch values.
               
               For example, this CEL expression returns a JSON patch to conditionally modify a value:
               
               	  [
               	    JSONPatch{op: "test", path: "/spec/example", value: "Red"},
               	    JSONPatch{op: "replace", path: "/spec/example", value: "Green"}
               	  ]
               
               To define an object for the patch value, use Object types. For example:
               
               	  [
               	    JSONPatch{
               	      op: "add",
               	      path: "/spec/selector",
               	      value: Object.spec.selector{matchLabels: {"environment": "test"}}
               	    }
               	  ]
               
               To use strings containing '/' and '~' as JSONPatch path keys, use "jsonpatch.escapeKey". For example:
               
               	  [
               	    JSONPatch{
               	      op: "add",
               	      path: "/metadata/labels/" + jsonpatch.escapeKey("example.com/environment"),
               	      value: "test"
               	    },
               	  ]
               
               CEL expressions have access to the types needed to create JSON patches and objects:
               
               - 'JSONPatch' - CEL type of JSON Patch operations. JSONPatch has the fields 'op', 'from', 'path' and 'value'.
                 See [JSON patch](https://jsonpatch.com/) for more details. The 'value' field may be set to any of: string,
                 integer, array, map or object.  If set, the 'path' and 'from' fields must be set to a
                 [JSON pointer](https://datatracker.ietf.org/doc/html/rfc6901/) string, where the 'jsonpatch.escapeKey()' CEL
                 function may be used to escape path keys containing '/' and '~'.
               - 'Object' - CEL type of the resource object. - 'Object.<fieldName>' - CEL type of object field (such as 'Object.spec') - 'Object.<fieldName1>.<fieldName2>...<fieldNameN>` - CEL type of nested field (such as 'Object.spec.containers')
               
               CEL expressions have access to the contents of the API request, organized into CEL variables as well as some other useful variables:
               
               - 'object' - The object from the incoming request. The value is null for DELETE requests. - 'oldObject' - The existing object. The value is null for CREATE requests. - 'request' - Attributes of the API request([ref](/pkg/apis/admission/types.go#AdmissionRequest)). - 'params' - Parameter resource referred to by the policy binding being evaluated. Only populated if the policy has a ParamKind. - 'namespaceObject' - The namespace object that the incoming object belongs to. The value is null for cluster-scoped resources. - 'variables' - Map of composited variables, from its name to its lazily evaluated value.
                 For example, a variable named 'foo' can be accessed as 'variables.foo'.
               - 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.
                 See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz
               - 'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the
                 request resource.
               
               CEL expressions have access to [Kubernetes CEL function libraries](https://kubernetes.io/docs/reference/using-api/cel/#cel-options-language-features-and-libraries) as well as:
               
               - 'jsonpatch.escapeKey' - Performs JSONPatch key escaping. '~' and  '/' are escaped as '~0' and `~1' respectively).
               
               Only property names of the form `[a-zA-Z_.-/][a-zA-Z0-9_.-/]*` are accessible. Required.
        """
        if expression is not None:
            pulumi.set(__self__, "expression", expression)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> Optional[_builtins.str]:
        """
        expression will be evaluated by CEL to create a [JSON patch](https://jsonpatch.com/). ref: https://github.com/google/cel-spec

        expression must return an array of JSONPatch values.

        For example, this CEL expression returns a JSON patch to conditionally modify a value:

        	  [
        	    JSONPatch{op: "test", path: "/spec/example", value: "Red"},
        	    JSONPatch{op: "replace", path: "/spec/example", value: "Green"}
        	  ]

        To define an object for the patch value, use Object types. For example:

        	  [
        	    JSONPatch{
        	      op: "add",
        	      path: "/spec/selector",
        	      value: Object.spec.selector{matchLabels: {"environment": "test"}}
        	    }
        	  ]

        To use strings containing '/' and '~' as JSONPatch path keys, use "jsonpatch.escapeKey". For example:

        	  [
        	    JSONPatch{
        	      op: "add",
        	      path: "/metadata/labels/" + jsonpatch.escapeKey("example.com/environment"),
        	      value: "test"
        	    },
        	  ]

        CEL expressions have access to the types needed to create JSON patches and objects:

        - 'JSONPatch' - CEL type of JSON Patch operations. JSONPatch has the fields 'op', 'from', 'path' and 'value'.
          See [JSON patch](https://jsonpatch.com/) for more details. The 'value' field may be set to any of: string,
          integer, array, map or object.  If set, the 'path' and 'from' fields must be set to a
          [JSON pointer](https://datatracker.ietf.org/doc/html/rfc6901/) string, where the 'jsonpatch.escapeKey()' CEL
          function may be used to escape path keys containing '/' and '~'.
        - 'Object' - CEL type of the resource object. - 'Object.<fieldName>' - CEL type of object field (such as 'Object.spec') - 'Object.<fieldName1>.<fieldName2>...<fieldNameN>` - CEL type of nested field (such as 'Object.spec.containers')

        CEL expressions have access to the contents of the API request, organized into CEL variables as well as some other useful variables:

        - 'object' - The object from the incoming request. The value is null for DELETE requests. - 'oldObject' - The existing object. The value is null for CREATE requests. - 'request' - Attributes of the API request([ref](/pkg/apis/admission/types.go#AdmissionRequest)). - 'params' - Parameter resource referred to by the policy binding being evaluated. Only populated if the policy has a ParamKind. - 'namespaceObject' - The namespace object that the incoming object belongs to. The value is null for cluster-scoped resources. - 'variables' - Map of composited variables, from its name to its lazily evaluated value.
          For example, a variable named 'foo' can be accessed as 'variables.foo'.
        - 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.
          See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz
        - 'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the
          request resource.

        CEL expressions have access to [Kubernetes CEL function libraries](https://kubernetes.io/docs/reference/using-api/cel/#cel-options-language-features-and-libraries) as well as:

        - 'jsonpatch.escapeKey' - Performs JSONPatch key escaping. '~' and  '/' are escaped as '~0' and `~1' respectively).

        Only property names of the form `[a-zA-Z_.-/][a-zA-Z0-9_.-/]*` are accessible. Required.
        """
        return pulumi.get(self, "expression")


@pulumi.output_type
class JSONPatchPatch(dict):
    """
    JSONPatch defines a JSON Patch.
    """
    def __init__(__self__, *,
                 expression: Optional[_builtins.str] = None):
        """
        JSONPatch defines a JSON Patch.
        :param _builtins.str expression: expression will be evaluated by CEL to create a [JSON patch](https://jsonpatch.com/). ref: https://github.com/google/cel-spec
               
               expression must return an array of JSONPatch values.
               
               For example, this CEL expression returns a JSON patch to conditionally modify a value:
               
               	  [
               	    JSONPatch{op: "test", path: "/spec/example", value: "Red"},
               	    JSONPatch{op: "replace", path: "/spec/example", value: "Green"}
               	  ]
               
               To define an object for the patch value, use Object types. For example:
               
               	  [
               	    JSONPatch{
               	      op: "add",
               	      path: "/spec/selector",
               	      value: Object.spec.selector{matchLabels: {"environment": "test"}}
               	    }
               	  ]
               
               To use strings containing '/' and '~' as JSONPatch path keys, use "jsonpatch.escapeKey". For example:
               
               	  [
               	    JSONPatch{
               	      op: "add",
               	      path: "/metadata/labels/" + jsonpatch.escapeKey("example.com/environment"),
               	      value: "test"
               	    },
               	  ]
               
               CEL expressions have access to the types needed to create JSON patches and objects:
               
               - 'JSONPatch' - CEL type of JSON Patch operations. JSONPatch has the fields 'op', 'from', 'path' and 'value'.
                 See [JSON patch](https://jsonpatch.com/) for more details. The 'value' field may be set to any of: string,
                 integer, array, map or object.  If set, the 'path' and 'from' fields must be set to a
                 [JSON pointer](https://datatracker.ietf.org/doc/html/rfc6901/) string, where the 'jsonpatch.escapeKey()' CEL
                 function may be used to escape path keys containing '/' and '~'.
               - 'Object' - CEL type of the resource object. - 'Object.<fieldName>' - CEL type of object field (such as 'Object.spec') - 'Object.<fieldName1>.<fieldName2>...<fieldNameN>` - CEL type of nested field (such as 'Object.spec.containers')
               
               CEL expressions have access to the contents of the API request, organized into CEL variables as well as some other useful variables:
               
               - 'object' - The object from the incoming request. The value is null for DELETE requests. - 'oldObject' - The existing object. The value is null for CREATE requests. - 'request' - Attributes of the API request([ref](/pkg/apis/admission/types.go#AdmissionRequest)). - 'params' - Parameter resource referred to by the policy binding being evaluated. Only populated if the policy has a ParamKind. - 'namespaceObject' - The namespace object that the incoming object belongs to. The value is null for cluster-scoped resources. - 'variables' - Map of composited variables, from its name to its lazily evaluated value.
                 For example, a variable named 'foo' can be accessed as 'variables.foo'.
               - 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.
                 See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz
               - 'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the
                 request resource.
               
               CEL expressions have access to [Kubernetes CEL function libraries](https://kubernetes.io/docs/reference/using-api/cel/#cel-options-language-features-and-libraries) as well as:
               
               - 'jsonpatch.escapeKey' - Performs JSONPatch key escaping. '~' and  '/' are escaped as '~0' and `~1' respectively).
               
               Only property names of the form `[a-zA-Z_.-/][a-zA-Z0-9_.-/]*` are accessible. Required.
        """
        if expression is not None:
            pulumi.set(__self__, "expression", expression)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> Optional[_builtins.str]:
        """
        expression will be evaluated by CEL to create a [JSON patch](https://jsonpatch.com/). ref: https://github.com/google/cel-spec

        expression must return an array of JSONPatch values.

        For example, this CEL expression returns a JSON patch to conditionally modify a value:

        	  [
        	    JSONPatch{op: "test", path: "/spec/example", value: "Red"},
        	    JSONPatch{op: "replace", path: "/spec/example", value: "Green"}
        	  ]

        To define an object for the patch value, use Object types. For example:

        	  [
        	    JSONPatch{
        	      op: "add",
        	      path: "/spec/selector",
        	      value: Object.spec.selector{matchLabels: {"environment": "test"}}
        	    }
        	  ]

        To use strings containing '/' and '~' as JSONPatch path keys, use "jsonpatch.escapeKey". For example:

        	  [
        	    JSONPatch{
        	      op: "add",
        	      path: "/metadata/labels/" + jsonpatch.escapeKey("example.com/environment"),
        	      value: "test"
        	    },
        	  ]

        CEL expressions have access to the types needed to create JSON patches and objects:

        - 'JSONPatch' - CEL type of JSON Patch operations. JSONPatch has the fields 'op', 'from', 'path' and 'value'.
          See [JSON patch](https://jsonpatch.com/) for more details. The 'value' field may be set to any of: string,
          integer, array, map or object.  If set, the 'path' and 'from' fields must be set to a
          [JSON pointer](https://datatracker.ietf.org/doc/html/rfc6901/) string, where the 'jsonpatch.escapeKey()' CEL
          function may be used to escape path keys containing '/' and '~'.
        - 'Object' - CEL type of the resource object. - 'Object.<fieldName>' - CEL type of object field (such as 'Object.spec') - 'Object.<fieldName1>.<fieldName2>...<fieldNameN>` - CEL type of nested field (such as 'Object.spec.containers')

        CEL expressions have access to the contents of the API request, organized into CEL variables as well as some other useful variables:

        - 'object' - The object from the incoming request. The value is null for DELETE requests. - 'oldObject' - The existing object. The value is null for CREATE requests. - 'request' - Attributes of the API request([ref](/pkg/apis/admission/types.go#AdmissionRequest)). - 'params' - Parameter resource referred to by the policy binding being evaluated. Only populated if the policy has a ParamKind. - 'namespaceObject' - The namespace object that the incoming object belongs to. The value is null for cluster-scoped resources. - 'variables' - Map of composited variables, from its name to its lazily evaluated value.
          For example, a variable named 'foo' can be accessed as 'variables.foo'.
        - 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.
          See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz
        - 'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the
          request resource.

        CEL expressions have access to [Kubernetes CEL function libraries](https://kubernetes.io/docs/reference/using-api/cel/#cel-options-language-features-and-libraries) as well as:

        - 'jsonpatch.escapeKey' - Performs JSONPatch key escaping. '~' and  '/' are escaped as '~0' and `~1' respectively).

        Only property names of the form `[a-zA-Z_.-/][a-zA-Z0-9_.-/]*` are accessible. Required.
        """
        return pulumi.get(self, "expression")


@pulumi.output_type
class MatchCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str expression: Expression represents the expression which will be evaluated by CEL. Must evaluate to bool. CEL expressions have access to the contents of the AdmissionRequest and Authorizer, organized into CEL variables:
               
               'object' - The object from the incoming request. The value is null for DELETE requests. 'oldObject' - The existing object. The value is null for CREATE requests. 'request' - Attributes of the admission request(/pkg/apis/admission/types.go#AdmissionRequest). 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.
                 See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz
               'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the
                 request resource.
               Documentation on CEL: https://kubernetes.io/docs/reference/using-api/cel/
               
               Required.
        :param _builtins.str name: Name is an identifier for this match condition, used for strategic merging of MatchConditions, as well as providing an identifier for logging purposes. A good name should be descriptive of the associated expression. Name must be a qualified name consisting of alphanumeric characters, '-', '_' or '.', and must start and end with an alphanumeric character (e.g. 'MyName',  or 'my.name',  or '123-abc', regex used for validation is '([A-Za-z0-9][-A-Za-z0-9_.]*)?[A-Za-z0-9]') with an optional DNS subdomain prefix and '/' (e.g. 'example.com/MyName')
               
               Required.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        """
        Expression represents the expression which will be evaluated by CEL. Must evaluate to bool. CEL expressions have access to the contents of the AdmissionRequest and Authorizer, organized into CEL variables:

        'object' - The object from the incoming request. The value is null for DELETE requests. 'oldObject' - The existing object. The value is null for CREATE requests. 'request' - Attributes of the admission request(/pkg/apis/admission/types.go#AdmissionRequest). 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.
          See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz
        'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the
          request resource.
        Documentation on CEL: https://kubernetes.io/docs/reference/using-api/cel/

        Required.
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name is an identifier for this match condition, used for strategic merging of MatchConditions, as well as providing an identifier for logging purposes. A good name should be descriptive of the associated expression. Name must be a qualified name consisting of alphanumeric characters, '-', '_' or '.', and must start and end with an alphanumeric character (e.g. 'MyName',  or 'my.name',  or '123-abc', regex used for validation is '([A-Za-z0-9][-A-Za-z0-9_.]*)?[A-Za-z0-9]') with an optional DNS subdomain prefix and '/' (e.g. 'example.com/MyName')

        Required.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class MatchConditionPatch(dict):
    def __init__(__self__, *,
                 expression: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str expression: Expression represents the expression which will be evaluated by CEL. Must evaluate to bool. CEL expressions have access to the contents of the AdmissionRequest and Authorizer, organized into CEL variables:
               
               'object' - The object from the incoming request. The value is null for DELETE requests. 'oldObject' - The existing object. The value is null for CREATE requests. 'request' - Attributes of the admission request(/pkg/apis/admission/types.go#AdmissionRequest). 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.
                 See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz
               'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the
                 request resource.
               Documentation on CEL: https://kubernetes.io/docs/reference/using-api/cel/
               
               Required.
        :param _builtins.str name: Name is an identifier for this match condition, used for strategic merging of MatchConditions, as well as providing an identifier for logging purposes. A good name should be descriptive of the associated expression. Name must be a qualified name consisting of alphanumeric characters, '-', '_' or '.', and must start and end with an alphanumeric character (e.g. 'MyName',  or 'my.name',  or '123-abc', regex used for validation is '([A-Za-z0-9][-A-Za-z0-9_.]*)?[A-Za-z0-9]') with an optional DNS subdomain prefix and '/' (e.g. 'example.com/MyName')
               
               Required.
        """
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> Optional[_builtins.str]:
        """
        Expression represents the expression which will be evaluated by CEL. Must evaluate to bool. CEL expressions have access to the contents of the AdmissionRequest and Authorizer, organized into CEL variables:

        'object' - The object from the incoming request. The value is null for DELETE requests. 'oldObject' - The existing object. The value is null for CREATE requests. 'request' - Attributes of the admission request(/pkg/apis/admission/types.go#AdmissionRequest). 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.
          See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz
        'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the
          request resource.
        Documentation on CEL: https://kubernetes.io/docs/reference/using-api/cel/

        Required.
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name is an identifier for this match condition, used for strategic merging of MatchConditions, as well as providing an identifier for logging purposes. A good name should be descriptive of the associated expression. Name must be a qualified name consisting of alphanumeric characters, '-', '_' or '.', and must start and end with an alphanumeric character (e.g. 'MyName',  or 'my.name',  or '123-abc', regex used for validation is '([A-Za-z0-9][-A-Za-z0-9_.]*)?[A-Za-z0-9]') with an optional DNS subdomain prefix and '/' (e.g. 'example.com/MyName')

        Required.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class MatchResources(dict):
    """
    MatchResources decides whether to run the admission control policy on an object based on whether it meets the match criteria. The exclude rules take precedence over include rules (if a resource matches both, it is excluded)
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludeResourceRules":
            suggest = "exclude_resource_rules"
        elif key == "matchPolicy":
            suggest = "match_policy"
        elif key == "namespaceSelector":
            suggest = "namespace_selector"
        elif key == "objectSelector":
            suggest = "object_selector"
        elif key == "resourceRules":
            suggest = "resource_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MatchResources. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MatchResources.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MatchResources.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exclude_resource_rules: Optional[Sequence['outputs.NamedRuleWithOperations']] = None,
                 match_policy: Optional[_builtins.str] = None,
                 namespace_selector: Optional['_meta.v1.outputs.LabelSelector'] = None,
                 object_selector: Optional['_meta.v1.outputs.LabelSelector'] = None,
                 resource_rules: Optional[Sequence['outputs.NamedRuleWithOperations']] = None):
        """
        MatchResources decides whether to run the admission control policy on an object based on whether it meets the match criteria. The exclude rules take precedence over include rules (if a resource matches both, it is excluded)
        :param Sequence['NamedRuleWithOperationsArgs'] exclude_resource_rules: ExcludeResourceRules describes what operations on what resources/subresources the policy should not care about. The exclude rules take precedence over include rules (if a resource matches both, it is excluded)
        :param _builtins.str match_policy: matchPolicy defines how the "MatchResources" list is used to match incoming requests. Allowed values are "Exact" or "Equivalent".
               
               - Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, the admission policy does not consider requests to apps/v1beta1 or extensions/v1beta1 API groups.
               
               - Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, the admission policy **does** consider requests made to apps/v1beta1 or extensions/v1beta1 API groups. The API server translates the request to a matched resource API if necessary.
               
               Defaults to "Equivalent"
        :param '_meta.v1.LabelSelectorArgs' namespace_selector: NamespaceSelector decides whether to run the admission control policy on an object based on whether the namespace for that object matches the selector. If the object itself is a namespace, the matching is performed on object.metadata.labels. If the object is another cluster scoped resource, it never skips the policy.
               
               For example, to run the webhook on any objects whose namespace is not associated with "runlevel" of "0" or "1";  you will set the selector as follows: "namespaceSelector": {
                 "matchExpressions": [
                   {
                     "key": "runlevel",
                     "operator": "NotIn",
                     "values": [
                       "0",
                       "1"
                     ]
                   }
                 ]
               }
               
               If instead you want to only run the policy on any objects whose namespace is associated with the "environment" of "prod" or "staging"; you will set the selector as follows: "namespaceSelector": {
                 "matchExpressions": [
                   {
                     "key": "environment",
                     "operator": "In",
                     "values": [
                       "prod",
                       "staging"
                     ]
                   }
                 ]
               }
               
               See https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/ for more examples of label selectors.
               
               Default to the empty LabelSelector, which matches everything.
        :param '_meta.v1.LabelSelectorArgs' object_selector: ObjectSelector decides whether to run the policy based on if the object has matching labels. objectSelector is evaluated against both the oldObject and newObject that would be sent to the policy's expression (CEL), and is considered to match if either object matches the selector. A null object (oldObject in the case of create, or newObject in the case of delete) or an object that cannot have labels (like a DeploymentRollback or a PodProxyOptions object) is not considered to match. Use the object selector only if the webhook is opt-in, because end users may skip the admission webhook by setting the labels. Default to the empty LabelSelector, which matches everything.
        :param Sequence['NamedRuleWithOperationsArgs'] resource_rules: ResourceRules describes what operations on what resources/subresources the admission policy matches. The policy cares about an operation if it matches _any_ Rule.
        """
        if exclude_resource_rules is not None:
            pulumi.set(__self__, "exclude_resource_rules", exclude_resource_rules)
        if match_policy is not None:
            pulumi.set(__self__, "match_policy", match_policy)
        if namespace_selector is not None:
            pulumi.set(__self__, "namespace_selector", namespace_selector)
        if object_selector is not None:
            pulumi.set(__self__, "object_selector", object_selector)
        if resource_rules is not None:
            pulumi.set(__self__, "resource_rules", resource_rules)

    @_builtins.property
    @pulumi.getter(name="excludeResourceRules")
    def exclude_resource_rules(self) -> Optional[Sequence['outputs.NamedRuleWithOperations']]:
        """
        ExcludeResourceRules describes what operations on what resources/subresources the policy should not care about. The exclude rules take precedence over include rules (if a resource matches both, it is excluded)
        """
        return pulumi.get(self, "exclude_resource_rules")

    @_builtins.property
    @pulumi.getter(name="matchPolicy")
    def match_policy(self) -> Optional[_builtins.str]:
        """
        matchPolicy defines how the "MatchResources" list is used to match incoming requests. Allowed values are "Exact" or "Equivalent".

        - Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, the admission policy does not consider requests to apps/v1beta1 or extensions/v1beta1 API groups.

        - Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, the admission policy **does** consider requests made to apps/v1beta1 or extensions/v1beta1 API groups. The API server translates the request to a matched resource API if necessary.

        Defaults to "Equivalent"
        """
        return pulumi.get(self, "match_policy")

    @_builtins.property
    @pulumi.getter(name="namespaceSelector")
    def namespace_selector(self) -> Optional['_meta.v1.outputs.LabelSelector']:
        """
        NamespaceSelector decides whether to run the admission control policy on an object based on whether the namespace for that object matches the selector. If the object itself is a namespace, the matching is performed on object.metadata.labels. If the object is another cluster scoped resource, it never skips the policy.

        For example, to run the webhook on any objects whose namespace is not associated with "runlevel" of "0" or "1";  you will set the selector as follows: "namespaceSelector": {
          "matchExpressions": [
            {
              "key": "runlevel",
              "operator": "NotIn",
              "values": [
                "0",
                "1"
              ]
            }
          ]
        }

        If instead you want to only run the policy on any objects whose namespace is associated with the "environment" of "prod" or "staging"; you will set the selector as follows: "namespaceSelector": {
          "matchExpressions": [
            {
              "key": "environment",
              "operator": "In",
              "values": [
                "prod",
                "staging"
              ]
            }
          ]
        }

        See https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/ for more examples of label selectors.

        Default to the empty LabelSelector, which matches everything.
        """
        return pulumi.get(self, "namespace_selector")

    @_builtins.property
    @pulumi.getter(name="objectSelector")
    def object_selector(self) -> Optional['_meta.v1.outputs.LabelSelector']:
        """
        ObjectSelector decides whether to run the policy based on if the object has matching labels. objectSelector is evaluated against both the oldObject and newObject that would be sent to the policy's expression (CEL), and is considered to match if either object matches the selector. A null object (oldObject in the case of create, or newObject in the case of delete) or an object that cannot have labels (like a DeploymentRollback or a PodProxyOptions object) is not considered to match. Use the object selector only if the webhook is opt-in, because end users may skip the admission webhook by setting the labels. Default to the empty LabelSelector, which matches everything.
        """
        return pulumi.get(self, "object_selector")

    @_builtins.property
    @pulumi.getter(name="resourceRules")
    def resource_rules(self) -> Optional[Sequence['outputs.NamedRuleWithOperations']]:
        """
        ResourceRules describes what operations on what resources/subresources the admission policy matches. The policy cares about an operation if it matches _any_ Rule.
        """
        return pulumi.get(self, "resource_rules")


@pulumi.output_type
class MatchResourcesPatch(dict):
    """
    MatchResources decides whether to run the admission control policy on an object based on whether it meets the match criteria. The exclude rules take precedence over include rules (if a resource matches both, it is excluded)
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludeResourceRules":
            suggest = "exclude_resource_rules"
        elif key == "matchPolicy":
            suggest = "match_policy"
        elif key == "namespaceSelector":
            suggest = "namespace_selector"
        elif key == "objectSelector":
            suggest = "object_selector"
        elif key == "resourceRules":
            suggest = "resource_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MatchResourcesPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MatchResourcesPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MatchResourcesPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exclude_resource_rules: Optional[Sequence['outputs.NamedRuleWithOperationsPatch']] = None,
                 match_policy: Optional[_builtins.str] = None,
                 namespace_selector: Optional['_meta.v1.outputs.LabelSelectorPatch'] = None,
                 object_selector: Optional['_meta.v1.outputs.LabelSelectorPatch'] = None,
                 resource_rules: Optional[Sequence['outputs.NamedRuleWithOperationsPatch']] = None):
        """
        MatchResources decides whether to run the admission control policy on an object based on whether it meets the match criteria. The exclude rules take precedence over include rules (if a resource matches both, it is excluded)
        :param Sequence['NamedRuleWithOperationsPatchArgs'] exclude_resource_rules: ExcludeResourceRules describes what operations on what resources/subresources the policy should not care about. The exclude rules take precedence over include rules (if a resource matches both, it is excluded)
        :param _builtins.str match_policy: matchPolicy defines how the "MatchResources" list is used to match incoming requests. Allowed values are "Exact" or "Equivalent".
               
               - Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, the admission policy does not consider requests to apps/v1beta1 or extensions/v1beta1 API groups.
               
               - Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, the admission policy **does** consider requests made to apps/v1beta1 or extensions/v1beta1 API groups. The API server translates the request to a matched resource API if necessary.
               
               Defaults to "Equivalent"
        :param '_meta.v1.LabelSelectorPatchArgs' namespace_selector: NamespaceSelector decides whether to run the admission control policy on an object based on whether the namespace for that object matches the selector. If the object itself is a namespace, the matching is performed on object.metadata.labels. If the object is another cluster scoped resource, it never skips the policy.
               
               For example, to run the webhook on any objects whose namespace is not associated with "runlevel" of "0" or "1";  you will set the selector as follows: "namespaceSelector": {
                 "matchExpressions": [
                   {
                     "key": "runlevel",
                     "operator": "NotIn",
                     "values": [
                       "0",
                       "1"
                     ]
                   }
                 ]
               }
               
               If instead you want to only run the policy on any objects whose namespace is associated with the "environment" of "prod" or "staging"; you will set the selector as follows: "namespaceSelector": {
                 "matchExpressions": [
                   {
                     "key": "environment",
                     "operator": "In",
                     "values": [
                       "prod",
                       "staging"
                     ]
                   }
                 ]
               }
               
               See https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/ for more examples of label selectors.
               
               Default to the empty LabelSelector, which matches everything.
        :param '_meta.v1.LabelSelectorPatchArgs' object_selector: ObjectSelector decides whether to run the policy based on if the object has matching labels. objectSelector is evaluated against both the oldObject and newObject that would be sent to the policy's expression (CEL), and is considered to match if either object matches the selector. A null object (oldObject in the case of create, or newObject in the case of delete) or an object that cannot have labels (like a DeploymentRollback or a PodProxyOptions object) is not considered to match. Use the object selector only if the webhook is opt-in, because end users may skip the admission webhook by setting the labels. Default to the empty LabelSelector, which matches everything.
        :param Sequence['NamedRuleWithOperationsPatchArgs'] resource_rules: ResourceRules describes what operations on what resources/subresources the admission policy matches. The policy cares about an operation if it matches _any_ Rule.
        """
        if exclude_resource_rules is not None:
            pulumi.set(__self__, "exclude_resource_rules", exclude_resource_rules)
        if match_policy is not None:
            pulumi.set(__self__, "match_policy", match_policy)
        if namespace_selector is not None:
            pulumi.set(__self__, "namespace_selector", namespace_selector)
        if object_selector is not None:
            pulumi.set(__self__, "object_selector", object_selector)
        if resource_rules is not None:
            pulumi.set(__self__, "resource_rules", resource_rules)

    @_builtins.property
    @pulumi.getter(name="excludeResourceRules")
    def exclude_resource_rules(self) -> Optional[Sequence['outputs.NamedRuleWithOperationsPatch']]:
        """
        ExcludeResourceRules describes what operations on what resources/subresources the policy should not care about. The exclude rules take precedence over include rules (if a resource matches both, it is excluded)
        """
        return pulumi.get(self, "exclude_resource_rules")

    @_builtins.property
    @pulumi.getter(name="matchPolicy")
    def match_policy(self) -> Optional[_builtins.str]:
        """
        matchPolicy defines how the "MatchResources" list is used to match incoming requests. Allowed values are "Exact" or "Equivalent".

        - Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, the admission policy does not consider requests to apps/v1beta1 or extensions/v1beta1 API groups.

        - Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, the admission policy **does** consider requests made to apps/v1beta1 or extensions/v1beta1 API groups. The API server translates the request to a matched resource API if necessary.

        Defaults to "Equivalent"
        """
        return pulumi.get(self, "match_policy")

    @_builtins.property
    @pulumi.getter(name="namespaceSelector")
    def namespace_selector(self) -> Optional['_meta.v1.outputs.LabelSelectorPatch']:
        """
        NamespaceSelector decides whether to run the admission control policy on an object based on whether the namespace for that object matches the selector. If the object itself is a namespace, the matching is performed on object.metadata.labels. If the object is another cluster scoped resource, it never skips the policy.

        For example, to run the webhook on any objects whose namespace is not associated with "runlevel" of "0" or "1";  you will set the selector as follows: "namespaceSelector": {
          "matchExpressions": [
            {
              "key": "runlevel",
              "operator": "NotIn",
              "values": [
                "0",
                "1"
              ]
            }
          ]
        }

        If instead you want to only run the policy on any objects whose namespace is associated with the "environment" of "prod" or "staging"; you will set the selector as follows: "namespaceSelector": {
          "matchExpressions": [
            {
              "key": "environment",
              "operator": "In",
              "values": [
                "prod",
                "staging"
              ]
            }
          ]
        }

        See https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/ for more examples of label selectors.

        Default to the empty LabelSelector, which matches everything.
        """
        return pulumi.get(self, "namespace_selector")

    @_builtins.property
    @pulumi.getter(name="objectSelector")
    def object_selector(self) -> Optional['_meta.v1.outputs.LabelSelectorPatch']:
        """
        ObjectSelector decides whether to run the policy based on if the object has matching labels. objectSelector is evaluated against both the oldObject and newObject that would be sent to the policy's expression (CEL), and is considered to match if either object matches the selector. A null object (oldObject in the case of create, or newObject in the case of delete) or an object that cannot have labels (like a DeploymentRollback or a PodProxyOptions object) is not considered to match. Use the object selector only if the webhook is opt-in, because end users may skip the admission webhook by setting the labels. Default to the empty LabelSelector, which matches everything.
        """
        return pulumi.get(self, "object_selector")

    @_builtins.property
    @pulumi.getter(name="resourceRules")
    def resource_rules(self) -> Optional[Sequence['outputs.NamedRuleWithOperationsPatch']]:
        """
        ResourceRules describes what operations on what resources/subresources the admission policy matches. The policy cares about an operation if it matches _any_ Rule.
        """
        return pulumi.get(self, "resource_rules")


@pulumi.output_type
class MutatingAdmissionPolicy(dict):
    """
    MutatingAdmissionPolicy describes the definition of an admission mutation policy that mutates the object coming into admission chain.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MutatingAdmissionPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MutatingAdmissionPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MutatingAdmissionPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[_builtins.str] = None,
                 kind: Optional[_builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.MutatingAdmissionPolicySpec'] = None):
        """
        MutatingAdmissionPolicy describes the definition of an admission mutation policy that mutates the object coming into admission chain.
        :param _builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param _builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        :param 'MutatingAdmissionPolicySpecArgs' spec: Specification of the desired behavior of the MutatingAdmissionPolicy.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'admissionregistration.k8s.io/v1alpha1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'MutatingAdmissionPolicy')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[_builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[_builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional['outputs.MutatingAdmissionPolicySpec']:
        """
        Specification of the desired behavior of the MutatingAdmissionPolicy.
        """
        return pulumi.get(self, "spec")


@pulumi.output_type
class MutatingAdmissionPolicyBinding(dict):
    """
    MutatingAdmissionPolicyBinding binds the MutatingAdmissionPolicy with parametrized resources. MutatingAdmissionPolicyBinding and the optional parameter resource together define how cluster administrators configure policies for clusters.

    For a given admission request, each binding will cause its policy to be evaluated N times, where N is 1 for policies/bindings that don't use params, otherwise N is the number of parameters selected by the binding. Each evaluation is constrained by a [runtime cost budget](https://kubernetes.io/docs/reference/using-api/cel/#runtime-cost-budget).

    Adding/removing policies, bindings, or params can not affect whether a given (policy, binding, param) combination is within its own CEL budget.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MutatingAdmissionPolicyBinding. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MutatingAdmissionPolicyBinding.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MutatingAdmissionPolicyBinding.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[_builtins.str] = None,
                 kind: Optional[_builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.MutatingAdmissionPolicyBindingSpec'] = None):
        """
        MutatingAdmissionPolicyBinding binds the MutatingAdmissionPolicy with parametrized resources. MutatingAdmissionPolicyBinding and the optional parameter resource together define how cluster administrators configure policies for clusters.

        For a given admission request, each binding will cause its policy to be evaluated N times, where N is 1 for policies/bindings that don't use params, otherwise N is the number of parameters selected by the binding. Each evaluation is constrained by a [runtime cost budget](https://kubernetes.io/docs/reference/using-api/cel/#runtime-cost-budget).

        Adding/removing policies, bindings, or params can not affect whether a given (policy, binding, param) combination is within its own CEL budget.
        :param _builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param _builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        :param 'MutatingAdmissionPolicyBindingSpecArgs' spec: Specification of the desired behavior of the MutatingAdmissionPolicyBinding.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'admissionregistration.k8s.io/v1alpha1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'MutatingAdmissionPolicyBinding')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[_builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[_builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional['outputs.MutatingAdmissionPolicyBindingSpec']:
        """
        Specification of the desired behavior of the MutatingAdmissionPolicyBinding.
        """
        return pulumi.get(self, "spec")


@pulumi.output_type
class MutatingAdmissionPolicyBindingSpec(dict):
    """
    MutatingAdmissionPolicyBindingSpec is the specification of the MutatingAdmissionPolicyBinding.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchResources":
            suggest = "match_resources"
        elif key == "paramRef":
            suggest = "param_ref"
        elif key == "policyName":
            suggest = "policy_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MutatingAdmissionPolicyBindingSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MutatingAdmissionPolicyBindingSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MutatingAdmissionPolicyBindingSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_resources: Optional['outputs.MatchResources'] = None,
                 param_ref: Optional['outputs.ParamRef'] = None,
                 policy_name: Optional[_builtins.str] = None):
        """
        MutatingAdmissionPolicyBindingSpec is the specification of the MutatingAdmissionPolicyBinding.
        :param 'MatchResourcesArgs' match_resources: matchResources limits what resources match this binding and may be mutated by it. Note that if matchResources matches a resource, the resource must also match a policy's matchConstraints and matchConditions before the resource may be mutated. When matchResources is unset, it does not constrain resource matching, and only the policy's matchConstraints and matchConditions must match for the resource to be mutated. Additionally, matchResources.resourceRules are optional and do not constraint matching when unset. Note that this is differs from MutatingAdmissionPolicy matchConstraints, where resourceRules are required. The CREATE, UPDATE and CONNECT operations are allowed.  The DELETE operation may not be matched. '*' matches CREATE, UPDATE and CONNECT.
        :param 'ParamRefArgs' param_ref: paramRef specifies the parameter resource used to configure the admission control policy. It should point to a resource of the type specified in spec.ParamKind of the bound MutatingAdmissionPolicy. If the policy specifies a ParamKind and the resource referred to by ParamRef does not exist, this binding is considered mis-configured and the FailurePolicy of the MutatingAdmissionPolicy applied. If the policy does not specify a ParamKind then this field is ignored, and the rules are evaluated without a param.
        :param _builtins.str policy_name: policyName references a MutatingAdmissionPolicy name which the MutatingAdmissionPolicyBinding binds to. If the referenced resource does not exist, this binding is considered invalid and will be ignored Required.
        """
        if match_resources is not None:
            pulumi.set(__self__, "match_resources", match_resources)
        if param_ref is not None:
            pulumi.set(__self__, "param_ref", param_ref)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)

    @_builtins.property
    @pulumi.getter(name="matchResources")
    def match_resources(self) -> Optional['outputs.MatchResources']:
        """
        matchResources limits what resources match this binding and may be mutated by it. Note that if matchResources matches a resource, the resource must also match a policy's matchConstraints and matchConditions before the resource may be mutated. When matchResources is unset, it does not constrain resource matching, and only the policy's matchConstraints and matchConditions must match for the resource to be mutated. Additionally, matchResources.resourceRules are optional and do not constraint matching when unset. Note that this is differs from MutatingAdmissionPolicy matchConstraints, where resourceRules are required. The CREATE, UPDATE and CONNECT operations are allowed.  The DELETE operation may not be matched. '*' matches CREATE, UPDATE and CONNECT.
        """
        return pulumi.get(self, "match_resources")

    @_builtins.property
    @pulumi.getter(name="paramRef")
    def param_ref(self) -> Optional['outputs.ParamRef']:
        """
        paramRef specifies the parameter resource used to configure the admission control policy. It should point to a resource of the type specified in spec.ParamKind of the bound MutatingAdmissionPolicy. If the policy specifies a ParamKind and the resource referred to by ParamRef does not exist, this binding is considered mis-configured and the FailurePolicy of the MutatingAdmissionPolicy applied. If the policy does not specify a ParamKind then this field is ignored, and the rules are evaluated without a param.
        """
        return pulumi.get(self, "param_ref")

    @_builtins.property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[_builtins.str]:
        """
        policyName references a MutatingAdmissionPolicy name which the MutatingAdmissionPolicyBinding binds to. If the referenced resource does not exist, this binding is considered invalid and will be ignored Required.
        """
        return pulumi.get(self, "policy_name")


@pulumi.output_type
class MutatingAdmissionPolicyBindingSpecPatch(dict):
    """
    MutatingAdmissionPolicyBindingSpec is the specification of the MutatingAdmissionPolicyBinding.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchResources":
            suggest = "match_resources"
        elif key == "paramRef":
            suggest = "param_ref"
        elif key == "policyName":
            suggest = "policy_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MutatingAdmissionPolicyBindingSpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MutatingAdmissionPolicyBindingSpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MutatingAdmissionPolicyBindingSpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_resources: Optional['outputs.MatchResourcesPatch'] = None,
                 param_ref: Optional['outputs.ParamRefPatch'] = None,
                 policy_name: Optional[_builtins.str] = None):
        """
        MutatingAdmissionPolicyBindingSpec is the specification of the MutatingAdmissionPolicyBinding.
        :param 'MatchResourcesPatchArgs' match_resources: matchResources limits what resources match this binding and may be mutated by it. Note that if matchResources matches a resource, the resource must also match a policy's matchConstraints and matchConditions before the resource may be mutated. When matchResources is unset, it does not constrain resource matching, and only the policy's matchConstraints and matchConditions must match for the resource to be mutated. Additionally, matchResources.resourceRules are optional and do not constraint matching when unset. Note that this is differs from MutatingAdmissionPolicy matchConstraints, where resourceRules are required. The CREATE, UPDATE and CONNECT operations are allowed.  The DELETE operation may not be matched. '*' matches CREATE, UPDATE and CONNECT.
        :param 'ParamRefPatchArgs' param_ref: paramRef specifies the parameter resource used to configure the admission control policy. It should point to a resource of the type specified in spec.ParamKind of the bound MutatingAdmissionPolicy. If the policy specifies a ParamKind and the resource referred to by ParamRef does not exist, this binding is considered mis-configured and the FailurePolicy of the MutatingAdmissionPolicy applied. If the policy does not specify a ParamKind then this field is ignored, and the rules are evaluated without a param.
        :param _builtins.str policy_name: policyName references a MutatingAdmissionPolicy name which the MutatingAdmissionPolicyBinding binds to. If the referenced resource does not exist, this binding is considered invalid and will be ignored Required.
        """
        if match_resources is not None:
            pulumi.set(__self__, "match_resources", match_resources)
        if param_ref is not None:
            pulumi.set(__self__, "param_ref", param_ref)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)

    @_builtins.property
    @pulumi.getter(name="matchResources")
    def match_resources(self) -> Optional['outputs.MatchResourcesPatch']:
        """
        matchResources limits what resources match this binding and may be mutated by it. Note that if matchResources matches a resource, the resource must also match a policy's matchConstraints and matchConditions before the resource may be mutated. When matchResources is unset, it does not constrain resource matching, and only the policy's matchConstraints and matchConditions must match for the resource to be mutated. Additionally, matchResources.resourceRules are optional and do not constraint matching when unset. Note that this is differs from MutatingAdmissionPolicy matchConstraints, where resourceRules are required. The CREATE, UPDATE and CONNECT operations are allowed.  The DELETE operation may not be matched. '*' matches CREATE, UPDATE and CONNECT.
        """
        return pulumi.get(self, "match_resources")

    @_builtins.property
    @pulumi.getter(name="paramRef")
    def param_ref(self) -> Optional['outputs.ParamRefPatch']:
        """
        paramRef specifies the parameter resource used to configure the admission control policy. It should point to a resource of the type specified in spec.ParamKind of the bound MutatingAdmissionPolicy. If the policy specifies a ParamKind and the resource referred to by ParamRef does not exist, this binding is considered mis-configured and the FailurePolicy of the MutatingAdmissionPolicy applied. If the policy does not specify a ParamKind then this field is ignored, and the rules are evaluated without a param.
        """
        return pulumi.get(self, "param_ref")

    @_builtins.property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[_builtins.str]:
        """
        policyName references a MutatingAdmissionPolicy name which the MutatingAdmissionPolicyBinding binds to. If the referenced resource does not exist, this binding is considered invalid and will be ignored Required.
        """
        return pulumi.get(self, "policy_name")


@pulumi.output_type
class MutatingAdmissionPolicySpec(dict):
    """
    MutatingAdmissionPolicySpec is the specification of the desired behavior of the admission policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failurePolicy":
            suggest = "failure_policy"
        elif key == "matchConditions":
            suggest = "match_conditions"
        elif key == "matchConstraints":
            suggest = "match_constraints"
        elif key == "paramKind":
            suggest = "param_kind"
        elif key == "reinvocationPolicy":
            suggest = "reinvocation_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MutatingAdmissionPolicySpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MutatingAdmissionPolicySpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MutatingAdmissionPolicySpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failure_policy: Optional[_builtins.str] = None,
                 match_conditions: Optional[Sequence['outputs.MatchCondition']] = None,
                 match_constraints: Optional['outputs.MatchResources'] = None,
                 mutations: Optional[Sequence['outputs.Mutation']] = None,
                 param_kind: Optional['outputs.ParamKind'] = None,
                 reinvocation_policy: Optional[_builtins.str] = None,
                 variables: Optional[Sequence['outputs.Variable']] = None):
        """
        MutatingAdmissionPolicySpec is the specification of the desired behavior of the admission policy.
        :param _builtins.str failure_policy: failurePolicy defines how to handle failures for the admission policy. Failures can occur from CEL expression parse errors, type check errors, runtime errors and invalid or mis-configured policy definitions or bindings.
               
               A policy is invalid if paramKind refers to a non-existent Kind. A binding is invalid if paramRef.name refers to a non-existent resource.
               
               failurePolicy does not define how validations that evaluate to false are handled.
               
               Allowed values are Ignore or Fail. Defaults to Fail.
        :param Sequence['MatchConditionArgs'] match_conditions: matchConditions is a list of conditions that must be met for a request to be validated. Match conditions filter requests that have already been matched by the matchConstraints. An empty list of matchConditions matches all requests. There are a maximum of 64 match conditions allowed.
               
               If a parameter object is provided, it can be accessed via the `params` handle in the same manner as validation expressions.
               
               The exact matching logic is (in order):
                 1. If ANY matchCondition evaluates to FALSE, the policy is skipped.
                 2. If ALL matchConditions evaluate to TRUE, the policy is evaluated.
                 3. If any matchCondition evaluates to an error (but none are FALSE):
                    - If failurePolicy=Fail, reject the request
                    - If failurePolicy=Ignore, the policy is skipped
        :param 'MatchResourcesArgs' match_constraints: matchConstraints specifies what resources this policy is designed to validate. The MutatingAdmissionPolicy cares about a request if it matches _all_ Constraints. However, in order to prevent clusters from being put into an unstable state that cannot be recovered from via the API MutatingAdmissionPolicy cannot match MutatingAdmissionPolicy and MutatingAdmissionPolicyBinding. The CREATE, UPDATE and CONNECT operations are allowed.  The DELETE operation may not be matched. '*' matches CREATE, UPDATE and CONNECT. Required.
        :param Sequence['MutationArgs'] mutations: mutations contain operations to perform on matching objects. mutations may not be empty; a minimum of one mutation is required. mutations are evaluated in order, and are reinvoked according to the reinvocationPolicy. The mutations of a policy are invoked for each binding of this policy and reinvocation of mutations occurs on a per binding basis.
        :param 'ParamKindArgs' param_kind: paramKind specifies the kind of resources used to parameterize this policy. If absent, there are no parameters for this policy and the param CEL variable will not be provided to validation expressions. If paramKind refers to a non-existent kind, this policy definition is mis-configured and the FailurePolicy is applied. If paramKind is specified but paramRef is unset in MutatingAdmissionPolicyBinding, the params variable will be null.
        :param _builtins.str reinvocation_policy: reinvocationPolicy indicates whether mutations may be called multiple times per MutatingAdmissionPolicyBinding as part of a single admission evaluation. Allowed values are "Never" and "IfNeeded".
               
               Never: These mutations will not be called more than once per binding in a single admission evaluation.
               
               IfNeeded: These mutations may be invoked more than once per binding for a single admission request and there is no guarantee of order with respect to other admission plugins, admission webhooks, bindings of this policy and admission policies.  Mutations are only reinvoked when mutations change the object after this mutation is invoked. Required.
        :param Sequence['VariableArgs'] variables: variables contain definitions of variables that can be used in composition of other expressions. Each variable is defined as a named CEL expression. The variables defined here will be available under `variables` in other expressions of the policy except matchConditions because matchConditions are evaluated before the rest of the policy.
               
               The expression of a variable can refer to other variables defined earlier in the list but not those after. Thus, variables must be sorted by the order of first appearance and acyclic.
        """
        if failure_policy is not None:
            pulumi.set(__self__, "failure_policy", failure_policy)
        if match_conditions is not None:
            pulumi.set(__self__, "match_conditions", match_conditions)
        if match_constraints is not None:
            pulumi.set(__self__, "match_constraints", match_constraints)
        if mutations is not None:
            pulumi.set(__self__, "mutations", mutations)
        if param_kind is not None:
            pulumi.set(__self__, "param_kind", param_kind)
        if reinvocation_policy is not None:
            pulumi.set(__self__, "reinvocation_policy", reinvocation_policy)
        if variables is not None:
            pulumi.set(__self__, "variables", variables)

    @_builtins.property
    @pulumi.getter(name="failurePolicy")
    def failure_policy(self) -> Optional[_builtins.str]:
        """
        failurePolicy defines how to handle failures for the admission policy. Failures can occur from CEL expression parse errors, type check errors, runtime errors and invalid or mis-configured policy definitions or bindings.

        A policy is invalid if paramKind refers to a non-existent Kind. A binding is invalid if paramRef.name refers to a non-existent resource.

        failurePolicy does not define how validations that evaluate to false are handled.

        Allowed values are Ignore or Fail. Defaults to Fail.
        """
        return pulumi.get(self, "failure_policy")

    @_builtins.property
    @pulumi.getter(name="matchConditions")
    def match_conditions(self) -> Optional[Sequence['outputs.MatchCondition']]:
        """
        matchConditions is a list of conditions that must be met for a request to be validated. Match conditions filter requests that have already been matched by the matchConstraints. An empty list of matchConditions matches all requests. There are a maximum of 64 match conditions allowed.

        If a parameter object is provided, it can be accessed via the `params` handle in the same manner as validation expressions.

        The exact matching logic is (in order):
          1. If ANY matchCondition evaluates to FALSE, the policy is skipped.
          2. If ALL matchConditions evaluate to TRUE, the policy is evaluated.
          3. If any matchCondition evaluates to an error (but none are FALSE):
             - If failurePolicy=Fail, reject the request
             - If failurePolicy=Ignore, the policy is skipped
        """
        return pulumi.get(self, "match_conditions")

    @_builtins.property
    @pulumi.getter(name="matchConstraints")
    def match_constraints(self) -> Optional['outputs.MatchResources']:
        """
        matchConstraints specifies what resources this policy is designed to validate. The MutatingAdmissionPolicy cares about a request if it matches _all_ Constraints. However, in order to prevent clusters from being put into an unstable state that cannot be recovered from via the API MutatingAdmissionPolicy cannot match MutatingAdmissionPolicy and MutatingAdmissionPolicyBinding. The CREATE, UPDATE and CONNECT operations are allowed.  The DELETE operation may not be matched. '*' matches CREATE, UPDATE and CONNECT. Required.
        """
        return pulumi.get(self, "match_constraints")

    @_builtins.property
    @pulumi.getter
    def mutations(self) -> Optional[Sequence['outputs.Mutation']]:
        """
        mutations contain operations to perform on matching objects. mutations may not be empty; a minimum of one mutation is required. mutations are evaluated in order, and are reinvoked according to the reinvocationPolicy. The mutations of a policy are invoked for each binding of this policy and reinvocation of mutations occurs on a per binding basis.
        """
        return pulumi.get(self, "mutations")

    @_builtins.property
    @pulumi.getter(name="paramKind")
    def param_kind(self) -> Optional['outputs.ParamKind']:
        """
        paramKind specifies the kind of resources used to parameterize this policy. If absent, there are no parameters for this policy and the param CEL variable will not be provided to validation expressions. If paramKind refers to a non-existent kind, this policy definition is mis-configured and the FailurePolicy is applied. If paramKind is specified but paramRef is unset in MutatingAdmissionPolicyBinding, the params variable will be null.
        """
        return pulumi.get(self, "param_kind")

    @_builtins.property
    @pulumi.getter(name="reinvocationPolicy")
    def reinvocation_policy(self) -> Optional[_builtins.str]:
        """
        reinvocationPolicy indicates whether mutations may be called multiple times per MutatingAdmissionPolicyBinding as part of a single admission evaluation. Allowed values are "Never" and "IfNeeded".

        Never: These mutations will not be called more than once per binding in a single admission evaluation.

        IfNeeded: These mutations may be invoked more than once per binding for a single admission request and there is no guarantee of order with respect to other admission plugins, admission webhooks, bindings of this policy and admission policies.  Mutations are only reinvoked when mutations change the object after this mutation is invoked. Required.
        """
        return pulumi.get(self, "reinvocation_policy")

    @_builtins.property
    @pulumi.getter
    def variables(self) -> Optional[Sequence['outputs.Variable']]:
        """
        variables contain definitions of variables that can be used in composition of other expressions. Each variable is defined as a named CEL expression. The variables defined here will be available under `variables` in other expressions of the policy except matchConditions because matchConditions are evaluated before the rest of the policy.

        The expression of a variable can refer to other variables defined earlier in the list but not those after. Thus, variables must be sorted by the order of first appearance and acyclic.
        """
        return pulumi.get(self, "variables")


@pulumi.output_type
class MutatingAdmissionPolicySpecPatch(dict):
    """
    MutatingAdmissionPolicySpec is the specification of the desired behavior of the admission policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failurePolicy":
            suggest = "failure_policy"
        elif key == "matchConditions":
            suggest = "match_conditions"
        elif key == "matchConstraints":
            suggest = "match_constraints"
        elif key == "paramKind":
            suggest = "param_kind"
        elif key == "reinvocationPolicy":
            suggest = "reinvocation_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MutatingAdmissionPolicySpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MutatingAdmissionPolicySpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MutatingAdmissionPolicySpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failure_policy: Optional[_builtins.str] = None,
                 match_conditions: Optional[Sequence['outputs.MatchConditionPatch']] = None,
                 match_constraints: Optional['outputs.MatchResourcesPatch'] = None,
                 mutations: Optional[Sequence['outputs.MutationPatch']] = None,
                 param_kind: Optional['outputs.ParamKindPatch'] = None,
                 reinvocation_policy: Optional[_builtins.str] = None,
                 variables: Optional[Sequence['outputs.VariablePatch']] = None):
        """
        MutatingAdmissionPolicySpec is the specification of the desired behavior of the admission policy.
        :param _builtins.str failure_policy: failurePolicy defines how to handle failures for the admission policy. Failures can occur from CEL expression parse errors, type check errors, runtime errors and invalid or mis-configured policy definitions or bindings.
               
               A policy is invalid if paramKind refers to a non-existent Kind. A binding is invalid if paramRef.name refers to a non-existent resource.
               
               failurePolicy does not define how validations that evaluate to false are handled.
               
               Allowed values are Ignore or Fail. Defaults to Fail.
        :param Sequence['MatchConditionPatchArgs'] match_conditions: matchConditions is a list of conditions that must be met for a request to be validated. Match conditions filter requests that have already been matched by the matchConstraints. An empty list of matchConditions matches all requests. There are a maximum of 64 match conditions allowed.
               
               If a parameter object is provided, it can be accessed via the `params` handle in the same manner as validation expressions.
               
               The exact matching logic is (in order):
                 1. If ANY matchCondition evaluates to FALSE, the policy is skipped.
                 2. If ALL matchConditions evaluate to TRUE, the policy is evaluated.
                 3. If any matchCondition evaluates to an error (but none are FALSE):
                    - If failurePolicy=Fail, reject the request
                    - If failurePolicy=Ignore, the policy is skipped
        :param 'MatchResourcesPatchArgs' match_constraints: matchConstraints specifies what resources this policy is designed to validate. The MutatingAdmissionPolicy cares about a request if it matches _all_ Constraints. However, in order to prevent clusters from being put into an unstable state that cannot be recovered from via the API MutatingAdmissionPolicy cannot match MutatingAdmissionPolicy and MutatingAdmissionPolicyBinding. The CREATE, UPDATE and CONNECT operations are allowed.  The DELETE operation may not be matched. '*' matches CREATE, UPDATE and CONNECT. Required.
        :param Sequence['MutationPatchArgs'] mutations: mutations contain operations to perform on matching objects. mutations may not be empty; a minimum of one mutation is required. mutations are evaluated in order, and are reinvoked according to the reinvocationPolicy. The mutations of a policy are invoked for each binding of this policy and reinvocation of mutations occurs on a per binding basis.
        :param 'ParamKindPatchArgs' param_kind: paramKind specifies the kind of resources used to parameterize this policy. If absent, there are no parameters for this policy and the param CEL variable will not be provided to validation expressions. If paramKind refers to a non-existent kind, this policy definition is mis-configured and the FailurePolicy is applied. If paramKind is specified but paramRef is unset in MutatingAdmissionPolicyBinding, the params variable will be null.
        :param _builtins.str reinvocation_policy: reinvocationPolicy indicates whether mutations may be called multiple times per MutatingAdmissionPolicyBinding as part of a single admission evaluation. Allowed values are "Never" and "IfNeeded".
               
               Never: These mutations will not be called more than once per binding in a single admission evaluation.
               
               IfNeeded: These mutations may be invoked more than once per binding for a single admission request and there is no guarantee of order with respect to other admission plugins, admission webhooks, bindings of this policy and admission policies.  Mutations are only reinvoked when mutations change the object after this mutation is invoked. Required.
        :param Sequence['VariablePatchArgs'] variables: variables contain definitions of variables that can be used in composition of other expressions. Each variable is defined as a named CEL expression. The variables defined here will be available under `variables` in other expressions of the policy except matchConditions because matchConditions are evaluated before the rest of the policy.
               
               The expression of a variable can refer to other variables defined earlier in the list but not those after. Thus, variables must be sorted by the order of first appearance and acyclic.
        """
        if failure_policy is not None:
            pulumi.set(__self__, "failure_policy", failure_policy)
        if match_conditions is not None:
            pulumi.set(__self__, "match_conditions", match_conditions)
        if match_constraints is not None:
            pulumi.set(__self__, "match_constraints", match_constraints)
        if mutations is not None:
            pulumi.set(__self__, "mutations", mutations)
        if param_kind is not None:
            pulumi.set(__self__, "param_kind", param_kind)
        if reinvocation_policy is not None:
            pulumi.set(__self__, "reinvocation_policy", reinvocation_policy)
        if variables is not None:
            pulumi.set(__self__, "variables", variables)

    @_builtins.property
    @pulumi.getter(name="failurePolicy")
    def failure_policy(self) -> Optional[_builtins.str]:
        """
        failurePolicy defines how to handle failures for the admission policy. Failures can occur from CEL expression parse errors, type check errors, runtime errors and invalid or mis-configured policy definitions or bindings.

        A policy is invalid if paramKind refers to a non-existent Kind. A binding is invalid if paramRef.name refers to a non-existent resource.

        failurePolicy does not define how validations that evaluate to false are handled.

        Allowed values are Ignore or Fail. Defaults to Fail.
        """
        return pulumi.get(self, "failure_policy")

    @_builtins.property
    @pulumi.getter(name="matchConditions")
    def match_conditions(self) -> Optional[Sequence['outputs.MatchConditionPatch']]:
        """
        matchConditions is a list of conditions that must be met for a request to be validated. Match conditions filter requests that have already been matched by the matchConstraints. An empty list of matchConditions matches all requests. There are a maximum of 64 match conditions allowed.

        If a parameter object is provided, it can be accessed via the `params` handle in the same manner as validation expressions.

        The exact matching logic is (in order):
          1. If ANY matchCondition evaluates to FALSE, the policy is skipped.
          2. If ALL matchConditions evaluate to TRUE, the policy is evaluated.
          3. If any matchCondition evaluates to an error (but none are FALSE):
             - If failurePolicy=Fail, reject the request
             - If failurePolicy=Ignore, the policy is skipped
        """
        return pulumi.get(self, "match_conditions")

    @_builtins.property
    @pulumi.getter(name="matchConstraints")
    def match_constraints(self) -> Optional['outputs.MatchResourcesPatch']:
        """
        matchConstraints specifies what resources this policy is designed to validate. The MutatingAdmissionPolicy cares about a request if it matches _all_ Constraints. However, in order to prevent clusters from being put into an unstable state that cannot be recovered from via the API MutatingAdmissionPolicy cannot match MutatingAdmissionPolicy and MutatingAdmissionPolicyBinding. The CREATE, UPDATE and CONNECT operations are allowed.  The DELETE operation may not be matched. '*' matches CREATE, UPDATE and CONNECT. Required.
        """
        return pulumi.get(self, "match_constraints")

    @_builtins.property
    @pulumi.getter
    def mutations(self) -> Optional[Sequence['outputs.MutationPatch']]:
        """
        mutations contain operations to perform on matching objects. mutations may not be empty; a minimum of one mutation is required. mutations are evaluated in order, and are reinvoked according to the reinvocationPolicy. The mutations of a policy are invoked for each binding of this policy and reinvocation of mutations occurs on a per binding basis.
        """
        return pulumi.get(self, "mutations")

    @_builtins.property
    @pulumi.getter(name="paramKind")
    def param_kind(self) -> Optional['outputs.ParamKindPatch']:
        """
        paramKind specifies the kind of resources used to parameterize this policy. If absent, there are no parameters for this policy and the param CEL variable will not be provided to validation expressions. If paramKind refers to a non-existent kind, this policy definition is mis-configured and the FailurePolicy is applied. If paramKind is specified but paramRef is unset in MutatingAdmissionPolicyBinding, the params variable will be null.
        """
        return pulumi.get(self, "param_kind")

    @_builtins.property
    @pulumi.getter(name="reinvocationPolicy")
    def reinvocation_policy(self) -> Optional[_builtins.str]:
        """
        reinvocationPolicy indicates whether mutations may be called multiple times per MutatingAdmissionPolicyBinding as part of a single admission evaluation. Allowed values are "Never" and "IfNeeded".

        Never: These mutations will not be called more than once per binding in a single admission evaluation.

        IfNeeded: These mutations may be invoked more than once per binding for a single admission request and there is no guarantee of order with respect to other admission plugins, admission webhooks, bindings of this policy and admission policies.  Mutations are only reinvoked when mutations change the object after this mutation is invoked. Required.
        """
        return pulumi.get(self, "reinvocation_policy")

    @_builtins.property
    @pulumi.getter
    def variables(self) -> Optional[Sequence['outputs.VariablePatch']]:
        """
        variables contain definitions of variables that can be used in composition of other expressions. Each variable is defined as a named CEL expression. The variables defined here will be available under `variables` in other expressions of the policy except matchConditions because matchConditions are evaluated before the rest of the policy.

        The expression of a variable can refer to other variables defined earlier in the list but not those after. Thus, variables must be sorted by the order of first appearance and acyclic.
        """
        return pulumi.get(self, "variables")


@pulumi.output_type
class Mutation(dict):
    """
    Mutation specifies the CEL expression which is used to apply the Mutation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "patchType":
            suggest = "patch_type"
        elif key == "applyConfiguration":
            suggest = "apply_configuration"
        elif key == "jsonPatch":
            suggest = "json_patch"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mutation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mutation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mutation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 patch_type: _builtins.str,
                 apply_configuration: Optional['outputs.ApplyConfiguration'] = None,
                 json_patch: Optional['outputs.JSONPatch'] = None):
        """
        Mutation specifies the CEL expression which is used to apply the Mutation.
        :param _builtins.str patch_type: patchType indicates the patch strategy used. Allowed values are "ApplyConfiguration" and "JSONPatch". Required.
        :param 'ApplyConfigurationArgs' apply_configuration: applyConfiguration defines the desired configuration values of an object. The configuration is applied to the admission object using [structured merge diff](https://github.com/kubernetes-sigs/structured-merge-diff). A CEL expression is used to create apply configuration.
        :param 'JSONPatchArgs' json_patch: jsonPatch defines a [JSON patch](https://jsonpatch.com/) operation to perform a mutation to the object. A CEL expression is used to create the JSON patch.
        """
        pulumi.set(__self__, "patch_type", patch_type)
        if apply_configuration is not None:
            pulumi.set(__self__, "apply_configuration", apply_configuration)
        if json_patch is not None:
            pulumi.set(__self__, "json_patch", json_patch)

    @_builtins.property
    @pulumi.getter(name="patchType")
    def patch_type(self) -> _builtins.str:
        """
        patchType indicates the patch strategy used. Allowed values are "ApplyConfiguration" and "JSONPatch". Required.
        """
        return pulumi.get(self, "patch_type")

    @_builtins.property
    @pulumi.getter(name="applyConfiguration")
    def apply_configuration(self) -> Optional['outputs.ApplyConfiguration']:
        """
        applyConfiguration defines the desired configuration values of an object. The configuration is applied to the admission object using [structured merge diff](https://github.com/kubernetes-sigs/structured-merge-diff). A CEL expression is used to create apply configuration.
        """
        return pulumi.get(self, "apply_configuration")

    @_builtins.property
    @pulumi.getter(name="jsonPatch")
    def json_patch(self) -> Optional['outputs.JSONPatch']:
        """
        jsonPatch defines a [JSON patch](https://jsonpatch.com/) operation to perform a mutation to the object. A CEL expression is used to create the JSON patch.
        """
        return pulumi.get(self, "json_patch")


@pulumi.output_type
class MutationPatch(dict):
    """
    Mutation specifies the CEL expression which is used to apply the Mutation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applyConfiguration":
            suggest = "apply_configuration"
        elif key == "jsonPatch":
            suggest = "json_patch"
        elif key == "patchType":
            suggest = "patch_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MutationPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MutationPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MutationPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 apply_configuration: Optional['outputs.ApplyConfigurationPatch'] = None,
                 json_patch: Optional['outputs.JSONPatchPatch'] = None,
                 patch_type: Optional[_builtins.str] = None):
        """
        Mutation specifies the CEL expression which is used to apply the Mutation.
        :param 'ApplyConfigurationPatchArgs' apply_configuration: applyConfiguration defines the desired configuration values of an object. The configuration is applied to the admission object using [structured merge diff](https://github.com/kubernetes-sigs/structured-merge-diff). A CEL expression is used to create apply configuration.
        :param 'JSONPatchPatchArgs' json_patch: jsonPatch defines a [JSON patch](https://jsonpatch.com/) operation to perform a mutation to the object. A CEL expression is used to create the JSON patch.
        :param _builtins.str patch_type: patchType indicates the patch strategy used. Allowed values are "ApplyConfiguration" and "JSONPatch". Required.
        """
        if apply_configuration is not None:
            pulumi.set(__self__, "apply_configuration", apply_configuration)
        if json_patch is not None:
            pulumi.set(__self__, "json_patch", json_patch)
        if patch_type is not None:
            pulumi.set(__self__, "patch_type", patch_type)

    @_builtins.property
    @pulumi.getter(name="applyConfiguration")
    def apply_configuration(self) -> Optional['outputs.ApplyConfigurationPatch']:
        """
        applyConfiguration defines the desired configuration values of an object. The configuration is applied to the admission object using [structured merge diff](https://github.com/kubernetes-sigs/structured-merge-diff). A CEL expression is used to create apply configuration.
        """
        return pulumi.get(self, "apply_configuration")

    @_builtins.property
    @pulumi.getter(name="jsonPatch")
    def json_patch(self) -> Optional['outputs.JSONPatchPatch']:
        """
        jsonPatch defines a [JSON patch](https://jsonpatch.com/) operation to perform a mutation to the object. A CEL expression is used to create the JSON patch.
        """
        return pulumi.get(self, "json_patch")

    @_builtins.property
    @pulumi.getter(name="patchType")
    def patch_type(self) -> Optional[_builtins.str]:
        """
        patchType indicates the patch strategy used. Allowed values are "ApplyConfiguration" and "JSONPatch". Required.
        """
        return pulumi.get(self, "patch_type")


@pulumi.output_type
class NamedRuleWithOperations(dict):
    """
    NamedRuleWithOperations is a tuple of Operations and Resources with ResourceNames.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiGroups":
            suggest = "api_groups"
        elif key == "apiVersions":
            suggest = "api_versions"
        elif key == "resourceNames":
            suggest = "resource_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NamedRuleWithOperations. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NamedRuleWithOperations.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NamedRuleWithOperations.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_groups: Optional[Sequence[_builtins.str]] = None,
                 api_versions: Optional[Sequence[_builtins.str]] = None,
                 operations: Optional[Sequence[_builtins.str]] = None,
                 resource_names: Optional[Sequence[_builtins.str]] = None,
                 resources: Optional[Sequence[_builtins.str]] = None,
                 scope: Optional[_builtins.str] = None):
        """
        NamedRuleWithOperations is a tuple of Operations and Resources with ResourceNames.
        :param Sequence[_builtins.str] api_groups: APIGroups is the API groups the resources belong to. '*' is all groups. If '*' is present, the length of the slice must be one. Required.
        :param Sequence[_builtins.str] api_versions: APIVersions is the API versions the resources belong to. '*' is all versions. If '*' is present, the length of the slice must be one. Required.
        :param Sequence[_builtins.str] operations: Operations is the operations the admission hook cares about - CREATE, UPDATE, DELETE, CONNECT or * for all of those operations and any future admission operations that are added. If '*' is present, the length of the slice must be one. Required.
        :param Sequence[_builtins.str] resource_names: ResourceNames is an optional white list of names that the rule applies to.  An empty set means that everything is allowed.
        :param Sequence[_builtins.str] resources: Resources is a list of resources this rule applies to.
               
               For example: 'pods' means pods. 'pods/log' means the log subresource of pods. '*' means all resources, but not subresources. 'pods/*' means all subresources of pods. '*/scale' means all scale subresources. '*/*' means all resources and their subresources.
               
               If wildcard is present, the validation rule will ensure resources do not overlap with each other.
               
               Depending on the enclosing object, subresources might not be allowed. Required.
        :param _builtins.str scope: scope specifies the scope of this rule. Valid values are "Cluster", "Namespaced", and "*" "Cluster" means that only cluster-scoped resources will match this rule. Namespace API objects are cluster-scoped. "Namespaced" means that only namespaced resources will match this rule. "*" means that there are no scope restrictions. Subresources match the scope of their parent resource. Default is "*".
        """
        if api_groups is not None:
            pulumi.set(__self__, "api_groups", api_groups)
        if api_versions is not None:
            pulumi.set(__self__, "api_versions", api_versions)
        if operations is not None:
            pulumi.set(__self__, "operations", operations)
        if resource_names is not None:
            pulumi.set(__self__, "resource_names", resource_names)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @_builtins.property
    @pulumi.getter(name="apiGroups")
    def api_groups(self) -> Optional[Sequence[_builtins.str]]:
        """
        APIGroups is the API groups the resources belong to. '*' is all groups. If '*' is present, the length of the slice must be one. Required.
        """
        return pulumi.get(self, "api_groups")

    @_builtins.property
    @pulumi.getter(name="apiVersions")
    def api_versions(self) -> Optional[Sequence[_builtins.str]]:
        """
        APIVersions is the API versions the resources belong to. '*' is all versions. If '*' is present, the length of the slice must be one. Required.
        """
        return pulumi.get(self, "api_versions")

    @_builtins.property
    @pulumi.getter
    def operations(self) -> Optional[Sequence[_builtins.str]]:
        """
        Operations is the operations the admission hook cares about - CREATE, UPDATE, DELETE, CONNECT or * for all of those operations and any future admission operations that are added. If '*' is present, the length of the slice must be one. Required.
        """
        return pulumi.get(self, "operations")

    @_builtins.property
    @pulumi.getter(name="resourceNames")
    def resource_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        ResourceNames is an optional white list of names that the rule applies to.  An empty set means that everything is allowed.
        """
        return pulumi.get(self, "resource_names")

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Optional[Sequence[_builtins.str]]:
        """
        Resources is a list of resources this rule applies to.

        For example: 'pods' means pods. 'pods/log' means the log subresource of pods. '*' means all resources, but not subresources. 'pods/*' means all subresources of pods. '*/scale' means all scale subresources. '*/*' means all resources and their subresources.

        If wildcard is present, the validation rule will ensure resources do not overlap with each other.

        Depending on the enclosing object, subresources might not be allowed. Required.
        """
        return pulumi.get(self, "resources")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[_builtins.str]:
        """
        scope specifies the scope of this rule. Valid values are "Cluster", "Namespaced", and "*" "Cluster" means that only cluster-scoped resources will match this rule. Namespace API objects are cluster-scoped. "Namespaced" means that only namespaced resources will match this rule. "*" means that there are no scope restrictions. Subresources match the scope of their parent resource. Default is "*".
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class NamedRuleWithOperationsPatch(dict):
    """
    NamedRuleWithOperations is a tuple of Operations and Resources with ResourceNames.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiGroups":
            suggest = "api_groups"
        elif key == "apiVersions":
            suggest = "api_versions"
        elif key == "resourceNames":
            suggest = "resource_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NamedRuleWithOperationsPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NamedRuleWithOperationsPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NamedRuleWithOperationsPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_groups: Optional[Sequence[_builtins.str]] = None,
                 api_versions: Optional[Sequence[_builtins.str]] = None,
                 operations: Optional[Sequence[_builtins.str]] = None,
                 resource_names: Optional[Sequence[_builtins.str]] = None,
                 resources: Optional[Sequence[_builtins.str]] = None,
                 scope: Optional[_builtins.str] = None):
        """
        NamedRuleWithOperations is a tuple of Operations and Resources with ResourceNames.
        :param Sequence[_builtins.str] api_groups: APIGroups is the API groups the resources belong to. '*' is all groups. If '*' is present, the length of the slice must be one. Required.
        :param Sequence[_builtins.str] api_versions: APIVersions is the API versions the resources belong to. '*' is all versions. If '*' is present, the length of the slice must be one. Required.
        :param Sequence[_builtins.str] operations: Operations is the operations the admission hook cares about - CREATE, UPDATE, DELETE, CONNECT or * for all of those operations and any future admission operations that are added. If '*' is present, the length of the slice must be one. Required.
        :param Sequence[_builtins.str] resource_names: ResourceNames is an optional white list of names that the rule applies to.  An empty set means that everything is allowed.
        :param Sequence[_builtins.str] resources: Resources is a list of resources this rule applies to.
               
               For example: 'pods' means pods. 'pods/log' means the log subresource of pods. '*' means all resources, but not subresources. 'pods/*' means all subresources of pods. '*/scale' means all scale subresources. '*/*' means all resources and their subresources.
               
               If wildcard is present, the validation rule will ensure resources do not overlap with each other.
               
               Depending on the enclosing object, subresources might not be allowed. Required.
        :param _builtins.str scope: scope specifies the scope of this rule. Valid values are "Cluster", "Namespaced", and "*" "Cluster" means that only cluster-scoped resources will match this rule. Namespace API objects are cluster-scoped. "Namespaced" means that only namespaced resources will match this rule. "*" means that there are no scope restrictions. Subresources match the scope of their parent resource. Default is "*".
        """
        if api_groups is not None:
            pulumi.set(__self__, "api_groups", api_groups)
        if api_versions is not None:
            pulumi.set(__self__, "api_versions", api_versions)
        if operations is not None:
            pulumi.set(__self__, "operations", operations)
        if resource_names is not None:
            pulumi.set(__self__, "resource_names", resource_names)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @_builtins.property
    @pulumi.getter(name="apiGroups")
    def api_groups(self) -> Optional[Sequence[_builtins.str]]:
        """
        APIGroups is the API groups the resources belong to. '*' is all groups. If '*' is present, the length of the slice must be one. Required.
        """
        return pulumi.get(self, "api_groups")

    @_builtins.property
    @pulumi.getter(name="apiVersions")
    def api_versions(self) -> Optional[Sequence[_builtins.str]]:
        """
        APIVersions is the API versions the resources belong to. '*' is all versions. If '*' is present, the length of the slice must be one. Required.
        """
        return pulumi.get(self, "api_versions")

    @_builtins.property
    @pulumi.getter
    def operations(self) -> Optional[Sequence[_builtins.str]]:
        """
        Operations is the operations the admission hook cares about - CREATE, UPDATE, DELETE, CONNECT or * for all of those operations and any future admission operations that are added. If '*' is present, the length of the slice must be one. Required.
        """
        return pulumi.get(self, "operations")

    @_builtins.property
    @pulumi.getter(name="resourceNames")
    def resource_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        ResourceNames is an optional white list of names that the rule applies to.  An empty set means that everything is allowed.
        """
        return pulumi.get(self, "resource_names")

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Optional[Sequence[_builtins.str]]:
        """
        Resources is a list of resources this rule applies to.

        For example: 'pods' means pods. 'pods/log' means the log subresource of pods. '*' means all resources, but not subresources. 'pods/*' means all subresources of pods. '*/scale' means all scale subresources. '*/*' means all resources and their subresources.

        If wildcard is present, the validation rule will ensure resources do not overlap with each other.

        Depending on the enclosing object, subresources might not be allowed. Required.
        """
        return pulumi.get(self, "resources")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[_builtins.str]:
        """
        scope specifies the scope of this rule. Valid values are "Cluster", "Namespaced", and "*" "Cluster" means that only cluster-scoped resources will match this rule. Namespace API objects are cluster-scoped. "Namespaced" means that only namespaced resources will match this rule. "*" means that there are no scope restrictions. Subresources match the scope of their parent resource. Default is "*".
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class ParamKind(dict):
    """
    ParamKind is a tuple of Group Kind and Version.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ParamKind. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ParamKind.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ParamKind.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[_builtins.str] = None,
                 kind: Optional[_builtins.str] = None):
        """
        ParamKind is a tuple of Group Kind and Version.
        :param _builtins.str api_version: APIVersion is the API group version the resources belong to. In format of "group/version". Required.
        :param _builtins.str kind: Kind is the API kind the resources belong to. Required.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[_builtins.str]:
        """
        APIVersion is the API group version the resources belong to. In format of "group/version". Required.
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[_builtins.str]:
        """
        Kind is the API kind the resources belong to. Required.
        """
        return pulumi.get(self, "kind")


@pulumi.output_type
class ParamKindPatch(dict):
    """
    ParamKind is a tuple of Group Kind and Version.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ParamKindPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ParamKindPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ParamKindPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[_builtins.str] = None,
                 kind: Optional[_builtins.str] = None):
        """
        ParamKind is a tuple of Group Kind and Version.
        :param _builtins.str api_version: APIVersion is the API group version the resources belong to. In format of "group/version". Required.
        :param _builtins.str kind: Kind is the API kind the resources belong to. Required.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[_builtins.str]:
        """
        APIVersion is the API group version the resources belong to. In format of "group/version". Required.
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[_builtins.str]:
        """
        Kind is the API kind the resources belong to. Required.
        """
        return pulumi.get(self, "kind")


@pulumi.output_type
class ParamRef(dict):
    """
    ParamRef describes how to locate the params to be used as input to expressions of rules applied by a policy binding.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parameterNotFoundAction":
            suggest = "parameter_not_found_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ParamRef. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ParamRef.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ParamRef.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 namespace: Optional[_builtins.str] = None,
                 parameter_not_found_action: Optional[_builtins.str] = None,
                 selector: Optional['_meta.v1.outputs.LabelSelector'] = None):
        """
        ParamRef describes how to locate the params to be used as input to expressions of rules applied by a policy binding.
        :param _builtins.str name: `name` is the name of the resource being referenced.
               
               `name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.
        :param _builtins.str namespace: namespace is the namespace of the referenced resource. Allows limiting the search for params to a specific namespace. Applies to both `name` and `selector` fields.
               
               A per-namespace parameter may be used by specifying a namespace-scoped `paramKind` in the policy and leaving this field empty.
               
               - If `paramKind` is cluster-scoped, this field MUST be unset. Setting this field results in a configuration error.
               
               - If `paramKind` is namespace-scoped, the namespace of the object being evaluated for admission will be used when this field is left unset. Take care that if this is left empty the binding must not match any cluster-scoped resources, which will result in an error.
        :param _builtins.str parameter_not_found_action: `parameterNotFoundAction` controls the behavior of the binding when the resource exists, and name or selector is valid, but there are no parameters matched by the binding. If the value is set to `Allow`, then no matched parameters will be treated as successful validation by the binding. If set to `Deny`, then no matched parameters will be subject to the `failurePolicy` of the policy.
               
               Allowed values are `Allow` or `Deny` Default to `Deny`
        :param '_meta.v1.LabelSelectorArgs' selector: selector can be used to match multiple param objects based on their labels. Supply selector: {} to match all resources of the ParamKind.
               
               If multiple params are found, they are all evaluated with the policy expressions and the results are ANDed together.
               
               One of `name` or `selector` must be set, but `name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if parameter_not_found_action is not None:
            pulumi.set(__self__, "parameter_not_found_action", parameter_not_found_action)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        `name` is the name of the resource being referenced.

        `name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        namespace is the namespace of the referenced resource. Allows limiting the search for params to a specific namespace. Applies to both `name` and `selector` fields.

        A per-namespace parameter may be used by specifying a namespace-scoped `paramKind` in the policy and leaving this field empty.

        - If `paramKind` is cluster-scoped, this field MUST be unset. Setting this field results in a configuration error.

        - If `paramKind` is namespace-scoped, the namespace of the object being evaluated for admission will be used when this field is left unset. Take care that if this is left empty the binding must not match any cluster-scoped resources, which will result in an error.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="parameterNotFoundAction")
    def parameter_not_found_action(self) -> Optional[_builtins.str]:
        """
        `parameterNotFoundAction` controls the behavior of the binding when the resource exists, and name or selector is valid, but there are no parameters matched by the binding. If the value is set to `Allow`, then no matched parameters will be treated as successful validation by the binding. If set to `Deny`, then no matched parameters will be subject to the `failurePolicy` of the policy.

        Allowed values are `Allow` or `Deny` Default to `Deny`
        """
        return pulumi.get(self, "parameter_not_found_action")

    @_builtins.property
    @pulumi.getter
    def selector(self) -> Optional['_meta.v1.outputs.LabelSelector']:
        """
        selector can be used to match multiple param objects based on their labels. Supply selector: {} to match all resources of the ParamKind.

        If multiple params are found, they are all evaluated with the policy expressions and the results are ANDed together.

        One of `name` or `selector` must be set, but `name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.
        """
        return pulumi.get(self, "selector")


@pulumi.output_type
class ParamRefPatch(dict):
    """
    ParamRef describes how to locate the params to be used as input to expressions of rules applied by a policy binding.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parameterNotFoundAction":
            suggest = "parameter_not_found_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ParamRefPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ParamRefPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ParamRefPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 namespace: Optional[_builtins.str] = None,
                 parameter_not_found_action: Optional[_builtins.str] = None,
                 selector: Optional['_meta.v1.outputs.LabelSelectorPatch'] = None):
        """
        ParamRef describes how to locate the params to be used as input to expressions of rules applied by a policy binding.
        :param _builtins.str name: `name` is the name of the resource being referenced.
               
               `name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.
        :param _builtins.str namespace: namespace is the namespace of the referenced resource. Allows limiting the search for params to a specific namespace. Applies to both `name` and `selector` fields.
               
               A per-namespace parameter may be used by specifying a namespace-scoped `paramKind` in the policy and leaving this field empty.
               
               - If `paramKind` is cluster-scoped, this field MUST be unset. Setting this field results in a configuration error.
               
               - If `paramKind` is namespace-scoped, the namespace of the object being evaluated for admission will be used when this field is left unset. Take care that if this is left empty the binding must not match any cluster-scoped resources, which will result in an error.
        :param _builtins.str parameter_not_found_action: `parameterNotFoundAction` controls the behavior of the binding when the resource exists, and name or selector is valid, but there are no parameters matched by the binding. If the value is set to `Allow`, then no matched parameters will be treated as successful validation by the binding. If set to `Deny`, then no matched parameters will be subject to the `failurePolicy` of the policy.
               
               Allowed values are `Allow` or `Deny` Default to `Deny`
        :param '_meta.v1.LabelSelectorPatchArgs' selector: selector can be used to match multiple param objects based on their labels. Supply selector: {} to match all resources of the ParamKind.
               
               If multiple params are found, they are all evaluated with the policy expressions and the results are ANDed together.
               
               One of `name` or `selector` must be set, but `name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if parameter_not_found_action is not None:
            pulumi.set(__self__, "parameter_not_found_action", parameter_not_found_action)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        `name` is the name of the resource being referenced.

        `name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        namespace is the namespace of the referenced resource. Allows limiting the search for params to a specific namespace. Applies to both `name` and `selector` fields.

        A per-namespace parameter may be used by specifying a namespace-scoped `paramKind` in the policy and leaving this field empty.

        - If `paramKind` is cluster-scoped, this field MUST be unset. Setting this field results in a configuration error.

        - If `paramKind` is namespace-scoped, the namespace of the object being evaluated for admission will be used when this field is left unset. Take care that if this is left empty the binding must not match any cluster-scoped resources, which will result in an error.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="parameterNotFoundAction")
    def parameter_not_found_action(self) -> Optional[_builtins.str]:
        """
        `parameterNotFoundAction` controls the behavior of the binding when the resource exists, and name or selector is valid, but there are no parameters matched by the binding. If the value is set to `Allow`, then no matched parameters will be treated as successful validation by the binding. If set to `Deny`, then no matched parameters will be subject to the `failurePolicy` of the policy.

        Allowed values are `Allow` or `Deny` Default to `Deny`
        """
        return pulumi.get(self, "parameter_not_found_action")

    @_builtins.property
    @pulumi.getter
    def selector(self) -> Optional['_meta.v1.outputs.LabelSelectorPatch']:
        """
        selector can be used to match multiple param objects based on their labels. Supply selector: {} to match all resources of the ParamKind.

        If multiple params are found, they are all evaluated with the policy expressions and the results are ANDed together.

        One of `name` or `selector` must be set, but `name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.
        """
        return pulumi.get(self, "selector")


@pulumi.output_type
class TypeChecking(dict):
    """
    TypeChecking contains results of type checking the expressions in the ValidatingAdmissionPolicy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expressionWarnings":
            suggest = "expression_warnings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TypeChecking. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TypeChecking.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TypeChecking.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expression_warnings: Optional[Sequence['outputs.ExpressionWarning']] = None):
        """
        TypeChecking contains results of type checking the expressions in the ValidatingAdmissionPolicy
        :param Sequence['ExpressionWarningArgs'] expression_warnings: The type checking warnings for each expression.
        """
        if expression_warnings is not None:
            pulumi.set(__self__, "expression_warnings", expression_warnings)

    @_builtins.property
    @pulumi.getter(name="expressionWarnings")
    def expression_warnings(self) -> Optional[Sequence['outputs.ExpressionWarning']]:
        """
        The type checking warnings for each expression.
        """
        return pulumi.get(self, "expression_warnings")


@pulumi.output_type
class TypeCheckingPatch(dict):
    """
    TypeChecking contains results of type checking the expressions in the ValidatingAdmissionPolicy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expressionWarnings":
            suggest = "expression_warnings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TypeCheckingPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TypeCheckingPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TypeCheckingPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expression_warnings: Optional[Sequence['outputs.ExpressionWarningPatch']] = None):
        """
        TypeChecking contains results of type checking the expressions in the ValidatingAdmissionPolicy
        :param Sequence['ExpressionWarningPatchArgs'] expression_warnings: The type checking warnings for each expression.
        """
        if expression_warnings is not None:
            pulumi.set(__self__, "expression_warnings", expression_warnings)

    @_builtins.property
    @pulumi.getter(name="expressionWarnings")
    def expression_warnings(self) -> Optional[Sequence['outputs.ExpressionWarningPatch']]:
        """
        The type checking warnings for each expression.
        """
        return pulumi.get(self, "expression_warnings")


@pulumi.output_type
class ValidatingAdmissionPolicy(dict):
    """
    ValidatingAdmissionPolicy describes the definition of an admission validation policy that accepts or rejects an object without changing it.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ValidatingAdmissionPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ValidatingAdmissionPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ValidatingAdmissionPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[_builtins.str] = None,
                 kind: Optional[_builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.ValidatingAdmissionPolicySpec'] = None,
                 status: Optional['outputs.ValidatingAdmissionPolicyStatus'] = None):
        """
        ValidatingAdmissionPolicy describes the definition of an admission validation policy that accepts or rejects an object without changing it.
        :param _builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param _builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        :param 'ValidatingAdmissionPolicySpecArgs' spec: Specification of the desired behavior of the ValidatingAdmissionPolicy.
        :param 'ValidatingAdmissionPolicyStatusArgs' status: The status of the ValidatingAdmissionPolicy, including warnings that are useful to determine if the policy behaves in the expected way. Populated by the system. Read-only.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'admissionregistration.k8s.io/v1alpha1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'ValidatingAdmissionPolicy')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[_builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[_builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional['outputs.ValidatingAdmissionPolicySpec']:
        """
        Specification of the desired behavior of the ValidatingAdmissionPolicy.
        """
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional['outputs.ValidatingAdmissionPolicyStatus']:
        """
        The status of the ValidatingAdmissionPolicy, including warnings that are useful to determine if the policy behaves in the expected way. Populated by the system. Read-only.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ValidatingAdmissionPolicyBinding(dict):
    """
    ValidatingAdmissionPolicyBinding binds the ValidatingAdmissionPolicy with paramerized resources. ValidatingAdmissionPolicyBinding and parameter CRDs together define how cluster administrators configure policies for clusters.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ValidatingAdmissionPolicyBinding. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ValidatingAdmissionPolicyBinding.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ValidatingAdmissionPolicyBinding.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[_builtins.str] = None,
                 kind: Optional[_builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.ValidatingAdmissionPolicyBindingSpec'] = None):
        """
        ValidatingAdmissionPolicyBinding binds the ValidatingAdmissionPolicy with paramerized resources. ValidatingAdmissionPolicyBinding and parameter CRDs together define how cluster administrators configure policies for clusters.
        :param _builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param _builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        :param 'ValidatingAdmissionPolicyBindingSpecArgs' spec: Specification of the desired behavior of the ValidatingAdmissionPolicyBinding.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'admissionregistration.k8s.io/v1alpha1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'ValidatingAdmissionPolicyBinding')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[_builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[_builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional['outputs.ValidatingAdmissionPolicyBindingSpec']:
        """
        Specification of the desired behavior of the ValidatingAdmissionPolicyBinding.
        """
        return pulumi.get(self, "spec")


@pulumi.output_type
class ValidatingAdmissionPolicyBindingSpec(dict):
    """
    ValidatingAdmissionPolicyBindingSpec is the specification of the ValidatingAdmissionPolicyBinding.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchResources":
            suggest = "match_resources"
        elif key == "paramRef":
            suggest = "param_ref"
        elif key == "policyName":
            suggest = "policy_name"
        elif key == "validationActions":
            suggest = "validation_actions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ValidatingAdmissionPolicyBindingSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ValidatingAdmissionPolicyBindingSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ValidatingAdmissionPolicyBindingSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_resources: Optional['outputs.MatchResources'] = None,
                 param_ref: Optional['outputs.ParamRef'] = None,
                 policy_name: Optional[_builtins.str] = None,
                 validation_actions: Optional[Sequence[_builtins.str]] = None):
        """
        ValidatingAdmissionPolicyBindingSpec is the specification of the ValidatingAdmissionPolicyBinding.
        :param 'MatchResourcesArgs' match_resources: MatchResources declares what resources match this binding and will be validated by it. Note that this is intersected with the policy's matchConstraints, so only requests that are matched by the policy can be selected by this. If this is unset, all resources matched by the policy are validated by this binding When resourceRules is unset, it does not constrain resource matching. If a resource is matched by the other fields of this object, it will be validated. Note that this is differs from ValidatingAdmissionPolicy matchConstraints, where resourceRules are required.
        :param 'ParamRefArgs' param_ref: ParamRef specifies the parameter resource used to configure the admission control policy. It should point to a resource of the type specified in ParamKind of the bound ValidatingAdmissionPolicy. If the policy specifies a ParamKind and the resource referred to by ParamRef does not exist, this binding is considered mis-configured and the FailurePolicy of the ValidatingAdmissionPolicy applied.
        :param _builtins.str policy_name: PolicyName references a ValidatingAdmissionPolicy name which the ValidatingAdmissionPolicyBinding binds to. If the referenced resource does not exist, this binding is considered invalid and will be ignored Required.
        :param Sequence[_builtins.str] validation_actions: validationActions declares how Validations of the referenced ValidatingAdmissionPolicy are enforced. If a validation evaluates to false it is always enforced according to these actions.
               
               Failures defined by the ValidatingAdmissionPolicy's FailurePolicy are enforced according to these actions only if the FailurePolicy is set to Fail, otherwise the failures are ignored. This includes compilation errors, runtime errors and misconfigurations of the policy.
               
               validationActions is declared as a set of action values. Order does not matter. validationActions may not contain duplicates of the same action.
               
               The supported actions values are:
               
               "Deny" specifies that a validation failure results in a denied request.
               
               "Warn" specifies that a validation failure is reported to the request client in HTTP Warning headers, with a warning code of 299. Warnings can be sent both for allowed or denied admission responses.
               
               "Audit" specifies that a validation failure is included in the published audit event for the request. The audit event will contain a `validation.policy.admission.k8s.io/validation_failure` audit annotation with a value containing the details of the validation failures, formatted as a JSON list of objects, each with the following fields: - message: The validation failure message string - policy: The resource name of the ValidatingAdmissionPolicy - binding: The resource name of the ValidatingAdmissionPolicyBinding - expressionIndex: The index of the failed validations in the ValidatingAdmissionPolicy - validationActions: The enforcement actions enacted for the validation failure Example audit annotation: `"validation.policy.admission.k8s.io/validation_failure": "[{"message": "Invalid value", {"policy": "policy.example.com", {"binding": "policybinding.example.com", {"expressionIndex": "1", {"validationActions": ["Audit"]}]"`
               
               Clients should expect to handle additional values by ignoring any values not recognized.
               
               "Deny" and "Warn" may not be used together since this combination needlessly duplicates the validation failure both in the API response body and the HTTP warning headers.
               
               Required.
        """
        if match_resources is not None:
            pulumi.set(__self__, "match_resources", match_resources)
        if param_ref is not None:
            pulumi.set(__self__, "param_ref", param_ref)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)
        if validation_actions is not None:
            pulumi.set(__self__, "validation_actions", validation_actions)

    @_builtins.property
    @pulumi.getter(name="matchResources")
    def match_resources(self) -> Optional['outputs.MatchResources']:
        """
        MatchResources declares what resources match this binding and will be validated by it. Note that this is intersected with the policy's matchConstraints, so only requests that are matched by the policy can be selected by this. If this is unset, all resources matched by the policy are validated by this binding When resourceRules is unset, it does not constrain resource matching. If a resource is matched by the other fields of this object, it will be validated. Note that this is differs from ValidatingAdmissionPolicy matchConstraints, where resourceRules are required.
        """
        return pulumi.get(self, "match_resources")

    @_builtins.property
    @pulumi.getter(name="paramRef")
    def param_ref(self) -> Optional['outputs.ParamRef']:
        """
        ParamRef specifies the parameter resource used to configure the admission control policy. It should point to a resource of the type specified in ParamKind of the bound ValidatingAdmissionPolicy. If the policy specifies a ParamKind and the resource referred to by ParamRef does not exist, this binding is considered mis-configured and the FailurePolicy of the ValidatingAdmissionPolicy applied.
        """
        return pulumi.get(self, "param_ref")

    @_builtins.property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[_builtins.str]:
        """
        PolicyName references a ValidatingAdmissionPolicy name which the ValidatingAdmissionPolicyBinding binds to. If the referenced resource does not exist, this binding is considered invalid and will be ignored Required.
        """
        return pulumi.get(self, "policy_name")

    @_builtins.property
    @pulumi.getter(name="validationActions")
    def validation_actions(self) -> Optional[Sequence[_builtins.str]]:
        """
        validationActions declares how Validations of the referenced ValidatingAdmissionPolicy are enforced. If a validation evaluates to false it is always enforced according to these actions.

        Failures defined by the ValidatingAdmissionPolicy's FailurePolicy are enforced according to these actions only if the FailurePolicy is set to Fail, otherwise the failures are ignored. This includes compilation errors, runtime errors and misconfigurations of the policy.

        validationActions is declared as a set of action values. Order does not matter. validationActions may not contain duplicates of the same action.

        The supported actions values are:

        "Deny" specifies that a validation failure results in a denied request.

        "Warn" specifies that a validation failure is reported to the request client in HTTP Warning headers, with a warning code of 299. Warnings can be sent both for allowed or denied admission responses.

        "Audit" specifies that a validation failure is included in the published audit event for the request. The audit event will contain a `validation.policy.admission.k8s.io/validation_failure` audit annotation with a value containing the details of the validation failures, formatted as a JSON list of objects, each with the following fields: - message: The validation failure message string - policy: The resource name of the ValidatingAdmissionPolicy - binding: The resource name of the ValidatingAdmissionPolicyBinding - expressionIndex: The index of the failed validations in the ValidatingAdmissionPolicy - validationActions: The enforcement actions enacted for the validation failure Example audit annotation: `"validation.policy.admission.k8s.io/validation_failure": "[{"message": "Invalid value", {"policy": "policy.example.com", {"binding": "policybinding.example.com", {"expressionIndex": "1", {"validationActions": ["Audit"]}]"`

        Clients should expect to handle additional values by ignoring any values not recognized.

        "Deny" and "Warn" may not be used together since this combination needlessly duplicates the validation failure both in the API response body and the HTTP warning headers.

        Required.
        """
        return pulumi.get(self, "validation_actions")


@pulumi.output_type
class ValidatingAdmissionPolicyBindingSpecPatch(dict):
    """
    ValidatingAdmissionPolicyBindingSpec is the specification of the ValidatingAdmissionPolicyBinding.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchResources":
            suggest = "match_resources"
        elif key == "paramRef":
            suggest = "param_ref"
        elif key == "policyName":
            suggest = "policy_name"
        elif key == "validationActions":
            suggest = "validation_actions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ValidatingAdmissionPolicyBindingSpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ValidatingAdmissionPolicyBindingSpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ValidatingAdmissionPolicyBindingSpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_resources: Optional['outputs.MatchResourcesPatch'] = None,
                 param_ref: Optional['outputs.ParamRefPatch'] = None,
                 policy_name: Optional[_builtins.str] = None,
                 validation_actions: Optional[Sequence[_builtins.str]] = None):
        """
        ValidatingAdmissionPolicyBindingSpec is the specification of the ValidatingAdmissionPolicyBinding.
        :param 'MatchResourcesPatchArgs' match_resources: MatchResources declares what resources match this binding and will be validated by it. Note that this is intersected with the policy's matchConstraints, so only requests that are matched by the policy can be selected by this. If this is unset, all resources matched by the policy are validated by this binding When resourceRules is unset, it does not constrain resource matching. If a resource is matched by the other fields of this object, it will be validated. Note that this is differs from ValidatingAdmissionPolicy matchConstraints, where resourceRules are required.
        :param 'ParamRefPatchArgs' param_ref: ParamRef specifies the parameter resource used to configure the admission control policy. It should point to a resource of the type specified in ParamKind of the bound ValidatingAdmissionPolicy. If the policy specifies a ParamKind and the resource referred to by ParamRef does not exist, this binding is considered mis-configured and the FailurePolicy of the ValidatingAdmissionPolicy applied.
        :param _builtins.str policy_name: PolicyName references a ValidatingAdmissionPolicy name which the ValidatingAdmissionPolicyBinding binds to. If the referenced resource does not exist, this binding is considered invalid and will be ignored Required.
        :param Sequence[_builtins.str] validation_actions: validationActions declares how Validations of the referenced ValidatingAdmissionPolicy are enforced. If a validation evaluates to false it is always enforced according to these actions.
               
               Failures defined by the ValidatingAdmissionPolicy's FailurePolicy are enforced according to these actions only if the FailurePolicy is set to Fail, otherwise the failures are ignored. This includes compilation errors, runtime errors and misconfigurations of the policy.
               
               validationActions is declared as a set of action values. Order does not matter. validationActions may not contain duplicates of the same action.
               
               The supported actions values are:
               
               "Deny" specifies that a validation failure results in a denied request.
               
               "Warn" specifies that a validation failure is reported to the request client in HTTP Warning headers, with a warning code of 299. Warnings can be sent both for allowed or denied admission responses.
               
               "Audit" specifies that a validation failure is included in the published audit event for the request. The audit event will contain a `validation.policy.admission.k8s.io/validation_failure` audit annotation with a value containing the details of the validation failures, formatted as a JSON list of objects, each with the following fields: - message: The validation failure message string - policy: The resource name of the ValidatingAdmissionPolicy - binding: The resource name of the ValidatingAdmissionPolicyBinding - expressionIndex: The index of the failed validations in the ValidatingAdmissionPolicy - validationActions: The enforcement actions enacted for the validation failure Example audit annotation: `"validation.policy.admission.k8s.io/validation_failure": "[{"message": "Invalid value", {"policy": "policy.example.com", {"binding": "policybinding.example.com", {"expressionIndex": "1", {"validationActions": ["Audit"]}]"`
               
               Clients should expect to handle additional values by ignoring any values not recognized.
               
               "Deny" and "Warn" may not be used together since this combination needlessly duplicates the validation failure both in the API response body and the HTTP warning headers.
               
               Required.
        """
        if match_resources is not None:
            pulumi.set(__self__, "match_resources", match_resources)
        if param_ref is not None:
            pulumi.set(__self__, "param_ref", param_ref)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)
        if validation_actions is not None:
            pulumi.set(__self__, "validation_actions", validation_actions)

    @_builtins.property
    @pulumi.getter(name="matchResources")
    def match_resources(self) -> Optional['outputs.MatchResourcesPatch']:
        """
        MatchResources declares what resources match this binding and will be validated by it. Note that this is intersected with the policy's matchConstraints, so only requests that are matched by the policy can be selected by this. If this is unset, all resources matched by the policy are validated by this binding When resourceRules is unset, it does not constrain resource matching. If a resource is matched by the other fields of this object, it will be validated. Note that this is differs from ValidatingAdmissionPolicy matchConstraints, where resourceRules are required.
        """
        return pulumi.get(self, "match_resources")

    @_builtins.property
    @pulumi.getter(name="paramRef")
    def param_ref(self) -> Optional['outputs.ParamRefPatch']:
        """
        ParamRef specifies the parameter resource used to configure the admission control policy. It should point to a resource of the type specified in ParamKind of the bound ValidatingAdmissionPolicy. If the policy specifies a ParamKind and the resource referred to by ParamRef does not exist, this binding is considered mis-configured and the FailurePolicy of the ValidatingAdmissionPolicy applied.
        """
        return pulumi.get(self, "param_ref")

    @_builtins.property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[_builtins.str]:
        """
        PolicyName references a ValidatingAdmissionPolicy name which the ValidatingAdmissionPolicyBinding binds to. If the referenced resource does not exist, this binding is considered invalid and will be ignored Required.
        """
        return pulumi.get(self, "policy_name")

    @_builtins.property
    @pulumi.getter(name="validationActions")
    def validation_actions(self) -> Optional[Sequence[_builtins.str]]:
        """
        validationActions declares how Validations of the referenced ValidatingAdmissionPolicy are enforced. If a validation evaluates to false it is always enforced according to these actions.

        Failures defined by the ValidatingAdmissionPolicy's FailurePolicy are enforced according to these actions only if the FailurePolicy is set to Fail, otherwise the failures are ignored. This includes compilation errors, runtime errors and misconfigurations of the policy.

        validationActions is declared as a set of action values. Order does not matter. validationActions may not contain duplicates of the same action.

        The supported actions values are:

        "Deny" specifies that a validation failure results in a denied request.

        "Warn" specifies that a validation failure is reported to the request client in HTTP Warning headers, with a warning code of 299. Warnings can be sent both for allowed or denied admission responses.

        "Audit" specifies that a validation failure is included in the published audit event for the request. The audit event will contain a `validation.policy.admission.k8s.io/validation_failure` audit annotation with a value containing the details of the validation failures, formatted as a JSON list of objects, each with the following fields: - message: The validation failure message string - policy: The resource name of the ValidatingAdmissionPolicy - binding: The resource name of the ValidatingAdmissionPolicyBinding - expressionIndex: The index of the failed validations in the ValidatingAdmissionPolicy - validationActions: The enforcement actions enacted for the validation failure Example audit annotation: `"validation.policy.admission.k8s.io/validation_failure": "[{"message": "Invalid value", {"policy": "policy.example.com", {"binding": "policybinding.example.com", {"expressionIndex": "1", {"validationActions": ["Audit"]}]"`

        Clients should expect to handle additional values by ignoring any values not recognized.

        "Deny" and "Warn" may not be used together since this combination needlessly duplicates the validation failure both in the API response body and the HTTP warning headers.

        Required.
        """
        return pulumi.get(self, "validation_actions")


@pulumi.output_type
class ValidatingAdmissionPolicySpec(dict):
    """
    ValidatingAdmissionPolicySpec is the specification of the desired behavior of the AdmissionPolicy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auditAnnotations":
            suggest = "audit_annotations"
        elif key == "failurePolicy":
            suggest = "failure_policy"
        elif key == "matchConditions":
            suggest = "match_conditions"
        elif key == "matchConstraints":
            suggest = "match_constraints"
        elif key == "paramKind":
            suggest = "param_kind"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ValidatingAdmissionPolicySpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ValidatingAdmissionPolicySpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ValidatingAdmissionPolicySpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 validations: Sequence['outputs.Validation'],
                 audit_annotations: Optional[Sequence['outputs.AuditAnnotation']] = None,
                 failure_policy: Optional[_builtins.str] = None,
                 match_conditions: Optional[Sequence['outputs.MatchCondition']] = None,
                 match_constraints: Optional['outputs.MatchResources'] = None,
                 param_kind: Optional['outputs.ParamKind'] = None,
                 variables: Optional[Sequence['outputs.Variable']] = None):
        """
        ValidatingAdmissionPolicySpec is the specification of the desired behavior of the AdmissionPolicy.
        :param Sequence['ValidationArgs'] validations: Validations contain CEL expressions which is used to apply the validation. A minimum of one validation is required for a policy definition. Required.
        :param Sequence['AuditAnnotationArgs'] audit_annotations: auditAnnotations contains CEL expressions which are used to produce audit annotations for the audit event of the API request. validations and auditAnnotations may not both be empty; a least one of validations or auditAnnotations is required.
        :param _builtins.str failure_policy: FailurePolicy defines how to handle failures for the admission policy. Failures can occur from invalid or mis-configured policy definitions or bindings. A policy is invalid if spec.paramKind refers to a non-existent Kind. A binding is invalid if spec.paramRef.name refers to a non-existent resource. Allowed values are Ignore or Fail. Defaults to Fail.
        :param Sequence['MatchConditionArgs'] match_conditions: MatchConditions is a list of conditions that must be met for a request to be validated. Match conditions filter requests that have already been matched by the rules, namespaceSelector, and objectSelector. An empty list of matchConditions matches all requests. There are a maximum of 64 match conditions allowed.
               
               If a parameter object is provided, it can be accessed via the `params` handle in the same manner as validation expressions.
               
               The exact matching logic is (in order):
                 1. If ANY matchCondition evaluates to FALSE, the policy is skipped.
                 2. If ALL matchConditions evaluate to TRUE, the policy is evaluated.
                 3. If any matchCondition evaluates to an error (but none are FALSE):
                    - If failurePolicy=Fail, reject the request
                    - If failurePolicy=Ignore, the policy is skipped
        :param 'MatchResourcesArgs' match_constraints: MatchConstraints specifies what resources this policy is designed to validate. The AdmissionPolicy cares about a request if it matches _all_ Constraints. However, in order to prevent clusters from being put into an unstable state that cannot be recovered from via the API ValidatingAdmissionPolicy cannot match ValidatingAdmissionPolicy and ValidatingAdmissionPolicyBinding. Required.
        :param 'ParamKindArgs' param_kind: ParamKind specifies the kind of resources used to parameterize this policy. If absent, there are no parameters for this policy and the param CEL variable will not be provided to validation expressions. If ParamKind refers to a non-existent kind, this policy definition is mis-configured and the FailurePolicy is applied. If paramKind is specified but paramRef is unset in ValidatingAdmissionPolicyBinding, the params variable will be null.
        :param Sequence['VariableArgs'] variables: Variables contain definitions of variables that can be used in composition of other expressions. Each variable is defined as a named CEL expression. The variables defined here will be available under `variables` in other expressions of the policy except MatchConditions because MatchConditions are evaluated before the rest of the policy.
               
               The expression of a variable can refer to other variables defined earlier in the list but not those after. Thus, Variables must be sorted by the order of first appearance and acyclic.
        """
        pulumi.set(__self__, "validations", validations)
        if audit_annotations is not None:
            pulumi.set(__self__, "audit_annotations", audit_annotations)
        if failure_policy is not None:
            pulumi.set(__self__, "failure_policy", failure_policy)
        if match_conditions is not None:
            pulumi.set(__self__, "match_conditions", match_conditions)
        if match_constraints is not None:
            pulumi.set(__self__, "match_constraints", match_constraints)
        if param_kind is not None:
            pulumi.set(__self__, "param_kind", param_kind)
        if variables is not None:
            pulumi.set(__self__, "variables", variables)

    @_builtins.property
    @pulumi.getter
    def validations(self) -> Sequence['outputs.Validation']:
        """
        Validations contain CEL expressions which is used to apply the validation. A minimum of one validation is required for a policy definition. Required.
        """
        return pulumi.get(self, "validations")

    @_builtins.property
    @pulumi.getter(name="auditAnnotations")
    def audit_annotations(self) -> Optional[Sequence['outputs.AuditAnnotation']]:
        """
        auditAnnotations contains CEL expressions which are used to produce audit annotations for the audit event of the API request. validations and auditAnnotations may not both be empty; a least one of validations or auditAnnotations is required.
        """
        return pulumi.get(self, "audit_annotations")

    @_builtins.property
    @pulumi.getter(name="failurePolicy")
    def failure_policy(self) -> Optional[_builtins.str]:
        """
        FailurePolicy defines how to handle failures for the admission policy. Failures can occur from invalid or mis-configured policy definitions or bindings. A policy is invalid if spec.paramKind refers to a non-existent Kind. A binding is invalid if spec.paramRef.name refers to a non-existent resource. Allowed values are Ignore or Fail. Defaults to Fail.
        """
        return pulumi.get(self, "failure_policy")

    @_builtins.property
    @pulumi.getter(name="matchConditions")
    def match_conditions(self) -> Optional[Sequence['outputs.MatchCondition']]:
        """
        MatchConditions is a list of conditions that must be met for a request to be validated. Match conditions filter requests that have already been matched by the rules, namespaceSelector, and objectSelector. An empty list of matchConditions matches all requests. There are a maximum of 64 match conditions allowed.

        If a parameter object is provided, it can be accessed via the `params` handle in the same manner as validation expressions.

        The exact matching logic is (in order):
          1. If ANY matchCondition evaluates to FALSE, the policy is skipped.
          2. If ALL matchConditions evaluate to TRUE, the policy is evaluated.
          3. If any matchCondition evaluates to an error (but none are FALSE):
             - If failurePolicy=Fail, reject the request
             - If failurePolicy=Ignore, the policy is skipped
        """
        return pulumi.get(self, "match_conditions")

    @_builtins.property
    @pulumi.getter(name="matchConstraints")
    def match_constraints(self) -> Optional['outputs.MatchResources']:
        """
        MatchConstraints specifies what resources this policy is designed to validate. The AdmissionPolicy cares about a request if it matches _all_ Constraints. However, in order to prevent clusters from being put into an unstable state that cannot be recovered from via the API ValidatingAdmissionPolicy cannot match ValidatingAdmissionPolicy and ValidatingAdmissionPolicyBinding. Required.
        """
        return pulumi.get(self, "match_constraints")

    @_builtins.property
    @pulumi.getter(name="paramKind")
    def param_kind(self) -> Optional['outputs.ParamKind']:
        """
        ParamKind specifies the kind of resources used to parameterize this policy. If absent, there are no parameters for this policy and the param CEL variable will not be provided to validation expressions. If ParamKind refers to a non-existent kind, this policy definition is mis-configured and the FailurePolicy is applied. If paramKind is specified but paramRef is unset in ValidatingAdmissionPolicyBinding, the params variable will be null.
        """
        return pulumi.get(self, "param_kind")

    @_builtins.property
    @pulumi.getter
    def variables(self) -> Optional[Sequence['outputs.Variable']]:
        """
        Variables contain definitions of variables that can be used in composition of other expressions. Each variable is defined as a named CEL expression. The variables defined here will be available under `variables` in other expressions of the policy except MatchConditions because MatchConditions are evaluated before the rest of the policy.

        The expression of a variable can refer to other variables defined earlier in the list but not those after. Thus, Variables must be sorted by the order of first appearance and acyclic.
        """
        return pulumi.get(self, "variables")


@pulumi.output_type
class ValidatingAdmissionPolicySpecPatch(dict):
    """
    ValidatingAdmissionPolicySpec is the specification of the desired behavior of the AdmissionPolicy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auditAnnotations":
            suggest = "audit_annotations"
        elif key == "failurePolicy":
            suggest = "failure_policy"
        elif key == "matchConditions":
            suggest = "match_conditions"
        elif key == "matchConstraints":
            suggest = "match_constraints"
        elif key == "paramKind":
            suggest = "param_kind"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ValidatingAdmissionPolicySpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ValidatingAdmissionPolicySpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ValidatingAdmissionPolicySpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audit_annotations: Optional[Sequence['outputs.AuditAnnotationPatch']] = None,
                 failure_policy: Optional[_builtins.str] = None,
                 match_conditions: Optional[Sequence['outputs.MatchConditionPatch']] = None,
                 match_constraints: Optional['outputs.MatchResourcesPatch'] = None,
                 param_kind: Optional['outputs.ParamKindPatch'] = None,
                 validations: Optional[Sequence['outputs.ValidationPatch']] = None,
                 variables: Optional[Sequence['outputs.VariablePatch']] = None):
        """
        ValidatingAdmissionPolicySpec is the specification of the desired behavior of the AdmissionPolicy.
        :param Sequence['AuditAnnotationPatchArgs'] audit_annotations: auditAnnotations contains CEL expressions which are used to produce audit annotations for the audit event of the API request. validations and auditAnnotations may not both be empty; a least one of validations or auditAnnotations is required.
        :param _builtins.str failure_policy: FailurePolicy defines how to handle failures for the admission policy. Failures can occur from invalid or mis-configured policy definitions or bindings. A policy is invalid if spec.paramKind refers to a non-existent Kind. A binding is invalid if spec.paramRef.name refers to a non-existent resource. Allowed values are Ignore or Fail. Defaults to Fail.
        :param Sequence['MatchConditionPatchArgs'] match_conditions: MatchConditions is a list of conditions that must be met for a request to be validated. Match conditions filter requests that have already been matched by the rules, namespaceSelector, and objectSelector. An empty list of matchConditions matches all requests. There are a maximum of 64 match conditions allowed.
               
               If a parameter object is provided, it can be accessed via the `params` handle in the same manner as validation expressions.
               
               The exact matching logic is (in order):
                 1. If ANY matchCondition evaluates to FALSE, the policy is skipped.
                 2. If ALL matchConditions evaluate to TRUE, the policy is evaluated.
                 3. If any matchCondition evaluates to an error (but none are FALSE):
                    - If failurePolicy=Fail, reject the request
                    - If failurePolicy=Ignore, the policy is skipped
        :param 'MatchResourcesPatchArgs' match_constraints: MatchConstraints specifies what resources this policy is designed to validate. The AdmissionPolicy cares about a request if it matches _all_ Constraints. However, in order to prevent clusters from being put into an unstable state that cannot be recovered from via the API ValidatingAdmissionPolicy cannot match ValidatingAdmissionPolicy and ValidatingAdmissionPolicyBinding. Required.
        :param 'ParamKindPatchArgs' param_kind: ParamKind specifies the kind of resources used to parameterize this policy. If absent, there are no parameters for this policy and the param CEL variable will not be provided to validation expressions. If ParamKind refers to a non-existent kind, this policy definition is mis-configured and the FailurePolicy is applied. If paramKind is specified but paramRef is unset in ValidatingAdmissionPolicyBinding, the params variable will be null.
        :param Sequence['ValidationPatchArgs'] validations: Validations contain CEL expressions which is used to apply the validation. A minimum of one validation is required for a policy definition. Required.
        :param Sequence['VariablePatchArgs'] variables: Variables contain definitions of variables that can be used in composition of other expressions. Each variable is defined as a named CEL expression. The variables defined here will be available under `variables` in other expressions of the policy except MatchConditions because MatchConditions are evaluated before the rest of the policy.
               
               The expression of a variable can refer to other variables defined earlier in the list but not those after. Thus, Variables must be sorted by the order of first appearance and acyclic.
        """
        if audit_annotations is not None:
            pulumi.set(__self__, "audit_annotations", audit_annotations)
        if failure_policy is not None:
            pulumi.set(__self__, "failure_policy", failure_policy)
        if match_conditions is not None:
            pulumi.set(__self__, "match_conditions", match_conditions)
        if match_constraints is not None:
            pulumi.set(__self__, "match_constraints", match_constraints)
        if param_kind is not None:
            pulumi.set(__self__, "param_kind", param_kind)
        if validations is not None:
            pulumi.set(__self__, "validations", validations)
        if variables is not None:
            pulumi.set(__self__, "variables", variables)

    @_builtins.property
    @pulumi.getter(name="auditAnnotations")
    def audit_annotations(self) -> Optional[Sequence['outputs.AuditAnnotationPatch']]:
        """
        auditAnnotations contains CEL expressions which are used to produce audit annotations for the audit event of the API request. validations and auditAnnotations may not both be empty; a least one of validations or auditAnnotations is required.
        """
        return pulumi.get(self, "audit_annotations")

    @_builtins.property
    @pulumi.getter(name="failurePolicy")
    def failure_policy(self) -> Optional[_builtins.str]:
        """
        FailurePolicy defines how to handle failures for the admission policy. Failures can occur from invalid or mis-configured policy definitions or bindings. A policy is invalid if spec.paramKind refers to a non-existent Kind. A binding is invalid if spec.paramRef.name refers to a non-existent resource. Allowed values are Ignore or Fail. Defaults to Fail.
        """
        return pulumi.get(self, "failure_policy")

    @_builtins.property
    @pulumi.getter(name="matchConditions")
    def match_conditions(self) -> Optional[Sequence['outputs.MatchConditionPatch']]:
        """
        MatchConditions is a list of conditions that must be met for a request to be validated. Match conditions filter requests that have already been matched by the rules, namespaceSelector, and objectSelector. An empty list of matchConditions matches all requests. There are a maximum of 64 match conditions allowed.

        If a parameter object is provided, it can be accessed via the `params` handle in the same manner as validation expressions.

        The exact matching logic is (in order):
          1. If ANY matchCondition evaluates to FALSE, the policy is skipped.
          2. If ALL matchConditions evaluate to TRUE, the policy is evaluated.
          3. If any matchCondition evaluates to an error (but none are FALSE):
             - If failurePolicy=Fail, reject the request
             - If failurePolicy=Ignore, the policy is skipped
        """
        return pulumi.get(self, "match_conditions")

    @_builtins.property
    @pulumi.getter(name="matchConstraints")
    def match_constraints(self) -> Optional['outputs.MatchResourcesPatch']:
        """
        MatchConstraints specifies what resources this policy is designed to validate. The AdmissionPolicy cares about a request if it matches _all_ Constraints. However, in order to prevent clusters from being put into an unstable state that cannot be recovered from via the API ValidatingAdmissionPolicy cannot match ValidatingAdmissionPolicy and ValidatingAdmissionPolicyBinding. Required.
        """
        return pulumi.get(self, "match_constraints")

    @_builtins.property
    @pulumi.getter(name="paramKind")
    def param_kind(self) -> Optional['outputs.ParamKindPatch']:
        """
        ParamKind specifies the kind of resources used to parameterize this policy. If absent, there are no parameters for this policy and the param CEL variable will not be provided to validation expressions. If ParamKind refers to a non-existent kind, this policy definition is mis-configured and the FailurePolicy is applied. If paramKind is specified but paramRef is unset in ValidatingAdmissionPolicyBinding, the params variable will be null.
        """
        return pulumi.get(self, "param_kind")

    @_builtins.property
    @pulumi.getter
    def validations(self) -> Optional[Sequence['outputs.ValidationPatch']]:
        """
        Validations contain CEL expressions which is used to apply the validation. A minimum of one validation is required for a policy definition. Required.
        """
        return pulumi.get(self, "validations")

    @_builtins.property
    @pulumi.getter
    def variables(self) -> Optional[Sequence['outputs.VariablePatch']]:
        """
        Variables contain definitions of variables that can be used in composition of other expressions. Each variable is defined as a named CEL expression. The variables defined here will be available under `variables` in other expressions of the policy except MatchConditions because MatchConditions are evaluated before the rest of the policy.

        The expression of a variable can refer to other variables defined earlier in the list but not those after. Thus, Variables must be sorted by the order of first appearance and acyclic.
        """
        return pulumi.get(self, "variables")


@pulumi.output_type
class ValidatingAdmissionPolicyStatus(dict):
    """
    ValidatingAdmissionPolicyStatus represents the status of a ValidatingAdmissionPolicy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "observedGeneration":
            suggest = "observed_generation"
        elif key == "typeChecking":
            suggest = "type_checking"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ValidatingAdmissionPolicyStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ValidatingAdmissionPolicyStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ValidatingAdmissionPolicyStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conditions: Optional[Sequence['_meta.v1.outputs.Condition']] = None,
                 observed_generation: Optional[_builtins.int] = None,
                 type_checking: Optional['outputs.TypeChecking'] = None):
        """
        ValidatingAdmissionPolicyStatus represents the status of a ValidatingAdmissionPolicy.
        :param Sequence['_meta.v1.ConditionArgs'] conditions: The conditions represent the latest available observations of a policy's current state.
        :param _builtins.int observed_generation: The generation observed by the controller.
        :param 'TypeCheckingArgs' type_checking: The results of type checking for each expression. Presence of this field indicates the completion of the type checking.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if type_checking is not None:
            pulumi.set(__self__, "type_checking", type_checking)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['_meta.v1.outputs.Condition']]:
        """
        The conditions represent the latest available observations of a policy's current state.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[_builtins.int]:
        """
        The generation observed by the controller.
        """
        return pulumi.get(self, "observed_generation")

    @_builtins.property
    @pulumi.getter(name="typeChecking")
    def type_checking(self) -> Optional['outputs.TypeChecking']:
        """
        The results of type checking for each expression. Presence of this field indicates the completion of the type checking.
        """
        return pulumi.get(self, "type_checking")


@pulumi.output_type
class ValidatingAdmissionPolicyStatusPatch(dict):
    """
    ValidatingAdmissionPolicyStatus represents the status of a ValidatingAdmissionPolicy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "observedGeneration":
            suggest = "observed_generation"
        elif key == "typeChecking":
            suggest = "type_checking"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ValidatingAdmissionPolicyStatusPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ValidatingAdmissionPolicyStatusPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ValidatingAdmissionPolicyStatusPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conditions: Optional[Sequence['_meta.v1.outputs.ConditionPatch']] = None,
                 observed_generation: Optional[_builtins.int] = None,
                 type_checking: Optional['outputs.TypeCheckingPatch'] = None):
        """
        ValidatingAdmissionPolicyStatus represents the status of a ValidatingAdmissionPolicy.
        :param Sequence['_meta.v1.ConditionPatchArgs'] conditions: The conditions represent the latest available observations of a policy's current state.
        :param _builtins.int observed_generation: The generation observed by the controller.
        :param 'TypeCheckingPatchArgs' type_checking: The results of type checking for each expression. Presence of this field indicates the completion of the type checking.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if type_checking is not None:
            pulumi.set(__self__, "type_checking", type_checking)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['_meta.v1.outputs.ConditionPatch']]:
        """
        The conditions represent the latest available observations of a policy's current state.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[_builtins.int]:
        """
        The generation observed by the controller.
        """
        return pulumi.get(self, "observed_generation")

    @_builtins.property
    @pulumi.getter(name="typeChecking")
    def type_checking(self) -> Optional['outputs.TypeCheckingPatch']:
        """
        The results of type checking for each expression. Presence of this field indicates the completion of the type checking.
        """
        return pulumi.get(self, "type_checking")


@pulumi.output_type
class Validation(dict):
    """
    Validation specifies the CEL expression which is used to apply the validation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messageExpression":
            suggest = "message_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Validation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Validation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Validation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expression: _builtins.str,
                 message: Optional[_builtins.str] = None,
                 message_expression: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None):
        """
        Validation specifies the CEL expression which is used to apply the validation.
        :param _builtins.str expression: Expression represents the expression which will be evaluated by CEL. ref: https://github.com/google/cel-spec CEL expressions have access to the contents of the Admission request/response, organized into CEL variables as well as some other useful variables:
               
               'object' - The object from the incoming request. The value is null for DELETE requests. 'oldObject' - The existing object. The value is null for CREATE requests. 'request' - Attributes of the admission request([ref](/pkg/apis/admission/types.go#AdmissionRequest)). 'params' - Parameter resource referred to by the policy binding being evaluated. Only populated if the policy has a ParamKind.
               
               The `apiVersion`, `kind`, `metadata.name` and `metadata.generateName` are always accessible from the root of the object. No other metadata properties are accessible.
               
               Only property names of the form `[a-zA-Z_.-/][a-zA-Z0-9_.-/]*` are accessible. Accessible property names are escaped according to the following rules when accessed in the expression: - '__' escapes to '__underscores__' - '.' escapes to '__dot__' - '-' escapes to '__dash__' - '/' escapes to '__slash__' - Property names that exactly match a CEL RESERVED keyword escape to '__{keyword}__'. The keywords are:
               	  "true", "false", "null", "in", "as", "break", "const", "continue", "else", "for", "function", "if",
               	  "import", "let", "loop", "package", "namespace", "return".
               Examples:
                 - Expression accessing a property named "namespace": {"Expression": "object.__namespace__ > 0"}
                 - Expression accessing a property named "x-prop": {"Expression": "object.x__dash__prop > 0"}
                 - Expression accessing a property named "redact__d": {"Expression": "object.redact__underscores__d > 0"}
               
               Equality on arrays with list type of 'set' or 'map' ignores element order, i.e. [1, 2] == [2, 1]. Concatenation on arrays with x-kubernetes-list-type use the semantics of the list type:
                 - 'set': `X + Y` performs a union where the array positions of all elements in `X` are preserved and
                   non-intersecting elements in `Y` are appended, retaining their partial order.
                 - 'map': `X + Y` performs a merge where the array positions of all keys in `X` are preserved but the values
                   are overwritten by values in `Y` when the key sets of `X` and `Y` intersect. Elements in `Y` with
                   non-intersecting keys are appended, retaining their partial order.
               Required.
        :param _builtins.str message: Message represents the message displayed when validation fails. The message is required if the Expression contains line breaks. The message must not contain line breaks. If unset, the message is "failed rule: {Rule}". e.g. "must be a URL with the host matching spec.host" If the Expression contains line breaks. Message is required. The message must not contain line breaks. If unset, the message is "failed Expression: {Expression}".
        :param _builtins.str message_expression: messageExpression declares a CEL expression that evaluates to the validation failure message that is returned when this rule fails. Since messageExpression is used as a failure message, it must evaluate to a string. If both message and messageExpression are present on a validation, then messageExpression will be used if validation fails. If messageExpression results in a runtime error, the runtime error is logged, and the validation failure message is produced as if the messageExpression field were unset. If messageExpression evaluates to an empty string, a string with only spaces, or a string that contains line breaks, then the validation failure message will also be produced as if the messageExpression field were unset, and the fact that messageExpression produced an empty string/string with only spaces/string with line breaks will be logged. messageExpression has access to all the same variables as the `expression` except for 'authorizer' and 'authorizer.requestResource'. Example: "object.x must be less than max ("+string(params.max)+")"
        :param _builtins.str reason: Reason represents a machine-readable description of why this validation failed. If this is the first validation in the list to fail, this reason, as well as the corresponding HTTP response code, are used in the HTTP response to the client. The currently supported reasons are: "Unauthorized", "Forbidden", "Invalid", "RequestEntityTooLarge". If not set, StatusReasonInvalid is used in the response to the client.
        """
        pulumi.set(__self__, "expression", expression)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if message_expression is not None:
            pulumi.set(__self__, "message_expression", message_expression)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        """
        Expression represents the expression which will be evaluated by CEL. ref: https://github.com/google/cel-spec CEL expressions have access to the contents of the Admission request/response, organized into CEL variables as well as some other useful variables:

        'object' - The object from the incoming request. The value is null for DELETE requests. 'oldObject' - The existing object. The value is null for CREATE requests. 'request' - Attributes of the admission request([ref](/pkg/apis/admission/types.go#AdmissionRequest)). 'params' - Parameter resource referred to by the policy binding being evaluated. Only populated if the policy has a ParamKind.

        The `apiVersion`, `kind`, `metadata.name` and `metadata.generateName` are always accessible from the root of the object. No other metadata properties are accessible.

        Only property names of the form `[a-zA-Z_.-/][a-zA-Z0-9_.-/]*` are accessible. Accessible property names are escaped according to the following rules when accessed in the expression: - '__' escapes to '__underscores__' - '.' escapes to '__dot__' - '-' escapes to '__dash__' - '/' escapes to '__slash__' - Property names that exactly match a CEL RESERVED keyword escape to '__{keyword}__'. The keywords are:
        	  "true", "false", "null", "in", "as", "break", "const", "continue", "else", "for", "function", "if",
        	  "import", "let", "loop", "package", "namespace", "return".
        Examples:
          - Expression accessing a property named "namespace": {"Expression": "object.__namespace__ > 0"}
          - Expression accessing a property named "x-prop": {"Expression": "object.x__dash__prop > 0"}
          - Expression accessing a property named "redact__d": {"Expression": "object.redact__underscores__d > 0"}

        Equality on arrays with list type of 'set' or 'map' ignores element order, i.e. [1, 2] == [2, 1]. Concatenation on arrays with x-kubernetes-list-type use the semantics of the list type:
          - 'set': `X + Y` performs a union where the array positions of all elements in `X` are preserved and
            non-intersecting elements in `Y` are appended, retaining their partial order.
          - 'map': `X + Y` performs a merge where the array positions of all keys in `X` are preserved but the values
            are overwritten by values in `Y` when the key sets of `X` and `Y` intersect. Elements in `Y` with
            non-intersecting keys are appended, retaining their partial order.
        Required.
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        Message represents the message displayed when validation fails. The message is required if the Expression contains line breaks. The message must not contain line breaks. If unset, the message is "failed rule: {Rule}". e.g. "must be a URL with the host matching spec.host" If the Expression contains line breaks. Message is required. The message must not contain line breaks. If unset, the message is "failed Expression: {Expression}".
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter(name="messageExpression")
    def message_expression(self) -> Optional[_builtins.str]:
        """
        messageExpression declares a CEL expression that evaluates to the validation failure message that is returned when this rule fails. Since messageExpression is used as a failure message, it must evaluate to a string. If both message and messageExpression are present on a validation, then messageExpression will be used if validation fails. If messageExpression results in a runtime error, the runtime error is logged, and the validation failure message is produced as if the messageExpression field were unset. If messageExpression evaluates to an empty string, a string with only spaces, or a string that contains line breaks, then the validation failure message will also be produced as if the messageExpression field were unset, and the fact that messageExpression produced an empty string/string with only spaces/string with line breaks will be logged. messageExpression has access to all the same variables as the `expression` except for 'authorizer' and 'authorizer.requestResource'. Example: "object.x must be less than max ("+string(params.max)+")"
        """
        return pulumi.get(self, "message_expression")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        Reason represents a machine-readable description of why this validation failed. If this is the first validation in the list to fail, this reason, as well as the corresponding HTTP response code, are used in the HTTP response to the client. The currently supported reasons are: "Unauthorized", "Forbidden", "Invalid", "RequestEntityTooLarge". If not set, StatusReasonInvalid is used in the response to the client.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class ValidationPatch(dict):
    """
    Validation specifies the CEL expression which is used to apply the validation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messageExpression":
            suggest = "message_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ValidationPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ValidationPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ValidationPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expression: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 message_expression: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None):
        """
        Validation specifies the CEL expression which is used to apply the validation.
        :param _builtins.str expression: Expression represents the expression which will be evaluated by CEL. ref: https://github.com/google/cel-spec CEL expressions have access to the contents of the Admission request/response, organized into CEL variables as well as some other useful variables:
               
               'object' - The object from the incoming request. The value is null for DELETE requests. 'oldObject' - The existing object. The value is null for CREATE requests. 'request' - Attributes of the admission request([ref](/pkg/apis/admission/types.go#AdmissionRequest)). 'params' - Parameter resource referred to by the policy binding being evaluated. Only populated if the policy has a ParamKind.
               
               The `apiVersion`, `kind`, `metadata.name` and `metadata.generateName` are always accessible from the root of the object. No other metadata properties are accessible.
               
               Only property names of the form `[a-zA-Z_.-/][a-zA-Z0-9_.-/]*` are accessible. Accessible property names are escaped according to the following rules when accessed in the expression: - '__' escapes to '__underscores__' - '.' escapes to '__dot__' - '-' escapes to '__dash__' - '/' escapes to '__slash__' - Property names that exactly match a CEL RESERVED keyword escape to '__{keyword}__'. The keywords are:
               	  "true", "false", "null", "in", "as", "break", "const", "continue", "else", "for", "function", "if",
               	  "import", "let", "loop", "package", "namespace", "return".
               Examples:
                 - Expression accessing a property named "namespace": {"Expression": "object.__namespace__ > 0"}
                 - Expression accessing a property named "x-prop": {"Expression": "object.x__dash__prop > 0"}
                 - Expression accessing a property named "redact__d": {"Expression": "object.redact__underscores__d > 0"}
               
               Equality on arrays with list type of 'set' or 'map' ignores element order, i.e. [1, 2] == [2, 1]. Concatenation on arrays with x-kubernetes-list-type use the semantics of the list type:
                 - 'set': `X + Y` performs a union where the array positions of all elements in `X` are preserved and
                   non-intersecting elements in `Y` are appended, retaining their partial order.
                 - 'map': `X + Y` performs a merge where the array positions of all keys in `X` are preserved but the values
                   are overwritten by values in `Y` when the key sets of `X` and `Y` intersect. Elements in `Y` with
                   non-intersecting keys are appended, retaining their partial order.
               Required.
        :param _builtins.str message: Message represents the message displayed when validation fails. The message is required if the Expression contains line breaks. The message must not contain line breaks. If unset, the message is "failed rule: {Rule}". e.g. "must be a URL with the host matching spec.host" If the Expression contains line breaks. Message is required. The message must not contain line breaks. If unset, the message is "failed Expression: {Expression}".
        :param _builtins.str message_expression: messageExpression declares a CEL expression that evaluates to the validation failure message that is returned when this rule fails. Since messageExpression is used as a failure message, it must evaluate to a string. If both message and messageExpression are present on a validation, then messageExpression will be used if validation fails. If messageExpression results in a runtime error, the runtime error is logged, and the validation failure message is produced as if the messageExpression field were unset. If messageExpression evaluates to an empty string, a string with only spaces, or a string that contains line breaks, then the validation failure message will also be produced as if the messageExpression field were unset, and the fact that messageExpression produced an empty string/string with only spaces/string with line breaks will be logged. messageExpression has access to all the same variables as the `expression` except for 'authorizer' and 'authorizer.requestResource'. Example: "object.x must be less than max ("+string(params.max)+")"
        :param _builtins.str reason: Reason represents a machine-readable description of why this validation failed. If this is the first validation in the list to fail, this reason, as well as the corresponding HTTP response code, are used in the HTTP response to the client. The currently supported reasons are: "Unauthorized", "Forbidden", "Invalid", "RequestEntityTooLarge". If not set, StatusReasonInvalid is used in the response to the client.
        """
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if message_expression is not None:
            pulumi.set(__self__, "message_expression", message_expression)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> Optional[_builtins.str]:
        """
        Expression represents the expression which will be evaluated by CEL. ref: https://github.com/google/cel-spec CEL expressions have access to the contents of the Admission request/response, organized into CEL variables as well as some other useful variables:

        'object' - The object from the incoming request. The value is null for DELETE requests. 'oldObject' - The existing object. The value is null for CREATE requests. 'request' - Attributes of the admission request([ref](/pkg/apis/admission/types.go#AdmissionRequest)). 'params' - Parameter resource referred to by the policy binding being evaluated. Only populated if the policy has a ParamKind.

        The `apiVersion`, `kind`, `metadata.name` and `metadata.generateName` are always accessible from the root of the object. No other metadata properties are accessible.

        Only property names of the form `[a-zA-Z_.-/][a-zA-Z0-9_.-/]*` are accessible. Accessible property names are escaped according to the following rules when accessed in the expression: - '__' escapes to '__underscores__' - '.' escapes to '__dot__' - '-' escapes to '__dash__' - '/' escapes to '__slash__' - Property names that exactly match a CEL RESERVED keyword escape to '__{keyword}__'. The keywords are:
        	  "true", "false", "null", "in", "as", "break", "const", "continue", "else", "for", "function", "if",
        	  "import", "let", "loop", "package", "namespace", "return".
        Examples:
          - Expression accessing a property named "namespace": {"Expression": "object.__namespace__ > 0"}
          - Expression accessing a property named "x-prop": {"Expression": "object.x__dash__prop > 0"}
          - Expression accessing a property named "redact__d": {"Expression": "object.redact__underscores__d > 0"}

        Equality on arrays with list type of 'set' or 'map' ignores element order, i.e. [1, 2] == [2, 1]. Concatenation on arrays with x-kubernetes-list-type use the semantics of the list type:
          - 'set': `X + Y` performs a union where the array positions of all elements in `X` are preserved and
            non-intersecting elements in `Y` are appended, retaining their partial order.
          - 'map': `X + Y` performs a merge where the array positions of all keys in `X` are preserved but the values
            are overwritten by values in `Y` when the key sets of `X` and `Y` intersect. Elements in `Y` with
            non-intersecting keys are appended, retaining their partial order.
        Required.
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        Message represents the message displayed when validation fails. The message is required if the Expression contains line breaks. The message must not contain line breaks. If unset, the message is "failed rule: {Rule}". e.g. "must be a URL with the host matching spec.host" If the Expression contains line breaks. Message is required. The message must not contain line breaks. If unset, the message is "failed Expression: {Expression}".
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter(name="messageExpression")
    def message_expression(self) -> Optional[_builtins.str]:
        """
        messageExpression declares a CEL expression that evaluates to the validation failure message that is returned when this rule fails. Since messageExpression is used as a failure message, it must evaluate to a string. If both message and messageExpression are present on a validation, then messageExpression will be used if validation fails. If messageExpression results in a runtime error, the runtime error is logged, and the validation failure message is produced as if the messageExpression field were unset. If messageExpression evaluates to an empty string, a string with only spaces, or a string that contains line breaks, then the validation failure message will also be produced as if the messageExpression field were unset, and the fact that messageExpression produced an empty string/string with only spaces/string with line breaks will be logged. messageExpression has access to all the same variables as the `expression` except for 'authorizer' and 'authorizer.requestResource'. Example: "object.x must be less than max ("+string(params.max)+")"
        """
        return pulumi.get(self, "message_expression")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        Reason represents a machine-readable description of why this validation failed. If this is the first validation in the list to fail, this reason, as well as the corresponding HTTP response code, are used in the HTTP response to the client. The currently supported reasons are: "Unauthorized", "Forbidden", "Invalid", "RequestEntityTooLarge". If not set, StatusReasonInvalid is used in the response to the client.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class Variable(dict):
    """
    Variable is the definition of a variable that is used for composition.
    """
    def __init__(__self__, *,
                 expression: _builtins.str,
                 name: _builtins.str):
        """
        Variable is the definition of a variable that is used for composition.
        :param _builtins.str expression: Expression is the expression that will be evaluated as the value of the variable. The CEL expression has access to the same identifiers as the CEL expressions in Validation.
        :param _builtins.str name: Name is the name of the variable. The name must be a valid CEL identifier and unique among all variables. The variable can be accessed in other expressions through `variables` For example, if name is "foo", the variable will be available as `variables.foo`
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        """
        Expression is the expression that will be evaluated as the value of the variable. The CEL expression has access to the same identifiers as the CEL expressions in Validation.
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name is the name of the variable. The name must be a valid CEL identifier and unique among all variables. The variable can be accessed in other expressions through `variables` For example, if name is "foo", the variable will be available as `variables.foo`
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class VariablePatch(dict):
    """
    Variable is the definition of a variable that is used for composition.
    """
    def __init__(__self__, *,
                 expression: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None):
        """
        Variable is the definition of a variable that is used for composition.
        :param _builtins.str expression: Expression is the expression that will be evaluated as the value of the variable. The CEL expression has access to the same identifiers as the CEL expressions in Validation.
        :param _builtins.str name: Name is the name of the variable. The name must be a valid CEL identifier and unique among all variables. The variable can be accessed in other expressions through `variables` For example, if name is "foo", the variable will be available as `variables.foo`
        """
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> Optional[_builtins.str]:
        """
        Expression is the expression that will be evaluated as the value of the variable. The CEL expression has access to the same identifiers as the CEL expressions in Validation.
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name is the name of the variable. The name must be a valid CEL identifier and unique among all variables. The variable can be accessed in other expressions through `variables` For example, if name is "foo", the variable will be available as `variables.foo`
        """
        return pulumi.get(self, "name")


