# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from ... import _utilities
from . import outputs
from ... import core as _core
from ... import meta as _meta
from ._inputs import *

__all__ = ['EventPatchArgs', 'EventPatch']

@pulumi.input_type
class EventPatchArgs:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 deprecated_count: Optional[pulumi.Input[_builtins.int]] = None,
                 deprecated_first_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 deprecated_last_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 deprecated_source: Optional[pulumi.Input['_core.v1.EventSourcePatchArgs']] = None,
                 event_time: Optional[pulumi.Input[_builtins.str]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaPatchArgs']] = None,
                 note: Optional[pulumi.Input[_builtins.str]] = None,
                 reason: Optional[pulumi.Input[_builtins.str]] = None,
                 regarding: Optional[pulumi.Input['_core.v1.ObjectReferencePatchArgs']] = None,
                 related: Optional[pulumi.Input['_core.v1.ObjectReferencePatchArgs']] = None,
                 reporting_controller: Optional[pulumi.Input[_builtins.str]] = None,
                 reporting_instance: Optional[pulumi.Input[_builtins.str]] = None,
                 series: Optional[pulumi.Input['EventSeriesPatchArgs']] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a EventPatch resource.
        :param pulumi.Input[_builtins.str] action: What action was taken/failed regarding to the regarding object.
        :param pulumi.Input[_builtins.str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[_builtins.int] deprecated_count: Deprecated field assuring backward compatibility with core.v1 Event type
        :param pulumi.Input[_builtins.str] deprecated_first_timestamp: Deprecated field assuring backward compatibility with core.v1 Event type
        :param pulumi.Input[_builtins.str] deprecated_last_timestamp: Deprecated field assuring backward compatibility with core.v1 Event type
        :param pulumi.Input['_core.v1.EventSourcePatchArgs'] deprecated_source: Deprecated field assuring backward compatibility with core.v1 Event type
        :param pulumi.Input[_builtins.str] event_time: Required. Time when this Event was first observed.
        :param pulumi.Input[_builtins.str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input[_builtins.str] note: Optional. A human-readable description of the status of this operation. Maximal length of the note is 1kB, but libraries should be prepared to handle values up to 64kB.
        :param pulumi.Input[_builtins.str] reason: Why the action was taken.
        :param pulumi.Input['_core.v1.ObjectReferencePatchArgs'] regarding: The object this Event is about. In most cases it's an Object reporting controller implements. E.g. ReplicaSetController implements ReplicaSets and this event is emitted because it acts on some changes in a ReplicaSet object.
        :param pulumi.Input['_core.v1.ObjectReferencePatchArgs'] related: Optional secondary object for more complex actions. E.g. when regarding object triggers a creation or deletion of related object.
        :param pulumi.Input[_builtins.str] reporting_controller: Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`.
        :param pulumi.Input[_builtins.str] reporting_instance: ID of the controller instance, e.g. `kubelet-xyzf`.
        :param pulumi.Input['EventSeriesPatchArgs'] series: Data about the Event series this event represents or nil if it's a singleton Event.
        :param pulumi.Input[_builtins.str] type: Type of this event (Normal, Warning), new types could be added in the future.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'events.k8s.io/v1beta1')
        if deprecated_count is not None:
            pulumi.set(__self__, "deprecated_count", deprecated_count)
        if deprecated_first_timestamp is not None:
            pulumi.set(__self__, "deprecated_first_timestamp", deprecated_first_timestamp)
        if deprecated_last_timestamp is not None:
            pulumi.set(__self__, "deprecated_last_timestamp", deprecated_last_timestamp)
        if deprecated_source is not None:
            pulumi.set(__self__, "deprecated_source", deprecated_source)
        if event_time is not None:
            pulumi.set(__self__, "event_time", event_time)
        if kind is not None:
            pulumi.set(__self__, "kind", 'Event')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if note is not None:
            pulumi.set(__self__, "note", note)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if regarding is not None:
            pulumi.set(__self__, "regarding", regarding)
        if related is not None:
            pulumi.set(__self__, "related", related)
        if reporting_controller is not None:
            pulumi.set(__self__, "reporting_controller", reporting_controller)
        if reporting_instance is not None:
            pulumi.set(__self__, "reporting_instance", reporting_instance)
        if series is not None:
            pulumi.set(__self__, "series", series)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        What action was taken/failed regarding to the regarding object.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_version", value)

    @_builtins.property
    @pulumi.getter(name="deprecatedCount")
    def deprecated_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Deprecated field assuring backward compatibility with core.v1 Event type
        """
        return pulumi.get(self, "deprecated_count")

    @deprecated_count.setter
    def deprecated_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "deprecated_count", value)

    @_builtins.property
    @pulumi.getter(name="deprecatedFirstTimestamp")
    def deprecated_first_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Deprecated field assuring backward compatibility with core.v1 Event type
        """
        return pulumi.get(self, "deprecated_first_timestamp")

    @deprecated_first_timestamp.setter
    def deprecated_first_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deprecated_first_timestamp", value)

    @_builtins.property
    @pulumi.getter(name="deprecatedLastTimestamp")
    def deprecated_last_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Deprecated field assuring backward compatibility with core.v1 Event type
        """
        return pulumi.get(self, "deprecated_last_timestamp")

    @deprecated_last_timestamp.setter
    def deprecated_last_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deprecated_last_timestamp", value)

    @_builtins.property
    @pulumi.getter(name="deprecatedSource")
    def deprecated_source(self) -> Optional[pulumi.Input['_core.v1.EventSourcePatchArgs']]:
        """
        Deprecated field assuring backward compatibility with core.v1 Event type
        """
        return pulumi.get(self, "deprecated_source")

    @deprecated_source.setter
    def deprecated_source(self, value: Optional[pulumi.Input['_core.v1.EventSourcePatchArgs']]):
        pulumi.set(self, "deprecated_source", value)

    @_builtins.property
    @pulumi.getter(name="eventTime")
    def event_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required. Time when this Event was first observed.
        """
        return pulumi.get(self, "event_time")

    @event_time.setter
    def event_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "event_time", value)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kind", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaPatchArgs']]:
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaPatchArgs']]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def note(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. A human-readable description of the status of this operation. Maximal length of the note is 1kB, but libraries should be prepared to handle values up to 64kB.
        """
        return pulumi.get(self, "note")

    @note.setter
    def note(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "note", value)

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Why the action was taken.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reason", value)

    @_builtins.property
    @pulumi.getter
    def regarding(self) -> Optional[pulumi.Input['_core.v1.ObjectReferencePatchArgs']]:
        """
        The object this Event is about. In most cases it's an Object reporting controller implements. E.g. ReplicaSetController implements ReplicaSets and this event is emitted because it acts on some changes in a ReplicaSet object.
        """
        return pulumi.get(self, "regarding")

    @regarding.setter
    def regarding(self, value: Optional[pulumi.Input['_core.v1.ObjectReferencePatchArgs']]):
        pulumi.set(self, "regarding", value)

    @_builtins.property
    @pulumi.getter
    def related(self) -> Optional[pulumi.Input['_core.v1.ObjectReferencePatchArgs']]:
        """
        Optional secondary object for more complex actions. E.g. when regarding object triggers a creation or deletion of related object.
        """
        return pulumi.get(self, "related")

    @related.setter
    def related(self, value: Optional[pulumi.Input['_core.v1.ObjectReferencePatchArgs']]):
        pulumi.set(self, "related", value)

    @_builtins.property
    @pulumi.getter(name="reportingController")
    def reporting_controller(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`.
        """
        return pulumi.get(self, "reporting_controller")

    @reporting_controller.setter
    def reporting_controller(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reporting_controller", value)

    @_builtins.property
    @pulumi.getter(name="reportingInstance")
    def reporting_instance(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the controller instance, e.g. `kubelet-xyzf`.
        """
        return pulumi.get(self, "reporting_instance")

    @reporting_instance.setter
    def reporting_instance(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reporting_instance", value)

    @_builtins.property
    @pulumi.getter
    def series(self) -> Optional[pulumi.Input['EventSeriesPatchArgs']]:
        """
        Data about the Event series this event represents or nil if it's a singleton Event.
        """
        return pulumi.get(self, "series")

    @series.setter
    def series(self, value: Optional[pulumi.Input['EventSeriesPatchArgs']]):
        pulumi.set(self, "series", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of this event (Normal, Warning), new types could be added in the future.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("kubernetes:events.k8s.io/v1beta1:EventPatch")
class EventPatch(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 deprecated_count: Optional[pulumi.Input[_builtins.int]] = None,
                 deprecated_first_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 deprecated_last_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 deprecated_source: Optional[pulumi.Input[Union['_core.v1.EventSourcePatchArgs', '_core.v1.EventSourcePatchArgsDict']]] = None,
                 event_time: Optional[pulumi.Input[_builtins.str]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Union['_meta.v1.ObjectMetaPatchArgs', '_meta.v1.ObjectMetaPatchArgsDict']]] = None,
                 note: Optional[pulumi.Input[_builtins.str]] = None,
                 reason: Optional[pulumi.Input[_builtins.str]] = None,
                 regarding: Optional[pulumi.Input[Union['_core.v1.ObjectReferencePatchArgs', '_core.v1.ObjectReferencePatchArgsDict']]] = None,
                 related: Optional[pulumi.Input[Union['_core.v1.ObjectReferencePatchArgs', '_core.v1.ObjectReferencePatchArgsDict']]] = None,
                 reporting_controller: Optional[pulumi.Input[_builtins.str]] = None,
                 reporting_instance: Optional[pulumi.Input[_builtins.str]] = None,
                 series: Optional[pulumi.Input[Union['EventSeriesPatchArgs', 'EventSeriesPatchArgsDict']]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Patch resources are used to modify existing Kubernetes resources by using
        Server-Side Apply updates. The name of the resource must be specified, but all other properties are optional. More than
        one patch may be applied to the same resource, and a random FieldManager name will be used for each Patch resource.
        Conflicts will result in an error by default, but can be forced using the "pulumi.com/patchForce" annotation. See the
        [Server-Side Apply Docs](https://www.pulumi.com/registry/packages/kubernetes/how-to-guides/managing-resources-with-server-side-apply/) for
        additional information about using Server-Side Apply to manage Kubernetes resources with Pulumi.
        Event is a report of an event somewhere in the cluster. It generally denotes some state change in the system.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: What action was taken/failed regarding to the regarding object.
        :param pulumi.Input[_builtins.str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[_builtins.int] deprecated_count: Deprecated field assuring backward compatibility with core.v1 Event type
        :param pulumi.Input[_builtins.str] deprecated_first_timestamp: Deprecated field assuring backward compatibility with core.v1 Event type
        :param pulumi.Input[_builtins.str] deprecated_last_timestamp: Deprecated field assuring backward compatibility with core.v1 Event type
        :param pulumi.Input[Union['_core.v1.EventSourcePatchArgs', '_core.v1.EventSourcePatchArgsDict']] deprecated_source: Deprecated field assuring backward compatibility with core.v1 Event type
        :param pulumi.Input[_builtins.str] event_time: Required. Time when this Event was first observed.
        :param pulumi.Input[_builtins.str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input[_builtins.str] note: Optional. A human-readable description of the status of this operation. Maximal length of the note is 1kB, but libraries should be prepared to handle values up to 64kB.
        :param pulumi.Input[_builtins.str] reason: Why the action was taken.
        :param pulumi.Input[Union['_core.v1.ObjectReferencePatchArgs', '_core.v1.ObjectReferencePatchArgsDict']] regarding: The object this Event is about. In most cases it's an Object reporting controller implements. E.g. ReplicaSetController implements ReplicaSets and this event is emitted because it acts on some changes in a ReplicaSet object.
        :param pulumi.Input[Union['_core.v1.ObjectReferencePatchArgs', '_core.v1.ObjectReferencePatchArgsDict']] related: Optional secondary object for more complex actions. E.g. when regarding object triggers a creation or deletion of related object.
        :param pulumi.Input[_builtins.str] reporting_controller: Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`.
        :param pulumi.Input[_builtins.str] reporting_instance: ID of the controller instance, e.g. `kubelet-xyzf`.
        :param pulumi.Input[Union['EventSeriesPatchArgs', 'EventSeriesPatchArgsDict']] series: Data about the Event series this event represents or nil if it's a singleton Event.
        :param pulumi.Input[_builtins.str] type: Type of this event (Normal, Warning), new types could be added in the future.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[EventPatchArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Patch resources are used to modify existing Kubernetes resources by using
        Server-Side Apply updates. The name of the resource must be specified, but all other properties are optional. More than
        one patch may be applied to the same resource, and a random FieldManager name will be used for each Patch resource.
        Conflicts will result in an error by default, but can be forced using the "pulumi.com/patchForce" annotation. See the
        [Server-Side Apply Docs](https://www.pulumi.com/registry/packages/kubernetes/how-to-guides/managing-resources-with-server-side-apply/) for
        additional information about using Server-Side Apply to manage Kubernetes resources with Pulumi.
        Event is a report of an event somewhere in the cluster. It generally denotes some state change in the system.

        :param str resource_name: The name of the resource.
        :param EventPatchArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EventPatchArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 deprecated_count: Optional[pulumi.Input[_builtins.int]] = None,
                 deprecated_first_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 deprecated_last_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 deprecated_source: Optional[pulumi.Input[Union['_core.v1.EventSourcePatchArgs', '_core.v1.EventSourcePatchArgsDict']]] = None,
                 event_time: Optional[pulumi.Input[_builtins.str]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Union['_meta.v1.ObjectMetaPatchArgs', '_meta.v1.ObjectMetaPatchArgsDict']]] = None,
                 note: Optional[pulumi.Input[_builtins.str]] = None,
                 reason: Optional[pulumi.Input[_builtins.str]] = None,
                 regarding: Optional[pulumi.Input[Union['_core.v1.ObjectReferencePatchArgs', '_core.v1.ObjectReferencePatchArgsDict']]] = None,
                 related: Optional[pulumi.Input[Union['_core.v1.ObjectReferencePatchArgs', '_core.v1.ObjectReferencePatchArgsDict']]] = None,
                 reporting_controller: Optional[pulumi.Input[_builtins.str]] = None,
                 reporting_instance: Optional[pulumi.Input[_builtins.str]] = None,
                 series: Optional[pulumi.Input[Union['EventSeriesPatchArgs', 'EventSeriesPatchArgsDict']]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EventPatchArgs.__new__(EventPatchArgs)

            __props__.__dict__["action"] = action
            __props__.__dict__["api_version"] = 'events.k8s.io/v1beta1'
            __props__.__dict__["deprecated_count"] = deprecated_count
            __props__.__dict__["deprecated_first_timestamp"] = deprecated_first_timestamp
            __props__.__dict__["deprecated_last_timestamp"] = deprecated_last_timestamp
            __props__.__dict__["deprecated_source"] = deprecated_source
            __props__.__dict__["event_time"] = event_time
            __props__.__dict__["kind"] = 'Event'
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["note"] = note
            __props__.__dict__["reason"] = reason
            __props__.__dict__["regarding"] = regarding
            __props__.__dict__["related"] = related
            __props__.__dict__["reporting_controller"] = reporting_controller
            __props__.__dict__["reporting_instance"] = reporting_instance
            __props__.__dict__["series"] = series
            __props__.__dict__["type"] = type
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="kubernetes:core/v1:EventPatch"), pulumi.Alias(type_="kubernetes:events.k8s.io/v1:EventPatch")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(EventPatch, __self__).__init__(
            'kubernetes:events.k8s.io/v1beta1:EventPatch',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'EventPatch':
        """
        Get an existing EventPatch resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = EventPatchArgs.__new__(EventPatchArgs)

        __props__.__dict__["action"] = None
        __props__.__dict__["api_version"] = None
        __props__.__dict__["deprecated_count"] = None
        __props__.__dict__["deprecated_first_timestamp"] = None
        __props__.__dict__["deprecated_last_timestamp"] = None
        __props__.__dict__["deprecated_source"] = None
        __props__.__dict__["event_time"] = None
        __props__.__dict__["kind"] = None
        __props__.__dict__["metadata"] = None
        __props__.__dict__["note"] = None
        __props__.__dict__["reason"] = None
        __props__.__dict__["regarding"] = None
        __props__.__dict__["related"] = None
        __props__.__dict__["reporting_controller"] = None
        __props__.__dict__["reporting_instance"] = None
        __props__.__dict__["series"] = None
        __props__.__dict__["type"] = None
        return EventPatch(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        What action was taken/failed regarding to the regarding object.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter(name="deprecatedCount")
    def deprecated_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Deprecated field assuring backward compatibility with core.v1 Event type
        """
        return pulumi.get(self, "deprecated_count")

    @_builtins.property
    @pulumi.getter(name="deprecatedFirstTimestamp")
    def deprecated_first_timestamp(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Deprecated field assuring backward compatibility with core.v1 Event type
        """
        return pulumi.get(self, "deprecated_first_timestamp")

    @_builtins.property
    @pulumi.getter(name="deprecatedLastTimestamp")
    def deprecated_last_timestamp(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Deprecated field assuring backward compatibility with core.v1 Event type
        """
        return pulumi.get(self, "deprecated_last_timestamp")

    @_builtins.property
    @pulumi.getter(name="deprecatedSource")
    def deprecated_source(self) -> pulumi.Output[Optional['_core.v1.outputs.EventSourcePatch']]:
        """
        Deprecated field assuring backward compatibility with core.v1 Event type
        """
        return pulumi.get(self, "deprecated_source")

    @_builtins.property
    @pulumi.getter(name="eventTime")
    def event_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Required. Time when this Event was first observed.
        """
        return pulumi.get(self, "event_time")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional['_meta.v1.outputs.ObjectMetaPatch']]:
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def note(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Optional. A human-readable description of the status of this operation. Maximal length of the note is 1kB, but libraries should be prepared to handle values up to 64kB.
        """
        return pulumi.get(self, "note")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Why the action was taken.
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter
    def regarding(self) -> pulumi.Output[Optional['_core.v1.outputs.ObjectReferencePatch']]:
        """
        The object this Event is about. In most cases it's an Object reporting controller implements. E.g. ReplicaSetController implements ReplicaSets and this event is emitted because it acts on some changes in a ReplicaSet object.
        """
        return pulumi.get(self, "regarding")

    @_builtins.property
    @pulumi.getter
    def related(self) -> pulumi.Output[Optional['_core.v1.outputs.ObjectReferencePatch']]:
        """
        Optional secondary object for more complex actions. E.g. when regarding object triggers a creation or deletion of related object.
        """
        return pulumi.get(self, "related")

    @_builtins.property
    @pulumi.getter(name="reportingController")
    def reporting_controller(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`.
        """
        return pulumi.get(self, "reporting_controller")

    @_builtins.property
    @pulumi.getter(name="reportingInstance")
    def reporting_instance(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ID of the controller instance, e.g. `kubelet-xyzf`.
        """
        return pulumi.get(self, "reporting_instance")

    @_builtins.property
    @pulumi.getter
    def series(self) -> pulumi.Output[Optional['outputs.EventSeriesPatch']]:
        """
        Data about the Event series this event represents or nil if it's a singleton Event.
        """
        return pulumi.get(self, "series")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Type of this event (Normal, Warning), new types could be added in the future.
        """
        return pulumi.get(self, "type")

