# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from ... import _utilities
from . import outputs
from ... import core as _core
from ... import meta as _meta

__all__ = [
    'Event',
    'EventSeries',
    'EventSeriesPatch',
]

@pulumi.output_type
class Event(dict):
    """
    Event is a report of an event somewhere in the cluster. It generally denotes some state change in the system.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventTime":
            suggest = "event_time"
        elif key == "apiVersion":
            suggest = "api_version"
        elif key == "deprecatedCount":
            suggest = "deprecated_count"
        elif key == "deprecatedFirstTimestamp":
            suggest = "deprecated_first_timestamp"
        elif key == "deprecatedLastTimestamp":
            suggest = "deprecated_last_timestamp"
        elif key == "deprecatedSource":
            suggest = "deprecated_source"
        elif key == "reportingController":
            suggest = "reporting_controller"
        elif key == "reportingInstance":
            suggest = "reporting_instance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Event. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Event.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Event.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_time: _builtins.str,
                 action: Optional[_builtins.str] = None,
                 api_version: Optional[_builtins.str] = None,
                 deprecated_count: Optional[_builtins.int] = None,
                 deprecated_first_timestamp: Optional[_builtins.str] = None,
                 deprecated_last_timestamp: Optional[_builtins.str] = None,
                 deprecated_source: Optional['_core.v1.outputs.EventSource'] = None,
                 kind: Optional[_builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 note: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None,
                 regarding: Optional['_core.v1.outputs.ObjectReference'] = None,
                 related: Optional['_core.v1.outputs.ObjectReference'] = None,
                 reporting_controller: Optional[_builtins.str] = None,
                 reporting_instance: Optional[_builtins.str] = None,
                 series: Optional['outputs.EventSeries'] = None,
                 type: Optional[_builtins.str] = None):
        """
        Event is a report of an event somewhere in the cluster. It generally denotes some state change in the system.
        :param _builtins.str event_time: Required. Time when this Event was first observed.
        :param _builtins.str action: What action was taken/failed regarding to the regarding object.
        :param _builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param _builtins.int deprecated_count: Deprecated field assuring backward compatibility with core.v1 Event type
        :param _builtins.str deprecated_first_timestamp: Deprecated field assuring backward compatibility with core.v1 Event type
        :param _builtins.str deprecated_last_timestamp: Deprecated field assuring backward compatibility with core.v1 Event type
        :param '_core.v1.EventSourceArgs' deprecated_source: Deprecated field assuring backward compatibility with core.v1 Event type
        :param _builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param _builtins.str note: Optional. A human-readable description of the status of this operation. Maximal length of the note is 1kB, but libraries should be prepared to handle values up to 64kB.
        :param _builtins.str reason: Why the action was taken.
        :param '_core.v1.ObjectReferenceArgs' regarding: The object this Event is about. In most cases it's an Object reporting controller implements. E.g. ReplicaSetController implements ReplicaSets and this event is emitted because it acts on some changes in a ReplicaSet object.
        :param '_core.v1.ObjectReferenceArgs' related: Optional secondary object for more complex actions. E.g. when regarding object triggers a creation or deletion of related object.
        :param _builtins.str reporting_controller: Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`.
        :param _builtins.str reporting_instance: ID of the controller instance, e.g. `kubelet-xyzf`.
        :param 'EventSeriesArgs' series: Data about the Event series this event represents or nil if it's a singleton Event.
        :param _builtins.str type: Type of this event (Normal, Warning), new types could be added in the future.
        """
        pulumi.set(__self__, "event_time", event_time)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'events.k8s.io/v1beta1')
        if deprecated_count is not None:
            pulumi.set(__self__, "deprecated_count", deprecated_count)
        if deprecated_first_timestamp is not None:
            pulumi.set(__self__, "deprecated_first_timestamp", deprecated_first_timestamp)
        if deprecated_last_timestamp is not None:
            pulumi.set(__self__, "deprecated_last_timestamp", deprecated_last_timestamp)
        if deprecated_source is not None:
            pulumi.set(__self__, "deprecated_source", deprecated_source)
        if kind is not None:
            pulumi.set(__self__, "kind", 'Event')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if note is not None:
            pulumi.set(__self__, "note", note)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if regarding is not None:
            pulumi.set(__self__, "regarding", regarding)
        if related is not None:
            pulumi.set(__self__, "related", related)
        if reporting_controller is not None:
            pulumi.set(__self__, "reporting_controller", reporting_controller)
        if reporting_instance is not None:
            pulumi.set(__self__, "reporting_instance", reporting_instance)
        if series is not None:
            pulumi.set(__self__, "series", series)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="eventTime")
    def event_time(self) -> _builtins.str:
        """
        Required. Time when this Event was first observed.
        """
        return pulumi.get(self, "event_time")

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[_builtins.str]:
        """
        What action was taken/failed regarding to the regarding object.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[_builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter(name="deprecatedCount")
    def deprecated_count(self) -> Optional[_builtins.int]:
        """
        Deprecated field assuring backward compatibility with core.v1 Event type
        """
        return pulumi.get(self, "deprecated_count")

    @_builtins.property
    @pulumi.getter(name="deprecatedFirstTimestamp")
    def deprecated_first_timestamp(self) -> Optional[_builtins.str]:
        """
        Deprecated field assuring backward compatibility with core.v1 Event type
        """
        return pulumi.get(self, "deprecated_first_timestamp")

    @_builtins.property
    @pulumi.getter(name="deprecatedLastTimestamp")
    def deprecated_last_timestamp(self) -> Optional[_builtins.str]:
        """
        Deprecated field assuring backward compatibility with core.v1 Event type
        """
        return pulumi.get(self, "deprecated_last_timestamp")

    @_builtins.property
    @pulumi.getter(name="deprecatedSource")
    def deprecated_source(self) -> Optional['_core.v1.outputs.EventSource']:
        """
        Deprecated field assuring backward compatibility with core.v1 Event type
        """
        return pulumi.get(self, "deprecated_source")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[_builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def note(self) -> Optional[_builtins.str]:
        """
        Optional. A human-readable description of the status of this operation. Maximal length of the note is 1kB, but libraries should be prepared to handle values up to 64kB.
        """
        return pulumi.get(self, "note")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        Why the action was taken.
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter
    def regarding(self) -> Optional['_core.v1.outputs.ObjectReference']:
        """
        The object this Event is about. In most cases it's an Object reporting controller implements. E.g. ReplicaSetController implements ReplicaSets and this event is emitted because it acts on some changes in a ReplicaSet object.
        """
        return pulumi.get(self, "regarding")

    @_builtins.property
    @pulumi.getter
    def related(self) -> Optional['_core.v1.outputs.ObjectReference']:
        """
        Optional secondary object for more complex actions. E.g. when regarding object triggers a creation or deletion of related object.
        """
        return pulumi.get(self, "related")

    @_builtins.property
    @pulumi.getter(name="reportingController")
    def reporting_controller(self) -> Optional[_builtins.str]:
        """
        Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`.
        """
        return pulumi.get(self, "reporting_controller")

    @_builtins.property
    @pulumi.getter(name="reportingInstance")
    def reporting_instance(self) -> Optional[_builtins.str]:
        """
        ID of the controller instance, e.g. `kubelet-xyzf`.
        """
        return pulumi.get(self, "reporting_instance")

    @_builtins.property
    @pulumi.getter
    def series(self) -> Optional['outputs.EventSeries']:
        """
        Data about the Event series this event represents or nil if it's a singleton Event.
        """
        return pulumi.get(self, "series")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of this event (Normal, Warning), new types could be added in the future.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class EventSeries(dict):
    """
    EventSeries contain information on series of events, i.e. thing that was/is happening continuously for some time.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastObservedTime":
            suggest = "last_observed_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSeries. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSeries.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSeries.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: _builtins.int,
                 last_observed_time: _builtins.str,
                 state: _builtins.str):
        """
        EventSeries contain information on series of events, i.e. thing that was/is happening continuously for some time.
        :param _builtins.int count: Number of occurrences in this series up to the last heartbeat time
        :param _builtins.str last_observed_time: Time when last Event from the series was seen before last heartbeat.
        :param _builtins.str state: Information whether this series is ongoing or finished. Deprecated. Planned removal for 1.18
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "last_observed_time", last_observed_time)
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def count(self) -> _builtins.int:
        """
        Number of occurrences in this series up to the last heartbeat time
        """
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter(name="lastObservedTime")
    def last_observed_time(self) -> _builtins.str:
        """
        Time when last Event from the series was seen before last heartbeat.
        """
        return pulumi.get(self, "last_observed_time")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        Information whether this series is ongoing or finished. Deprecated. Planned removal for 1.18
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class EventSeriesPatch(dict):
    """
    EventSeries contain information on series of events, i.e. thing that was/is happening continuously for some time.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastObservedTime":
            suggest = "last_observed_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSeriesPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSeriesPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSeriesPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: Optional[_builtins.int] = None,
                 last_observed_time: Optional[_builtins.str] = None,
                 state: Optional[_builtins.str] = None):
        """
        EventSeries contain information on series of events, i.e. thing that was/is happening continuously for some time.
        :param _builtins.int count: Number of occurrences in this series up to the last heartbeat time
        :param _builtins.str last_observed_time: Time when last Event from the series was seen before last heartbeat.
        :param _builtins.str state: Information whether this series is ongoing or finished. Deprecated. Planned removal for 1.18
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if last_observed_time is not None:
            pulumi.set(__self__, "last_observed_time", last_observed_time)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def count(self) -> Optional[_builtins.int]:
        """
        Number of occurrences in this series up to the last heartbeat time
        """
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter(name="lastObservedTime")
    def last_observed_time(self) -> Optional[_builtins.str]:
        """
        Time when last Event from the series was seen before last heartbeat.
        """
        return pulumi.get(self, "last_observed_time")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        Information whether this series is ongoing or finished. Deprecated. Planned removal for 1.18
        """
        return pulumi.get(self, "state")


