# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from ... import _utilities

__all__ = ['DirectoryArgs', 'Directory']

@pulumi.input_type
class DirectoryArgs:
    def __init__(__self__, *,
                 directory: pulumi.Input[_builtins.str],
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_await: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Directory resource.
        :param pulumi.Input[_builtins.str] directory: The directory containing the kustomization to apply. The value can be a local directory or a folder in a
               git repository.
               Example: ./helloWorld
               Example: https://github.com/kubernetes-sigs/kustomize/tree/master/examples/helloWorld
        :param pulumi.Input[_builtins.str] namespace: The default namespace to apply to the resources. Defaults to the provider's namespace.
        :param pulumi.Input[_builtins.str] resource_prefix: A prefix for the auto-generated resource names. Defaults to the name of the Directory resource. Example: A resource created with resourcePrefix="foo" would produce a resource named "foo:resourceName".
        :param pulumi.Input[_builtins.bool] skip_await: Indicates that child resources should skip the await logic.
        """
        pulumi.set(__self__, "directory", directory)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if resource_prefix is not None:
            pulumi.set(__self__, "resource_prefix", resource_prefix)
        if skip_await is not None:
            pulumi.set(__self__, "skip_await", skip_await)

    @_builtins.property
    @pulumi.getter
    def directory(self) -> pulumi.Input[_builtins.str]:
        """
        The directory containing the kustomization to apply. The value can be a local directory or a folder in a
        git repository.
        Example: ./helloWorld
        Example: https://github.com/kubernetes-sigs/kustomize/tree/master/examples/helloWorld
        """
        return pulumi.get(self, "directory")

    @directory.setter
    def directory(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "directory", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default namespace to apply to the resources. Defaults to the provider's namespace.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="resourcePrefix")
    def resource_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A prefix for the auto-generated resource names. Defaults to the name of the Directory resource. Example: A resource created with resourcePrefix="foo" would produce a resource named "foo:resourceName".
        """
        return pulumi.get(self, "resource_prefix")

    @resource_prefix.setter
    def resource_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_prefix", value)

    @_builtins.property
    @pulumi.getter(name="skipAwait")
    def skip_await(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates that child resources should skip the await logic.
        """
        return pulumi.get(self, "skip_await")

    @skip_await.setter
    def skip_await(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_await", value)


@pulumi.type_token("kubernetes:kustomize/v2:Directory")
class Directory(pulumi.ComponentResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 directory: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_await: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Directory is a component representing a collection of resources described by a kustomize directory (kustomization).

        ## Example Usage
        ### Local Kustomize Directory
        ```python
        from pulumi_kubernetes.kustomize.v2 import Directory

        hello_world = Directory(
            "hello-world-local",
            directory="./helloWorld",
        )
        ```
        ### Kustomize Directory from a Git Repo
        ```python
        from pulumi_kubernetes.kustomize.v2 import Directory

        hello_world = Directory(
            "hello-world-remote",
            directory="https://github.com/kubernetes-sigs/kustomize/tree/v3.3.1/examples/helloWorld",
        )
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] directory: The directory containing the kustomization to apply. The value can be a local directory or a folder in a
               git repository.
               Example: ./helloWorld
               Example: https://github.com/kubernetes-sigs/kustomize/tree/master/examples/helloWorld
        :param pulumi.Input[_builtins.str] namespace: The default namespace to apply to the resources. Defaults to the provider's namespace.
        :param pulumi.Input[_builtins.str] resource_prefix: A prefix for the auto-generated resource names. Defaults to the name of the Directory resource. Example: A resource created with resourcePrefix="foo" would produce a resource named "foo:resourceName".
        :param pulumi.Input[_builtins.bool] skip_await: Indicates that child resources should skip the await logic.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DirectoryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Directory is a component representing a collection of resources described by a kustomize directory (kustomization).

        ## Example Usage
        ### Local Kustomize Directory
        ```python
        from pulumi_kubernetes.kustomize.v2 import Directory

        hello_world = Directory(
            "hello-world-local",
            directory="./helloWorld",
        )
        ```
        ### Kustomize Directory from a Git Repo
        ```python
        from pulumi_kubernetes.kustomize.v2 import Directory

        hello_world = Directory(
            "hello-world-remote",
            directory="https://github.com/kubernetes-sigs/kustomize/tree/v3.3.1/examples/helloWorld",
        )
        ```

        :param str resource_name: The name of the resource.
        :param DirectoryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DirectoryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 directory: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_await: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is not None:
            raise ValueError('ComponentResource classes do not support opts.id')
        else:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DirectoryArgs.__new__(DirectoryArgs)

            if directory is None and not opts.urn:
                raise TypeError("Missing required property 'directory'")
            __props__.__dict__["directory"] = directory
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["resource_prefix"] = resource_prefix
            __props__.__dict__["skip_await"] = skip_await
            __props__.__dict__["resources"] = None
        super(Directory, __self__).__init__(
            'kubernetes:kustomize/v2:Directory',
            resource_name,
            __props__,
            opts,
            remote=True)

    @_builtins.property
    @pulumi.getter
    def resources(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Resources created by the Directory resource.
        """
        return pulumi.get(self, "resources")

